/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.xpect.methods;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.ts.typeRefs.Versionable;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;

/**
 * Provides X!PECT methods for testing versions
 */
@XpectImport(N4JSOffsetAdapter.class)
@SuppressWarnings("all")
public class ModelVersionXpectMethod {
  @Inject
  private N4JSTypeSystem ts;
  
  /**
   * Tests the version of a classifier declaration or type reference
   */
  @ParameterParser(syntax = "(\'of\' arg1=OFFSET)?")
  @Xpect
  public void version(@StringExpectation final IStringExpectation expectation, final N4JSOffsetAdapter.IEObjectCoveringRegion arg1) {
    if ((expectation == null)) {
      throw new IllegalStateException("No expectation specified, add \'--> version\'");
    }
    final EObject object = arg1.getEObject();
    final int actualVersion = this.getVersion(object);
    expectation.assertEquals(this.toString(actualVersion));
  }
  
  private int getVersion(final EObject object) {
    int _switchResult = (int) 0;
    boolean _matched = false;
    if (object instanceof IdentifierRef) {
      _matched=true;
      return this.getVersion(((IdentifierRef)object).getId());
    }
    if (!_matched) {
      if (object instanceof Type) {
        _matched=true;
        return ((Type)object).getVersion();
      }
    }
    if (!_matched) {
      if (object instanceof Versionable) {
        _matched=true;
        _switchResult = ((Versionable)object).getVersion();
      }
    }
    if (!_matched) {
      if (object instanceof TypableElement) {
        _matched=true;
        _switchResult = this.ts.tau(((TypableElement)object)).getVersion();
      }
    }
    if (!_matched) {
      EClass _eClass = object.eClass();
      String _plus = ("Cannot determine version of " + _eClass);
      throw new IllegalArgumentException(_plus);
    }
    return _switchResult;
  }
  
  private String toString(final int version) {
    if ((version == Integer.MAX_VALUE)) {
      return "*";
    }
    return Integer.toString(version);
  }
}
