/**
 * Copyright (c) 2018 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.n4idl.migrations;

import com.google.common.hash.HashCode;
import java.util.Collections;
import org.eclipse.n4js.n4idl.migrations.SwitchCondition;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * {@link SwitchCondition} which assures that a given value is a (non-empty) array
 * whose elements fulfill the given {@link #elementTypeCondition}.
 */
@SuppressWarnings("all")
public class ArrayTypeSwitchCondition extends SwitchCondition {
  public final SwitchCondition elementTypeCondition;
  
  public ArrayTypeSwitchCondition(final SwitchCondition elementTypeCondition) {
    this.elementTypeCondition = elementTypeCondition;
  }
  
  @Override
  public int hashCode() {
    int _hashCode = this.elementTypeCondition.hashCode();
    int _asInt = HashCode.fromString(ArrayTypeSwitchCondition.class.getSimpleName()).asInt();
    int _multiply = (31 * _asInt);
    return (_hashCode + _multiply);
  }
  
  @Override
  public String getConditionAsString(final String valueIdentifier) {
    return String.format("(%s array with (%s))", valueIdentifier, 
      this.elementTypeCondition.getConditionAsString((valueIdentifier + "[0]")));
  }
  
  @Override
  public Iterable<? extends SwitchCondition> subConditions() {
    return Collections.<SwitchCondition>unmodifiableList(CollectionLiterals.<SwitchCondition>newArrayList(this.elementTypeCondition));
  }
}
