/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.validation;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.n4js.utils.NLS;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

/**
 * Provides messages and helper methods for creating NLS messages.
 * This class uses an active annotation {@code @NLS} to derive constants and methods out of the entries of the
 * {@code messages.properties}. See {@link org.eclipse.n4js.utils.NLSProcessor} for details about the message format.
 */
@NLS(propertyFileName = "messages")
@SuppressWarnings("all")
public class IssueCodes {
  private final static String BUNDLE_NAME = IssueCodes.class.getPackage().getName() + ".messages";
  
  private final static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
  
  private final static String INITIALIZER = new Function0<String>() {
        public String apply() {
          org.eclipse.osgi.util.NLS.initializeMessages(BUNDLE_NAME, IssueCodes.class);
          return "";
        }
      }.apply();;
  
  private static String getString(final String key) {
    try {
    	String value = RESOURCE_BUNDLE.getString(key);
    	String[] parts = value.split(";;;");
    	return parts[1];
    } catch (MissingResourceException e) {
    	return '!' + key + '!';
    }
  }
  
  public static Severity getDefaultSeverity(final String key) {
    try {
    	String value = RESOURCE_BUNDLE.getString(key);
    	String[] parts = value.split(";;;");
    	String defaultSeverity = parts[0];
    	return Severity.valueOf(defaultSeverity.toUpperCase());
    } catch (MissingResourceException e) {
    	return null;
    }
  }
  
  public final static String ANN_DISALLOWED_AT_LOCATION = "ANN_DISALLOWED_AT_LOCATION";
  
  /**
   * The annotation @{0} is disallowed for this location.
   */
  public static String getMessageForANN_DISALLOWED_AT_LOCATION(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_DISALLOWED_AT_LOCATION), new Object [] { param0 });
  }
  
  public final static String ANN_DISALLOWED_IN_NONDEFINTION_FILE = "ANN_DISALLOWED_IN_NONDEFINTION_FILE";
  
  /**
   * The annotation @{0} can only be applied in definition files.
   */
  public static String getMessageForANN_DISALLOWED_IN_NONDEFINTION_FILE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_DISALLOWED_IN_NONDEFINTION_FILE), new Object [] { param0 });
  }
  
  public final static String ANN_DISALLOWED_IN_NON_RUNTIME_COMPONENT = "ANN_DISALLOWED_IN_NON_RUNTIME_COMPONENT";
  
  /**
   * The annotation @{0} can only be applied in a runtime component.
   */
  public static String getMessageForANN_DISALLOWED_IN_NON_RUNTIME_COMPONENT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_DISALLOWED_IN_NON_RUNTIME_COMPONENT), new Object [] { param0 });
  }
  
  public final static String ANN_NON_REPEATABLE = "ANN_NON_REPEATABLE";
  
  /**
   * Duplicate annotation of non-repeatable type @{0}.
   */
  public static String getMessageForANN_NON_REPEATABLE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_NON_REPEATABLE), new Object [] { param0 });
  }
  
  public final static String ANN_NOT_DEFINED = "ANN_NOT_DEFINED";
  
  /**
   * The annotation @{0} is not defined.
   */
  public static String getMessageForANN_NOT_DEFINED(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_NOT_DEFINED), new Object [] { param0 });
  }
  
  public final static String ANN_ONLY_ALLOWED_LOCATION_CONSTRUCTORS = "ANN_ONLY_ALLOWED_LOCATION_CONSTRUCTORS";
  
  /**
   * The annotation @{0} may only be applied at a parameter of a constructor.
   */
  public static String getMessageForANN_ONLY_ALLOWED_LOCATION_CONSTRUCTORS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_ONLY_ALLOWED_LOCATION_CONSTRUCTORS), new Object [] { param0 });
  }
  
  public final static String ANN_ONL_ALLOWED_IN_VARIANTS = "ANN_ONL_ALLOWED_IN_VARIANTS";
  
  /**
   * The annotation @{0} may only be applied in {1} files.
   */
  public static String getMessageForANN_ONL_ALLOWED_IN_VARIANTS(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_ONL_ALLOWED_IN_VARIANTS), new Object [] { param0, param1 });
  }
  
  public final static String ANN_POLY_AWARE_AND_MODULE_MUTUAL_EXCLUSIVE = "ANN_POLY_AWARE_AND_MODULE_MUTUAL_EXCLUSIVE";
  
  /**
   * A module cannot be annotated as filler and filling at the same time.
   */
  public static String getMessageForANN_POLY_AWARE_AND_MODULE_MUTUAL_EXCLUSIVE() {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_POLY_AWARE_AND_MODULE_MUTUAL_EXCLUSIVE), new Object [] {  });
  }
  
  public final static String ANN_POLY_STATIC_POLY_ONLY_IN_POLYFILL_MODULE = "ANN_POLY_STATIC_POLY_ONLY_IN_POLYFILL_MODULE";
  
  /**
   * The annotation StaticPolyfill is only allowed in modules annotated as StaticPolyfillModule.
   */
  public static String getMessageForANN_POLY_STATIC_POLY_ONLY_IN_POLYFILL_MODULE() {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_POLY_STATIC_POLY_ONLY_IN_POLYFILL_MODULE), new Object [] {  });
  }
  
  public final static String ANN_PROMISIFIABLE_BAD_CALLBACK_ERROR_NOT_FIRST_ARG = "ANN_PROMISIFIABLE_BAD_CALLBACK_ERROR_NOT_FIRST_ARG";
  
  /**
   * If the callback of a @Promisifiable function/method has a parameter of type Error, this parameter must be the first parameter.
   */
  public static String getMessageForANN_PROMISIFIABLE_BAD_CALLBACK_ERROR_NOT_FIRST_ARG() {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_PROMISIFIABLE_BAD_CALLBACK_ERROR_NOT_FIRST_ARG), new Object [] {  });
  }
  
  public final static String ANN_PROMISIFIABLE_BAD_CALLBACK_MORE_THAN_ONE_ERROR = "ANN_PROMISIFIABLE_BAD_CALLBACK_MORE_THAN_ONE_ERROR";
  
  /**
   * The callback of a @Promisifiable function/method must not have more than one parameter of type Error.
   */
  public static String getMessageForANN_PROMISIFIABLE_BAD_CALLBACK_MORE_THAN_ONE_ERROR() {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_PROMISIFIABLE_BAD_CALLBACK_MORE_THAN_ONE_ERROR), new Object [] {  });
  }
  
  public final static String ANN_PROMISIFIABLE_MISSING_CALLBACK = "ANN_PROMISIFIABLE_MISSING_CALLBACK";
  
  /**
   * The annotation @Promisifiable is only allowed on functions/methods that take a function as a last argument (i.e. the callback).
   */
  public static String getMessageForANN_PROMISIFIABLE_MISSING_CALLBACK() {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_PROMISIFIABLE_MISSING_CALLBACK), new Object [] {  });
  }
  
  public final static String ANN_REQUIRES_TEST = "ANN_REQUIRES_TEST";
  
  /**
   * Only methods annotated with @Test could be annotated with {0}.
   */
  public static String getMessageForANN_REQUIRES_TEST(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_REQUIRES_TEST), new Object [] { param0 });
  }
  
  public final static String ANN_THIS_DISALLOWED_ON_STATIC_MEMBER_OF_INTERFACE = "ANN_THIS_DISALLOWED_ON_STATIC_MEMBER_OF_INTERFACE";
  
  /**
   * @This annotation not allowed on static members of interfaces.
   */
  public static String getMessageForANN_THIS_DISALLOWED_ON_STATIC_MEMBER_OF_INTERFACE() {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_THIS_DISALLOWED_ON_STATIC_MEMBER_OF_INTERFACE), new Object [] {  });
  }
  
  public final static String ANN_THIS_NOT_SUBTYPE_OF_CONTAINING_TYPE = "ANN_THIS_NOT_SUBTYPE_OF_CONTAINING_TYPE";
  
  /**
   * Declared @This type of {0} in {1} must be a subtype of {2}.
   */
  public static String getMessageForANN_THIS_NOT_SUBTYPE_OF_CONTAINING_TYPE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_THIS_NOT_SUBTYPE_OF_CONTAINING_TYPE), new Object [] { param0, param1, param2 });
  }
  
  public final static String ANN_UNNECESSARY = "ANN_UNNECESSARY";
  
  /**
   * Unnecessary @{0}.
   */
  public static String getMessageForANN_UNNECESSARY(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_UNNECESSARY), new Object [] { param0 });
  }
  
  public final static String ANN_UNUSED_IDEBUG = "ANN_UNUSED_IDEBUG";
  
  /**
   * No matching error found, apparently bug IDEBUG-{0} has been fixed or does not occur here.
   */
  public static String getMessageForANN_UNUSED_IDEBUG(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_UNUSED_IDEBUG), new Object [] { param0 });
  }
  
  public final static String ANN_WRONG_ARGUMENT_TYPE = "ANN_WRONG_ARGUMENT_TYPE";
  
  /**
   * The annotation @{0} expects a {1} here.
   */
  public static String getMessageForANN_WRONG_ARGUMENT_TYPE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_WRONG_ARGUMENT_TYPE), new Object [] { param0, param1 });
  }
  
  public final static String ANN_WRONG_NUMBER_OF_ARGUMENTS = "ANN_WRONG_NUMBER_OF_ARGUMENTS";
  
  /**
   * Wrong number of annotation arguments: @{0} expects {1} but got {2}.
   */
  public static String getMessageForANN_WRONG_NUMBER_OF_ARGUMENTS(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN_WRONG_NUMBER_OF_ARGUMENTS), new Object [] { param0, param1, param2 });
  }
  
  public final static String ANN__ONLY_IN_N4JS = "ANN__ONLY_IN_N4JS";
  
  /**
   * Annotations are a N4JS feature and cannot be used in JS mode.
   */
  public static String getMessageForANN__ONLY_IN_N4JS() {
    return org.eclipse.osgi.util.NLS.bind(getString(ANN__ONLY_IN_N4JS), new Object [] {  });
  }
  
  public final static String AST_BINARY_LOGICAL_EXPRESSION_MISSING_PART = "AST_BINARY_LOGICAL_EXPRESSION_MISSING_PART";
  
  /**
   * The logical expression is missing the {0}.
   */
  public static String getMessageForAST_BINARY_LOGICAL_EXPRESSION_MISSING_PART(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_BINARY_LOGICAL_EXPRESSION_MISSING_PART), new Object [] { param0 });
  }
  
  public final static String AST_CATCH_VAR_TYPED = "AST_CATCH_VAR_TYPED";
  
  /**
   * Catch variable must not be typed.
   */
  public static String getMessageForAST_CATCH_VAR_TYPED() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_CATCH_VAR_TYPED), new Object [] {  });
  }
  
  public final static String AST_CONST_HAS_NO_INITIALIZER = "AST_CONST_HAS_NO_INITIALIZER";
  
  /**
   * Const variable {0} must be provided with an initializer.
   */
  public static String getMessageForAST_CONST_HAS_NO_INITIALIZER(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_CONST_HAS_NO_INITIALIZER), new Object [] { param0 });
  }
  
  public final static String AST_CONST_IN_STATEMENT_POSITION = "AST_CONST_IN_STATEMENT_POSITION";
  
  /**
   * Const variable statements must be on the top level or nested in a block.
   */
  public static String getMessageForAST_CONST_IN_STATEMENT_POSITION() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_CONST_IN_STATEMENT_POSITION), new Object [] {  });
  }
  
  public final static String AST_EXP_INVALID_LHS_ASS = "AST_EXP_INVALID_LHS_ASS";
  
  /**
   * Invalid assignment left-hand side.
   */
  public static String getMessageForAST_EXP_INVALID_LHS_ASS() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_EXP_INVALID_LHS_ASS), new Object [] {  });
  }
  
  public final static String AST_GLOBAL_JS_NAME_CONFLICT = "AST_GLOBAL_JS_NAME_CONFLICT";
  
  /**
   * Globally defined element named {0} must be defined in runtime environment.
   */
  public static String getMessageForAST_GLOBAL_JS_NAME_CONFLICT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_GLOBAL_JS_NAME_CONFLICT), new Object [] { param0 });
  }
  
  public final static String AST_GLOBAL_NAME_CONFLICT = "AST_GLOBAL_NAME_CONFLICT";
  
  /**
   * Globally defined element must not be named {0}.
   */
  public static String getMessageForAST_GLOBAL_NAME_CONFLICT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_GLOBAL_NAME_CONFLICT), new Object [] { param0 });
  }
  
  public final static String AST_GLOBAL_NAME_SHADOW_ERR = "AST_GLOBAL_NAME_SHADOW_ERR";
  
  /**
   * {0} shadows {1} from global scope.
   */
  public static String getMessageForAST_GLOBAL_NAME_SHADOW_ERR(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_GLOBAL_NAME_SHADOW_ERR), new Object [] { param0, param1 });
  }
  
  public final static String AST_INVALID_BREAK = "AST_INVALID_BREAK";
  
  /**
   * break statement without enclosing iteration or case block
   */
  public static String getMessageForAST_INVALID_BREAK() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_INVALID_BREAK), new Object [] {  });
  }
  
  public final static String AST_INVALID_CONTINUE = "AST_INVALID_CONTINUE";
  
  /**
   * continue statement without enclosing iteration
   */
  public static String getMessageForAST_INVALID_CONTINUE() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_INVALID_CONTINUE), new Object [] {  });
  }
  
  public final static String AST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN = "AST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN";
  
  /**
   * Only a variable or nested destructuring pattern is allowed at this location within a destructuring pattern.
   */
  public static String getMessageForAST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_INVALID_EXPR_IN_LHS_DESTRUCTURING_PATTERN), new Object [] {  });
  }
  
  public final static String AST_INVALID_LABEL = "AST_INVALID_LABEL";
  
  /**
   * Label must be of an enclosing iteration statement but may not cross function boundaries
   */
  public static String getMessageForAST_INVALID_LABEL() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_INVALID_LABEL), new Object [] {  });
  }
  
  public final static String AST_INVALID_NEW_TARGET = "AST_INVALID_NEW_TARGET";
  
  /**
   * Invalid new.target.
   */
  public static String getMessageForAST_INVALID_NEW_TARGET() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_INVALID_NEW_TARGET), new Object [] {  });
  }
  
  public final static String AST_INVALID_OPERAND = "AST_INVALID_OPERAND";
  
  /**
   * Invalid {0} operand.
   */
  public static String getMessageForAST_INVALID_OPERAND(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_INVALID_OPERAND), new Object [] { param0 });
  }
  
  public final static String AST_INVALID_PROPERTY_METHOD_IN_LHS_DESTRUCTURING_PATTERN = "AST_INVALID_PROPERTY_METHOD_IN_LHS_DESTRUCTURING_PATTERN";
  
  /**
   * Property methods are not allowed within an object destructuring pattern.
   */
  public static String getMessageForAST_INVALID_PROPERTY_METHOD_IN_LHS_DESTRUCTURING_PATTERN() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_INVALID_PROPERTY_METHOD_IN_LHS_DESTRUCTURING_PATTERN), new Object [] {  });
  }
  
  public final static String AST_INVALID_RETURN = "AST_INVALID_RETURN";
  
  /**
   * return statement without enclosing function
   */
  public static String getMessageForAST_INVALID_RETURN() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_INVALID_RETURN), new Object [] {  });
  }
  
  public final static String AST_INVALID_YIELD_EXPRESSION = "AST_INVALID_YIELD_EXPRESSION";
  
  /**
   * The parameter initializer of a generator may not contain a `yield` expression.
   */
  public static String getMessageForAST_INVALID_YIELD_EXPRESSION() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_INVALID_YIELD_EXPRESSION), new Object [] {  });
  }
  
  public final static String AST_LET_IN_STATEMENT_POSITION = "AST_LET_IN_STATEMENT_POSITION";
  
  /**
   * Let declarations may not appear in statement position.
   */
  public static String getMessageForAST_LET_IN_STATEMENT_POSITION() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_LET_IN_STATEMENT_POSITION), new Object [] {  });
  }
  
  public final static String AST_NAME_DUPLICATE_ERR = "AST_NAME_DUPLICATE_ERR";
  
  /**
   * {0} duplicates {1}.
   */
  public static String getMessageForAST_NAME_DUPLICATE_ERR(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_NAME_DUPLICATE_ERR), new Object [] { param0, param1 });
  }
  
  public final static String AST_NAME_DUPLICATE_WARN = "AST_NAME_DUPLICATE_WARN";
  
  /**
   * {0} duplicates {1}.
   */
  public static String getMessageForAST_NAME_DUPLICATE_WARN(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_NAME_DUPLICATE_WARN), new Object [] { param0, param1 });
  }
  
  public final static String AST_NAME_SHADOW_ERR = "AST_NAME_SHADOW_ERR";
  
  /**
   * {0} shadows {1}.
   */
  public static String getMessageForAST_NAME_SHADOW_ERR(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_NAME_SHADOW_ERR), new Object [] { param0, param1 });
  }
  
  public final static String AST_NAME_SHADOW_WARN = "AST_NAME_SHADOW_WARN";
  
  /**
   * {0} shadows {1}.
   */
  public static String getMessageForAST_NAME_SHADOW_WARN(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_NAME_SHADOW_WARN), new Object [] { param0, param1 });
  }
  
  public final static String AST_NO_FUNCTIONTYPEREFS_IN_CLASSIFIERTYPEREF = "AST_NO_FUNCTIONTYPEREFS_IN_CLASSIFIERTYPEREF";
  
  /**
   * Function types are not allowed in classifier type references.
   */
  public static String getMessageForAST_NO_FUNCTIONTYPEREFS_IN_CLASSIFIERTYPEREF() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_NO_FUNCTIONTYPEREFS_IN_CLASSIFIERTYPEREF), new Object [] {  });
  }
  
  public final static String AST_NO_TYPE_ARGS_IN_CLASSIFIERTYPEREF = "AST_NO_TYPE_ARGS_IN_CLASSIFIERTYPEREF";
  
  /**
   * Only raw types can be used in classifier type references.
   */
  public static String getMessageForAST_NO_TYPE_ARGS_IN_CLASSIFIERTYPEREF() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_NO_TYPE_ARGS_IN_CLASSIFIERTYPEREF), new Object [] {  });
  }
  
  public final static String AST_RESERVED_IDENTIFIER = "AST_RESERVED_IDENTIFIER";
  
  /**
   * {0} is a reserved identifier.
   */
  public static String getMessageForAST_RESERVED_IDENTIFIER(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_RESERVED_IDENTIFIER), new Object [] { param0 });
  }
  
  public final static String AST_REST_MUST_APPEAR_AT_END = "AST_REST_MUST_APPEAR_AT_END";
  
  /**
   * Rest operator only allowed on last element in an array destructuring pattern.
   */
  public static String getMessageForAST_REST_MUST_APPEAR_AT_END() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_REST_MUST_APPEAR_AT_END), new Object [] {  });
  }
  
  public final static String AST_REST_WITH_INITIALIZER = "AST_REST_WITH_INITIALIZER";
  
  /**
   * Rest operator does not support an initializer.
   */
  public static String getMessageForAST_REST_WITH_INITIALIZER() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_REST_WITH_INITIALIZER), new Object [] {  });
  }
  
  public final static String AST_SCRIPT_ANNO_INVALID_PLACEMENT = "AST_SCRIPT_ANNO_INVALID_PLACEMENT";
  
  /**
   * The script annotation @@{0} must be placed at the top of the module.
   */
  public static String getMessageForAST_SCRIPT_ANNO_INVALID_PLACEMENT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_SCRIPT_ANNO_INVALID_PLACEMENT), new Object [] { param0 });
  }
  
  public final static String AST_SINGLE_NAME_IN_OBJECT_LITERAL_UNSUPPORTED = "AST_SINGLE_NAME_IN_OBJECT_LITERAL_UNSUPPORTED";
  
  /**
   * Single name syntax in object literals is unsupported at the moment (only allowed in object destructuring patterns).
   */
  public static String getMessageForAST_SINGLE_NAME_IN_OBJECT_LITERAL_UNSUPPORTED() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_SINGLE_NAME_IN_OBJECT_LITERAL_UNSUPPORTED), new Object [] {  });
  }
  
  public final static String AST_SPREAD_IN_ARRAY_LITERAL_UNSUPPORTED = "AST_SPREAD_IN_ARRAY_LITERAL_UNSUPPORTED";
  
  /**
   * Spread operator in array literals is unsupported at the moment (only allowed in array destructuring patterns).
   */
  public static String getMessageForAST_SPREAD_IN_ARRAY_LITERAL_UNSUPPORTED() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_SPREAD_IN_ARRAY_LITERAL_UNSUPPORTED), new Object [] {  });
  }
  
  public final static String AST_STR_FUN_NOT_NESTED = "AST_STR_FUN_NOT_NESTED";
  
  /**
   * Functions must only be declared on script level or as part of other expressions
   */
  public static String getMessageForAST_STR_FUN_NOT_NESTED() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_STR_FUN_NOT_NESTED), new Object [] {  });
  }
  
  public final static String AST_STR_NO_OCTALS = "AST_STR_NO_OCTALS";
  
  /**
   * octal literals and octal escape sequences are not allowed in strict mode.
   */
  public static String getMessageForAST_STR_NO_OCTALS() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_STR_NO_OCTALS), new Object [] {  });
  }
  
  public final static String AST_STR_NO_WITH_STMT = "AST_STR_NO_WITH_STMT";
  
  /**
   * With statement not allowed.
   */
  public static String getMessageForAST_STR_NO_WITH_STMT() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_STR_NO_WITH_STMT), new Object [] {  });
  }
  
  public final static String AST_THIS_WRONG_PLACE = "AST_THIS_WRONG_PLACE";
  
  /**
   * The 'this' type isn't allowed on this place. (Please refer to Spec for valid use cases.)
   */
  public static String getMessageForAST_THIS_WRONG_PLACE() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_THIS_WRONG_PLACE), new Object [] {  });
  }
  
  public final static String AST_TOP_LEVEL_STATEMENTS = "AST_TOP_LEVEL_STATEMENTS";
  
  /**
   * Top-level statements are not supported in {0} files.
   */
  public static String getMessageForAST_TOP_LEVEL_STATEMENTS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_TOP_LEVEL_STATEMENTS), new Object [] { param0 });
  }
  
  public final static String AST_TYPE_DECL_MISSING_NAME = "AST_TYPE_DECL_MISSING_NAME";
  
  /**
   * Name missing in type declaration.
   */
  public static String getMessageForAST_TYPE_DECL_MISSING_NAME() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_TYPE_DECL_MISSING_NAME), new Object [] {  });
  }
  
  public final static String AST_VAR_DECL_IN_FOR_INVALID_INIT = "AST_VAR_DECL_IN_FOR_INVALID_INIT";
  
  /**
   * The iteration variable of a for..in or for..of loop must not be provided with an initializer.
   */
  public static String getMessageForAST_VAR_DECL_IN_FOR_INVALID_INIT() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_VAR_DECL_IN_FOR_INVALID_INIT), new Object [] {  });
  }
  
  public final static String AST_VAR_DECL_RECURSIVE = "AST_VAR_DECL_RECURSIVE";
  
  /**
   * Reference to variable {0} within the initializer expression of the declaration of {0}.
   */
  public static String getMessageForAST_VAR_DECL_RECURSIVE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_VAR_DECL_RECURSIVE), new Object [] { param0 });
  }
  
  public final static String AST_VAR_STMT_NO_DECL = "AST_VAR_STMT_NO_DECL";
  
  /**
   * A variable statement must at least contain one variable declaration.
   */
  public static String getMessageForAST_VAR_STMT_NO_DECL() {
    return org.eclipse.osgi.util.NLS.bind(getString(AST_VAR_STMT_NO_DECL), new Object [] {  });
  }
  
  public final static String BIT_SYMBOL_INVALID_USE = "BIT_SYMBOL_INVALID_USE";
  
  /**
   * Invalid use of 'Symbol': may only be used to create symbols (i.e. Symbol()) or to access built-in symbols (e.g. Symbol.iterator).
   */
  public static String getMessageForBIT_SYMBOL_INVALID_USE() {
    return org.eclipse.osgi.util.NLS.bind(getString(BIT_SYMBOL_INVALID_USE), new Object [] {  });
  }
  
  public final static String BIT_SYMBOL_NOT_A_CTOR = "BIT_SYMBOL_NOT_A_CTOR";
  
  /**
   * Symbol is not a constructor, use Symbol() without new.
   */
  public static String getMessageForBIT_SYMBOL_NOT_A_CTOR() {
    return org.eclipse.osgi.util.NLS.bind(getString(BIT_SYMBOL_NOT_A_CTOR), new Object [] {  });
  }
  
  public final static String CFG_LOCAL_VAR_UNUSED = "CFG_LOCAL_VAR_UNUSED";
  
  /**
   * The local variable {0} is never used
   */
  public static String getMessageForCFG_LOCAL_VAR_UNUSED(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CFG_LOCAL_VAR_UNUSED), new Object [] { param0 });
  }
  
  public final static String CFG_USED_BEFORE_DECLARED = "CFG_USED_BEFORE_DECLARED";
  
  /**
   * Variable {0} is used before it is declared
   */
  public static String getMessageForCFG_USED_BEFORE_DECLARED(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CFG_USED_BEFORE_DECLARED), new Object [] { param0 });
  }
  
  public final static String CLF_ABSTRACT_BODY = "CLF_ABSTRACT_BODY";
  
  /**
   * Abstract methods do not specify a body.
   */
  public static String getMessageForCLF_ABSTRACT_BODY() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_ABSTRACT_BODY), new Object [] {  });
  }
  
  public final static String CLF_ABSTRACT_FINAL = "CLF_ABSTRACT_FINAL";
  
  /**
   * An abstract {0} cannot be declared final.
   */
  public static String getMessageForCLF_ABSTRACT_FINAL(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_ABSTRACT_FINAL), new Object [] { param0 });
  }
  
  public final static String CLF_ABSTRACT_MISSING = "CLF_ABSTRACT_MISSING";
  
  /**
   * The abstract {0} {1} in class {2} can only be defined in an abstract class.
   */
  public static String getMessageForCLF_ABSTRACT_MISSING(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_ABSTRACT_MISSING), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_CANNOT_CALL_ABSTRACT_SUPER_METHOD = "CLF_CANNOT_CALL_ABSTRACT_SUPER_METHOD";
  
  /**
   * Cannot call super method since it is abstract.
   */
  public static String getMessageForCLF_CANNOT_CALL_ABSTRACT_SUPER_METHOD() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CANNOT_CALL_ABSTRACT_SUPER_METHOD), new Object [] {  });
  }
  
  public final static String CLF_CANNOT_REFER_TO_DEFAULT_METHOD_WITH_SUPER = "CLF_CANNOT_REFER_TO_DEFAULT_METHOD_WITH_SUPER";
  
  /**
   * Cannot refer to default method of an implemented interface with super.
   */
  public static String getMessageForCLF_CANNOT_REFER_TO_DEFAULT_METHOD_WITH_SUPER() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CANNOT_REFER_TO_DEFAULT_METHOD_WITH_SUPER), new Object [] {  });
  }
  
  public final static String CLF_CONSUMED_FIELD_ACCESSOR_PAIR_INCOMPLETE = "CLF_CONSUMED_FIELD_ACCESSOR_PAIR_INCOMPLETE";
  
  /**
   * Missing {0} to completely override consumed {1}."
   */
  public static String getMessageForCLF_CONSUMED_FIELD_ACCESSOR_PAIR_INCOMPLETE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CONSUMED_FIELD_ACCESSOR_PAIR_INCOMPLETE), new Object [] { param0, param1 });
  }
  
  public final static String CLF_CONSUMED_INHERITED_MEMBER_UNSOLVABLE_CONFLICT = "CLF_CONSUMED_INHERITED_MEMBER_UNSOLVABLE_CONFLICT";
  
  /**
   * Inherited {0} cannot implement {1}.
   */
  public static String getMessageForCLF_CONSUMED_INHERITED_MEMBER_UNSOLVABLE_CONFLICT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CONSUMED_INHERITED_MEMBER_UNSOLVABLE_CONFLICT), new Object [] { param0, param1 });
  }
  
  public final static String CLF_CONSUMED_MEMBER_SOLVABLE_CONFLICT = "CLF_CONSUMED_MEMBER_SOLVABLE_CONFLICT";
  
  /**
   * Redefine ambiguously consumed members: {0}.
   */
  public static String getMessageForCLF_CONSUMED_MEMBER_SOLVABLE_CONFLICT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CONSUMED_MEMBER_SOLVABLE_CONFLICT), new Object [] { param0 });
  }
  
  public final static String CLF_CONSUMED_MEMBER_UNSOLVABLE_CONFLICT = "CLF_CONSUMED_MEMBER_UNSOLVABLE_CONFLICT";
  
  /**
   * Incompatible consumed members: {0}.
   */
  public static String getMessageForCLF_CONSUMED_MEMBER_UNSOLVABLE_CONFLICT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CONSUMED_MEMBER_UNSOLVABLE_CONFLICT), new Object [] { param0 });
  }
  
  public final static String CLF_CONSUMED_OVERRIDE_FIELD = "CLF_CONSUMED_OVERRIDE_FIELD";
  
  /**
   * The consumed {0} cannot override {1}.
   */
  public static String getMessageForCLF_CONSUMED_OVERRIDE_FIELD(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CONSUMED_OVERRIDE_FIELD), new Object [] { param0, param1 });
  }
  
  public final static String CLF_CONSUMED_OVERRIDE_MEMBERTYPE_INCOMPATIBLE = "CLF_CONSUMED_OVERRIDE_MEMBERTYPE_INCOMPATIBLE";
  
  /**
   * Cannot override {1} with consumed {0}.
   */
  public static String getMessageForCLF_CONSUMED_OVERRIDE_MEMBERTYPE_INCOMPATIBLE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CONSUMED_OVERRIDE_MEMBERTYPE_INCOMPATIBLE), new Object [] { param0, param1 });
  }
  
  public final static String CLF_CTOR_CALLABLE_DUPLICATE = "CLF_CTOR_CALLABLE_DUPLICATE";
  
  /**
   * Duplicate callable constructor.
   */
  public static String getMessageForCLF_CTOR_CALLABLE_DUPLICATE() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CTOR_CALLABLE_DUPLICATE), new Object [] {  });
  }
  
  public final static String CLF_CTOR_CALLABLE_ONLY_IN_CLASS = "CLF_CTOR_CALLABLE_ONLY_IN_CLASS";
  
  /**
   * Callable constructors may only be used in classes (not in interfaces).
   */
  public static String getMessageForCLF_CTOR_CALLABLE_ONLY_IN_CLASS() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CTOR_CALLABLE_ONLY_IN_CLASS), new Object [] {  });
  }
  
  public final static String CLF_CTOR_CALLABLE_ONLY_IN_N4JSD = "CLF_CTOR_CALLABLE_ONLY_IN_N4JSD";
  
  /**
   * Callable constructors may only be used in .n4jsd files.
   */
  public static String getMessageForCLF_CTOR_CALLABLE_ONLY_IN_N4JSD() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CTOR_CALLABLE_ONLY_IN_N4JSD), new Object [] {  });
  }
  
  public final static String CLF_CTOR_ILLEGAL_MODIFIER = "CLF_CTOR_ILLEGAL_MODIFIER";
  
  /**
   * A constructor must not be declared abstract, static or final and may not be annotated with @Override.
   */
  public static String getMessageForCLF_CTOR_ILLEGAL_MODIFIER() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CTOR_ILLEGAL_MODIFIER), new Object [] {  });
  }
  
  public final static String CLF_CTOR_NO_TYPE_PARAMETERS = "CLF_CTOR_NO_TYPE_PARAMETERS";
  
  /**
   * Constructors must not have any type parameters.
   */
  public static String getMessageForCLF_CTOR_NO_TYPE_PARAMETERS() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CTOR_NO_TYPE_PARAMETERS), new Object [] {  });
  }
  
  public final static String CLF_CTOR_RETURN_TYPE = "CLF_CTOR_RETURN_TYPE";
  
  /**
   * A constructor must not have a return type declaration.
   */
  public static String getMessageForCLF_CTOR_RETURN_TYPE() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_CTOR_RETURN_TYPE), new Object [] {  });
  }
  
  public final static String CLF_DEF_SITE_VARIANCE_ONLY_IN_CLASSIFIER = "CLF_DEF_SITE_VARIANCE_ONLY_IN_CLASSIFIER";
  
  /**
   * Declaration of definition-site variance only allowed in generic classes and interfaces, not in generic functions or methods.
   */
  public static String getMessageForCLF_DEF_SITE_VARIANCE_ONLY_IN_CLASSIFIER() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_DEF_SITE_VARIANCE_ONLY_IN_CLASSIFIER), new Object [] {  });
  }
  
  public final static String CLF_DUP_CTOR = "CLF_DUP_CTOR";
  
  /**
   * Constructor line {0} duplicates constructor in line {1}.
   */
  public static String getMessageForCLF_DUP_CTOR(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_DUP_CTOR), new Object [] { param0, param1 });
  }
  
  public final static String CLF_DUP_MEMBER = "CLF_DUP_MEMBER";
  
  /**
   * The {0} duplicates {1}.
   */
  public static String getMessageForCLF_DUP_MEMBER(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_DUP_MEMBER), new Object [] { param0, param1 });
  }
  
  public final static String CLF_DUP_MODULE = "CLF_DUP_MODULE";
  
  /**
   * A duplicate module {0} is also defined in {1}.
   */
  public static String getMessageForCLF_DUP_MODULE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_DUP_MODULE), new Object [] { param0, param1 });
  }
  
  public final static String CLF_DUP_WITH_MEMBER = "CLF_DUP_WITH_MEMBER";
  
  /**
   * The {0} conflicts with the structural this type in the inherit constructor definition.
   */
  public static String getMessageForCLF_DUP_WITH_MEMBER(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_DUP_WITH_MEMBER), new Object [] { param0 });
  }
  
  public final static String CLF_EXTENDS_PRIMITIVE_GENERIC_TYPE = "CLF_EXTENDS_PRIMITIVE_GENERIC_TYPE";
  
  /**
   * Cannot subclass primitive type {0}.
   */
  public static String getMessageForCLF_EXTENDS_PRIMITIVE_GENERIC_TYPE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXTENDS_PRIMITIVE_GENERIC_TYPE), new Object [] { param0 });
  }
  
  public final static String CLF_EXTEND_FINAL = "CLF_EXTEND_FINAL";
  
  /**
   * Cannot extend final class {0}.
   */
  public static String getMessageForCLF_EXTEND_FINAL(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXTEND_FINAL), new Object [] { param0 });
  }
  
  public final static String CLF_EXTEND_NON_ACCESSIBLE_CTOR = "CLF_EXTEND_NON_ACCESSIBLE_CTOR";
  
  /**
   * Cannot extend {0} {1} because its constructor is not accessible.
   */
  public static String getMessageForCLF_EXTEND_NON_ACCESSIBLE_CTOR(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXTEND_NON_ACCESSIBLE_CTOR), new Object [] { param0, param1 });
  }
  
  public final static String CLF_EXT_ANNOTATED_CONSUME = "CLF_EXT_ANNOTATED_CONSUME";
  
  /**
   * External {0} annotated with @N4JS aren't allowed to consume interfaces without such annotation.
   */
  public static String getMessageForCLF_EXT_ANNOTATED_CONSUME(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_ANNOTATED_CONSUME), new Object [] { param0 });
  }
  
  public final static String CLF_EXT_ANNOTATED_EXTEND = "CLF_EXT_ANNOTATED_EXTEND";
  
  /**
   * External classes annotated with @N4JS aren't allowed to extend a class without such annotation.
   */
  public static String getMessageForCLF_EXT_ANNOTATED_EXTEND() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_ANNOTATED_EXTEND), new Object [] {  });
  }
  
  public final static String CLF_EXT_ANNOTATED_EXT_INTERF = "CLF_EXT_ANNOTATED_EXT_INTERF";
  
  /**
   * Interfaces annotated with @N4JS aren't allowed to extend interfaces without such annotation.
   */
  public static String getMessageForCLF_EXT_ANNOTATED_EXT_INTERF() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_ANNOTATED_EXT_INTERF), new Object [] {  });
  }
  
  public final static String CLF_EXT_ANNOTATED_IMPLEMENTS = "CLF_EXT_ANNOTATED_IMPLEMENTS";
  
  /**
   * External {0} annotated with @N4JS aren't allowed to implement interfaces without such annotation.
   */
  public static String getMessageForCLF_EXT_ANNOTATED_IMPLEMENTS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_ANNOTATED_IMPLEMENTS), new Object [] { param0 });
  }
  
  public final static String CLF_EXT_CONSUME_NON_EXT = "CLF_EXT_CONSUME_NON_EXT";
  
  /**
   * External {0} aren't allowed to consume a non external interface.
   */
  public static String getMessageForCLF_EXT_CONSUME_NON_EXT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_CONSUME_NON_EXT), new Object [] { param0 });
  }
  
  public final static String CLF_EXT_DUPLICATE_PATH_SRC_EXTERNAL = "CLF_EXT_DUPLICATE_PATH_SRC_EXTERNAL";
  
  /**
   * Duplicate external file {0}, has been already defined in {1}.
   */
  public static String getMessageForCLF_EXT_DUPLICATE_PATH_SRC_EXTERNAL(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_DUPLICATE_PATH_SRC_EXTERNAL), new Object [] { param0, param1 });
  }
  
  public final static String CLF_EXT_EXPORTED = "CLF_EXT_EXPORTED";
  
  /**
   * External elements have to be exported.
   */
  public static String getMessageForCLF_EXT_EXPORTED() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_EXPORTED), new Object [] {  });
  }
  
  public final static String CLF_EXT_EXTENDS_NON_EXT_INTERF = "CLF_EXT_EXTENDS_NON_EXT_INTERF";
  
  /**
   * Interfaces in n4jsd files aren't allowed to extend interfaces from non n4jsd files.
   */
  public static String getMessageForCLF_EXT_EXTENDS_NON_EXT_INTERF() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_EXTENDS_NON_EXT_INTERF), new Object [] {  });
  }
  
  public final static String CLF_EXT_EXTERNAL = "CLF_EXT_EXTERNAL";
  
  /**
   * External {0} have to be marked as 'external' in n4jsd files.
   */
  public static String getMessageForCLF_EXT_EXTERNAL(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_EXTERNAL), new Object [] { param0 });
  }
  
  public final static String CLF_EXT_EXTERNAL_N4JSD = "CLF_EXT_EXTERNAL_N4JSD";
  
  /**
   * {0} declared as external have to be placed in a file with file extension 'n4jsd'.
   */
  public static String getMessageForCLF_EXT_EXTERNAL_N4JSD(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_EXTERNAL_N4JSD), new Object [] { param0 });
  }
  
  public final static String CLF_EXT_FUN_NO_BODY = "CLF_EXT_FUN_NO_BODY";
  
  /**
   * External function declarations have to have no body.
   */
  public static String getMessageForCLF_EXT_FUN_NO_BODY() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_FUN_NO_BODY), new Object [] {  });
  }
  
  public final static String CLF_EXT_IMPLEMENTS_NON_EXT = "CLF_EXT_IMPLEMENTS_NON_EXT";
  
  /**
   * External {0} aren't allowed to implement an interface from a non n4jsd file.
   */
  public static String getMessageForCLF_EXT_IMPLEMENTS_NON_EXT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_IMPLEMENTS_NON_EXT), new Object [] { param0 });
  }
  
  public final static String CLF_EXT_INTF_PUBLIC = "CLF_EXT_INTF_PUBLIC";
  
  /**
   * Structural typed interfaces in n4jsd files have to be marked as 'public' (and without @Internal).
   */
  public static String getMessageForCLF_EXT_INTF_PUBLIC() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_INTF_PUBLIC), new Object [] {  });
  }
  
  public final static String CLF_EXT_LITERAL_NO_VALUE = "CLF_EXT_LITERAL_NO_VALUE";
  
  /**
   * An enumeration literal in a n4jsd file isn't allowed to define a value.
   */
  public static String getMessageForCLF_EXT_LITERAL_NO_VALUE() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_LITERAL_NO_VALUE), new Object [] {  });
  }
  
  public final static String CLF_EXT_METHOD_NO_ANNO = "CLF_EXT_METHOD_NO_ANNO";
  
  /**
   * {0} in external {1} must not have the {2} annotation.
   */
  public static String getMessageForCLF_EXT_METHOD_NO_ANNO(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_METHOD_NO_ANNO), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_EXT_NOT_ANNOTATED_EXTEND_N4OBJECT = "CLF_EXT_NOT_ANNOTATED_EXTEND_N4OBJECT";
  
  /**
   * External classes without annotation @N4JS aren't allowed to inherit from n4js classes.
   */
  public static String getMessageForCLF_EXT_NOT_ANNOTATED_EXTEND_N4OBJECT() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_NOT_ANNOTATED_EXTEND_N4OBJECT), new Object [] {  });
  }
  
  public final static String CLF_EXT_NO_FIELD_EXPR = "CLF_EXT_NO_FIELD_EXPR";
  
  /**
   * Fields in external {0} have to have no right side.
   */
  public static String getMessageForCLF_EXT_NO_FIELD_EXPR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_NO_FIELD_EXPR), new Object [] { param0 });
  }
  
  public final static String CLF_EXT_NO_MATCH = "CLF_EXT_NO_MATCH";
  
  /**
   * For the given n4jsd file no corresponding external file resp. no matching implemented by expression can be found.
   */
  public static String getMessageForCLF_EXT_NO_MATCH() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_NO_MATCH), new Object [] {  });
  }
  
  public final static String CLF_EXT_NO_METHOD_BODY = "CLF_EXT_NO_METHOD_BODY";
  
  /**
   * {0} in external {1} have to have no body.
   */
  public static String getMessageForCLF_EXT_NO_METHOD_BODY(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_NO_METHOD_BODY), new Object [] { param0, param1 });
  }
  
  public final static String CLF_EXT_NO_OBSERV_ANNO = "CLF_EXT_NO_OBSERV_ANNO";
  
  /**
   * External {0} must not have the Observable annotation.
   */
  public static String getMessageForCLF_EXT_NO_OBSERV_ANNO(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_NO_OBSERV_ANNO), new Object [] { param0 });
  }
  
  public final static String CLF_EXT_PROVIDED_BY_RUNTIME_IN_RUNTIME_TYPE = "CLF_EXT_PROVIDED_BY_RUNTIME_IN_RUNTIME_TYPE";
  
  /**
   * Only runtime environments/libraries may specify elements provided by runtime.
   */
  public static String getMessageForCLF_EXT_PROVIDED_BY_RUNTIME_IN_RUNTIME_TYPE() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_PROVIDED_BY_RUNTIME_IN_RUNTIME_TYPE), new Object [] {  });
  }
  
  public final static String CLF_EXT_PROVIDES_IMPL_ONLY_IN_DEFFILES = "CLF_EXT_PROVIDES_IMPL_ONLY_IN_DEFFILES";
  
  /**
   * @{0} must only be used in external {1} in n4jsd files.
   */
  public static String getMessageForCLF_EXT_PROVIDES_IMPL_ONLY_IN_DEFFILES(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_PROVIDES_IMPL_ONLY_IN_DEFFILES), new Object [] { param0, param1 });
  }
  
  public final static String CLF_EXT_PROVIDES_IMPL_ONLY_IN_INTERFACE_MEMBERS = "CLF_EXT_PROVIDES_IMPL_ONLY_IN_INTERFACE_MEMBERS";
  
  /**
   * @{0} must only be used in {1}.
   */
  public static String getMessageForCLF_EXT_PROVIDES_IMPL_ONLY_IN_INTERFACE_MEMBERS(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_PROVIDES_IMPL_ONLY_IN_INTERFACE_MEMBERS), new Object [] { param0, param1 });
  }
  
  public final static String CLF_EXT_PROVIDES_IMPL_ONLY_IN_N4JS_INTERFACES = "CLF_EXT_PROVIDES_IMPL_ONLY_IN_N4JS_INTERFACES";
  
  /**
   * @{0} must only be used in {1} annotated with @N4JS.
   */
  public static String getMessageForCLF_EXT_PROVIDES_IMPL_ONLY_IN_N4JS_INTERFACES(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_PROVIDES_IMPL_ONLY_IN_N4JS_INTERFACES), new Object [] { param0, param1 });
  }
  
  public final static String CLF_EXT_PUBLIC = "CLF_EXT_PUBLIC";
  
  /**
   * External {0} have to be marked as 'public' (and without @Internal).
   */
  public static String getMessageForCLF_EXT_PUBLIC(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_PUBLIC), new Object [] { param0 });
  }
  
  public final static String CLF_EXT_PUBLIC_CONSTRUCTOR = "CLF_EXT_PUBLIC_CONSTRUCTOR";
  
  /**
   * External classes have to have a public constructor, unless they are annotated with @N4JS.
   */
  public static String getMessageForCLF_EXT_PUBLIC_CONSTRUCTOR() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_PUBLIC_CONSTRUCTOR), new Object [] {  });
  }
  
  public final static String CLF_EXT_UNALLOWED_N4JSD = "CLF_EXT_UNALLOWED_N4JSD";
  
  /**
   * Only classes, interfaces, enums and functions declared as external as well as structural typed interfaces are allowed in n4jsd files.
   */
  public static String getMessageForCLF_EXT_UNALLOWED_N4JSD() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_UNALLOWED_N4JSD), new Object [] {  });
  }
  
  public final static String CLF_EXT_VAR_NO_VAL = "CLF_EXT_VAR_NO_VAL";
  
  /**
   * External {0} declaration cannot be initialized.
   */
  public static String getMessageForCLF_EXT_VAR_NO_VAL(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_EXT_VAR_NO_VAL), new Object [] { param0 });
  }
  
  public final static String CLF_FIELD_CONST_FINAL = "CLF_FIELD_CONST_FINAL";
  
  /**
   * A field may not be declared both final and const.
   */
  public static String getMessageForCLF_FIELD_CONST_FINAL() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_FIELD_CONST_FINAL), new Object [] {  });
  }
  
  public final static String CLF_FIELD_CONST_MISSING_INIT = "CLF_FIELD_CONST_MISSING_INIT";
  
  /**
   * Const field {0} must be provided with an initializer.
   */
  public static String getMessageForCLF_FIELD_CONST_MISSING_INIT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_FIELD_CONST_MISSING_INIT), new Object [] { param0 });
  }
  
  public final static String CLF_FIELD_CONST_STATIC = "CLF_FIELD_CONST_STATIC";
  
  /**
   * All const fields are static. Remove unnecessary modifier 'static'.
   */
  public static String getMessageForCLF_FIELD_CONST_STATIC() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_FIELD_CONST_STATIC), new Object [] {  });
  }
  
  public final static String CLF_FIELD_FINAL_MISSING_INIT = "CLF_FIELD_FINAL_MISSING_INIT";
  
  /**
   * Final field {0} must be provided with an initializer or must be initialized in the constructor.
   */
  public static String getMessageForCLF_FIELD_FINAL_MISSING_INIT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_FIELD_FINAL_MISSING_INIT), new Object [] { param0 });
  }
  
  public final static String CLF_FIELD_FINAL_MISSING_INIT_IN_STATIC_POLYFILL = "CLF_FIELD_FINAL_MISSING_INIT_IN_STATIC_POLYFILL";
  
  /**
   * Final field {0} must be provided with an initializer or must be initialized in the constructor. HINT: You might want to check the polyfilled constructor.
   */
  public static String getMessageForCLF_FIELD_FINAL_MISSING_INIT_IN_STATIC_POLYFILL(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_FIELD_FINAL_MISSING_INIT_IN_STATIC_POLYFILL), new Object [] { param0 });
  }
  
  public final static String CLF_FIELD_FINAL_REINIT_IN_CTOR = "CLF_FIELD_FINAL_REINIT_IN_CTOR";
  
  /**
   * Final field {0} has an initializer and may therefore not be initialized in the constructor.
   */
  public static String getMessageForCLF_FIELD_FINAL_REINIT_IN_CTOR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_FIELD_FINAL_REINIT_IN_CTOR), new Object [] { param0 });
  }
  
  public final static String CLF_FIELD_FINAL_STATIC = "CLF_FIELD_FINAL_STATIC";
  
  /**
   * A field may not be declared both final and static. Use a const field instead.
   */
  public static String getMessageForCLF_FIELD_FINAL_STATIC() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_FIELD_FINAL_STATIC), new Object [] {  });
  }
  
  public final static String CLF_FIELD_OPTIONAL_OLD_SYNTAX = "CLF_FIELD_OPTIONAL_OLD_SYNTAX";
  
  /**
   * This syntax for optional fields is no longer allowed. Place the ? right after the field's name.
   */
  public static String getMessageForCLF_FIELD_OPTIONAL_OLD_SYNTAX() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_FIELD_OPTIONAL_OLD_SYNTAX), new Object [] {  });
  }
  
  public final static String CLF_IMPLEMENT_EXTEND_SAME_INTERFACE_INCONSISTENTLY = "CLF_IMPLEMENT_EXTEND_SAME_INTERFACE_INCONSISTENTLY";
  
  /**
   * Cannot {0} interface {1} multiple times with different type arguments for {2}: {3}.
   */
  public static String getMessageForCLF_IMPLEMENT_EXTEND_SAME_INTERFACE_INCONSISTENTLY(final Object param0, final Object param1, final Object param2, final Object param3) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_IMPLEMENT_EXTEND_SAME_INTERFACE_INCONSISTENTLY), new Object [] { param0, param1, param2, param3 });
  }
  
  public final static String CLF_IMPLEMENT_EXTEND_WITH_WILDCARD = "CLF_IMPLEMENT_EXTEND_WITH_WILDCARD";
  
  /**
   * Wildcards may not be used as type argument when declaring an extended or implemented type.
   */
  public static String getMessageForCLF_IMPLEMENT_EXTEND_WITH_WILDCARD() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_IMPLEMENT_EXTEND_WITH_WILDCARD), new Object [] {  });
  }
  
  public final static String CLF_IMPLEMENT_MEMBERTYPE_INCOMPATIBLE = "CLF_IMPLEMENT_MEMBERTYPE_INCOMPATIBLE";
  
  /**
   * Cannot implement {1} with {0}.{2}
   */
  public static String getMessageForCLF_IMPLEMENT_MEMBERTYPE_INCOMPATIBLE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_IMPLEMENT_MEMBERTYPE_INCOMPATIBLE), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_IMPLEMENT_MIXIN_CONFLICTS = "CLF_IMPLEMENT_MIXIN_CONFLICTS";
  
  /**
   * The {0} cannot be mixed in {1} due to conflicts.
   */
  public static String getMessageForCLF_IMPLEMENT_MIXIN_CONFLICTS(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_IMPLEMENT_MIXIN_CONFLICTS), new Object [] { param0, param1 });
  }
  
  public final static String CLF_INHERITANCE_CYCLE = "CLF_INHERITANCE_CYCLE";
  
  /**
   * Inheritance cycle detected: {0}.
   */
  public static String getMessageForCLF_INHERITANCE_CYCLE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_INHERITANCE_CYCLE), new Object [] { param0 });
  }
  
  public final static String CLF_INTERNAL_BAD_WITH_PRIVATE_OR_PROJECT = "CLF_INTERNAL_BAD_WITH_PRIVATE_OR_PROJECT";
  
  /**
   * @Internal is only allowed for public and protected.
   */
  public static String getMessageForCLF_INTERNAL_BAD_WITH_PRIVATE_OR_PROJECT() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_INTERNAL_BAD_WITH_PRIVATE_OR_PROJECT), new Object [] {  });
  }
  
  public final static String CLF_INVALID_ACCESS_OF_STATIC_MEMBER_OF_INTERFACE = "CLF_INVALID_ACCESS_OF_STATIC_MEMBER_OF_INTERFACE";
  
  /**
   * Static members of interfaces may only be accessed directly via the type name of their containing interface.
   */
  public static String getMessageForCLF_INVALID_ACCESS_OF_STATIC_MEMBER_OF_INTERFACE() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_INVALID_ACCESS_OF_STATIC_MEMBER_OF_INTERFACE), new Object [] {  });
  }
  
  public final static String CLF_LOW_ACCESSOR_WITH_INTERNAL = "CLF_LOW_ACCESSOR_WITH_INTERNAL";
  
  /**
   * A {0} with visibility {1} shouldn't be annotated with @Internal.
   */
  public static String getMessageForCLF_LOW_ACCESSOR_WITH_INTERNAL(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_LOW_ACCESSOR_WITH_INTERNAL), new Object [] { param0, param1 });
  }
  
  public final static String CLF_METHOD_BODY_FORBIDDEN_REFERENCE_NAME = "CLF_METHOD_BODY_FORBIDDEN_REFERENCE_NAME";
  
  /**
   * A reference to a function ending with "___n4" is not allowed inside a method-body.
   */
  public static String getMessageForCLF_METHOD_BODY_FORBIDDEN_REFERENCE_NAME() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_METHOD_BODY_FORBIDDEN_REFERENCE_NAME), new Object [] {  });
  }
  
  public final static String CLF_MINIMAL_ACCESSIBILITY_IN_INTERFACES = "CLF_MINIMAL_ACCESSIBILITY_IN_INTERFACES";
  
  /**
   * Members of interfaces must not be declared private.
   */
  public static String getMessageForCLF_MINIMAL_ACCESSIBILITY_IN_INTERFACES() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_MINIMAL_ACCESSIBILITY_IN_INTERFACES), new Object [] {  });
  }
  
  public final static String CLF_MISSING_BODY = "CLF_MISSING_BODY";
  
  /**
   * The {0} {1} has to have either a body or must be defined abstract.
   */
  public static String getMessageForCLF_MISSING_BODY(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_MISSING_BODY), new Object [] { param0, param1 });
  }
  
  public final static String CLF_MISSING_CTOR_BODY = "CLF_MISSING_CTOR_BODY";
  
  /**
   * Constructors must have a body.
   */
  public static String getMessageForCLF_MISSING_CTOR_BODY() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_MISSING_CTOR_BODY), new Object [] {  });
  }
  
  public final static String CLF_MISSING_IMPLEMENTATION = "CLF_MISSING_IMPLEMENTATION";
  
  /**
   * Class {0} must either be declared abstract or implement {1}.
   */
  public static String getMessageForCLF_MISSING_IMPLEMENTATION(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_MISSING_IMPLEMENTATION), new Object [] { param0, param1 });
  }
  
  public final static String CLF_MISSING_IMPLEMENTATION_EXT = "CLF_MISSING_IMPLEMENTATION_EXT";
  
  /**
   * External class {0} must either be declared abstract or explicit declare {1}.
   */
  public static String getMessageForCLF_MISSING_IMPLEMENTATION_EXT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_MISSING_IMPLEMENTATION_EXT), new Object [] { param0, param1 });
  }
  
  public final static String CLF_MULTIPLE_ROLE_CONSUME = "CLF_MULTIPLE_ROLE_CONSUME";
  
  /**
   * Cannot consume {0} multiple times.
   */
  public static String getMessageForCLF_MULTIPLE_ROLE_CONSUME(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_MULTIPLE_ROLE_CONSUME), new Object [] { param0 });
  }
  
  public final static String CLF_NAME_CONFLICTS_WITH_CONSTRUCTOR = "CLF_NAME_CONFLICTS_WITH_CONSTRUCTOR";
  
  /**
   * Name may be confused with constructor.
   */
  public static String getMessageForCLF_NAME_CONFLICTS_WITH_CONSTRUCTOR() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NAME_CONFLICTS_WITH_CONSTRUCTOR), new Object [] {  });
  }
  
  public final static String CLF_NAME_CONTAINS_DISCOURAGED_CHARACTER = "CLF_NAME_CONTAINS_DISCOURAGED_CHARACTER";
  
  /**
   * Name should not contain {0} character.
   */
  public static String getMessageForCLF_NAME_CONTAINS_DISCOURAGED_CHARACTER(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NAME_CONTAINS_DISCOURAGED_CHARACTER), new Object [] { param0 });
  }
  
  public final static String CLF_NAME_DIFFERS_TYPE = "CLF_NAME_DIFFERS_TYPE";
  
  /**
   * {0} is not of type {1} but of type {2}.
   */
  public static String getMessageForCLF_NAME_DIFFERS_TYPE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NAME_DIFFERS_TYPE), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_NAME_DOES_NOT_MATCH_WITH_PATTERN_FOR_STATIC_OR_CONST = "CLF_NAME_DOES_NOT_MATCH_WITH_PATTERN_FOR_STATIC_OR_CONST";
  
  /**
   * Name should be all upper case with words separated by underscores for variables with {0} modifier.
   */
  public static String getMessageForCLF_NAME_DOES_NOT_MATCH_WITH_PATTERN_FOR_STATIC_OR_CONST(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NAME_DOES_NOT_MATCH_WITH_PATTERN_FOR_STATIC_OR_CONST), new Object [] { param0 });
  }
  
  public final static String CLF_NAME_DOES_NOT_START_LOWERCASE = "CLF_NAME_DOES_NOT_START_LOWERCASE";
  
  /**
   * {0} names should start with lower case letter.
   */
  public static String getMessageForCLF_NAME_DOES_NOT_START_LOWERCASE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NAME_DOES_NOT_START_LOWERCASE), new Object [] { param0 });
  }
  
  public final static String CLF_NAME_DOES_NOT_START_UPPERCASE = "CLF_NAME_DOES_NOT_START_UPPERCASE";
  
  /**
   * {0} names should start with upper case letter.
   */
  public static String getMessageForCLF_NAME_DOES_NOT_START_UPPERCASE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NAME_DOES_NOT_START_UPPERCASE), new Object [] { param0 });
  }
  
  public final static String CLF_NAME_DOLLAR = "CLF_NAME_DOLLAR";
  
  /**
   * Member names must not start with a dollar character.
   */
  public static String getMessageForCLF_NAME_DOLLAR() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NAME_DOLLAR), new Object [] {  });
  }
  
  public final static String CLF_NAME_INDISTINGUISHABLE = "CLF_NAME_INDISTINGUISHABLE";
  
  /**
   * {0} may be indistinguishable with {1}.
   */
  public static String getMessageForCLF_NAME_INDISTINGUISHABLE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NAME_INDISTINGUISHABLE), new Object [] { param0, param1 });
  }
  
  public final static String CLF_NAME_RESERVED = "CLF_NAME_RESERVED";
  
  /**
   * {0} may be confused with {1}.
   */
  public static String getMessageForCLF_NAME_RESERVED(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NAME_RESERVED), new Object [] { param0, param1 });
  }
  
  public final static String CLF_NON_ACCESSIBLE_ABSTRACT_MEMBERS = "CLF_NON_ACCESSIBLE_ABSTRACT_MEMBERS";
  
  /**
   * Cannot {0} {1}: cannot implement one or more non-accessible abstract members: {2}.
   */
  public static String getMessageForCLF_NON_ACCESSIBLE_ABSTRACT_MEMBERS(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NON_ACCESSIBLE_ABSTRACT_MEMBERS), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_NOT_EXPORTED_NOT_PRIVATE = "CLF_NOT_EXPORTED_NOT_PRIVATE";
  
  /**
   * A {0} with visibility {1} must be marked as exported.
   */
  public static String getMessageForCLF_NOT_EXPORTED_NOT_PRIVATE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NOT_EXPORTED_NOT_PRIVATE), new Object [] { param0, param1 });
  }
  
  public final static String CLF_NO_FINAL_INTERFACE_MEMBER = "CLF_NO_FINAL_INTERFACE_MEMBER";
  
  /**
   * In interfaces, only methods may be declared final.
   */
  public static String getMessageForCLF_NO_FINAL_INTERFACE_MEMBER() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NO_FINAL_INTERFACE_MEMBER), new Object [] {  });
  }
  
  public final static String CLF_NO_THIS_IN_FIELD_OF_INTERFACE = "CLF_NO_THIS_IN_FIELD_OF_INTERFACE";
  
  /**
   * In interfaces, the 'this' literal may not be used in initializers of data fields.
   */
  public static String getMessageForCLF_NO_THIS_IN_FIELD_OF_INTERFACE() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NO_THIS_IN_FIELD_OF_INTERFACE), new Object [] {  });
  }
  
  public final static String CLF_NO_THIS_IN_STATIC_FIELD = "CLF_NO_THIS_IN_STATIC_FIELD";
  
  /**
   * The 'this' literal may not be used in initializers of static data fields.
   */
  public static String getMessageForCLF_NO_THIS_IN_STATIC_FIELD() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NO_THIS_IN_STATIC_FIELD), new Object [] {  });
  }
  
  public final static String CLF_NO_THIS_IN_STATIC_MEMBER_OF_INTERFACE = "CLF_NO_THIS_IN_STATIC_MEMBER_OF_INTERFACE";
  
  /**
   * In interfaces, the 'this' literal may not be used in static methods or field accessors and in initializers of static data fields.
   */
  public static String getMessageForCLF_NO_THIS_IN_STATIC_MEMBER_OF_INTERFACE() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_NO_THIS_IN_STATIC_MEMBER_OF_INTERFACE), new Object [] {  });
  }
  
  public final static String CLF_OBSERVABLE_MISSING = "CLF_OBSERVABLE_MISSING";
  
  /**
   * Class {0} extends observable class {1} and must therefore be annotated with @Observable.
   */
  public static String getMessageForCLF_OBSERVABLE_MISSING(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_OBSERVABLE_MISSING), new Object [] { param0, param1 });
  }
  
  public final static String CLF_OVERRIDEN_CONCRETE_WITH_ABSTRACT = "CLF_OVERRIDEN_CONCRETE_WITH_ABSTRACT";
  
  /**
   * The abstract {0} cannot override concrete {1}.
   */
  public static String getMessageForCLF_OVERRIDEN_CONCRETE_WITH_ABSTRACT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_OVERRIDEN_CONCRETE_WITH_ABSTRACT), new Object [] { param0, param1 });
  }
  
  public final static String CLF_OVERRIDE_ANNOTATION = "CLF_OVERRIDE_ANNOTATION";
  
  /**
   * The {0} {1} {2} must be annotated with @Override.
   */
  public static String getMessageForCLF_OVERRIDE_ANNOTATION(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_OVERRIDE_ANNOTATION), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_OVERRIDE_CONST = "CLF_OVERRIDE_CONST";
  
  /**
   * The {0} cannot override {1}.
   */
  public static String getMessageForCLF_OVERRIDE_CONST(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_OVERRIDE_CONST), new Object [] { param0, param1 });
  }
  
  public final static String CLF_OVERRIDE_FIELD_REQUIRES_ACCESSOR_PAIR = "CLF_OVERRIDE_FIELD_REQUIRES_ACCESSOR_PAIR";
  
  /**
   * The {0} cannot override {1}, matching {2} missing.
   */
  public static String getMessageForCLF_OVERRIDE_FIELD_REQUIRES_ACCESSOR_PAIR(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_OVERRIDE_FIELD_REQUIRES_ACCESSOR_PAIR), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_OVERRIDE_FINAL = "CLF_OVERRIDE_FINAL";
  
  /**
   * The {0} cannot override final {1}.
   */
  public static String getMessageForCLF_OVERRIDE_FINAL(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_OVERRIDE_FINAL), new Object [] { param0, param1 });
  }
  
  public final static String CLF_OVERRIDE_MEMBERTYPE_INCOMPATIBLE = "CLF_OVERRIDE_MEMBERTYPE_INCOMPATIBLE";
  
  /**
   * Cannot override {1} with {0}.
   */
  public static String getMessageForCLF_OVERRIDE_MEMBERTYPE_INCOMPATIBLE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_OVERRIDE_MEMBERTYPE_INCOMPATIBLE), new Object [] { param0, param1 });
  }
  
  public final static String CLF_OVERRIDE_NON_EXISTENT = "CLF_OVERRIDE_NON_EXISTENT";
  
  /**
   * The {0} {1} must override or implement a {0} from a super class or interface.
   */
  public static String getMessageForCLF_OVERRIDE_NON_EXISTENT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_OVERRIDE_NON_EXISTENT), new Object [] { param0, param1 });
  }
  
  public final static String CLF_OVERRIDE_NON_EXISTENT_INTERFACE = "CLF_OVERRIDE_NON_EXISTENT_INTERFACE";
  
  /**
   * The {0} does not override {1} (no inheritance of static members in interfaces); remove annotation @Override.
   */
  public static String getMessageForCLF_OVERRIDE_NON_EXISTENT_INTERFACE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_OVERRIDE_NON_EXISTENT_INTERFACE), new Object [] { param0, param1 });
  }
  
  public final static String CLF_OVERRIDE_VISIBILITY = "CLF_OVERRIDE_VISIBILITY";
  
  /**
   * The {0} cannot reduce the visibility of {1}.
   */
  public static String getMessageForCLF_OVERRIDE_VISIBILITY(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_OVERRIDE_VISIBILITY), new Object [] { param0, param1 });
  }
  
  public final static String CLF_OVERRIDE_WITH_FINAL_OR_CONST_FIELD = "CLF_OVERRIDE_WITH_FINAL_OR_CONST_FIELD";
  
  /**
   * Cannot override {0} with a {1} field.
   */
  public static String getMessageForCLF_OVERRIDE_WITH_FINAL_OR_CONST_FIELD(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_OVERRIDE_WITH_FINAL_OR_CONST_FIELD), new Object [] { param0, param1 });
  }
  
  public final static String CLF_POLYFILL_CTOR_NOT_OVERRIDE_COMPATIBLE = "CLF_POLYFILL_CTOR_NOT_OVERRIDE_COMPATIBLE";
  
  /**
   * Constructor of polyfill {0} must be override compatible with inherited constructor: {1}
   */
  public static String getMessageForCLF_POLYFILL_CTOR_NOT_OVERRIDE_COMPATIBLE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_CTOR_NOT_OVERRIDE_COMPATIBLE), new Object [] { param0, param1 });
  }
  
  public final static String CLF_POLYFILL_DIFFERENT_GLOBALS = "CLF_POLYFILL_DIFFERENT_GLOBALS";
  
  /**
   * Module containing polyfill {0} is {1}, but filled classes module is {2}.
   */
  public static String getMessageForCLF_POLYFILL_DIFFERENT_GLOBALS(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_DIFFERENT_GLOBALS), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_POLYFILL_DIFFERENT_MODIFIER = "CLF_POLYFILL_DIFFERENT_MODIFIER";
  
  /**
   * Polyfill {0} cannot be declared {1}, must be defined {2} just as the filled class.
   */
  public static String getMessageForCLF_POLYFILL_DIFFERENT_MODIFIER(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_DIFFERENT_MODIFIER), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_POLYFILL_DIFFERENT_MODULE_SPECIFIER = "CLF_POLYFILL_DIFFERENT_MODULE_SPECIFIER";
  
  /**
   * Specifier {1} of module containing polyfill {0} must equal name of filled classes module specifier {2}.
   */
  public static String getMessageForCLF_POLYFILL_DIFFERENT_MODULE_SPECIFIER(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_DIFFERENT_MODULE_SPECIFIER), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_POLYFILL_DIFFERENT_NAME = "CLF_POLYFILL_DIFFERENT_NAME";
  
  /**
   * Name of polyfill {0} must equal name of filled class {1}.
   */
  public static String getMessageForCLF_POLYFILL_DIFFERENT_NAME(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_DIFFERENT_NAME), new Object [] { param0, param1 });
  }
  
  public final static String CLF_POLYFILL_DIFFERENT_TYPEPARS = "CLF_POLYFILL_DIFFERENT_TYPEPARS";
  
  /**
   * Polyfill {0} must declare same type parameters as filled class.
   */
  public static String getMessageForCLF_POLYFILL_DIFFERENT_TYPEPARS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_DIFFERENT_TYPEPARS), new Object [] { param0 });
  }
  
  public final static String CLF_POLYFILL_EXTEND_MISSING = "CLF_POLYFILL_EXTEND_MISSING";
  
  /**
   * Polyfill {0} must explicitly extend a class.
   */
  public static String getMessageForCLF_POLYFILL_EXTEND_MISSING(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_EXTEND_MISSING), new Object [] { param0 });
  }
  
  public final static String CLF_POLYFILL_FILLED_NOT_PROVIDEDBYRUNTIME = "CLF_POLYFILL_FILLED_NOT_PROVIDEDBYRUNTIME";
  
  /**
   * Polyfill {0} cannot fill class not provided by runtime.
   */
  public static String getMessageForCLF_POLYFILL_FILLED_NOT_PROVIDEDBYRUNTIME(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_FILLED_NOT_PROVIDEDBYRUNTIME), new Object [] { param0 });
  }
  
  public final static String CLF_POLYFILL_MULTIPOLYFILLS_MEMBER_CONFLICT = "CLF_POLYFILL_MULTIPOLYFILLS_MEMBER_CONFLICT";
  
  /**
   * Polyfills in {0} provide member {1} - only one provider per member is allowed.
   */
  public static String getMessageForCLF_POLYFILL_MULTIPOLYFILLS_MEMBER_CONFLICT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_MULTIPOLYFILLS_MEMBER_CONFLICT), new Object [] { param0, param1 });
  }
  
  public final static String CLF_POLYFILL_NOT_PROVIDEDBYRUNTIME = "CLF_POLYFILL_NOT_PROVIDEDBYRUNTIME";
  
  /**
   * Polyfill {0} must be provided by runtime.
   */
  public static String getMessageForCLF_POLYFILL_NOT_PROVIDEDBYRUNTIME(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_NOT_PROVIDEDBYRUNTIME), new Object [] { param0 });
  }
  
  public final static String CLF_POLYFILL_NO_IMPLEMENTS_OR_CONSUMES = "CLF_POLYFILL_NO_IMPLEMENTS_OR_CONSUMES";
  
  /**
   * Polyfill {0} must not implement any interfaces or consume any interfaces.
   */
  public static String getMessageForCLF_POLYFILL_NO_IMPLEMENTS_OR_CONSUMES(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_NO_IMPLEMENTS_OR_CONSUMES), new Object [] { param0 });
  }
  
  public final static String CLF_POLYFILL_NO_TOPLEVEL = "CLF_POLYFILL_NO_TOPLEVEL";
  
  /**
   * Polyfill {0} can only extend top level class declaration.
   */
  public static String getMessageForCLF_POLYFILL_NO_TOPLEVEL(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_NO_TOPLEVEL), new Object [] { param0 });
  }
  
  public final static String CLF_POLYFILL_STATIC_DIFFERENT_VARIANT = "CLF_POLYFILL_STATIC_DIFFERENT_VARIANT";
  
  /**
   * Since static polyfill {0} is declared in an {1} file, the filled type must also be declared in an {1} file.
   */
  public static String getMessageForCLF_POLYFILL_STATIC_DIFFERENT_VARIANT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_STATIC_DIFFERENT_VARIANT), new Object [] { param0, param1 });
  }
  
  public final static String CLF_POLYFILL_STATIC_FILLED_TYPE_NOT_AWARE = "CLF_POLYFILL_STATIC_FILLED_TYPE_NOT_AWARE";
  
  /**
   * For static polyfills, the module of the filled type {0} must be annotated with @StaticPolyfillAware.
   */
  public static String getMessageForCLF_POLYFILL_STATIC_FILLED_TYPE_NOT_AWARE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_STATIC_FILLED_TYPE_NOT_AWARE), new Object [] { param0 });
  }
  
  public final static String CLF_POLYFILL_TYPEPARS_DIFFER_TYPEARGS = "CLF_POLYFILL_TYPEPARS_DIFFER_TYPEARGS";
  
  /**
   * Polyfill {0} must pass type parameters to type arguments in same order and without modifications, but {1} differs from {2}.
   */
  public static String getMessageForCLF_POLYFILL_TYPEPARS_DIFFER_TYPEARGS(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_POLYFILL_TYPEPARS_DIFFER_TYPEARGS), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_PSEUDO_REDEFINED_SPEC_CTOR_INCOMPATIBLE = "CLF_PSEUDO_REDEFINED_SPEC_CTOR_INCOMPATIBLE";
  
  /**
   * Inherited {0} in context of {1} not compatible to itself in context of {2}.
   */
  public static String getMessageForCLF_PSEUDO_REDEFINED_SPEC_CTOR_INCOMPATIBLE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_PSEUDO_REDEFINED_SPEC_CTOR_INCOMPATIBLE), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_REDEFINED_BY_CONSUMED_MEMBER_TYPE_INVALID = "CLF_REDEFINED_BY_CONSUMED_MEMBER_TYPE_INVALID";
  
  /**
   * Type of {0} {1} does not conform to {2} {3}: {4}.
   */
  public static String getMessageForCLF_REDEFINED_BY_CONSUMED_MEMBER_TYPE_INVALID(final Object param0, final Object param1, final Object param2, final Object param3, final Object param4) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_REDEFINED_BY_CONSUMED_MEMBER_TYPE_INVALID), new Object [] { param0, param1, param2, param3, param4 });
  }
  
  public final static String CLF_REDEFINED_BY_CONSUMED_TYPE_NOT_SAME_TYPE = "CLF_REDEFINED_BY_CONSUMED_TYPE_NOT_SAME_TYPE";
  
  /**
   * Type of inherited {0} must equal type of {1} {2}.
   */
  public static String getMessageForCLF_REDEFINED_BY_CONSUMED_TYPE_NOT_SAME_TYPE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_REDEFINED_BY_CONSUMED_TYPE_NOT_SAME_TYPE), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_REDEFINED_MEMBER_TYPE_INVALID = "CLF_REDEFINED_MEMBER_TYPE_INVALID";
  
  /**
   * Type of {0} does not conform to {2} {1}: {3}.{4}
   */
  public static String getMessageForCLF_REDEFINED_MEMBER_TYPE_INVALID(final Object param0, final Object param1, final Object param2, final Object param3, final Object param4) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_REDEFINED_MEMBER_TYPE_INVALID), new Object [] { param0, param1, param2, param3, param4 });
  }
  
  public final static String CLF_REDEFINED_METHOD_TYPE_CONFLICT = "CLF_REDEFINED_METHOD_TYPE_CONFLICT";
  
  /**
   * Signature of {0} does not conform to {1} {2}: {3}.{4}
   */
  public static String getMessageForCLF_REDEFINED_METHOD_TYPE_CONFLICT(final Object param0, final Object param1, final Object param2, final Object param3, final Object param4) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_REDEFINED_METHOD_TYPE_CONFLICT), new Object [] { param0, param1, param2, param3, param4 });
  }
  
  public final static String CLF_REDEFINED_NON_ACCESSIBLE = "CLF_REDEFINED_NON_ACCESSIBLE";
  
  /**
   * The {0} cannot override or implement non-accessible {1}.
   */
  public static String getMessageForCLF_REDEFINED_NON_ACCESSIBLE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_REDEFINED_NON_ACCESSIBLE), new Object [] { param0, param1 });
  }
  
  public final static String CLF_REDEFINED_TYPE_NOT_SAME_TYPE = "CLF_REDEFINED_TYPE_NOT_SAME_TYPE";
  
  /**
   * Type of {0} must equal type of {1} {2}.{3}
   */
  public static String getMessageForCLF_REDEFINED_TYPE_NOT_SAME_TYPE(final Object param0, final Object param1, final Object param2, final Object param3) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_REDEFINED_TYPE_NOT_SAME_TYPE), new Object [] { param0, param1, param2, param3 });
  }
  
  public final static String CLF_SPEC_BUILT_IN_OR_PROVIDED_BY_RUNTIME_OR_EXTENAL_WITHOUT_N4JS_ANNOTATION = "CLF_SPEC_BUILT_IN_OR_PROVIDED_BY_RUNTIME_OR_EXTENAL_WITHOUT_N4JS_ANNOTATION";
  
  /**
   * {0} is a property of built-in / provided by runtime / external without @N4JS annotation interface {1} and can not be initialized in Spec constructor.
   */
  public static String getMessageForCLF_SPEC_BUILT_IN_OR_PROVIDED_BY_RUNTIME_OR_EXTENAL_WITHOUT_N4JS_ANNOTATION(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_SPEC_BUILT_IN_OR_PROVIDED_BY_RUNTIME_OR_EXTENAL_WITHOUT_N4JS_ANNOTATION), new Object [] { param0, param1 });
  }
  
  public final static String CLF_SPEC_MULTIPLE = "CLF_SPEC_MULTIPLE";
  
  /**
   * Only a single formal parameter in each constructor may be annotated with @Spec.
   */
  public static String getMessageForCLF_SPEC_MULTIPLE() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_SPEC_MULTIPLE), new Object [] {  });
  }
  
  public final static String CLF_SPEC_SUPERFLUOUS_PROPERTIES = "CLF_SPEC_SUPERFLUOUS_PROPERTIES";
  
  /**
   * {0} is not defined in {1}.
   */
  public static String getMessageForCLF_SPEC_SUPERFLUOUS_PROPERTIES(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_SPEC_SUPERFLUOUS_PROPERTIES), new Object [] { param0, param1 });
  }
  
  public final static String CLF_SPEC_WRONG_ADD_MEMBERTYPE = "CLF_SPEC_WRONG_ADD_MEMBERTYPE";
  
  /**
   * Type of structural member {0} of spec parameter must be a subtype of {1}: {2}.
   */
  public static String getMessageForCLF_SPEC_WRONG_ADD_MEMBERTYPE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_SPEC_WRONG_ADD_MEMBERTYPE), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_SPEC_WRONG_TYPE = "CLF_SPEC_WRONG_TYPE";
  
  /**
   * Annotation @Spec may only be used with formal parameters of type ~i~this.
   */
  public static String getMessageForCLF_SPEC_WRONG_TYPE() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_SPEC_WRONG_TYPE), new Object [] {  });
  }
  
  public final static String CLF_STATIC_ABSTRACT = "CLF_STATIC_ABSTRACT";
  
  /**
   * The {0} {1} may not be both static and abstract.
   */
  public static String getMessageForCLF_STATIC_ABSTRACT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_STATIC_ABSTRACT), new Object [] { param0, param1 });
  }
  
  public final static String CLF_TEST_CLASS_NOT_EXPORTED = "CLF_TEST_CLASS_NOT_EXPORTED";
  
  /**
   * Classes containing test methods must be exported or abstract.
   */
  public static String getMessageForCLF_TEST_CLASS_NOT_EXPORTED() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_TEST_CLASS_NOT_EXPORTED), new Object [] {  });
  }
  
  public final static String CLF_TYPE_VARIABLE_AT_INVALID_POSITION = "CLF_TYPE_VARIABLE_AT_INVALID_POSITION";
  
  /**
   * Cannot use {0} type variable at {1} position.
   */
  public static String getMessageForCLF_TYPE_VARIABLE_AT_INVALID_POSITION(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_TYPE_VARIABLE_AT_INVALID_POSITION), new Object [] { param0, param1 });
  }
  
  public final static String CLF_UNMATCHED_ACCESSOR_OVERRIDE = "CLF_UNMATCHED_ACCESSOR_OVERRIDE";
  
  /**
   * {0} cannot be {1} without overriding the corresponding {2}.
   */
  public static String getMessageForCLF_UNMATCHED_ACCESSOR_OVERRIDE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_UNMATCHED_ACCESSOR_OVERRIDE), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_UNMATCHED_ACCESSOR_OVERRIDE_JS = "CLF_UNMATCHED_ACCESSOR_OVERRIDE_JS";
  
  /**
   * {0} should not be {1} without overriding the corresponding {2}.
   */
  public static String getMessageForCLF_UNMATCHED_ACCESSOR_OVERRIDE_JS(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_UNMATCHED_ACCESSOR_OVERRIDE_JS), new Object [] { param0, param1, param2 });
  }
  
  public final static String CLF_UPPER_BOUND_FINAL = "CLF_UPPER_BOUND_FINAL";
  
  /**
   * Final type {0} should not be used as upper bound of type parameter {1}. Final types cannot be extended.
   */
  public static String getMessageForCLF_UPPER_BOUND_FINAL(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_UPPER_BOUND_FINAL), new Object [] { param0, param1 });
  }
  
  public final static String CLF_VOID_ACCESSOR = "CLF_VOID_ACCESSOR";
  
  /**
   * Void is not a valid type for getters and setters.
   */
  public static String getMessageForCLF_VOID_ACCESSOR() {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_VOID_ACCESSOR), new Object [] {  });
  }
  
  public final static String CLF_WRONG_META_TYPE = "CLF_WRONG_META_TYPE";
  
  /**
   * The {0} cannot {1} {2}.
   */
  public static String getMessageForCLF_WRONG_META_TYPE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(CLF_WRONG_META_TYPE), new Object [] { param0, param1, param2 });
  }
  
  public final static String COMP_SUBMESSAGES = "COMP_SUBMESSAGES";
  
  /**
   * {1} in {0}.
   */
  public static String getMessageForCOMP_SUBMESSAGES(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(COMP_SUBMESSAGES), new Object [] { param0, param1 });
  }
  
  public final static String DEPRECATED_PROJECT_TYPE = "DEPRECATED_PROJECT_TYPE";
  
  /**
   * Project type ''{0}'' is deprecated and will be removed soon. {1}
   */
  public static String getMessageForDEPRECATED_PROJECT_TYPE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(DEPRECATED_PROJECT_TYPE), new Object [] { param0, param1 });
  }
  
  public final static String DESTRUCT_EMPTY_PATTERN = "DESTRUCT_EMPTY_PATTERN";
  
  /**
   * Empty destructuring pattern (disallowed for time being, since ES6 implementations have different semantics).
   */
  public static String getMessageForDESTRUCT_EMPTY_PATTERN() {
    return org.eclipse.osgi.util.NLS.bind(getString(DESTRUCT_EMPTY_PATTERN), new Object [] {  });
  }
  
  public final static String DESTRUCT_PROP_MISSING = "DESTRUCT_PROP_MISSING";
  
  /**
   * Value to be destructured does not contain a property, field or getter named "{0}": {1}.
   */
  public static String getMessageForDESTRUCT_PROP_MISSING(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(DESTRUCT_PROP_MISSING), new Object [] { param0, param1 });
  }
  
  public final static String DESTRUCT_PROP_WITH_ERROR = "DESTRUCT_PROP_WITH_ERROR";
  
  /**
   * Property named "{0}" is not readable: {1}.
   */
  public static String getMessageForDESTRUCT_PROP_WITH_ERROR(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(DESTRUCT_PROP_WITH_ERROR), new Object [] { param0, param1 });
  }
  
  public final static String DESTRUCT_TYPE_ERROR_PATTERN = "DESTRUCT_TYPE_ERROR_PATTERN";
  
  /**
   * {0} destructuring pattern cannot be applied to {1}: {2}.
   */
  public static String getMessageForDESTRUCT_TYPE_ERROR_PATTERN(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(DESTRUCT_TYPE_ERROR_PATTERN), new Object [] { param0, param1, param2 });
  }
  
  public final static String DESTRUCT_TYPE_ERROR_VAR = "DESTRUCT_TYPE_ERROR_VAR";
  
  /**
   * Variable {0} cannot hold destructured value {1}: {2}.
   */
  public static String getMessageForDESTRUCT_TYPE_ERROR_VAR(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(DESTRUCT_TYPE_ERROR_VAR), new Object [] { param0, param1, param2 });
  }
  
  public final static String DFG_NULL_DEREFERENCE = "DFG_NULL_DEREFERENCE";
  
  /**
   * Variable {0} {1} {2}{3}
   */
  public static String getMessageForDFG_NULL_DEREFERENCE(final Object param0, final Object param1, final Object param2, final Object param3) {
    return org.eclipse.osgi.util.NLS.bind(getString(DFG_NULL_DEREFERENCE), new Object [] { param0, param1, param2, param3 });
  }
  
  public final static String DISALLOWED_NO_VALIDATE_FOR_N4JS = "DISALLOWED_NO_VALIDATE_FOR_N4JS";
  
  /**
   * {0} paths shouldn't match n4js files.
   */
  public static String getMessageForDISALLOWED_NO_VALIDATE_FOR_N4JS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(DISALLOWED_NO_VALIDATE_FOR_N4JS), new Object [] { param0 });
  }
  
  public final static String DI_ANN_ARG_MUST_BE_ANNOTATED_WITH = "DI_ANN_ARG_MUST_BE_ANNOTATED_WITH";
  
  /**
   * Argument to annotation @{0} must be a class annotated with @{1}.
   */
  public static String getMessageForDI_ANN_ARG_MUST_BE_ANNOTATED_WITH(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_ARG_MUST_BE_ANNOTATED_WITH), new Object [] { param0, param1 });
  }
  
  public final static String DI_ANN_BINDER_AND_INJECTOR_DONT_GO_TOGETHER = "DI_ANN_BINDER_AND_INJECTOR_DONT_GO_TOGETHER";
  
  /**
   * Annotations @Binder and @GenerateInjector may not be applied both on the same class definition.
   */
  public static String getMessageForDI_ANN_BINDER_AND_INJECTOR_DONT_GO_TOGETHER() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_BINDER_AND_INJECTOR_DONT_GO_TOGETHER), new Object [] {  });
  }
  
  public final static String DI_ANN_BINDER_EXTENDS = "DI_ANN_BINDER_EXTENDS";
  
  /**
   * Classes annotated with @Binder may not extend another class.
   */
  public static String getMessageForDI_ANN_BINDER_EXTENDS() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_BINDER_EXTENDS), new Object [] {  });
  }
  
  public final static String DI_ANN_BINDER_NOT_APPLICABLE = "DI_ANN_BINDER_NOT_APPLICABLE";
  
  /**
   * Annotation @Binder is applicable only for (exported) non-abstract class definitions.
   */
  public static String getMessageForDI_ANN_BINDER_NOT_APPLICABLE() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_BINDER_NOT_APPLICABLE), new Object [] {  });
  }
  
  public final static String DI_ANN_BIND_ABSTRACT_TARGET = "DI_ANN_BIND_ABSTRACT_TARGET";
  
  /**
   * The target of a @Binding must be a non-abstract class.
   */
  public static String getMessageForDI_ANN_BIND_ABSTRACT_TARGET() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_BIND_ABSTRACT_TARGET), new Object [] {  });
  }
  
  public final static String DI_ANN_BIND_SECOND_MUST_BE_SUBTYPE_FIRST = "DI_ANN_BIND_SECOND_MUST_BE_SUBTYPE_FIRST";
  
  /**
   * Second argument to @{0} must be a subtype of the first.
   */
  public static String getMessageForDI_ANN_BIND_SECOND_MUST_BE_SUBTYPE_FIRST(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_BIND_SECOND_MUST_BE_SUBTYPE_FIRST), new Object [] { param0 });
  }
  
  public final static String DI_ANN_BIND_SINGLETON_TARGET_SHOULD_BE_DEFINED_AS_SINGLETON = "DI_ANN_BIND_SINGLETON_TARGET_SHOULD_BE_DEFINED_AS_SINGLETON";
  
  /**
   * {0} can be defined as a singleton if it is annotated with @Singleton on the definition site.
   */
  public static String getMessageForDI_ANN_BIND_SINGLETON_TARGET_SHOULD_BE_DEFINED_AS_SINGLETON(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_BIND_SINGLETON_TARGET_SHOULD_BE_DEFINED_AS_SINGLETON), new Object [] { param0 });
  }
  
  public final static String DI_ANN_DUPLICATE_BINDING = "DI_ANN_DUPLICATE_BINDING";
  
  /**
   * Duplicate @Binding-s (two different bindings share the same key, for the same @Binder).
   */
  public static String getMessageForDI_ANN_DUPLICATE_BINDING() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_DUPLICATE_BINDING), new Object [] {  });
  }
  
  public final static String DI_ANN_INJECTED_NOT_APPLICABLE = "DI_ANN_INJECTED_NOT_APPLICABLE";
  
  /**
   * @Injected annotates a class (abstract or not) defined in an API project.
   */
  public static String getMessageForDI_ANN_INJECTED_NOT_APPLICABLE() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_INJECTED_NOT_APPLICABLE), new Object [] {  });
  }
  
  public final static String DI_ANN_INJECTOR_CANNOT_BE_INJECTED_INTO_INJECTOR = "DI_ANN_INJECTOR_CANNOT_BE_INJECTED_INTO_INJECTOR";
  
  /**
   * Types annotated with @GenerateInjector cannot be injected. Use @WithParentInjector instead for creating nested injectors.
   */
  public static String getMessageForDI_ANN_INJECTOR_CANNOT_BE_INJECTED_INTO_INJECTOR() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_INJECTOR_CANNOT_BE_INJECTED_INTO_INJECTOR), new Object [] {  });
  }
  
  public final static String DI_ANN_INJECTOR_CTOR_MUST_BE_INJECT = "DI_ANN_INJECTOR_CTOR_MUST_BE_INJECT";
  
  /**
   * The constructor of an injector must itself be injected unless it declares no parameters.
   */
  public static String getMessageForDI_ANN_INJECTOR_CTOR_MUST_BE_INJECT() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_INJECTOR_CTOR_MUST_BE_INJECT), new Object [] {  });
  }
  
  public final static String DI_ANN_INJECTOR_EXTENDS = "DI_ANN_INJECTOR_EXTENDS";
  
  /**
   * Classes annotated with @GenerateInjector cannot extend other class.
   */
  public static String getMessageForDI_ANN_INJECTOR_EXTENDS() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_INJECTOR_EXTENDS), new Object [] {  });
  }
  
  public final static String DI_ANN_INJECTOR_MISSING = "DI_ANN_INJECTOR_MISSING";
  
  /**
   * An instance of N4Injector is required here.
   */
  public static String getMessageForDI_ANN_INJECTOR_MISSING() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_INJECTOR_MISSING), new Object [] {  });
  }
  
  public final static String DI_ANN_INJECTOR_REQUIRED = "DI_ANN_INJECTOR_REQUIRED";
  
  /**
   * Only types annotated with @GenerateInjector can be used here.
   */
  public static String getMessageForDI_ANN_INJECTOR_REQUIRED() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_INJECTOR_REQUIRED), new Object [] {  });
  }
  
  public final static String DI_ANN_INJECT_METHOD_NOT_SUPPORTED_YET = "DI_ANN_INJECT_METHOD_NOT_SUPPORTED_YET";
  
  /**
   * Method injection not supported yet.
   */
  public static String getMessageForDI_ANN_INJECT_METHOD_NOT_SUPPORTED_YET() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_INJECT_METHOD_NOT_SUPPORTED_YET), new Object [] {  });
  }
  
  public final static String DI_ANN_INTERFACE_INJECTION_NOT_SUPPORTED = "DI_ANN_INTERFACE_INJECTION_NOT_SUPPORTED";
  
  /**
   * Injection inside interfaces is not supported.
   */
  public static String getMessageForDI_ANN_INTERFACE_INJECTION_NOT_SUPPORTED() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_INTERFACE_INJECTION_NOT_SUPPORTED), new Object [] {  });
  }
  
  public final static String DI_ANN_MISSING_NEEDED_BINDERS = "DI_ANN_MISSING_NEEDED_BINDERS";
  
  /**
   * Instances are missing for the following binders (they are used by the injector and themselves require injection): {0}.
   */
  public static String getMessageForDI_ANN_MISSING_NEEDED_BINDERS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_MISSING_NEEDED_BINDERS), new Object [] { param0 });
  }
  
  public final static String DI_ANN_MISSING_PROVIDED_BINDERS = "DI_ANN_MISSING_PROVIDED_BINDERS";
  
  /**
   * No binders are provided (third param for this callsite). The following binders are used by the injector and themselves require injection: {0}.
   */
  public static String getMessageForDI_ANN_MISSING_PROVIDED_BINDERS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_MISSING_PROVIDED_BINDERS), new Object [] { param0 });
  }
  
  public final static String DI_ANN_ONLY_ON_CLASS_ANNOTATED_WITH = "DI_ANN_ONLY_ON_CLASS_ANNOTATED_WITH";
  
  /**
   * The annotation @{0} is only allowed on classes annotated with @{1}.
   */
  public static String getMessageForDI_ANN_ONLY_ON_CLASS_ANNOTATED_WITH(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_ONLY_ON_CLASS_ANNOTATED_WITH), new Object [] { param0, param1 });
  }
  
  public final static String DI_ANN_ONLY_ON_METHOD_IN_CLASS_ANNOTATED_WITH = "DI_ANN_ONLY_ON_METHOD_IN_CLASS_ANNOTATED_WITH";
  
  /**
   * The annotation @{0} is only allowed on methods contained in a class annotated with @{1}.
   */
  public static String getMessageForDI_ANN_ONLY_ON_METHOD_IN_CLASS_ANNOTATED_WITH(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_ONLY_ON_METHOD_IN_CLASS_ANNOTATED_WITH), new Object [] { param0, param1 });
  }
  
  public final static String DI_ANN_PROVIDES_METHOD_MUST_RETURN_VALUE = "DI_ANN_PROVIDES_METHOD_MUST_RETURN_VALUE";
  
  /**
   * A provider method must return a value.
   */
  public static String getMessageForDI_ANN_PROVIDES_METHOD_MUST_RETURN_VALUE() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_PROVIDES_METHOD_MUST_RETURN_VALUE), new Object [] {  });
  }
  
  public final static String DI_ANN_USE_INJECTOR_CYCLE = "DI_ANN_USE_INJECTOR_CYCLE";
  
  /**
   * A cycle was detected among the parent injectors: {0}.
   */
  public static String getMessageForDI_ANN_USE_INJECTOR_CYCLE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_ANN_USE_INJECTOR_CYCLE), new Object [] { param0 });
  }
  
  public final static String DI_API_INJECTED = "DI_API_INJECTED";
  
  /**
   * The class being instantiated (or one of its super-types) has been marked @Injected in an API project.
   */
  public static String getMessageForDI_API_INJECTED() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_API_INJECTED), new Object [] {  });
  }
  
  public final static String DI_CTOR_BREAKS_INJECTION_CHAIN = "DI_CTOR_BREAKS_INJECTION_CHAIN";
  
  /**
   * Constructor at super class {0} is annotated with @Inject. Omitting the @Inject annotation from constructor at class {1} could break injection chain.
   */
  public static String getMessageForDI_CTOR_BREAKS_INJECTION_CHAIN(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_CTOR_BREAKS_INJECTION_CHAIN), new Object [] { param0, param1 });
  }
  
  public final static String DI_FIELD_IS_NOT_INJECTED_YET = "DI_FIELD_IS_NOT_INJECTED_YET";
  
  /**
   * {0} is not yet injected at this point.
   */
  public static String getMessageForDI_FIELD_IS_NOT_INJECTED_YET(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_FIELD_IS_NOT_INJECTED_YET), new Object [] { param0 });
  }
  
  public final static String DI_MUST_BE_INJECTED = "DI_MUST_BE_INJECTED";
  
  /**
   * Type {0} must be injected, because it contains or inherits one or more members annotated with @Inject.
   */
  public static String getMessageForDI_MUST_BE_INJECTED(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_MUST_BE_INJECTED), new Object [] { param0 });
  }
  
  public final static String DI_NOT_INJECTABLE = "DI_NOT_INJECTABLE";
  
  /**
   * Type {0} is not injectable {1}: only user-defined, non-generic, nominally typed interfaces and classes are allowed.
   */
  public static String getMessageForDI_NOT_INJECTABLE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_NOT_INJECTABLE), new Object [] { param0, param1 });
  }
  
  public final static String DI_VARARGS_NOT_INJECTABLE = "DI_VARARGS_NOT_INJECTABLE";
  
  /**
   * Injection of parameters that are variadic or optional is not supported.
   */
  public static String getMessageForDI_VARARGS_NOT_INJECTABLE() {
    return org.eclipse.osgi.util.NLS.bind(getString(DI_VARARGS_NOT_INJECTABLE), new Object [] {  });
  }
  
  public final static String DUPLICATE_PROJECT_REF = "DUPLICATE_PROJECT_REF";
  
  /**
   * Duplicate project reference {0}.
   */
  public static String getMessageForDUPLICATE_PROJECT_REF(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(DUPLICATE_PROJECT_REF), new Object [] { param0 });
  }
  
  public final static String ENM_DUPLICTAE_LITERALS = "ENM_DUPLICTAE_LITERALS";
  
  /**
   * Multiple literals with name {0}.
   */
  public static String getMessageForENM_DUPLICTAE_LITERALS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(ENM_DUPLICTAE_LITERALS), new Object [] { param0 });
  }
  
  public final static String ENM_INVALID_USE_OF_STRINGBASED_ENUM = "ENM_INVALID_USE_OF_STRINGBASED_ENUM";
  
  /**
   * A @StringBased enum may only be used in type annotations and in property access expressions to access either one of its literals the static getter called 'literals'.
   */
  public static String getMessageForENM_INVALID_USE_OF_STRINGBASED_ENUM() {
    return org.eclipse.osgi.util.NLS.bind(getString(ENM_INVALID_USE_OF_STRINGBASED_ENUM), new Object [] {  });
  }
  
  public final static String ENM_LITERALS_HIDE_META = "ENM_LITERALS_HIDE_META";
  
  /**
   * EnumLiteral cannot have the same name as Enum meta property <{0}>.
   */
  public static String getMessageForENM_LITERALS_HIDE_META(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(ENM_LITERALS_HIDE_META), new Object [] { param0 });
  }
  
  public final static String ENM_WITHOUT_LITERALS = "ENM_WITHOUT_LITERALS";
  
  /**
   * An enum type must declare at least one literal.
   */
  public static String getMessageForENM_WITHOUT_LITERALS() {
    return org.eclipse.osgi.util.NLS.bind(getString(ENM_WITHOUT_LITERALS), new Object [] {  });
  }
  
  public final static String EXP_ACCESS_INVALID_TYPE_OF_TARGET = "EXP_ACCESS_INVALID_TYPE_OF_TARGET";
  
  /**
   * Target of property access not a subtype of the declared @This type of {0}: {1} is not a subtype of {2}.
   */
  public static String getMessageForEXP_ACCESS_INVALID_TYPE_OF_TARGET(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_ACCESS_INVALID_TYPE_OF_TARGET), new Object [] { param0, param1, param2 });
  }
  
  public final static String EXP_ASSIGN_CONST_VARIABLE = "EXP_ASSIGN_CONST_VARIABLE";
  
  /**
   * Const variable {0} is read-only.
   */
  public static String getMessageForEXP_ASSIGN_CONST_VARIABLE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_ASSIGN_CONST_VARIABLE), new Object [] { param0 });
  }
  
  public final static String EXP_AWAIT_NON_ASYNC = "EXP_AWAIT_NON_ASYNC";
  
  /**
   * await should only be used on expressions of type Promise<?,?> since otherwise it has no effect.
   */
  public static String getMessageForEXP_AWAIT_NON_ASYNC() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_AWAIT_NON_ASYNC), new Object [] {  });
  }
  
  public final static String EXP_AWAIT_NON_ASYNC_SPECIAL = "EXP_AWAIT_NON_ASYNC_SPECIAL";
  
  /**
   * await should not be used on ''{0}'' since it has no effect here.
   */
  public static String getMessageForEXP_AWAIT_NON_ASYNC_SPECIAL(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_AWAIT_NON_ASYNC_SPECIAL), new Object [] { param0 });
  }
  
  public final static String EXP_CALL_CLASS_CTOR = "EXP_CALL_CLASS_CTOR";
  
  /**
   * Cannot directly invoke class constructor functions; use 'new' instead.
   */
  public static String getMessageForEXP_CALL_CLASS_CTOR() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_CALL_CLASS_CTOR), new Object [] {  });
  }
  
  public final static String EXP_CALL_NOT_A_FUNCTION = "EXP_CALL_NOT_A_FUNCTION";
  
  /**
   * Not a function or method: {0}.
   */
  public static String getMessageForEXP_CALL_NOT_A_FUNCTION(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_CALL_NOT_A_FUNCTION), new Object [] { param0 });
  }
  
  public final static String EXP_CAST_FAILED = "EXP_CAST_FAILED";
  
  /**
   * Cannot cast from {0} to {1}
   */
  public static String getMessageForEXP_CAST_FAILED(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_CAST_FAILED), new Object [] { param0, param1 });
  }
  
  public final static String EXP_CAST_INVALID_TARGET = "EXP_CAST_INVALID_TARGET";
  
  /**
   * Can only cast to class, interface, enum, function, primitive, union or intersection types
   */
  public static String getMessageForEXP_CAST_INVALID_TARGET() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_CAST_INVALID_TARGET), new Object [] {  });
  }
  
  public final static String EXP_CAST_UNNECESSARY = "EXP_CAST_UNNECESSARY";
  
  /**
   * Unnecessary cast from {0} to {1}
   */
  public static String getMessageForEXP_CAST_UNNECESSARY(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_CAST_UNNECESSARY), new Object [] { param0, param1 });
  }
  
  public final static String EXP_COMPILE_TIME_MANDATORY = "EXP_COMPILE_TIME_MANDATORY";
  
  /**
   * Not a compile-time expression: {0}.
   */
  public static String getMessageForEXP_COMPILE_TIME_MANDATORY(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_COMPILE_TIME_MANDATORY), new Object [] { param0 });
  }
  
  public final static String EXP_COMPUTED_PROP_NAME_DISCOURAGED = "EXP_COMPUTED_PROP_NAME_DISCOURAGED";
  
  /**
   * Computed property name using an expression other than a compile-time expression; this property won't be type-checked at compile time.
   */
  public static String getMessageForEXP_COMPUTED_PROP_NAME_DISCOURAGED() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_COMPUTED_PROP_NAME_DISCOURAGED), new Object [] {  });
  }
  
  public final static String EXP_FORBIDDEN_TYPE_IN_BINARY_LOGICAL_EXPRESSION = "EXP_FORBIDDEN_TYPE_IN_BINARY_LOGICAL_EXPRESSION";
  
  /**
   * {0} is not allowed on the left hand side of a logical expression.
   */
  public static String getMessageForEXP_FORBIDDEN_TYPE_IN_BINARY_LOGICAL_EXPRESSION(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_FORBIDDEN_TYPE_IN_BINARY_LOGICAL_EXPRESSION), new Object [] { param0 });
  }
  
  public final static String EXP_INCONSISTENT_VARIANCE_OF_TYPE_ARG = "EXP_INCONSISTENT_VARIANCE_OF_TYPE_ARG";
  
  /**
   * Cannot use wildcard with {0} bound as argument to a {1} type parameter.
   */
  public static String getMessageForEXP_INCONSISTENT_VARIANCE_OF_TYPE_ARG(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_INCONSISTENT_VARIANCE_OF_TYPE_ARG), new Object [] { param0, param1 });
  }
  
  public final static String EXP_INCONSISTENT_VARIANCE_OF_TYPE_ARG_IN_OUT = "EXP_INCONSISTENT_VARIANCE_OF_TYPE_ARG_IN_OUT";
  
  /**
   * Cannot combine {0} on use site with {1} on definition site.
   */
  public static String getMessageForEXP_INCONSISTENT_VARIANCE_OF_TYPE_ARG_IN_OUT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_INCONSISTENT_VARIANCE_OF_TYPE_ARG_IN_OUT), new Object [] { param0, param1 });
  }
  
  public final static String EXP_INDEXED_ACCESS_COMPUTED_NOTFOUND = "EXP_INDEXED_ACCESS_COMPUTED_NOTFOUND";
  
  /**
   * Member {0} not found.
   */
  public static String getMessageForEXP_INDEXED_ACCESS_COMPUTED_NOTFOUND(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_INDEXED_ACCESS_COMPUTED_NOTFOUND), new Object [] { param0 });
  }
  
  public final static String EXP_INDEXED_ACCESS_ENUM = "EXP_INDEXED_ACCESS_ENUM";
  
  /**
   * Indexed access is not allowed for enumerations.
   */
  public static String getMessageForEXP_INDEXED_ACCESS_ENUM() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_INDEXED_ACCESS_ENUM), new Object [] {  });
  }
  
  public final static String EXP_INDEXED_ACCESS_FORBIDDEN = "EXP_INDEXED_ACCESS_FORBIDDEN";
  
  /**
   * Indexed access is only allowed for strings, arrays and iterables and for immediate(!) instances of Object.
   */
  public static String getMessageForEXP_INDEXED_ACCESS_FORBIDDEN() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_INDEXED_ACCESS_FORBIDDEN), new Object [] {  });
  }
  
  public final static String EXP_INDEXED_ACCESS_IMPL_RESTRICTION = "EXP_INDEXED_ACCESS_IMPL_RESTRICTION";
  
  /**
   * Implementation restriction: member name clashes with compiler-internal, synthetic, mangled name.
   */
  public static String getMessageForEXP_INDEXED_ACCESS_IMPL_RESTRICTION() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_INDEXED_ACCESS_IMPL_RESTRICTION), new Object [] {  });
  }
  
  public final static String EXP_INDEXED_ACCESS_SYMBOL_INVALID = "EXP_INDEXED_ACCESS_SYMBOL_INVALID";
  
  /**
   * Indexed access with built-in symbols is only allowed for Symbol.iterator.
   */
  public static String getMessageForEXP_INDEXED_ACCESS_SYMBOL_INVALID() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_INDEXED_ACCESS_SYMBOL_INVALID), new Object [] {  });
  }
  
  public final static String EXP_INDEXED_ACCESS_SYMBOL_READONLY = "EXP_INDEXED_ACCESS_SYMBOL_READONLY";
  
  /**
   * Access to property Symbol.iterator of an Iterable is read-only.
   */
  public static String getMessageForEXP_INDEXED_ACCESS_SYMBOL_READONLY() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_INDEXED_ACCESS_SYMBOL_READONLY), new Object [] {  });
  }
  
  public final static String EXP_INDEXED_ACCESS_SYMBOL_WRONG_TYPE = "EXP_INDEXED_ACCESS_SYMBOL_WRONG_TYPE";
  
  /**
   * Access of property Symbol.iterator only allowed for instances of Iterable and immediate instances of Object.
   */
  public static String getMessageForEXP_INDEXED_ACCESS_SYMBOL_WRONG_TYPE() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_INDEXED_ACCESS_SYMBOL_WRONG_TYPE), new Object [] {  });
  }
  
  public final static String EXP_MATH_OPERAND_IS_CONSTANT = "EXP_MATH_OPERAND_IS_CONSTANT";
  
  /**
   * Operand of type {0} will be interpreted as {1}.
   */
  public static String getMessageForEXP_MATH_OPERAND_IS_CONSTANT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_MATH_OPERAND_IS_CONSTANT), new Object [] { param0, param1 });
  }
  
  public final static String EXP_MATH_OPERATION_RESULT_IS_CONSTANT = "EXP_MATH_OPERATION_RESULT_IS_CONSTANT";
  
  /**
   * Operand {0} will always result in {1}.
   */
  public static String getMessageForEXP_MATH_OPERATION_RESULT_IS_CONSTANT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_MATH_OPERATION_RESULT_IS_CONSTANT), new Object [] { param0, param1 });
  }
  
  public final static String EXP_MATH_TYPE_NOT_PERMITTED = "EXP_MATH_TYPE_NOT_PERMITTED";
  
  /**
   * Operand of type {0} cannot be converted to number.
   */
  public static String getMessageForEXP_MATH_TYPE_NOT_PERMITTED(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_MATH_TYPE_NOT_PERMITTED), new Object [] { param0 });
  }
  
  public final static String EXP_METHOD_REF_UNATTACHED_FROM_RECEIVER = "EXP_METHOD_REF_UNATTACHED_FROM_RECEIVER";
  
  /**
   * A reference to method {0} is created detached from a (correct) this-instance.
   */
  public static String getMessageForEXP_METHOD_REF_UNATTACHED_FROM_RECEIVER(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_METHOD_REF_UNATTACHED_FROM_RECEIVER), new Object [] { param0 });
  }
  
  public final static String EXP_MISPLACED_AWAIT_EXPRESSION = "EXP_MISPLACED_AWAIT_EXPRESSION";
  
  /**
   * {0} is allowed only inside functions annotated with {1}.
   */
  public static String getMessageForEXP_MISPLACED_AWAIT_EXPRESSION(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_MISPLACED_AWAIT_EXPRESSION), new Object [] { param0, param1 });
  }
  
  public final static String EXP_MISSNG_AWAIT_FOR_ASYNC_TARGET = "EXP_MISSNG_AWAIT_FOR_ASYNC_TARGET";
  
  /**
   * Calling async function without await, Promise should be made explicit.
   */
  public static String getMessageForEXP_MISSNG_AWAIT_FOR_ASYNC_TARGET() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_MISSNG_AWAIT_FOR_ASYNC_TARGET), new Object [] {  });
  }
  
  public final static String EXP_NEW_CANNOT_INSTANTIATE = "EXP_NEW_CANNOT_INSTANTIATE";
  
  /**
   * Cannot instantiate {0} {1}.
   */
  public static String getMessageForEXP_NEW_CANNOT_INSTANTIATE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_NEW_CANNOT_INSTANTIATE), new Object [] { param0, param1 });
  }
  
  public final static String EXP_NEW_NOT_A_CTOR = "EXP_NEW_NOT_A_CTOR";
  
  /**
   * Not a reference to a constructor: {0}.
   */
  public static String getMessageForEXP_NEW_NOT_A_CTOR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_NEW_NOT_A_CTOR), new Object [] { param0 });
  }
  
  public final static String EXP_NEW_WILDCARD_NO_COVARIANT_CTOR = "EXP_NEW_WILDCARD_NO_COVARIANT_CTOR";
  
  /**
   * Cannot instantiate {0}, because {1} does not have a @CovariantConstructor.
   */
  public static String getMessageForEXP_NEW_WILDCARD_NO_COVARIANT_CTOR(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_NEW_WILDCARD_NO_COVARIANT_CTOR), new Object [] { param0, param1 });
  }
  
  public final static String EXP_NEW_WILDCARD_OR_TYPEVAR = "EXP_NEW_WILDCARD_OR_TYPEVAR";
  
  /**
   * Cannot instantiate {0}.
   */
  public static String getMessageForEXP_NEW_WILDCARD_OR_TYPEVAR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_NEW_WILDCARD_OR_TYPEVAR), new Object [] { param0 });
  }
  
  public final static String EXP_NUM_OF_ARGS_TOO_FEW = "EXP_NUM_OF_ARGS_TOO_FEW";
  
  /**
   * Incorrect number of arguments: expected {0}, got {1}.
   */
  public static String getMessageForEXP_NUM_OF_ARGS_TOO_FEW(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_NUM_OF_ARGS_TOO_FEW), new Object [] { param0, param1 });
  }
  
  public final static String EXP_NUM_OF_ARGS_TOO_MANY = "EXP_NUM_OF_ARGS_TOO_MANY";
  
  /**
   * Incorrect number of arguments: expected {0}, got {1}.
   */
  public static String getMessageForEXP_NUM_OF_ARGS_TOO_MANY(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_NUM_OF_ARGS_TOO_MANY), new Object [] { param0, param1 });
  }
  
  public final static String EXP_OPTIONAL_INVALID_PLACE = "EXP_OPTIONAL_INVALID_PLACE";
  
  /**
   * The optional modifier isn't allowed here.
   */
  public static String getMessageForEXP_OPTIONAL_INVALID_PLACE() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_OPTIONAL_INVALID_PLACE), new Object [] {  });
  }
  
  public final static String EXP_PROMISIFY_INVALID_USE = "EXP_PROMISIFY_INVALID_USE";
  
  /**
   * @Promisify may only be applied to a call expression with a @Promisifiable function or method as target.
   */
  public static String getMessageForEXP_PROMISIFY_INVALID_USE() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_PROMISIFY_INVALID_USE), new Object [] {  });
  }
  
  public final static String EXP_USE_OF_UNDEF_EXPR = "EXP_USE_OF_UNDEF_EXPR";
  
  /**
   * The type of this expression is 'undefined', so it will never evaluate to a value other than 'undefined'.
   */
  public static String getMessageForEXP_USE_OF_UNDEF_EXPR() {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_USE_OF_UNDEF_EXPR), new Object [] {  });
  }
  
  public final static String EXP_WARN_CONSTANT_EQUALITY_TEST = "EXP_WARN_CONSTANT_EQUALITY_TEST";
  
  /**
   * Neither {0} is a subtype of {1} nor {1} is a subtype of {0}. The expression will always evaluate to {2}.
   */
  public static String getMessageForEXP_WARN_CONSTANT_EQUALITY_TEST(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_WARN_CONSTANT_EQUALITY_TEST), new Object [] { param0, param1, param2 });
  }
  
  public final static String EXP_WARN_DISPENSABLE_CONDITIONAL_EXPRESSION = "EXP_WARN_DISPENSABLE_CONDITIONAL_EXPRESSION";
  
  /**
   * Dispensable use of conditional expression. The expression ''{0}'' always evaluates to {1}, so only the {2} side will ever be evaluated.
   */
  public static String getMessageForEXP_WARN_DISPENSABLE_CONDITIONAL_EXPRESSION(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_WARN_DISPENSABLE_CONDITIONAL_EXPRESSION), new Object [] { param0, param1, param2 });
  }
  
  public final static String EXP_WRONG_NUMBER_OF_TYPEARGS = "EXP_WRONG_NUMBER_OF_TYPEARGS";
  
  /**
   * Incorrect number of type arguments: expected {0}, got {1}.
   */
  public static String getMessageForEXP_WRONG_NUMBER_OF_TYPEARGS(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_WRONG_NUMBER_OF_TYPEARGS), new Object [] { param0, param1 });
  }
  
  public final static String EXP_WRONG_NUMBER_OF_TYPEARGS_FOR_ELEMENT = "EXP_WRONG_NUMBER_OF_TYPEARGS_FOR_ELEMENT";
  
  /**
   * Incorrect number of type arguments for {0} {1}: expected {2}, got {3}.
   */
  public static String getMessageForEXP_WRONG_NUMBER_OF_TYPEARGS_FOR_ELEMENT(final Object param0, final Object param1, final Object param2, final Object param3) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXP_WRONG_NUMBER_OF_TYPEARGS_FOR_ELEMENT), new Object [] { param0, param1, param2, param3 });
  }
  
  public final static String EXTERNAL_LIBRARY_ERRORS = "EXTERNAL_LIBRARY_ERRORS";
  
  /**
   * External library error: {0}
   */
  public static String getMessageForEXTERNAL_LIBRARY_ERRORS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXTERNAL_LIBRARY_ERRORS), new Object [] { param0 });
  }
  
  public final static String EXTERNAL_LIBRARY_WARNINGS = "EXTERNAL_LIBRARY_WARNINGS";
  
  /**
   * External library warning: {0}
   */
  public static String getMessageForEXTERNAL_LIBRARY_WARNINGS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXTERNAL_LIBRARY_WARNINGS), new Object [] { param0 });
  }
  
  public final static String EXTERNAL_PROJECT_REFERENCES_WORKSPACE_PROJECT = "EXTERNAL_PROJECT_REFERENCES_WORKSPACE_PROJECT";
  
  /**
   * Transitive external project dependency of project ''{0}'' requires a workspace project ''{1}''. Current project setup could result in runtime oddities. It is highly recommended to import project ''{0}'' into workspace as well.
   */
  public static String getMessageForEXTERNAL_PROJECT_REFERENCES_WORKSPACE_PROJECT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(EXTERNAL_PROJECT_REFERENCES_WORKSPACE_PROJECT), new Object [] { param0, param1 });
  }
  
  public final static String FUN_BLOCK = "FUN_BLOCK";
  
  /**
   * Functions declarations should not be placed in blocks. Use a function expression or move the statement to the top of the outer function.
   */
  public static String getMessageForFUN_BLOCK() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_BLOCK), new Object [] {  });
  }
  
  public final static String FUN_BODY = "FUN_BODY";
  
  /**
   * Functions have to have a body.
   */
  public static String getMessageForFUN_BODY() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_BODY), new Object [] {  });
  }
  
  public final static String FUN_DEAD_CODE = "FUN_DEAD_CODE";
  
  /**
   * Dead code.
   */
  public static String getMessageForFUN_DEAD_CODE() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_DEAD_CODE), new Object [] {  });
  }
  
  public final static String FUN_DEAD_CODE_WITH_PREDECESSOR = "FUN_DEAD_CODE_WITH_PREDECESSOR";
  
  /**
   * Dead code. No execution possible after {0}.
   */
  public static String getMessageForFUN_DEAD_CODE_WITH_PREDECESSOR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_DEAD_CODE_WITH_PREDECESSOR), new Object [] { param0 });
  }
  
  public final static String FUN_MISSING_ELSE_BRANCH_FOR_CONDITIONAL_LAST_CONTROL_FLOW = "FUN_MISSING_ELSE_BRANCH_FOR_CONDITIONAL_LAST_CONTROL_FLOW";
  
  /**
   * Last if statement on control flow path is missing required else branch.
   */
  public static String getMessageForFUN_MISSING_ELSE_BRANCH_FOR_CONDITIONAL_LAST_CONTROL_FLOW() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_MISSING_ELSE_BRANCH_FOR_CONDITIONAL_LAST_CONTROL_FLOW), new Object [] {  });
  }
  
  public final static String FUN_MISSING_RETURN_EXPRESSION = "FUN_MISSING_RETURN_EXPRESSION";
  
  /**
   * Return statement must have an expression of type {0}
   */
  public static String getMessageForFUN_MISSING_RETURN_EXPRESSION(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_MISSING_RETURN_EXPRESSION), new Object [] { param0 });
  }
  
  public final static String FUN_MISSING_RETURN_OR_THROW_STATEMENT = "FUN_MISSING_RETURN_OR_THROW_STATEMENT";
  
  /**
   * Missing return or throw statement.
   */
  public static String getMessageForFUN_MISSING_RETURN_OR_THROW_STATEMENT() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_MISSING_RETURN_OR_THROW_STATEMENT), new Object [] {  });
  }
  
  public final static String FUN_MISSING_RETURN_OR_THROW_STATEMENT_FOR_CANNOT_BE_CHECKED = "FUN_MISSING_RETURN_OR_THROW_STATEMENT_FOR_CANNOT_BE_CHECKED";
  
  /**
   * Missing return or throw statement after for-expression. Correct termination of for-loops cannot be verified. Please append return/throw.
   */
  public static String getMessageForFUN_MISSING_RETURN_OR_THROW_STATEMENT_FOR_CANNOT_BE_CHECKED() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_MISSING_RETURN_OR_THROW_STATEMENT_FOR_CANNOT_BE_CHECKED), new Object [] {  });
  }
  
  public final static String FUN_MISSING_RETURN_OR_THROW_STATEMENT_WHILE_CANNOT_BE_CHECKED = "FUN_MISSING_RETURN_OR_THROW_STATEMENT_WHILE_CANNOT_BE_CHECKED";
  
  /**
   * Missing return or throw statement after while-expression. Correct termination of while-loops cannot be verified. Please append return/throw.
   */
  public static String getMessageForFUN_MISSING_RETURN_OR_THROW_STATEMENT_WHILE_CANNOT_BE_CHECKED() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_MISSING_RETURN_OR_THROW_STATEMENT_WHILE_CANNOT_BE_CHECKED), new Object [] {  });
  }
  
  public final static String FUN_NAME_MISSING = "FUN_NAME_MISSING";
  
  /**
   * Function declarations must have a name.
   */
  public static String getMessageForFUN_NAME_MISSING() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_NAME_MISSING), new Object [] {  });
  }
  
  public final static String FUN_NAME_RESERVED = "FUN_NAME_RESERVED";
  
  /**
   * {0} may be confused with {1}.
   */
  public static String getMessageForFUN_NAME_RESERVED(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_NAME_RESERVED), new Object [] { param0, param1 });
  }
  
  public final static String FUN_PARAM_COUNT = "FUN_PARAM_COUNT";
  
  /**
   * Passed parameter count {0} doesn't match with expected parameter count {1}.
   */
  public static String getMessageForFUN_PARAM_COUNT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_PARAM_COUNT), new Object [] { param0, param1 });
  }
  
  public final static String FUN_PARAM_IMPLICIT_DEFAULT_PARAM = "FUN_PARAM_IMPLICIT_DEFAULT_PARAM";
  
  /**
   * This parameter is changed to the default parameter ''{0}=undefined'' since it follows a default parameter.
   */
  public static String getMessageForFUN_PARAM_IMPLICIT_DEFAULT_PARAM(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_PARAM_IMPLICIT_DEFAULT_PARAM), new Object [] { param0 });
  }
  
  public final static String FUN_PARAM_INITIALIZER_ILLEGAL_AWAIT_CALL = "FUN_PARAM_INITIALIZER_ILLEGAL_AWAIT_CALL";
  
  /**
   * Illegal await-expression in initializer of formal parameter ''{0}''.
   */
  public static String getMessageForFUN_PARAM_INITIALIZER_ILLEGAL_AWAIT_CALL(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_PARAM_INITIALIZER_ILLEGAL_AWAIT_CALL), new Object [] { param0 });
  }
  
  public final static String FUN_PARAM_INITIALIZER_ILLEGAL_FORWARD_REFERENCE = "FUN_PARAM_INITIALIZER_ILLEGAL_FORWARD_REFERENCE";
  
  /**
   * Illegal forward reference to formal parameter of same function.
   */
  public static String getMessageForFUN_PARAM_INITIALIZER_ILLEGAL_FORWARD_REFERENCE() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_PARAM_INITIALIZER_ILLEGAL_FORWARD_REFERENCE), new Object [] {  });
  }
  
  public final static String FUN_PARAM_INITIALIZER_ILLEGAL_REFERENCE_TO_BODY_VARIABLE = "FUN_PARAM_INITIALIZER_ILLEGAL_REFERENCE_TO_BODY_VARIABLE";
  
  /**
   * Initializer of parameter ''{0}'' cannot reference the identifier ''{1}'' declared in the body.
   */
  public static String getMessageForFUN_PARAM_INITIALIZER_ILLEGAL_REFERENCE_TO_BODY_VARIABLE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_PARAM_INITIALIZER_ILLEGAL_REFERENCE_TO_BODY_VARIABLE), new Object [] { param0, param1 });
  }
  
  public final static String FUN_PARAM_INITIALIZER_ONLY_UNDEFINED_ALLOWED = "FUN_PARAM_INITIALIZER_ONLY_UNDEFINED_ALLOWED";
  
  /**
   * Only ''undefined'' allowed for initializers of default parameters in function types.
   */
  public static String getMessageForFUN_PARAM_INITIALIZER_ONLY_UNDEFINED_ALLOWED() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_PARAM_INITIALIZER_ONLY_UNDEFINED_ALLOWED), new Object [] {  });
  }
  
  public final static String FUN_PARAM_OPTIONAL_WRONG_SYNTAX = "FUN_PARAM_OPTIONAL_WRONG_SYNTAX";
  
  /**
   * Wrong syntax: Use {0}=undefined instead of ?.
   */
  public static String getMessageForFUN_PARAM_OPTIONAL_WRONG_SYNTAX(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_PARAM_OPTIONAL_WRONG_SYNTAX), new Object [] { param0 });
  }
  
  public final static String FUN_PARAM_VARIADIC_ONLY_LAST = "FUN_PARAM_VARIADIC_ONLY_LAST";
  
  /**
   * Only the last formal parameter can be variadic.
   */
  public static String getMessageForFUN_PARAM_VARIADIC_ONLY_LAST() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_PARAM_VARIADIC_ONLY_LAST), new Object [] {  });
  }
  
  public final static String FUN_PARAM_VARIADIC_WITH_INITIALIZER = "FUN_PARAM_VARIADIC_WITH_INITIALIZER";
  
  /**
   * Variadic parameters must not have a default initializer.
   */
  public static String getMessageForFUN_PARAM_VARIADIC_WITH_INITIALIZER() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_PARAM_VARIADIC_WITH_INITIALIZER), new Object [] {  });
  }
  
  public final static String FUN_RETURNTYPE_VOID_FOR_SETTER_VIOLATED = "FUN_RETURNTYPE_VOID_FOR_SETTER_VIOLATED";
  
  /**
   * Set accessors must not return anything.
   */
  public static String getMessageForFUN_RETURNTYPE_VOID_FOR_SETTER_VIOLATED() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_RETURNTYPE_VOID_FOR_SETTER_VIOLATED), new Object [] {  });
  }
  
  public final static String FUN_SETTER_CANT_BE_DEFAULT = "FUN_SETTER_CANT_BE_DEFAULT";
  
  /**
   * Default parameter is not allowed in setter declarations.
   */
  public static String getMessageForFUN_SETTER_CANT_BE_DEFAULT() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_SETTER_CANT_BE_DEFAULT), new Object [] {  });
  }
  
  public final static String FUN_SETTER_CANT_BE_VARIADIC = "FUN_SETTER_CANT_BE_VARIADIC";
  
  /**
   * Variadic parameter is not allowed in setter declarations.
   */
  public static String getMessageForFUN_SETTER_CANT_BE_VARIADIC() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_SETTER_CANT_BE_VARIADIC), new Object [] {  });
  }
  
  public final static String FUN_SINGLE_EXP_LAMBDA_IMPLICIT_RETURN_ALLOWED_UNLESS_VOID = "FUN_SINGLE_EXP_LAMBDA_IMPLICIT_RETURN_ALLOWED_UNLESS_VOID";
  
  /**
   * An arrow-function is used in a context where its body is expected to have some value as opposed to being void.
   */
  public static String getMessageForFUN_SINGLE_EXP_LAMBDA_IMPLICIT_RETURN_ALLOWED_UNLESS_VOID() {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_SINGLE_EXP_LAMBDA_IMPLICIT_RETURN_ALLOWED_UNLESS_VOID), new Object [] {  });
  }
  
  public final static String FUN_UNUSED_GENERIC_TYPE_PARAM = "FUN_UNUSED_GENERIC_TYPE_PARAM";
  
  /**
   * Type variable {0} not used in parameters or return type.
   */
  public static String getMessageForFUN_UNUSED_GENERIC_TYPE_PARAM(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(FUN_UNUSED_GENERIC_TYPE_PARAM), new Object [] { param0 });
  }
  
  public final static String IDL_ELEMENT_CAN_ONLY_BE_REFERENCED_FROM_VA_CONTEXT = "IDL_ELEMENT_CAN_ONLY_BE_REFERENCED_FROM_VA_CONTEXT";
  
  /**
   * The version-aware {0} can only be referenced from version-aware contexts.
   */
  public static String getMessageForIDL_ELEMENT_CAN_ONLY_BE_REFERENCED_FROM_VA_CONTEXT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_ELEMENT_CAN_ONLY_BE_REFERENCED_FROM_VA_CONTEXT), new Object [] { param0 });
  }
  
  public final static String IDL_EXPLICIT_VERSION_DECLARATION_NOT_ALLOWED = "IDL_EXPLICIT_VERSION_DECLARATION_NOT_ALLOWED";
  
  /**
   * The explicit declaration of type version requests is only allowed in functions/classifiers annotated as @Migration or @VersionAware.
   */
  public static String getMessageForIDL_EXPLICIT_VERSION_DECLARATION_NOT_ALLOWED() {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_EXPLICIT_VERSION_DECLARATION_NOT_ALLOWED), new Object [] {  });
  }
  
  public final static String IDL_FAILED_TO_INFER_CONTEXT_VERSION = "IDL_FAILED_TO_INFER_CONTEXT_VERSION";
  
  /**
   * Failed to infer the context version for {0}. Please declare an explicit type version.
   */
  public static String getMessageForIDL_FAILED_TO_INFER_CONTEXT_VERSION(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_FAILED_TO_INFER_CONTEXT_VERSION), new Object [] { param0 });
  }
  
  public final static String IDL_INVALID_VERSION = "IDL_INVALID_VERSION";
  
  /**
   * Requested version {0} exceeds the maximal version {1} of the current context.
   */
  public static String getMessageForIDL_INVALID_VERSION(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_INVALID_VERSION), new Object [] { param0, param1 });
  }
  
  public final static String IDL_MIGRATE_CALL_AMBIGUOUS = "IDL_MIGRATE_CALL_AMBIGUOUS";
  
  /**
   * Cannot un-ambiguously resolve the migration to handle this migrate call. Candidates are {0}.
   */
  public static String getMessageForIDL_MIGRATE_CALL_AMBIGUOUS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_MIGRATE_CALL_AMBIGUOUS), new Object [] { param0 });
  }
  
  public final static String IDL_MIGRATION_AMBIGUOUS_VERSION = "IDL_MIGRATION_AMBIGUOUS_VERSION";
  
  /**
   * The {0} version of migration {1} is ambiguous.
   */
  public static String getMessageForIDL_MIGRATION_AMBIGUOUS_VERSION(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_MIGRATION_AMBIGUOUS_VERSION), new Object [] { param0, param1 });
  }
  
  public final static String IDL_MIGRATION_CONFLICT_WITH = "IDL_MIGRATION_CONFLICT_WITH";
  
  /**
   * Migration {0} with arguments {1} and target version {2} conflicts with {3}.
   */
  public static String getMessageForIDL_MIGRATION_CONFLICT_WITH(final Object param0, final Object param1, final Object param2, final Object param3) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_MIGRATION_CONFLICT_WITH), new Object [] { param0, param1, param2, param3 });
  }
  
  public final static String IDL_MIGRATION_HAS_PRINCIPAL_ARGUMENT = "IDL_MIGRATION_HAS_PRINCIPAL_ARGUMENT";
  
  /**
   * Migrations must declare at least one versioned source type.
   */
  public static String getMessageForIDL_MIGRATION_HAS_PRINCIPAL_ARGUMENT() {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_MIGRATION_HAS_PRINCIPAL_ARGUMENT), new Object [] {  });
  }
  
  public final static String IDL_MIGRATION_MUST_DECLARE_IN_AND_OUTPUT = "IDL_MIGRATION_MUST_DECLARE_IN_AND_OUTPUT";
  
  /**
   * Migrations must declare at least one parameter and a (non-void) return value.
   */
  public static String getMessageForIDL_MIGRATION_MUST_DECLARE_IN_AND_OUTPUT() {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_MIGRATION_MUST_DECLARE_IN_AND_OUTPUT), new Object [] {  });
  }
  
  public final static String IDL_MIGRATION_MUST_EXPLICITLY_DECLARE_RETURN_TYPE = "IDL_MIGRATION_MUST_EXPLICITLY_DECLARE_RETURN_TYPE";
  
  /**
   * Migrations must explicitly declare a return type.
   */
  public static String getMessageForIDL_MIGRATION_MUST_EXPLICITLY_DECLARE_RETURN_TYPE() {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_MIGRATION_MUST_EXPLICITLY_DECLARE_RETURN_TYPE), new Object [] {  });
  }
  
  public final static String IDL_MIGRATION_NO_EXPLICIT_CONTEXT_PARAMETER = "IDL_MIGRATION_NO_EXPLICIT_CONTEXT_PARAMETER";
  
  /**
   * Migrations must not explicitly declare a MigrationContext parameter. The MigrationContext is always implicit (access via context).
   */
  public static String getMessageForIDL_MIGRATION_NO_EXPLICIT_CONTEXT_PARAMETER() {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_MIGRATION_NO_EXPLICIT_CONTEXT_PARAMETER), new Object [] {  });
  }
  
  public final static String IDL_MIGRATION_NO_MATCHING_CANDIDATE = "IDL_MIGRATION_NO_MATCHING_CANDIDATE";
  
  /**
   * Could not find a matching migration candidate for arguments {0} and target version {1}. {2}
   */
  public static String getMessageForIDL_MIGRATION_NO_MATCHING_CANDIDATE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_MIGRATION_NO_MATCHING_CANDIDATE), new Object [] { param0, param1, param2 });
  }
  
  public final static String IDL_MIGRATION_SAME_SOURCE_AND_TARGET_VERSION = "IDL_MIGRATION_SAME_SOURCE_AND_TARGET_VERSION";
  
  /**
   * The migration {0} migrates from and to the same model version {1}. 
   */
  public static String getMessageForIDL_MIGRATION_SAME_SOURCE_AND_TARGET_VERSION(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_MIGRATION_SAME_SOURCE_AND_TARGET_VERSION), new Object [] { param0, param1 });
  }
  
  public final static String IDL_MIGRATION_SIGNATURE_NO_COMPOSED_TYPES = "IDL_MIGRATION_SIGNATURE_NO_COMPOSED_TYPES";
  
  /**
   * Migrations must not specify composed types (union or intersection) as source or target types.
   */
  public static String getMessageForIDL_MIGRATION_SIGNATURE_NO_COMPOSED_TYPES() {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_MIGRATION_SIGNATURE_NO_COMPOSED_TYPES), new Object [] {  });
  }
  
  public final static String IDL_MIGRATION_UNSUPPORTED_PARAMETER_TYPE = "IDL_MIGRATION_UNSUPPORTED_PARAMETER_TYPE";
  
  /**
   * Unsupported migration parameter type {0}.
   */
  public static String getMessageForIDL_MIGRATION_UNSUPPORTED_PARAMETER_TYPE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_MIGRATION_UNSUPPORTED_PARAMETER_TYPE), new Object [] { param0 });
  }
  
  public final static String IDL_MIGRATION_VERSION_CANNOT_BE_INFERRED = "IDL_MIGRATION_VERSION_CANNOT_BE_INFERRED";
  
  /**
   * The {0} version of migration {1} cannot be inferred.
   */
  public static String getMessageForIDL_MIGRATION_VERSION_CANNOT_BE_INFERRED(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_MIGRATION_VERSION_CANNOT_BE_INFERRED), new Object [] { param0, param1 });
  }
  
  public final static String IDL_VERSIONED_ELEMENT_MISSING_VERSION = "IDL_VERSIONED_ELEMENT_MISSING_VERSION";
  
  /**
   * The {0} {1} must explicitly declare a version.
   */
  public static String getMessageForIDL_VERSIONED_ELEMENT_MISSING_VERSION(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_VERSIONED_ELEMENT_MISSING_VERSION), new Object [] { param0, param1 });
  }
  
  public final static String IDL_VERSIONED_TYPES_NOT_SUPPORTED = "IDL_VERSIONED_TYPES_NOT_SUPPORTED";
  
  /**
   * Versioned types are not supported in {0} files.
   */
  public static String getMessageForIDL_VERSIONED_TYPES_NOT_SUPPORTED(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_VERSIONED_TYPES_NOT_SUPPORTED), new Object [] { param0 });
  }
  
  public final static String IDL_VERSION_AWARE_CLASSIFIER_MUST_NOT_DECLARE_VERSION = "IDL_VERSION_AWARE_CLASSIFIER_MUST_NOT_DECLARE_VERSION";
  
  /**
   * Classifiers annotated as @VersionAware must not declare a version.
   */
  public static String getMessageForIDL_VERSION_AWARE_CLASSIFIER_MUST_NOT_DECLARE_VERSION() {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_VERSION_AWARE_CLASSIFIER_MUST_NOT_DECLARE_VERSION), new Object [] {  });
  }
  
  public final static String IDL_VERSION_AWARE_ELEMENT_ONLY_REF_FROM_VARIANTS = "IDL_VERSION_AWARE_ELEMENT_ONLY_REF_FROM_VARIANTS";
  
  /**
   * The version-aware {0} can only be referenced from {1} files.
   */
  public static String getMessageForIDL_VERSION_AWARE_ELEMENT_ONLY_REF_FROM_VARIANTS(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IDL_VERSION_AWARE_ELEMENT_ONLY_REF_FROM_VARIANTS), new Object [] { param0, param1 });
  }
  
  public final static String IMP_AMBIGUOUS = "IMP_AMBIGUOUS";
  
  /**
   * The {0} {1} is ambiguously imported from {2}.
   */
  public static String getMessageForIMP_AMBIGUOUS(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_AMBIGUOUS), new Object [] { param0, param1, param2 });
  }
  
  public final static String IMP_AMBIGUOUS_WILDCARD = "IMP_AMBIGUOUS_WILDCARD";
  
  /**
   * The {0} {1} is ambiguously imported from {2}.
   */
  public static String getMessageForIMP_AMBIGUOUS_WILDCARD(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_AMBIGUOUS_WILDCARD), new Object [] { param0, param1, param2 });
  }
  
  public final static String IMP_CONFLICT = "IMP_CONFLICT";
  
  /**
   * Conflicting import of {0} with import from {1}.
   */
  public static String getMessageForIMP_CONFLICT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_CONFLICT), new Object [] { param0, param1 });
  }
  
  public final static String IMP_CONFLICT_ALIASES = "IMP_CONFLICT_ALIASES";
  
  /**
   * Conflicting import of {0}. Cannot import same type with different name ({1}) from {2}.
   */
  public static String getMessageForIMP_CONFLICT_ALIASES(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_CONFLICT_ALIASES), new Object [] { param0, param1, param2 });
  }
  
  public final static String IMP_CONFLICT_ALIAS_TYPE = "IMP_CONFLICT_ALIAS_TYPE";
  
  /**
   * Conflicting import of {0} as {1}. Cannot import same type with different name ({2}) from {3}.
   */
  public static String getMessageForIMP_CONFLICT_ALIAS_TYPE(final Object param0, final Object param1, final Object param2, final Object param3) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_CONFLICT_ALIAS_TYPE), new Object [] { param0, param1, param2, param3 });
  }
  
  public final static String IMP_DEFAULT_EXPORT_DUPLICATE = "IMP_DEFAULT_EXPORT_DUPLICATE";
  
  /**
   * Duplicate default export.
   */
  public static String getMessageForIMP_DEFAULT_EXPORT_DUPLICATE() {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_DEFAULT_EXPORT_DUPLICATE), new Object [] {  });
  }
  
  public final static String IMP_DEFAULT_EXPORT_WITH_VAR_LET_CONST = "IMP_DEFAULT_EXPORT_WITH_VAR_LET_CONST";
  
  /**
   * Default exports may not be used with var, let, or const.
   */
  public static String getMessageForIMP_DEFAULT_EXPORT_WITH_VAR_LET_CONST() {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_DEFAULT_EXPORT_WITH_VAR_LET_CONST), new Object [] {  });
  }
  
  public final static String IMP_DISCOURAGED_PLACEMENT = "IMP_DISCOURAGED_PLACEMENT";
  
  /**
   * The import statement should be placed on top of other statements.
   */
  public static String getMessageForIMP_DISCOURAGED_PLACEMENT() {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_DISCOURAGED_PLACEMENT), new Object [] {  });
  }
  
  public final static String IMP_DUPLICATE = "IMP_DUPLICATE";
  
  /**
   * {0} from {1} is already imported as {2}.
   */
  public static String getMessageForIMP_DUPLICATE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_DUPLICATE), new Object [] { param0, param1, param2 });
  }
  
  public final static String IMP_DUPLICATEX = "IMP_DUPLICATEX";
  
  /**
   * Duplicate import of {0} in import from {1}.
   */
  public static String getMessageForIMP_DUPLICATEX(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_DUPLICATEX), new Object [] { param0, param1 });
  }
  
  public final static String IMP_DUPLICATE_ALIAS = "IMP_DUPLICATE_ALIAS";
  
  /**
   * Duplicate import of {0}, already defined as {1} in import from {2}.
   */
  public static String getMessageForIMP_DUPLICATE_ALIAS(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_DUPLICATE_ALIAS), new Object [] { param0, param1, param2 });
  }
  
  public final static String IMP_DUPLICATE_NAMESPACE = "IMP_DUPLICATE_NAMESPACE";
  
  /**
   * Elements of {0} are already imported in namespace {1}.
   */
  public static String getMessageForIMP_DUPLICATE_NAMESPACE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_DUPLICATE_NAMESPACE), new Object [] { param0, param1 });
  }
  
  public final static String IMP_DYNAMIC_NAMESPACE_IMPORT_N4JS = "IMP_DYNAMIC_NAMESPACE_IMPORT_N4JS";
  
  /**
   * N4JS module {0} must not be imported dynamically.
   */
  public static String getMessageForIMP_DYNAMIC_NAMESPACE_IMPORT_N4JS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_DYNAMIC_NAMESPACE_IMPORT_N4JS), new Object [] { param0 });
  }
  
  public final static String IMP_DYNAMIC_NAMESPACE_IMPORT_N4JSD = "IMP_DYNAMIC_NAMESPACE_IMPORT_N4JSD";
  
  /**
   * N4JSD module {0} should not be imported dynamically.
   */
  public static String getMessageForIMP_DYNAMIC_NAMESPACE_IMPORT_N4JSD(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_DYNAMIC_NAMESPACE_IMPORT_N4JSD), new Object [] { param0 });
  }
  
  public final static String IMP_EMPTY_WILDCARD_IMPORT = "IMP_EMPTY_WILDCARD_IMPORT";
  
  /**
   * The wild-card import from {0} doesn't import anything because nothing is exported there.
   */
  public static String getMessageForIMP_EMPTY_WILDCARD_IMPORT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_EMPTY_WILDCARD_IMPORT), new Object [] { param0 });
  }
  
  public final static String IMP_IMPORTED_ELEMENT_READ_ONLY = "IMP_IMPORTED_ELEMENT_READ_ONLY";
  
  /**
   * Imported element {0} is read-only.
   */
  public static String getMessageForIMP_IMPORTED_ELEMENT_READ_ONLY(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_IMPORTED_ELEMENT_READ_ONLY), new Object [] { param0 });
  }
  
  public final static String IMP_LOCAL_NAME_CONFLICT = "IMP_LOCAL_NAME_CONFLICT";
  
  /**
   * Name {0} is already used as {1}.
   */
  public static String getMessageForIMP_LOCAL_NAME_CONFLICT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_LOCAL_NAME_CONFLICT), new Object [] { param0, param1 });
  }
  
  public final static String IMP_PLAIN_ACCESS_OF_ALIASED_TYPE = "IMP_PLAIN_ACCESS_OF_ALIASED_TYPE";
  
  /**
   * {0} has been imported as {1}.
   */
  public static String getMessageForIMP_PLAIN_ACCESS_OF_ALIASED_TYPE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_PLAIN_ACCESS_OF_ALIASED_TYPE), new Object [] { param0, param1 });
  }
  
  public final static String IMP_PLAIN_ACCESS_OF_NAMESPACED_TYPE = "IMP_PLAIN_ACCESS_OF_NAMESPACED_TYPE";
  
  /**
   * {0} has been imported as {1}.
   */
  public static String getMessageForIMP_PLAIN_ACCESS_OF_NAMESPACED_TYPE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_PLAIN_ACCESS_OF_NAMESPACED_TYPE), new Object [] { param0, param1 });
  }
  
  public final static String IMP_STATIC_NAMESPACE_IMPORT_PLAIN_JS = "IMP_STATIC_NAMESPACE_IMPORT_PLAIN_JS";
  
  /**
   * Use dynamic import in order to access elements of {0}.
   */
  public static String getMessageForIMP_STATIC_NAMESPACE_IMPORT_PLAIN_JS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_STATIC_NAMESPACE_IMPORT_PLAIN_JS), new Object [] { param0 });
  }
  
  public final static String IMP_STMT_DUPLICATE_NAMED = "IMP_STMT_DUPLICATE_NAMED";
  
  /**
   * Duplicate named import statement with local name {0} and imported module {1}.
   */
  public static String getMessageForIMP_STMT_DUPLICATE_NAMED(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_STMT_DUPLICATE_NAMED), new Object [] { param0, param1 });
  }
  
  public final static String IMP_STMT_DUPLICATE_NAMESPACE = "IMP_STMT_DUPLICATE_NAMESPACE";
  
  /**
   * Duplicate namespace import statement with name {0} and imported module {1}.
   */
  public static String getMessageForIMP_STMT_DUPLICATE_NAMESPACE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_STMT_DUPLICATE_NAMESPACE), new Object [] { param0, param1 });
  }
  
  public final static String IMP_UNRESOLVED = "IMP_UNRESOLVED";
  
  /**
   * Import of {0} cannot be resolved.
   */
  public static String getMessageForIMP_UNRESOLVED(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_UNRESOLVED), new Object [] { param0 });
  }
  
  public final static String IMP_UNUSED_IMPORT = "IMP_UNUSED_IMPORT";
  
  /**
   * The import of {0} is unused.
   */
  public static String getMessageForIMP_UNUSED_IMPORT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(IMP_UNUSED_IMPORT), new Object [] { param0 });
  }
  
  public final static String INTER_ANY_USED = "INTER_ANY_USED";
  
  /**
   * The use of the any type in an intersection type is discouraged.
   */
  public static String getMessageForINTER_ANY_USED() {
    return org.eclipse.osgi.util.NLS.bind(getString(INTER_ANY_USED), new Object [] {  });
  }
  
  public final static String INTER_MEMBER_TYPE_CONFLICT = "INTER_MEMBER_TYPE_CONFLICT";
  
  /**
   * Member method {0} is in conflict with non-method members in types of intersection: {1}.
   */
  public static String getMessageForINTER_MEMBER_TYPE_CONFLICT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(INTER_MEMBER_TYPE_CONFLICT), new Object [] { param0, param1 });
  }
  
  public final static String INTER_ONLY_ONE_CLASS_ALLOWED = "INTER_ONLY_ONE_CLASS_ALLOWED";
  
  /**
   * An intersection type should not contain more than one class. Otherwise there cannot exist a value of such a type.
   */
  public static String getMessageForINTER_ONLY_ONE_CLASS_ALLOWED() {
    return org.eclipse.osgi.util.NLS.bind(getString(INTER_ONLY_ONE_CLASS_ALLOWED), new Object [] {  });
  }
  
  public final static String INTER_REDUNDANT_SUPERTYPE = "INTER_REDUNDANT_SUPERTYPE";
  
  /**
   * The use of redundant supertypes is discouraged.
   */
  public static String getMessageForINTER_REDUNDANT_SUPERTYPE() {
    return org.eclipse.osgi.util.NLS.bind(getString(INTER_REDUNDANT_SUPERTYPE), new Object [] {  });
  }
  
  public final static String INTER_UNCOMMON = "INTER_UNCOMMON";
  
  /**
   * Member {0} is incompatible in types of intersection.
   */
  public static String getMessageForINTER_UNCOMMON(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(INTER_UNCOMMON), new Object [] { param0 });
  }
  
  public final static String INVALID_API_PROJECT_DEPENDENCY = "INVALID_API_PROJECT_DEPENDENCY";
  
  /**
   * Library project {0} with an implementation ID cannot be declared among the dependencies of an API project.
   */
  public static String getMessageForINVALID_API_PROJECT_DEPENDENCY(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(INVALID_API_PROJECT_DEPENDENCY), new Object [] { param0 });
  }
  
  public final static String INVALID_FEATURE_FOR_PROJECT_TYPE = "INVALID_FEATURE_FOR_PROJECT_TYPE";
  
  /**
   * {0} cannot be specified for {1} projects.
   */
  public static String getMessageForINVALID_FEATURE_FOR_PROJECT_TYPE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(INVALID_FEATURE_FOR_PROJECT_TYPE), new Object [] { param0, param1 });
  }
  
  public final static String INVALID_PROJECT_TYPE_REF = "INVALID_PROJECT_TYPE_REF";
  
  /**
   * Project {0} of type {1} cannot be declared among the {2}.
   */
  public static String getMessageForINVALID_PROJECT_TYPE_REF(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(INVALID_PROJECT_TYPE_REF), new Object [] { param0, param1, param2 });
  }
  
  public final static String INVALID_WILDCARD = "INVALID_WILDCARD";
  
  /**
   * "{0}" isn't a valid character sequence in a wild card.
   */
  public static String getMessageForINVALID_WILDCARD(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(INVALID_WILDCARD), new Object [] { param0 });
  }
  
  public final static String ITF_CONSTRUCTOR_BODY = "ITF_CONSTRUCTOR_BODY";
  
  /**
   * Constructors in interfaces must not have a body.
   */
  public static String getMessageForITF_CONSTRUCTOR_BODY() {
    return org.eclipse.osgi.util.NLS.bind(getString(ITF_CONSTRUCTOR_BODY), new Object [] {  });
  }
  
  public final static String ITF_CONSTRUCTOR_COVARIANCE = "ITF_CONSTRUCTOR_COVARIANCE";
  
  /**
   * Constructors in interfaces must be annotated with @CovariantConstructor.
   */
  public static String getMessageForITF_CONSTRUCTOR_COVARIANCE() {
    return org.eclipse.osgi.util.NLS.bind(getString(ITF_CONSTRUCTOR_COVARIANCE), new Object [] {  });
  }
  
  public final static String ITF_NO_FIELD_INITIALIZER = "ITF_NO_FIELD_INITIALIZER";
  
  /**
   * Cannot initialize field in interface. Only classes or interfaces implementing {1} can initialize {0}.
   */
  public static String getMessageForITF_NO_FIELD_INITIALIZER(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(ITF_NO_FIELD_INITIALIZER), new Object [] { param0, param1 });
  }
  
  public final static String ITF_NO_FINAL = "ITF_NO_FINAL";
  
  /**
   * Interfaces must not be declared final.
   */
  public static String getMessageForITF_NO_FINAL() {
    return org.eclipse.osgi.util.NLS.bind(getString(ITF_NO_FINAL), new Object [] {  });
  }
  
  public final static String JSX_JSXELEMENT_IN_NON_JSX_RESOURCE = "JSX_JSXELEMENT_IN_NON_JSX_RESOURCE";
  
  /**
   * JSX element is expected to be placed in JSX like resource, was {0}.
   */
  public static String getMessageForJSX_JSXELEMENT_IN_NON_JSX_RESOURCE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_JSXELEMENT_IN_NON_JSX_RESOURCE), new Object [] { param0 });
  }
  
  public final static String JSX_JSXELEMENT_NOT_BIND_TO_REACT_COMPONENT = "JSX_JSXELEMENT_NOT_BIND_TO_REACT_COMPONENT";
  
  /**
   * JSX element {0} does not bind to any valid React component.
   */
  public static String getMessageForJSX_JSXELEMENT_NOT_BIND_TO_REACT_COMPONENT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_JSXELEMENT_NOT_BIND_TO_REACT_COMPONENT), new Object [] { param0 });
  }
  
  public final static String JSX_JSXELEMENT_OPENING_CLOSING_ELEMENT_NOT_MATCH = "JSX_JSXELEMENT_OPENING_CLOSING_ELEMENT_NOT_MATCH";
  
  /**
   * Opening element {0} does not match with closing element {1}.
   */
  public static String getMessageForJSX_JSXELEMENT_OPENING_CLOSING_ELEMENT_NOT_MATCH(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_JSXELEMENT_OPENING_CLOSING_ELEMENT_NOT_MATCH), new Object [] { param0, param1 });
  }
  
  public final static String JSX_JSXPROPERTY_ATTRIBUTE_NON_OPTIONAL_PROPERTY_NOT_SPECIFIED = "JSX_JSXPROPERTY_ATTRIBUTE_NON_OPTIONAL_PROPERTY_NOT_SPECIFIED";
  
  /**
   * Non-optional property {0} should be specified.
   */
  public static String getMessageForJSX_JSXPROPERTY_ATTRIBUTE_NON_OPTIONAL_PROPERTY_NOT_SPECIFIED(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_JSXPROPERTY_ATTRIBUTE_NON_OPTIONAL_PROPERTY_NOT_SPECIFIED), new Object [] { param0 });
  }
  
  public final static String JSX_JSXSPREADATTRIBUTE_NOT_DECLARED_IN_PROPS = "JSX_JSXSPREADATTRIBUTE_NOT_DECLARED_IN_PROPS";
  
  /**
   * Attribute {0} is not a declared property in the props of {1}.
   */
  public static String getMessageForJSX_JSXSPREADATTRIBUTE_NOT_DECLARED_IN_PROPS(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_JSXSPREADATTRIBUTE_NOT_DECLARED_IN_PROPS), new Object [] { param0, param1 });
  }
  
  public final static String JSX_JSXSPREADATTRIBUTE_WRONG_SUBTYPE = "JSX_JSXSPREADATTRIBUTE_WRONG_SUBTYPE";
  
  /**
   * Attribute {0} has wrong type because {1} not subtype of {2}.
   */
  public static String getMessageForJSX_JSXSPREADATTRIBUTE_WRONG_SUBTYPE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_JSXSPREADATTRIBUTE_WRONG_SUBTYPE), new Object [] { param0, param1, param2 });
  }
  
  public final static String JSX_JSXSPROPERTYATTRIBUTE_NOT_DECLARED_IN_PROPS = "JSX_JSXSPROPERTYATTRIBUTE_NOT_DECLARED_IN_PROPS";
  
  /**
   * Attribute {0} is not a declared property in the props of {1}.
   */
  public static String getMessageForJSX_JSXSPROPERTYATTRIBUTE_NOT_DECLARED_IN_PROPS(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_JSXSPROPERTYATTRIBUTE_NOT_DECLARED_IN_PROPS), new Object [] { param0, param1 });
  }
  
  public final static String JSX_NAME_CANNOT_BE_REACT = "JSX_NAME_CANNOT_BE_REACT";
  
  /**
   * Element cannot be named React in N4JSX file.
   */
  public static String getMessageForJSX_NAME_CANNOT_BE_REACT() {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_NAME_CANNOT_BE_REACT), new Object [] {  });
  }
  
  public final static String JSX_REACT_CLASS_COMPONENT_CANNOT_START_WITH_LOWER_CASE = "JSX_REACT_CLASS_COMPONENT_CANNOT_START_WITH_LOWER_CASE";
  
  /**
   * React class component {0} cannot start with lower case.
   */
  public static String getMessageForJSX_REACT_CLASS_COMPONENT_CANNOT_START_WITH_LOWER_CASE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_REACT_CLASS_COMPONENT_CANNOT_START_WITH_LOWER_CASE), new Object [] { param0 });
  }
  
  public final static String JSX_REACT_ELEMENT_CLASS_NOT_REACT_ELEMENT_ERROR = "JSX_REACT_ELEMENT_CLASS_NOT_REACT_ELEMENT_ERROR";
  
  /**
   * The referred class is not a subtype of React.Component
   */
  public static String getMessageForJSX_REACT_ELEMENT_CLASS_NOT_REACT_ELEMENT_ERROR() {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_REACT_ELEMENT_CLASS_NOT_REACT_ELEMENT_ERROR), new Object [] {  });
  }
  
  public final static String JSX_REACT_ELEMENT_FUNCTION_NOT_REACT_ELEMENT_ERROR = "JSX_REACT_ELEMENT_FUNCTION_NOT_REACT_ELEMENT_ERROR";
  
  /**
   * Expect a function returning React.Element but the return type is {0}.
   */
  public static String getMessageForJSX_REACT_ELEMENT_FUNCTION_NOT_REACT_ELEMENT_ERROR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_REACT_ELEMENT_FUNCTION_NOT_REACT_ELEMENT_ERROR), new Object [] { param0 });
  }
  
  public final static String JSX_REACT_ELEMENT_NOT_FUNCTION_OR_CLASS_ERROR = "JSX_REACT_ELEMENT_NOT_FUNCTION_OR_CLASS_ERROR";
  
  /**
   * JSX element is expected to bind to either a function or class, but bind to type {0} instead.
   */
  public static String getMessageForJSX_REACT_ELEMENT_NOT_FUNCTION_OR_CLASS_ERROR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_REACT_ELEMENT_NOT_FUNCTION_OR_CLASS_ERROR), new Object [] { param0 });
  }
  
  public final static String JSX_REACT_FUNCTIONAL_COMPONENT_CANNOT_START_WITH_LOWER_CASE = "JSX_REACT_FUNCTIONAL_COMPONENT_CANNOT_START_WITH_LOWER_CASE";
  
  /**
   * React functional component {0} cannot start with lower case.
   */
  public static String getMessageForJSX_REACT_FUNCTIONAL_COMPONENT_CANNOT_START_WITH_LOWER_CASE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_REACT_FUNCTIONAL_COMPONENT_CANNOT_START_WITH_LOWER_CASE), new Object [] { param0 });
  }
  
  public final static String JSX_REACT_NAMESPACE_NOT_ALLOWED = "JSX_REACT_NAMESPACE_NOT_ALLOWED";
  
  /**
   * Namespace to react must be React.
   */
  public static String getMessageForJSX_REACT_NAMESPACE_NOT_ALLOWED() {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_REACT_NAMESPACE_NOT_ALLOWED), new Object [] {  });
  }
  
  public final static String JSX_REACT_NOT_RESOLVED = "JSX_REACT_NOT_RESOLVED";
  
  /**
   * Cannot resolve JSX implementation.
   */
  public static String getMessageForJSX_REACT_NOT_RESOLVED() {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_REACT_NOT_RESOLVED), new Object [] {  });
  }
  
  public final static String JSX_TAG_UNKNOWN = "JSX_TAG_UNKNOWN";
  
  /**
   * Tag {0} is neither a known HTML tag nor an SVG tag.
   */
  public static String getMessageForJSX_TAG_UNKNOWN(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSX_TAG_UNKNOWN), new Object [] { param0 });
  }
  
  public final static String KEY_SUP_ACCESS_FIELD = "KEY_SUP_ACCESS_FIELD";
  
  /**
   * Super member access may not be used to access a field.
   */
  public static String getMessageForKEY_SUP_ACCESS_FIELD() {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_ACCESS_FIELD), new Object [] {  });
  }
  
  public final static String KEY_SUP_ACCESS_INVALID_LOC = "KEY_SUP_ACCESS_INVALID_LOC";
  
  /**
   * Super member access may only be used in constructors, methods, getters, or setters.
   */
  public static String getMessageForKEY_SUP_ACCESS_INVALID_LOC() {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_ACCESS_INVALID_LOC), new Object [] {  });
  }
  
  public final static String KEY_SUP_ACCESS_INVALID_LOC_INTERFACE = "KEY_SUP_ACCESS_INVALID_LOC_INTERFACE";
  
  /**
   * Super member access may not be used in interfaces.
   */
  public static String getMessageForKEY_SUP_ACCESS_INVALID_LOC_INTERFACE() {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_ACCESS_INVALID_LOC_INTERFACE), new Object [] {  });
  }
  
  public final static String KEY_SUP_ACCESS_NO_EXTENDS = "KEY_SUP_ACCESS_NO_EXTENDS";
  
  /**
   * Super member access requires a declared super type.
   */
  public static String getMessageForKEY_SUP_ACCESS_NO_EXTENDS() {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_ACCESS_NO_EXTENDS), new Object [] {  });
  }
  
  public final static String KEY_SUP_CALL_NO_INDEXACCESS = "KEY_SUP_CALL_NO_INDEXACCESS";
  
  /**
   * Super member access may not be used with index access.
   */
  public static String getMessageForKEY_SUP_CALL_NO_INDEXACCESS() {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_CALL_NO_INDEXACCESS), new Object [] {  });
  }
  
  public final static String KEY_SUP_CTOR_EXPRSTMT = "KEY_SUP_CTOR_EXPRSTMT";
  
  /**
   * Super constructor call must no be used in a composed expression.
   */
  public static String getMessageForKEY_SUP_CTOR_EXPRSTMT() {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_CTOR_EXPRSTMT), new Object [] {  });
  }
  
  public final static String KEY_SUP_CTOR_INVALID_EXPR_BEFORE = "KEY_SUP_CTOR_INVALID_EXPR_BEFORE";
  
  /**
   * Super constructor call must not be preceded by {0}.
   */
  public static String getMessageForKEY_SUP_CTOR_INVALID_EXPR_BEFORE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_CTOR_INVALID_EXPR_BEFORE), new Object [] { param0 });
  }
  
  public final static String KEY_SUP_CTOR_INVALID_LOC = "KEY_SUP_CTOR_INVALID_LOC";
  
  /**
   * Super calls may only be used in constructors.
   */
  public static String getMessageForKEY_SUP_CTOR_INVALID_LOC() {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_CTOR_INVALID_LOC), new Object [] {  });
  }
  
  public final static String KEY_SUP_CTOR_NESTED = "KEY_SUP_CTOR_NESTED";
  
  /**
   * Super constructor call must only be directly contained in constructor body, i.e. not nested in {0}.
   */
  public static String getMessageForKEY_SUP_CTOR_NESTED(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_CTOR_NESTED), new Object [] { param0 });
  }
  
  public final static String KEY_SUP_INVALID_USAGE = "KEY_SUP_INVALID_USAGE";
  
  /**
   * Keyword super may only be used in member access expressions, call expressions or new expressions.
   */
  public static String getMessageForKEY_SUP_INVALID_USAGE() {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_INVALID_USAGE), new Object [] {  });
  }
  
  public final static String KEY_SUP_NESTED = "KEY_SUP_NESTED";
  
  /**
   * Super call must not be nested in function expressions.
   */
  public static String getMessageForKEY_SUP_NESTED() {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_NESTED), new Object [] {  });
  }
  
  public final static String KEY_SUP_NEW_NOT_SUPPORTED = "KEY_SUP_NEW_NOT_SUPPORTED";
  
  /**
   * Keyword super with in expressions is not supported yet.
   */
  public static String getMessageForKEY_SUP_NEW_NOT_SUPPORTED() {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_NEW_NOT_SUPPORTED), new Object [] {  });
  }
  
  public final static String KEY_SUP_REQUIRE_EXPLICIT_SUPERCTOR_CALL = "KEY_SUP_REQUIRE_EXPLICIT_SUPERCTOR_CALL";
  
  /**
   * Must explicitly invoke constructor of super class {0}.
   */
  public static String getMessageForKEY_SUP_REQUIRE_EXPLICIT_SUPERCTOR_CALL(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_SUP_REQUIRE_EXPLICIT_SUPERCTOR_CALL), new Object [] { param0 });
  }
  
  public final static String KEY_THIS_REJECTED_IN_TOP_LEVEL_LAMBDA = "KEY_THIS_REJECTED_IN_TOP_LEVEL_LAMBDA";
  
  /**
   * In a top-level arrow function, the 'this' keyword refers to nothing.
   */
  public static String getMessageForKEY_THIS_REJECTED_IN_TOP_LEVEL_LAMBDA() {
    return org.eclipse.osgi.util.NLS.bind(getString(KEY_THIS_REJECTED_IN_TOP_LEVEL_LAMBDA), new Object [] {  });
  }
  
  public final static String MISMATCHING_IMPLEMENTATION_ID = "MISMATCHING_IMPLEMENTATION_ID";
  
  /**
   * Implementation ID mismatch. Current project belongs to ''{0}'' implementation while {1} project belongs to ''{2}'' implementation.
   */
  public static String getMessageForMISMATCHING_IMPLEMENTATION_ID(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(MISMATCHING_IMPLEMENTATION_ID), new Object [] { param0, param1, param2 });
  }
  
  public final static String MISMATCHING_TESTED_PROJECT_TYPES = "MISMATCHING_TESTED_PROJECT_TYPES";
  
  /**
   * Tested projects should have the same project type.
   */
  public static String getMessageForMISMATCHING_TESTED_PROJECT_TYPES() {
    return org.eclipse.osgi.util.NLS.bind(getString(MISMATCHING_TESTED_PROJECT_TYPES), new Object [] {  });
  }
  
  public final static String MISSING_YARN_WORKSPACE = "MISSING_YARN_WORKSPACE";
  
  /**
   * Project depends on workspace project {0} which is missing in the node_modules folder. Either install project {0} or introduce a yarn workspace of both of the projects.
   */
  public static String getMessageForMISSING_YARN_WORKSPACE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(MISSING_YARN_WORKSPACE), new Object [] { param0 });
  }
  
  public final static String MOD_NAME_MUST_NOT_CONTAIN_DOTS = "MOD_NAME_MUST_NOT_CONTAIN_DOTS";
  
  /**
   * {0} of this module contain(s) the disallowed character ''.'' : ''{1}''.
   */
  public static String getMessageForMOD_NAME_MUST_NOT_CONTAIN_DOTS(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(MOD_NAME_MUST_NOT_CONTAIN_DOTS), new Object [] { param0, param1 });
  }
  
  public final static String NON_EXISTING_MODULE_SPECIFIER = "NON_EXISTING_MODULE_SPECIFIER";
  
  /**
   * Module specifier {0} doesn't exist.
   */
  public static String getMessageForNON_EXISTING_MODULE_SPECIFIER(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(NON_EXISTING_MODULE_SPECIFIER), new Object [] { param0 });
  }
  
  public final static String NON_EXISTING_PROJECT = "NON_EXISTING_PROJECT";
  
  /**
   * Project does not exist with project ID: {0}.
   */
  public static String getMessageForNON_EXISTING_PROJECT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(NON_EXISTING_PROJECT), new Object [] { param0 });
  }
  
  public final static String NON_EXISTING_PROJECT_WARNING = "NON_EXISTING_PROJECT_WARNING";
  
  /**
   * Project does not exist with project ID: {0}.
   */
  public static String getMessageForNON_EXISTING_PROJECT_WARNING(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(NON_EXISTING_PROJECT_WARNING), new Object [] { param0 });
  }
  
  public final static String NON_REGISTERED_PROJECT = "NON_REGISTERED_PROJECT";
  
  /**
   * Project {0} is not registered.
   */
  public static String getMessageForNON_REGISTERED_PROJECT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(NON_REGISTERED_PROJECT), new Object [] { param0 });
  }
  
  public final static String NO_MATCHING_VERSION = "NO_MATCHING_VERSION";
  
  /**
   * Project {0} is required in version {1}, but only version {2} is present.
   */
  public static String getMessageForNO_MATCHING_VERSION(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(NO_MATCHING_VERSION), new Object [] { param0, param1, param2 });
  }
  
  public final static String NO_MATCHING_VERSION_SHADOWING = "NO_MATCHING_VERSION_SHADOWING";
  
  /**
   * This {0}project requires {1}project {2} in version {3}, but only version {4} is present.
   */
  public static String getMessageForNO_MATCHING_VERSION_SHADOWING(final Object param0, final Object param1, final Object param2, final Object param3, final Object param4) {
    return org.eclipse.osgi.util.NLS.bind(getString(NO_MATCHING_VERSION_SHADOWING), new Object [] { param0, param1, param2, param3, param4 });
  }
  
  public final static String NO_N4JS_IN_RUNTIME_COMPONENT = "NO_N4JS_IN_RUNTIME_COMPONENT";
  
  /**
   * An n4js file may not be contained in a runtime component (i.e. runtime environment or runtime library).
   */
  public static String getMessageForNO_N4JS_IN_RUNTIME_COMPONENT() {
    return org.eclipse.osgi.util.NLS.bind(getString(NO_N4JS_IN_RUNTIME_COMPONENT), new Object [] {  });
  }
  
  public final static String NO_PROJECT_FOUND = "NO_PROJECT_FOUND";
  
  /**
   * No project found for resource {0}.
   */
  public static String getMessageForNO_PROJECT_FOUND(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(NO_PROJECT_FOUND), new Object [] { param0 });
  }
  
  public final static String NO_RELATIVE_NAVIGATION = "NO_RELATIVE_NAVIGATION";
  
  /**
   * Relative navigation isn't allowed in a module specifier.
   */
  public static String getMessageForNO_RELATIVE_NAVIGATION() {
    return org.eclipse.osgi.util.NLS.bind(getString(NO_RELATIVE_NAVIGATION), new Object [] {  });
  }
  
  public final static String OBSOLETE_BLOCK = "OBSOLETE_BLOCK";
  
  /**
   * Obsolete {0} block.
   */
  public static String getMessageForOBSOLETE_BLOCK(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(OBSOLETE_BLOCK), new Object [] { param0 });
  }
  
  public final static String OUTPUT_AND_SOURCES_FOLDER_NESTING = "OUTPUT_AND_SOURCES_FOLDER_NESTING";
  
  /**
   * {0} must not be located inside {1}.
   */
  public static String getMessageForOUTPUT_AND_SOURCES_FOLDER_NESTING(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(OUTPUT_AND_SOURCES_FOLDER_NESTING), new Object [] { param0, param1 });
  }
  
  public final static String PKGJ_APIIMPL_MISSING_IMPL_ID = "PKGJ_APIIMPL_MISSING_IMPL_ID";
  
  /**
   * When defining one or more implemented projects, you also have to define an implementation ID, using property "implementationId".
   */
  public static String getMessageForPKGJ_APIIMPL_MISSING_IMPL_ID() {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_APIIMPL_MISSING_IMPL_ID), new Object [] {  });
  }
  
  public final static String PKGJ_APIIMPL_MISSING_IMPL_PROJECTS = "PKGJ_APIIMPL_MISSING_IMPL_PROJECTS";
  
  /**
   * When defining an implementation ID, you also have to define one or more API projects that are implemented by this project using property 'n4js.implementedProjects'.
   */
  public static String getMessageForPKGJ_APIIMPL_MISSING_IMPL_PROJECTS() {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_APIIMPL_MISSING_IMPL_PROJECTS), new Object [] {  });
  }
  
  public final static String PKGJ_APIIMPL_REFLEXIVE = "PKGJ_APIIMPL_REFLEXIVE";
  
  /**
   * An implementation project may not implement itself.
   */
  public static String getMessageForPKGJ_APIIMPL_REFLEXIVE() {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_APIIMPL_REFLEXIVE), new Object [] {  });
  }
  
  public final static String PKGJ_DEFINES_PROPERTY = "PKGJ_DEFINES_PROPERTY";
  
  /**
   * A project of type "{0}" must {1}define the property "{2}".
   */
  public static String getMessageForPKGJ_DEFINES_PROPERTY(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_DEFINES_PROPERTY), new Object [] { param0, param1, param2 });
  }
  
  public final static String PKGJ_DUPLICATE_MODULE_FILTER_SPECIFIER = "PKGJ_DUPLICATE_MODULE_FILTER_SPECIFIER";
  
  /**
   * Duplicate module filter specifier.
   */
  public static String getMessageForPKGJ_DUPLICATE_MODULE_FILTER_SPECIFIER() {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_DUPLICATE_MODULE_FILTER_SPECIFIER), new Object [] {  });
  }
  
  public final static String PKGJ_DUPLICATE_SOURCE_CONTAINER = "PKGJ_DUPLICATE_SOURCE_CONTAINER";
  
  /**
   * Duplicate path "{0}" has already been declared as source container{1}.
   */
  public static String getMessageForPKGJ_DUPLICATE_SOURCE_CONTAINER(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_DUPLICATE_SOURCE_CONTAINER), new Object [] { param0, param1 });
  }
  
  public final static String PKGJ_EMPTY_INIT_MODULE = "PKGJ_EMPTY_INIT_MODULE";
  
  /**
   * An init module specifier must not be empty.
   */
  public static String getMessageForPKGJ_EMPTY_INIT_MODULE() {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_EMPTY_INIT_MODULE), new Object [] {  });
  }
  
  public final static String PKGJ_EMPTY_PROJECT_REFERENCE = "PKGJ_EMPTY_PROJECT_REFERENCE";
  
  /**
   * A project reference must not be empty.
   */
  public static String getMessageForPKGJ_EMPTY_PROJECT_REFERENCE() {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_EMPTY_PROJECT_REFERENCE), new Object [] {  });
  }
  
  public final static String PKGJ_EMPTY_SOURCE_PATH = "PKGJ_EMPTY_SOURCE_PATH";
  
  /**
   * Source container paths must not be empty.
   */
  public static String getMessageForPKGJ_EMPTY_SOURCE_PATH() {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_EMPTY_SOURCE_PATH), new Object [] {  });
  }
  
  public final static String PKGJ_EXPECTED_DIRECTORY_PATH = "PKGJ_EXPECTED_DIRECTORY_PATH";
  
  /**
   * Path "{0}" does not point to a directory.
   */
  public static String getMessageForPKGJ_EXPECTED_DIRECTORY_PATH(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_EXPECTED_DIRECTORY_PATH), new Object [] { param0 });
  }
  
  public final static String PKGJ_FILTER_NO_N4JS_MATCH = "PKGJ_FILTER_NO_N4JS_MATCH";
  
  /**
   * Module filters of type {0} must not match N4JS modules/files.
   */
  public static String getMessageForPKGJ_FILTER_NO_N4JS_MATCH(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_FILTER_NO_N4JS_MATCH), new Object [] { param0 });
  }
  
  public final static String PKGJ_IMPL_PROJECT_IS_MISSING_FOR_TYPE_DEF = "PKGJ_IMPL_PROJECT_IS_MISSING_FOR_TYPE_DEF";
  
  /**
   * The implementation project {0} of type definition project {1} is missing from the dependencies section.
   */
  public static String getMessageForPKGJ_IMPL_PROJECT_IS_MISSING_FOR_TYPE_DEF(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_IMPL_PROJECT_IS_MISSING_FOR_TYPE_DEF), new Object [] { param0, param1 });
  }
  
  public final static String PKGJ_INVALID_ABSOLUTE_PATH = "PKGJ_INVALID_ABSOLUTE_PATH";
  
  /**
   * Path "{0}" must not be absolute.
   */
  public static String getMessageForPKGJ_INVALID_ABSOLUTE_PATH(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_ABSOLUTE_PATH), new Object [] { param0 });
  }
  
  public final static String PKGJ_INVALID_MODULE_FILTER_SPECIFIER = "PKGJ_INVALID_MODULE_FILTER_SPECIFIER";
  
  /**
   * Invalid module specifier. Use simple strings or object syntax instead.
   */
  public static String getMessageForPKGJ_INVALID_MODULE_FILTER_SPECIFIER() {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_MODULE_FILTER_SPECIFIER), new Object [] {  });
  }
  
  public final static String PKGJ_INVALID_MODULE_FILTER_SPECIFIER_EMPTY = "PKGJ_INVALID_MODULE_FILTER_SPECIFIER_EMPTY";
  
  /**
   * The filter specifier and declared source container must not be empty.
   */
  public static String getMessageForPKGJ_INVALID_MODULE_FILTER_SPECIFIER_EMPTY() {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_MODULE_FILTER_SPECIFIER_EMPTY), new Object [] {  });
  }
  
  public final static String PKGJ_INVALID_MODULE_FILTER_TYPE = "PKGJ_INVALID_MODULE_FILTER_TYPE";
  
  /**
   * Invalid module filter type "{0}". Valid filter types are {1}.
   */
  public static String getMessageForPKGJ_INVALID_MODULE_FILTER_TYPE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_MODULE_FILTER_TYPE), new Object [] { param0, param1 });
  }
  
  public final static String PKGJ_INVALID_MODULE_LOADER = "PKGJ_INVALID_MODULE_LOADER";
  
  /**
   * Invalid module loader "{0}".
   */
  public static String getMessageForPKGJ_INVALID_MODULE_LOADER(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_MODULE_LOADER), new Object [] { param0 });
  }
  
  public final static String PKGJ_INVALID_PATH = "PKGJ_INVALID_PATH";
  
  /**
   * "{0}" is not a valid path.
   */
  public static String getMessageForPKGJ_INVALID_PATH(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_PATH), new Object [] { param0 });
  }
  
  public final static String PKGJ_INVALID_PROJECT_NAME = "PKGJ_INVALID_PROJECT_NAME";
  
  /**
   * The name "{0}" is not a valid package name.
   */
  public static String getMessageForPKGJ_INVALID_PROJECT_NAME(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_PROJECT_NAME), new Object [] { param0 });
  }
  
  public final static String PKGJ_INVALID_PROJECT_TYPE = "PKGJ_INVALID_PROJECT_TYPE";
  
  /**
   * Invalid project type "{0}".
   */
  public static String getMessageForPKGJ_INVALID_PROJECT_TYPE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_PROJECT_TYPE), new Object [] { param0 });
  }
  
  public final static String PKGJ_INVALID_SCOPE_NAME = "PKGJ_INVALID_SCOPE_NAME";
  
  /**
   * The name "{0}" is not a valid scope name.
   */
  public static String getMessageForPKGJ_INVALID_SCOPE_NAME(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_SCOPE_NAME), new Object [] { param0 });
  }
  
  public final static String PKGJ_INVALID_SOURCE_CONTAINER_TYPE = "PKGJ_INVALID_SOURCE_CONTAINER_TYPE";
  
  /**
   * Invalid source container type "{0}".
   */
  public static String getMessageForPKGJ_INVALID_SOURCE_CONTAINER_TYPE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_SOURCE_CONTAINER_TYPE), new Object [] { param0 });
  }
  
  public final static String PKGJ_INVALID_VERSION_NUMBER = "PKGJ_INVALID_VERSION_NUMBER";
  
  /**
   * Invalid version number "{0}": {1}.
   */
  public static String getMessageForPKGJ_INVALID_VERSION_NUMBER(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_VERSION_NUMBER), new Object [] { param0, param1 });
  }
  
  public final static String PKGJ_INVALID_VERSION_REQUIREMENT = "PKGJ_INVALID_VERSION_REQUIREMENT";
  
  /**
   * Invalid version requirement "{0}": {1}. Will assume empty string.
   */
  public static String getMessageForPKGJ_INVALID_VERSION_REQUIREMENT(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_VERSION_REQUIREMENT), new Object [] { param0, param1 });
  }
  
  public final static String PKGJ_INVALID_WILDCARD = "PKGJ_INVALID_WILDCARD";
  
  /**
   * "{0}" is not a valid character sequence in a wildcard.
   */
  public static String getMessageForPKGJ_INVALID_WILDCARD(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_INVALID_WILDCARD), new Object [] { param0 });
  }
  
  public final static String PKGJ_MODULE_FILTER_DOES_NOT_MATCH = "PKGJ_MODULE_FILTER_DOES_NOT_MATCH";
  
  /**
   * Module filter "{0}" does not match any modules.
   */
  public static String getMessageForPKGJ_MODULE_FILTER_DOES_NOT_MATCH(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_MODULE_FILTER_DOES_NOT_MATCH), new Object [] { param0 });
  }
  
  public final static String PKGJ_NESTED_SOURCE_CONTAINER = "PKGJ_NESTED_SOURCE_CONTAINER";
  
  /**
   * A source container must not be nested within other source containers (nested in {0})
   */
  public static String getMessageForPKGJ_NESTED_SOURCE_CONTAINER(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_NESTED_SOURCE_CONTAINER), new Object [] { param0 });
  }
  
  public final static String PKGJ_NON_EXISTING_MAIN_MODULE = "PKGJ_NON_EXISTING_MAIN_MODULE";
  
  /**
   * Main module specifier {0} does not exist.
   */
  public static String getMessageForPKGJ_NON_EXISTING_MAIN_MODULE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_NON_EXISTING_MAIN_MODULE), new Object [] { param0 });
  }
  
  public final static String PKGJ_NON_EXISTING_PATH = "PKGJ_NON_EXISTING_PATH";
  
  /**
   * Path {0} does not exist.
   */
  public static String getMessageForPKGJ_NON_EXISTING_PATH(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_NON_EXISTING_PATH), new Object [] { param0 });
  }
  
  public final static String PKGJ_NON_EXISTING_SOURCE_PATH = "PKGJ_NON_EXISTING_SOURCE_PATH";
  
  /**
   * Source container path {0} does not exist.
   */
  public static String getMessageForPKGJ_NON_EXISTING_SOURCE_PATH(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_NON_EXISTING_SOURCE_PATH), new Object [] { param0 });
  }
  
  public final static String PKGJ_NO_OUTPUT_FOLDER = "PKGJ_NO_OUTPUT_FOLDER";
  
  /**
   * There is no output folder defined, so compilation isn't possible.
   */
  public static String getMessageForPKGJ_NO_OUTPUT_FOLDER() {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_NO_OUTPUT_FOLDER), new Object [] {  });
  }
  
  public final static String PKGJ_NO_RELATIVE_NAVIGATION = "PKGJ_NO_RELATIVE_NAVIGATION";
  
  /**
   * Relative navigation is not allowed in a module filter specifier.
   */
  public static String getMessageForPKGJ_NO_RELATIVE_NAVIGATION() {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_NO_RELATIVE_NAVIGATION), new Object [] {  });
  }
  
  public final static String PKGJ_PACKAGE_NAME_MISMATCH = "PKGJ_PACKAGE_NAME_MISMATCH";
  
  /**
   * The package name "{0}" does not match the name of the project folder "{1}" on the file system.
   */
  public static String getMessageForPKGJ_PACKAGE_NAME_MISMATCH(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_PACKAGE_NAME_MISMATCH), new Object [] { param0, param1 });
  }
  
  public final static String PKGJ_PROJECT_NAME_ECLIPSE_MISMATCH = "PKGJ_PROJECT_NAME_ECLIPSE_MISMATCH";
  
  /**
   * The package name "{0}" does not match project name "{1}" used in the Eclipse workspace.
   */
  public static String getMessageForPKGJ_PROJECT_NAME_ECLIPSE_MISMATCH(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_PROJECT_NAME_ECLIPSE_MISMATCH), new Object [] { param0, param1 });
  }
  
  public final static String PKGJ_PROJECT_REFERENCE_MUST_BE_DEPENDENCY = "PKGJ_PROJECT_REFERENCE_MUST_BE_DEPENDENCY";
  
  /**
   * The project reference {0} in {1} must also be declared as explicit project dependency in 'dependencies' or 'devDependencies'.
   */
  public static String getMessageForPKGJ_PROJECT_REFERENCE_MUST_BE_DEPENDENCY(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_PROJECT_REFERENCE_MUST_BE_DEPENDENCY), new Object [] { param0, param1 });
  }
  
  public final static String PKGJ_PROJECT_TYPE_MANDATORY_OUTPUT_AND_SOURCES = "PKGJ_PROJECT_TYPE_MANDATORY_OUTPUT_AND_SOURCES";
  
  /**
   * Projects of type {0} must always declare an output folder and at least one source container.
   */
  public static String getMessageForPKGJ_PROJECT_TYPE_MANDATORY_OUTPUT_AND_SOURCES(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_PROJECT_TYPE_MANDATORY_OUTPUT_AND_SOURCES), new Object [] { param0 });
  }
  
  public final static String PKGJ_PROPERTY_UNKNOWN = "PKGJ_PROPERTY_UNKNOWN";
  
  /**
   * Property "{0}" is unknown.
   */
  public static String getMessageForPKGJ_PROPERTY_UNKNOWN(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_PROPERTY_UNKNOWN), new Object [] { param0 });
  }
  
  public final static String PKGJ_SCOPE_NAME_MISMATCH = "PKGJ_SCOPE_NAME_MISMATCH";
  
  /**
   * The scope name "{0}" does not match the name of the project folder's parent folder "{1}" on the file system.
   */
  public static String getMessageForPKGJ_SCOPE_NAME_MISMATCH(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_SCOPE_NAME_MISMATCH), new Object [] { param0, param1 });
  }
  
  public final static String PKGJ_SEMVER_ERROR = "PKGJ_SEMVER_ERROR";
  
  /**
   * {0}
   */
  public static String getMessageForPKGJ_SEMVER_ERROR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_SEMVER_ERROR), new Object [] { param0 });
  }
  
  public final static String PKGJ_SEMVER_WARNING = "PKGJ_SEMVER_WARNING";
  
  /**
   * {0}
   */
  public static String getMessageForPKGJ_SEMVER_WARNING(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_SEMVER_WARNING), new Object [] { param0 });
  }
  
  public final static String PKGJ_SRC_IN_FILTER_IS_NO_DECLARED_SOURCE = "PKGJ_SRC_IN_FILTER_IS_NO_DECLARED_SOURCE";
  
  /**
   * The given source container "{0}" has not been declared as source container.
   */
  public static String getMessageForPKGJ_SRC_IN_FILTER_IS_NO_DECLARED_SOURCE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PKGJ_SRC_IN_FILTER_IS_NO_DECLARED_SOURCE), new Object [] { param0 });
  }
  
  public final static String POLY_CLASH_IN_RUNTIMEDEPENDENCY = "POLY_CLASH_IN_RUNTIMEDEPENDENCY";
  
  /**
   * The libraries {0} provide polyfills for the same element {1} and cannot be used together.
   */
  public static String getMessageForPOLY_CLASH_IN_RUNTIMEDEPENDENCY(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(POLY_CLASH_IN_RUNTIMEDEPENDENCY), new Object [] { param0, param1 });
  }
  
  public final static String POLY_CLASH_IN_RUNTIMEDEPENDENCY_MULTI = "POLY_CLASH_IN_RUNTIMEDEPENDENCY_MULTI";
  
  /**
   * The libraries {0} provide polyfills for the same elements {1}  and cannot be used together.
   */
  public static String getMessageForPOLY_CLASH_IN_RUNTIMEDEPENDENCY_MULTI(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(POLY_CLASH_IN_RUNTIMEDEPENDENCY_MULTI), new Object [] { param0, param1 });
  }
  
  public final static String POLY_CLASH_IN_STATIC_POLYFILL_MODULE = "POLY_CLASH_IN_STATIC_POLYFILL_MODULE";
  
  /**
   * Only one module annotated with @@StaticPolyfillModule is allowed per project. Conflicting with {0}.
   */
  public static String getMessageForPOLY_CLASH_IN_STATIC_POLYFILL_MODULE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(POLY_CLASH_IN_STATIC_POLYFILL_MODULE), new Object [] { param0 });
  }
  
  public final static String POLY_ERROR_IN_RUNTIMEDEPENDENCY = "POLY_ERROR_IN_RUNTIMEDEPENDENCY";
  
  /**
   * Erroneous library {0} provides contradicting polyfills for {1}.
   */
  public static String getMessageForPOLY_ERROR_IN_RUNTIMEDEPENDENCY(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(POLY_ERROR_IN_RUNTIMEDEPENDENCY), new Object [] { param0, param1 });
  }
  
  public final static String POLY_IMPLEMENTING_INTERFACE_NOT_ALLOWED = "POLY_IMPLEMENTING_INTERFACE_NOT_ALLOWED";
  
  /**
   * The filling class cannot introduce additional interfaces; all interfaces must be declared on the filled class.
   */
  public static String getMessageForPOLY_IMPLEMENTING_INTERFACE_NOT_ALLOWED() {
    return org.eclipse.osgi.util.NLS.bind(getString(POLY_IMPLEMENTING_INTERFACE_NOT_ALLOWED), new Object [] {  });
  }
  
  public final static String POLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES = "POLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES";
  
  /**
   * Only top-level classes annotated as StaticPolyfill are allowed in a module annotated with StaticPolyfillModule.
   */
  public static String getMessageForPOLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES() {
    return org.eclipse.osgi.util.NLS.bind(getString(POLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES), new Object [] {  });
  }
  
  public final static String POST_PROCESSING_FAILED = "POST_PROCESSING_FAILED";
  
  /**
   * {0} {1} thrown during post-processing (please report this!): {2}
   */
  public static String getMessageForPOST_PROCESSING_FAILED(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(POST_PROCESSING_FAILED), new Object [] { param0, param1, param2 });
  }
  
  public final static String PROJECT_DEPENDENCY_CYCLE = "PROJECT_DEPENDENCY_CYCLE";
  
  /**
   * The project configuration contains a dependency cycle of projects {0}.
   */
  public static String getMessageForPROJECT_DEPENDENCY_CYCLE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(PROJECT_DEPENDENCY_CYCLE), new Object [] { param0 });
  }
  
  public final static String PROJECT_REFERENCES_ITSELF = "PROJECT_REFERENCES_ITSELF";
  
  /**
   * Project cannot reference itself.
   */
  public static String getMessageForPROJECT_REFERENCES_ITSELF() {
    return org.eclipse.osgi.util.NLS.bind(getString(PROJECT_REFERENCES_ITSELF), new Object [] {  });
  }
  
  public final static String SRCTEST_NO_TESTLIB_DEP = "SRCTEST_NO_TESTLIB_DEP";
  
  /**
   * Project with source folder of type test should depend on {0}.
   */
  public static String getMessageForSRCTEST_NO_TESTLIB_DEP(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(SRCTEST_NO_TESTLIB_DEP), new Object [] { param0 });
  }
  
  public final static String SYN_KW_EXTENDS_IMPLEMENTS_MIXED_UP = "SYN_KW_EXTENDS_IMPLEMENTS_MIXED_UP";
  
  /**
   * The {0} cannot {1} {2}, use "{3}".
   */
  public static String getMessageForSYN_KW_EXTENDS_IMPLEMENTS_MIXED_UP(final Object param0, final Object param1, final Object param2, final Object param3) {
    return org.eclipse.osgi.util.NLS.bind(getString(SYN_KW_EXTENDS_IMPLEMENTS_MIXED_UP), new Object [] { param0, param1, param2, param3 });
  }
  
  public final static String SYN_KW_EXTENDS_IMPLEMENTS_WRONG_ORDER = "SYN_KW_EXTENDS_IMPLEMENTS_WRONG_ORDER";
  
  /**
   * Extended class must be declared before implemented interfaces.
   */
  public static String getMessageForSYN_KW_EXTENDS_IMPLEMENTS_WRONG_ORDER() {
    return org.eclipse.osgi.util.NLS.bind(getString(SYN_KW_EXTENDS_IMPLEMENTS_WRONG_ORDER), new Object [] {  });
  }
  
  public final static String SYN_MODIFIER_ACCESS_SEVERAL = "SYN_MODIFIER_ACCESS_SEVERAL";
  
  /**
   * Only a single access modifier may be provided.
   */
  public static String getMessageForSYN_MODIFIER_ACCESS_SEVERAL() {
    return org.eclipse.osgi.util.NLS.bind(getString(SYN_MODIFIER_ACCESS_SEVERAL), new Object [] {  });
  }
  
  public final static String SYN_MODIFIER_BAD_ORDER = "SYN_MODIFIER_BAD_ORDER";
  
  /**
   * Modifiers should appear in this order: {0}.
   */
  public static String getMessageForSYN_MODIFIER_BAD_ORDER(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(SYN_MODIFIER_BAD_ORDER), new Object [] { param0 });
  }
  
  public final static String SYN_MODIFIER_DUPLICATE = "SYN_MODIFIER_DUPLICATE";
  
  /**
   * Duplicate modifier {0}.
   */
  public static String getMessageForSYN_MODIFIER_DUPLICATE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(SYN_MODIFIER_DUPLICATE), new Object [] { param0 });
  }
  
  public final static String SYN_MODIFIER_INVALID = "SYN_MODIFIER_INVALID";
  
  /**
   * Modifier {0} is not allowed on a {1}.
   */
  public static String getMessageForSYN_MODIFIER_INVALID(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(SYN_MODIFIER_INVALID), new Object [] { param0, param1 });
  }
  
  public final static String THIRD_PARTY_BABEL_LET_CONST_IN_FUN_EXPR = "THIRD_PARTY_BABEL_LET_CONST_IN_FUN_EXPR";
  
  /**
   * This code is prone to Babel bug #6302. If you use Babel in your build pipeline, you should rename this let/const or the containing function expression.
   */
  public static String getMessageForTHIRD_PARTY_BABEL_LET_CONST_IN_FUN_EXPR() {
    return org.eclipse.osgi.util.NLS.bind(getString(THIRD_PARTY_BABEL_LET_CONST_IN_FUN_EXPR), new Object [] {  });
  }
  
  public final static String TYS_ADDITIONAL_STRUCTURAL_MEMBERS_ON_TYPE_VARS = "TYS_ADDITIONAL_STRUCTURAL_MEMBERS_ON_TYPE_VARS";
  
  /**
   * No additional structural members allowed on type variables, since they can cause collisions.
   */
  public static String getMessageForTYS_ADDITIONAL_STRUCTURAL_MEMBERS_ON_TYPE_VARS() {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_ADDITIONAL_STRUCTURAL_MEMBERS_ON_TYPE_VARS), new Object [] {  });
  }
  
  public final static String TYS_CANNOT_TYPE = "TYS_CANNOT_TYPE";
  
  /**
   * cannot type {0}.
   */
  public static String getMessageForTYS_CANNOT_TYPE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_CANNOT_TYPE), new Object [] { param0 });
  }
  
  public final static String TYS_COMPOUND_MISSING_GETTER = "TYS_COMPOUND_MISSING_GETTER";
  
  /**
   * Missing getter on left-hand side of compound assignment.
   */
  public static String getMessageForTYS_COMPOUND_MISSING_GETTER() {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_COMPOUND_MISSING_GETTER), new Object [] {  });
  }
  
  public final static String TYS_FOR_IN_VAR_STRING = "TYS_FOR_IN_VAR_STRING";
  
  /**
   * Type of for-in-loop variable must be a super type of string but {0} is not.
   */
  public static String getMessageForTYS_FOR_IN_VAR_STRING(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_FOR_IN_VAR_STRING), new Object [] { param0 });
  }
  
  public final static String TYS_FUNCTION_DISALLOWED_AS_TYPE = "TYS_FUNCTION_DISALLOWED_AS_TYPE";
  
  /**
   * The name of a declared function may not be used as a type name.
   */
  public static String getMessageForTYS_FUNCTION_DISALLOWED_AS_TYPE() {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_FUNCTION_DISALLOWED_AS_TYPE), new Object [] {  });
  }
  
  public final static String TYS_INSTANCEOF_NOT_SUPPORTED_FOR_BUILT_IN_INTERFACES = "TYS_INSTANCEOF_NOT_SUPPORTED_FOR_BUILT_IN_INTERFACES";
  
  /**
   * 'instanceof' cannot be used with built-in interface {0}.
   */
  public static String getMessageForTYS_INSTANCEOF_NOT_SUPPORTED_FOR_BUILT_IN_INTERFACES(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_INSTANCEOF_NOT_SUPPORTED_FOR_BUILT_IN_INTERFACES), new Object [] { param0 });
  }
  
  public final static String TYS_INSTANCEOF_NOT_SUPPORTED_FOR_PRIMITIVE_TYPES = "TYS_INSTANCEOF_NOT_SUPPORTED_FOR_PRIMITIVE_TYPES";
  
  /**
   * 'instanceof' cannot be used with primitive types.
   */
  public static String getMessageForTYS_INSTANCEOF_NOT_SUPPORTED_FOR_PRIMITIVE_TYPES() {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_INSTANCEOF_NOT_SUPPORTED_FOR_PRIMITIVE_TYPES), new Object [] {  });
  }
  
  public final static String TYS_INSTANCEOF_NOT_SUPPORTED_FOR_STRUCTURAL_TYPES = "TYS_INSTANCEOF_NOT_SUPPORTED_FOR_STRUCTURAL_TYPES";
  
  /**
   * 'instanceof' cannot be used with structurally defined type {0}.
   */
  public static String getMessageForTYS_INSTANCEOF_NOT_SUPPORTED_FOR_STRUCTURAL_TYPES(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_INSTANCEOF_NOT_SUPPORTED_FOR_STRUCTURAL_TYPES), new Object [] { param0 });
  }
  
  public final static String TYS_INVALID_TYPE_SYNTAX = "TYS_INVALID_TYPE_SYNTAX";
  
  /**
   * Wrong type syntax: Use 'foo:Type' rather than 'Type foo'.
   */
  public static String getMessageForTYS_INVALID_TYPE_SYNTAX() {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_INVALID_TYPE_SYNTAX), new Object [] {  });
  }
  
  public final static String TYS_MEMBER_NOT_IN_STRUCTURAL_FIELDS_TYPE_USE_SITE = "TYS_MEMBER_NOT_IN_STRUCTURAL_FIELDS_TYPE_USE_SITE";
  
  /**
   * {0} {1} is not available for fields-only-referenced type {2}.
   */
  public static String getMessageForTYS_MEMBER_NOT_IN_STRUCTURAL_FIELDS_TYPE_USE_SITE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_MEMBER_NOT_IN_STRUCTURAL_FIELDS_TYPE_USE_SITE), new Object [] { param0, param1, param2 });
  }
  
  public final static String TYS_MEMBER_NOT_IN_STRUCTURAL_TYPE_DEF_SITE = "TYS_MEMBER_NOT_IN_STRUCTURAL_TYPE_DEF_SITE";
  
  /**
   * {0} {1} is not available for structurally defined type {2}.
   */
  public static String getMessageForTYS_MEMBER_NOT_IN_STRUCTURAL_TYPE_DEF_SITE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_MEMBER_NOT_IN_STRUCTURAL_TYPE_DEF_SITE), new Object [] { param0, param1, param2 });
  }
  
  public final static String TYS_MEMBER_NOT_IN_STRUCTURAL_TYPE_USE_SITE = "TYS_MEMBER_NOT_IN_STRUCTURAL_TYPE_USE_SITE";
  
  /**
   * {0} {1} is not available for structurally referenced type {2}.
   */
  public static String getMessageForTYS_MEMBER_NOT_IN_STRUCTURAL_TYPE_USE_SITE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_MEMBER_NOT_IN_STRUCTURAL_TYPE_USE_SITE), new Object [] { param0, param1, param2 });
  }
  
  public final static String TYS_MISSING = "TYS_MISSING";
  
  /**
   * Types model hasn't been built for this file. Please report this bug to a N4JS developer.
   */
  public static String getMessageForTYS_MISSING() {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_MISSING), new Object [] {  });
  }
  
  public final static String TYS_NON_THIS_ASYNC = "TYS_NON_THIS_ASYNC";
  
  /**
   * The return type of an async function is not allowed to refer to the this-type.
   */
  public static String getMessageForTYS_NON_THIS_ASYNC() {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_NON_THIS_ASYNC), new Object [] {  });
  }
  
  public final static String TYS_NON_VOID_ASYNC = "TYS_NON_VOID_ASYNC";
  
  /**
   * Internal error: Only Promise allowed as inferred return type of an async FunctionDefinition
   */
  public static String getMessageForTYS_NON_VOID_ASYNC() {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_NON_VOID_ASYNC), new Object [] {  });
  }
  
  public final static String TYS_NO_SUBTYPE = "TYS_NO_SUBTYPE";
  
  /**
   * {0} is not a subtype of {1}.
   */
  public static String getMessageForTYS_NO_SUBTYPE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_NO_SUBTYPE), new Object [] { param0, param1 });
  }
  
  public final static String TYS_NO_SUPERTYPE_WRITE_ACCESS = "TYS_NO_SUPERTYPE_WRITE_ACCESS";
  
  /**
   * expecting write-access for type {0} but {1} is not a super type of {0}.
   */
  public static String getMessageForTYS_NO_SUPERTYPE_WRITE_ACCESS(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_NO_SUPERTYPE_WRITE_ACCESS), new Object [] { param0, param1 });
  }
  
  public final static String TYS_NULL_OBJECT = "TYS_NULL_OBJECT";
  
  /**
   * passed null object to system at {0}.
   */
  public static String getMessageForTYS_NULL_OBJECT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_NULL_OBJECT), new Object [] { param0 });
  }
  
  public final static String TYS_PRIMITIVE_TYPE_DYNAMIC = "TYS_PRIMITIVE_TYPE_DYNAMIC";
  
  /**
   * Primitive type {0} must not be referenced dynamically.
   */
  public static String getMessageForTYS_PRIMITIVE_TYPE_DYNAMIC(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_PRIMITIVE_TYPE_DYNAMIC), new Object [] { param0 });
  }
  
  public final static String TYS_PROPERTY_HAS_NO_SETTER = "TYS_PROPERTY_HAS_NO_SETTER";
  
  /**
   * Property {0} has no setter.
   */
  public static String getMessageForTYS_PROPERTY_HAS_NO_SETTER(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_PROPERTY_HAS_NO_SETTER), new Object [] { param0 });
  }
  
  public final static String TYS_STRUCTURAL_PRIMITIVE = "TYS_STRUCTURAL_PRIMITIVE";
  
  /**
   * Structural type operator ~ does not have any effect on primitive types
   */
  public static String getMessageForTYS_STRUCTURAL_PRIMITIVE() {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_STRUCTURAL_PRIMITIVE), new Object [] {  });
  }
  
  public final static String TYS_VOID_AT_WRONG_LOCATION = "TYS_VOID_AT_WRONG_LOCATION";
  
  /**
   * Type 'void' may only be used to declare the return type of functions and methods.
   */
  public static String getMessageForTYS_VOID_AT_WRONG_LOCATION() {
    return org.eclipse.osgi.util.NLS.bind(getString(TYS_VOID_AT_WRONG_LOCATION), new Object [] {  });
  }
  
  public final static String UNI_ANY_USED = "UNI_ANY_USED";
  
  /**
   * The use of the any type in a union type is discouraged.
   */
  public static String getMessageForUNI_ANY_USED() {
    return org.eclipse.osgi.util.NLS.bind(getString(UNI_ANY_USED), new Object [] {  });
  }
  
  public final static String UNI_DIFFERENT_TYPES = "UNI_DIFFERENT_TYPES";
  
  /**
   * Member {0} not of same type in all types of union: {1}.
   */
  public static String getMessageForUNI_DIFFERENT_TYPES(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(UNI_DIFFERENT_TYPES), new Object [] { param0, param1 });
  }
  
  public final static String UNI_INVALID_COMBINATION = "UNI_INVALID_COMBINATION";
  
  /**
   * Union combines fields and {0} with name {1} and therefore property {1} is {2}.
   */
  public static String getMessageForUNI_INVALID_COMBINATION(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(UNI_INVALID_COMBINATION), new Object [] { param0, param1, param2 });
  }
  
  public final static String UNI_INVALID_COMBINATION_SETTER_VS_READ_ONLY_FIELD = "UNI_INVALID_COMBINATION_SETTER_VS_READ_ONLY_FIELD";
  
  /**
   * Union combines fields and setters with name {0} but still write-access is not allowed because one or more fields are read-only (const or @Final).
   */
  public static String getMessageForUNI_INVALID_COMBINATION_SETTER_VS_READ_ONLY_FIELD(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(UNI_INVALID_COMBINATION_SETTER_VS_READ_ONLY_FIELD), new Object [] { param0 });
  }
  
  public final static String UNI_MISSING = "UNI_MISSING";
  
  /**
   * Member {0} not present in all types of union; missing from: {1}.
   */
  public static String getMessageForUNI_MISSING(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(UNI_MISSING), new Object [] { param0, param1 });
  }
  
  public final static String UNI_MULTIPLE_KINDS = "UNI_MULTIPLE_KINDS";
  
  /**
   * Member {0} not of same kind in all types of union: {1}.
   */
  public static String getMessageForUNI_MULTIPLE_KINDS(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(UNI_MULTIPLE_KINDS), new Object [] { param0, param1 });
  }
  
  public final static String UNI_REDUNDANT_SUBTYPE = "UNI_REDUNDANT_SUBTYPE";
  
  /**
   * The use of redundant subtypes is discouraged.
   */
  public static String getMessageForUNI_REDUNDANT_SUBTYPE() {
    return org.eclipse.osgi.util.NLS.bind(getString(UNI_REDUNDANT_SUBTYPE), new Object [] {  });
  }
  
  public final static String UNI_UNCOMMON = "UNI_UNCOMMON";
  
  /**
   * Member {0} not present in all types of union or incompatible.
   */
  public static String getMessageForUNI_UNCOMMON(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(UNI_UNCOMMON), new Object [] { param0 });
  }
  
  public final static String UNSUPPORTED = "UNSUPPORTED";
  
  /**
   * Unsupported feature: {0}.
   */
  public static String getMessageForUNSUPPORTED(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(UNSUPPORTED), new Object [] { param0 });
  }
  
  public final static String VCO_BINARYINT_CONVERT_EMPTY_STR = "VCO_BINARYINT_CONVERT_EMPTY_STR";
  
  /**
   * Couldn't convert empty string to a binary int value.
   */
  public static String getMessageForVCO_BINARYINT_CONVERT_EMPTY_STR() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_BINARYINT_CONVERT_EMPTY_STR), new Object [] {  });
  }
  
  public final static String VCO_BINARYINT_CONVERT_STR = "VCO_BINARYINT_CONVERT_STR";
  
  /**
   * Couldn't convert {0} to a binary int value.
   */
  public static String getMessageForVCO_BINARYINT_CONVERT_STR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_BINARYINT_CONVERT_STR), new Object [] { param0 });
  }
  
  public final static String VCO_BINARYINT_CONVERT_TOO_SHORT = "VCO_BINARYINT_CONVERT_TOO_SHORT";
  
  /**
   * Couldn't convert {0} to an int value.
   */
  public static String getMessageForVCO_BINARYINT_CONVERT_TOO_SHORT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_BINARYINT_CONVERT_TOO_SHORT), new Object [] { param0 });
  }
  
  public final static String VCO_BINARYINT_NEGATIVE = "VCO_BINARYINT_NEGATIVE";
  
  /**
   * {0}-value may not be negative (value: {1}).
   */
  public static String getMessageForVCO_BINARYINT_NEGATIVE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_BINARYINT_NEGATIVE), new Object [] { param0, param1 });
  }
  
  public final static String VCO_DOUBLE_CONVERT_EMPTY_STR = "VCO_DOUBLE_CONVERT_EMPTY_STR";
  
  /**
   * Couldn't convert empty string to a double value.
   */
  public static String getMessageForVCO_DOUBLE_CONVERT_EMPTY_STR() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_DOUBLE_CONVERT_EMPTY_STR), new Object [] {  });
  }
  
  public final static String VCO_DOUBLE_CONVERT_STR = "VCO_DOUBLE_CONVERT_STR";
  
  /**
   * Couldn't convert {0} to a double value.
   */
  public static String getMessageForVCO_DOUBLE_CONVERT_STR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_DOUBLE_CONVERT_STR), new Object [] { param0 });
  }
  
  public final static String VCO_DOUBLE_NEGATIVE = "VCO_DOUBLE_NEGATIVE";
  
  /**
   * {0}-value may not be negative (value: {1}).
   */
  public static String getMessageForVCO_DOUBLE_NEGATIVE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_DOUBLE_NEGATIVE), new Object [] { param0, param1 });
  }
  
  public final static String VCO_HEXINT_CONVERT_EMPTY_STR = "VCO_HEXINT_CONVERT_EMPTY_STR";
  
  /**
   * Couldn't convert empty string to an hex int value.
   */
  public static String getMessageForVCO_HEXINT_CONVERT_EMPTY_STR() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_HEXINT_CONVERT_EMPTY_STR), new Object [] {  });
  }
  
  public final static String VCO_HEXINT_CONVERT_STR = "VCO_HEXINT_CONVERT_STR";
  
  /**
   * Couldn't convert {0} to an hex int value.
   */
  public static String getMessageForVCO_HEXINT_CONVERT_STR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_HEXINT_CONVERT_STR), new Object [] { param0 });
  }
  
  public final static String VCO_HEXINT_CONVERT_TOO_SHORT = "VCO_HEXINT_CONVERT_TOO_SHORT";
  
  /**
   * Couldn't convert {0} to an int value.
   */
  public static String getMessageForVCO_HEXINT_CONVERT_TOO_SHORT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_HEXINT_CONVERT_TOO_SHORT), new Object [] { param0 });
  }
  
  public final static String VCO_HEXINT_NEGATIVE = "VCO_HEXINT_NEGATIVE";
  
  /**
   * {0}-value may not be negative (value: {1}).
   */
  public static String getMessageForVCO_HEXINT_NEGATIVE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_HEXINT_NEGATIVE), new Object [] { param0, param1 });
  }
  
  public final static String VCO_IDENT_ESCAP_SEQ = "VCO_IDENT_ESCAP_SEQ";
  
  /**
   * Illegal escape sequence in identifier {0} at position {1}.
   */
  public static String getMessageForVCO_IDENT_ESCAP_SEQ(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_IDENT_ESCAP_SEQ), new Object [] { param0, param1 });
  }
  
  public final static String VCO_IDENT_ILLEGAL_CHAR = "VCO_IDENT_ILLEGAL_CHAR";
  
  /**
   * Illegal character in identifier ''{0}'' at position {1}.
   */
  public static String getMessageForVCO_IDENT_ILLEGAL_CHAR(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_IDENT_ILLEGAL_CHAR), new Object [] { param0, param1 });
  }
  
  public final static String VCO_IDENT_ILLEGAL_CHAR_WITH_RESULT = "VCO_IDENT_ILLEGAL_CHAR_WITH_RESULT";
  
  /**
   * Illegal character in identifier ''{0}'' ({1}) at position {2}.
   */
  public static String getMessageForVCO_IDENT_ILLEGAL_CHAR_WITH_RESULT(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_IDENT_ILLEGAL_CHAR_WITH_RESULT), new Object [] { param0, param1, param2 });
  }
  
  public final static String VCO_NPE = "VCO_NPE";
  
  /**
   * A NullPointerException occurred. This indicates a missing value converter or a bug in its implementation.
   */
  public static String getMessageForVCO_NPE() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_NPE), new Object [] {  });
  }
  
  public final static String VCO_NULL_FEATURE = "VCO_NULL_FEATURE";
  
  /**
   * ValueConverter returned null for primitive feature {0}
   */
  public static String getMessageForVCO_NULL_FEATURE(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_NULL_FEATURE), new Object [] { param0 });
  }
  
  public final static String VCO_OCTALINT_CONVERT_EMPTY_STR = "VCO_OCTALINT_CONVERT_EMPTY_STR";
  
  /**
   * Couldn't convert empty string to an octal int value.
   */
  public static String getMessageForVCO_OCTALINT_CONVERT_EMPTY_STR() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_OCTALINT_CONVERT_EMPTY_STR), new Object [] {  });
  }
  
  public final static String VCO_OCTALINT_CONVERT_STR = "VCO_OCTALINT_CONVERT_STR";
  
  /**
   * Couldn't convert {0} to an octal int value.
   */
  public static String getMessageForVCO_OCTALINT_CONVERT_STR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_OCTALINT_CONVERT_STR), new Object [] { param0 });
  }
  
  public final static String VCO_OCTALINT_CONVERT_TOO_SHORT = "VCO_OCTALINT_CONVERT_TOO_SHORT";
  
  /**
   * Couldn't convert {0} to an int value.
   */
  public static String getMessageForVCO_OCTALINT_CONVERT_TOO_SHORT(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_OCTALINT_CONVERT_TOO_SHORT), new Object [] { param0 });
  }
  
  public final static String VCO_OCTALINT_LEADING_ZEROS = "VCO_OCTALINT_LEADING_ZEROS";
  
  /**
   * Don't use extra leading zeros {0}."
   */
  public static String getMessageForVCO_OCTALINT_LEADING_ZEROS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_OCTALINT_LEADING_ZEROS), new Object [] { param0 });
  }
  
  public final static String VCO_OCTALINT_NEGATIVE = "VCO_OCTALINT_NEGATIVE";
  
  /**
   * {0}-value may not be negative (value: {1}).
   */
  public static String getMessageForVCO_OCTALINT_NEGATIVE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_OCTALINT_NEGATIVE), new Object [] { param0, param1 });
  }
  
  public final static String VCO_REGEX_ILLEGAL_ESCAP = "VCO_REGEX_ILLEGAL_ESCAP";
  
  /**
   * Illegal escape sequence in regular expression {0}
   */
  public static String getMessageForVCO_REGEX_ILLEGAL_ESCAP(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_REGEX_ILLEGAL_ESCAP), new Object [] { param0 });
  }
  
  public final static String VCO_REGEX_INVALID = "VCO_REGEX_INVALID";
  
  /**
   * Invalid regular expression literal
   */
  public static String getMessageForVCO_REGEX_INVALID() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_REGEX_INVALID), new Object [] {  });
  }
  
  public final static String VCO_SCIINT_CONVERT_EMPTY_STR = "VCO_SCIINT_CONVERT_EMPTY_STR";
  
  /**
   * Couldn't convert empty string to an scientific int value.
   */
  public static String getMessageForVCO_SCIINT_CONVERT_EMPTY_STR() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_SCIINT_CONVERT_EMPTY_STR), new Object [] {  });
  }
  
  public final static String VCO_SCIINT_CONVERT_STR = "VCO_SCIINT_CONVERT_STR";
  
  /**
   * Couldn't convert {0} to an scientific int value.
   */
  public static String getMessageForVCO_SCIINT_CONVERT_STR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_SCIINT_CONVERT_STR), new Object [] { param0 });
  }
  
  public final static String VCO_SCIINT_NEGATIVE = "VCO_SCIINT_NEGATIVE";
  
  /**
   * {0}-value may not be negative (value: {1}).
   */
  public static String getMessageForVCO_SCIINT_NEGATIVE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_SCIINT_NEGATIVE), new Object [] { param0, param1 });
  }
  
  public final static String VCO_STRING_BAD_ESCAP_ERROR = "VCO_STRING_BAD_ESCAP_ERROR";
  
  /**
   * Bad escapement
   */
  public static String getMessageForVCO_STRING_BAD_ESCAP_ERROR() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_STRING_BAD_ESCAP_ERROR), new Object [] {  });
  }
  
  public final static String VCO_STRING_BAD_ESCAP_WARN = "VCO_STRING_BAD_ESCAP_WARN";
  
  /**
   * Bad escapement
   */
  public static String getMessageForVCO_STRING_BAD_ESCAP_WARN() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_STRING_BAD_ESCAP_WARN), new Object [] {  });
  }
  
  public final static String VCO_STRING_DOUBLE_QUOTE = "VCO_STRING_DOUBLE_QUOTE";
  
  /**
   * String literal is not properly closed by a double-quote.
   */
  public static String getMessageForVCO_STRING_DOUBLE_QUOTE() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_STRING_DOUBLE_QUOTE), new Object [] {  });
  }
  
  public final static String VCO_STRING_QUOTE = "VCO_STRING_QUOTE";
  
  /**
   * String literal is not properly closed by a quote.
   */
  public static String getMessageForVCO_STRING_QUOTE() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_STRING_QUOTE), new Object [] {  });
  }
  
  public final static String VCO_TEMPLATE_MIDDLE = "VCO_TEMPLATE_MIDDLE";
  
  /**
   * Template literal is not properly closed by ${.
   */
  public static String getMessageForVCO_TEMPLATE_MIDDLE() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_TEMPLATE_MIDDLE), new Object [] {  });
  }
  
  public final static String VCO_TEMPLATE_QUOTE = "VCO_TEMPLATE_QUOTE";
  
  /**
   * Template literal is not properly closed by a backtick.
   */
  public static String getMessageForVCO_TEMPLATE_QUOTE() {
    return org.eclipse.osgi.util.NLS.bind(getString(VCO_TEMPLATE_QUOTE), new Object [] {  });
  }
  
  public final static String VIS_ILLEGAL_FUN_ACCESS = "VIS_ILLEGAL_FUN_ACCESS";
  
  /**
   * The function {0} is not visible.
   */
  public static String getMessageForVIS_ILLEGAL_FUN_ACCESS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VIS_ILLEGAL_FUN_ACCESS), new Object [] { param0 });
  }
  
  public final static String VIS_ILLEGAL_MEMBER_ACCESS = "VIS_ILLEGAL_MEMBER_ACCESS";
  
  /**
   * The {0} {1} is not visible.
   */
  public static String getMessageForVIS_ILLEGAL_MEMBER_ACCESS(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(VIS_ILLEGAL_MEMBER_ACCESS), new Object [] { param0, param1 });
  }
  
  public final static String VIS_ILLEGAL_STATIC_MEMBER_WRITE_ACCESS = "VIS_ILLEGAL_STATIC_MEMBER_WRITE_ACCESS";
  
  /**
   * Write access to the static member {1} defined in {0} must use {0} directly.
   */
  public static String getMessageForVIS_ILLEGAL_STATIC_MEMBER_WRITE_ACCESS(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(VIS_ILLEGAL_STATIC_MEMBER_WRITE_ACCESS), new Object [] { param0, param1 });
  }
  
  public final static String VIS_ILLEGAL_STATIC_MEMBER_WRITE_ACCESS_WITH_ALIAS = "VIS_ILLEGAL_STATIC_MEMBER_WRITE_ACCESS_WITH_ALIAS";
  
  /**
   * Write access to the static member {1} defined in {0} must use the alias {2} directly.
   */
  public static String getMessageForVIS_ILLEGAL_STATIC_MEMBER_WRITE_ACCESS_WITH_ALIAS(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(VIS_ILLEGAL_STATIC_MEMBER_WRITE_ACCESS_WITH_ALIAS), new Object [] { param0, param1, param2 });
  }
  
  public final static String VIS_ILLEGAL_TYPE_ACCESS = "VIS_ILLEGAL_TYPE_ACCESS";
  
  /**
   * The type {0} is not visible.
   */
  public static String getMessageForVIS_ILLEGAL_TYPE_ACCESS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VIS_ILLEGAL_TYPE_ACCESS), new Object [] { param0 });
  }
  
  public final static String VIS_ILLEGAL_VARIABLE_ACCESS = "VIS_ILLEGAL_VARIABLE_ACCESS";
  
  /**
   * The variable {0} is not visible.
   */
  public static String getMessageForVIS_ILLEGAL_VARIABLE_ACCESS(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VIS_ILLEGAL_VARIABLE_ACCESS), new Object [] { param0 });
  }
  
  public final static String VIS_NEW_CANNOT_INSTANTIATE_INVISIBLE_CONSTRUCTOR = "VIS_NEW_CANNOT_INSTANTIATE_INVISIBLE_CONSTRUCTOR";
  
  /**
   * The constructor of {0} is not visible.
   */
  public static String getMessageForVIS_NEW_CANNOT_INSTANTIATE_INVISIBLE_CONSTRUCTOR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VIS_NEW_CANNOT_INSTANTIATE_INVISIBLE_CONSTRUCTOR), new Object [] { param0 });
  }
  
  public final static String VIS_RESTRITCTED_USAGE = "VIS_RESTRITCTED_USAGE";
  
  /**
   * The usage of {0} is not allowed in {1} mode.
   */
  public static String getMessageForVIS_RESTRITCTED_USAGE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(VIS_RESTRITCTED_USAGE), new Object [] { param0, param1 });
  }
  
  public final static String VIS_TYPE_PARAMETER_HIDES_TYPE = "VIS_TYPE_PARAMETER_HIDES_TYPE";
  
  /**
   * The type parameter {0} hides {1} {0}.
   */
  public static String getMessageForVIS_TYPE_PARAMETER_HIDES_TYPE(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(VIS_TYPE_PARAMETER_HIDES_TYPE), new Object [] { param0, param1 });
  }
  
  public final static String VIS_WRONG_READ_WRITE_ACCESS = "VIS_WRONG_READ_WRITE_ACCESS";
  
  /**
   * The {0} {1} is {2}.
   */
  public static String getMessageForVIS_WRONG_READ_WRITE_ACCESS(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(VIS_WRONG_READ_WRITE_ACCESS), new Object [] { param0, param1, param2 });
  }
  
  public final static String VIS_WRONG_STATIC_ACCESSOR = "VIS_WRONG_STATIC_ACCESSOR";
  
  /**
   * The {0} member {1} cannot be accessed from a {2} context.
   */
  public static String getMessageForVIS_WRONG_STATIC_ACCESSOR(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(VIS_WRONG_STATIC_ACCESSOR), new Object [] { param0, param1, param2 });
  }
  
  public final static String VIS_WRONG_TYPE_VARIABLE_ACCESSOR = "VIS_WRONG_TYPE_VARIABLE_ACCESSOR";
  
  /**
   * The type variable {0} cannot be accessed from a static context.
   */
  public static String getMessageForVIS_WRONG_TYPE_VARIABLE_ACCESSOR(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(VIS_WRONG_TYPE_VARIABLE_ACCESSOR), new Object [] { param0 });
  }
}
