/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.validation;

import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.BreakStatement;
import org.eclipse.n4js.n4JS.CatchVariable;
import org.eclipse.n4js.n4JS.ContinueStatement;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.N4ClassDefinition;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyGetterDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertySetterDeclaration;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.ThrowStatement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.projectDescription.ModuleFilterType;
import org.eclipse.n4js.ts.types.BuiltInType;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructField;
import org.eclipse.n4js.ts.types.TStructGetter;
import org.eclipse.n4js.ts.types.TStructSetter;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeAccessModifier;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.validation.TypesKeywordProvider;

/**
 * Helper returning the keyword of a given AST or type element, e.g., "class" for a class declaration.
 */
@Singleton
@SuppressWarnings("all")
public class N4JSElementKeywordProvider extends TypesKeywordProvider {
  protected String _keyword(final N4ClassDefinition n4ClassDefinition) {
    return "class";
  }
  
  protected String _keyword(final N4InterfaceDeclaration n4RoleDeclaration) {
    return "interface";
  }
  
  protected String _keyword(final N4EnumDeclaration n4EnumDeclaration) {
    return "enum";
  }
  
  protected String _keyword(final FunctionDeclaration functionDeclaration) {
    return "function";
  }
  
  protected String _keyword(final N4ClassifierDefinition n4ClassifierDefinition) {
    return "classifier";
  }
  
  protected String _keyword(final N4MemberDeclaration n4MemberDeclaration) {
    return "member";
  }
  
  protected String _keyword(final N4FieldDeclaration n4FieldDeclaration) {
    return "field";
  }
  
  protected String _keyword(final N4MethodDeclaration n4MethodDeclaration) {
    String _xifexpression = null;
    boolean _isConstructor = n4MethodDeclaration.isConstructor();
    if (_isConstructor) {
      _xifexpression = "constructor";
    } else {
      _xifexpression = "method";
    }
    return _xifexpression;
  }
  
  protected String _keyword(final N4GetterDeclaration n4GetterDeclaration) {
    return "getter";
  }
  
  protected String _keyword(final N4SetterDeclaration n4SetterDeclaration) {
    return "setter";
  }
  
  protected String _keyword(final ExportedVariableStatement exportedVariableStmt) {
    return "variable";
  }
  
  protected String _keyword(final VariableStatement VariableStmt) {
    return "variable";
  }
  
  protected String _keyword(final VariableDeclaration VariableDecl) {
    return "variable";
  }
  
  protected String _keyword(final CatchVariable catchVar) {
    return "catch variable";
  }
  
  protected String _keyword(final FunctionExpression fnExp) {
    return "function expression";
  }
  
  protected String _keyword(final ParameterizedCallExpression callExp) {
    return "call expression";
  }
  
  protected String _keyword(final FormalParameter fparam) {
    return "parameter";
  }
  
  protected String _keyword(final NamedImportSpecifier namedImportSpecifier) {
    return "named import";
  }
  
  protected String _keyword(final PropertyAssignment propertyAssignment) {
    return "property";
  }
  
  protected String _keyword(final PropertyGetterDeclaration propertyGetterDeclaration) {
    return "property getter";
  }
  
  protected String _keyword(final PropertySetterDeclaration propertySetterDeclaration) {
    return "property setter";
  }
  
  protected String _keyword(final PropertyNameValuePair propertyNameValuePair) {
    return "property";
  }
  
  protected String _keyword(final ThisLiteral thisLiteral) {
    return "this keyword";
  }
  
  protected String _keyword(final BreakStatement brk) {
    return "break";
  }
  
  protected String _keyword(final ContinueStatement cntn) {
    return "continue";
  }
  
  protected String _keyword(final ThrowStatement thrw) {
    return "throw";
  }
  
  protected String _keyword(final ReturnStatement rtrn) {
    return "return";
  }
  
  protected String _keyword(final Void nullValue) {
    return "";
  }
  
  protected String _keyword(final ModuleFilterType moduleFilterType) {
    String _switchResult = null;
    if (moduleFilterType != null) {
      switch (moduleFilterType) {
        case NO_VALIDATE:
          _switchResult = "noValidate";
          break;
        case NO_MODULE_WRAP:
          _switchResult = "noModuleWrap";
          break;
        default:
          _switchResult = "unknown filter type";
          break;
      }
    } else {
      _switchResult = "unknown filter type";
    }
    return _switchResult;
  }
  
  public String keyword(final Object n4RoleDeclaration) {
    if (n4RoleDeclaration instanceof TClass) {
      return _keyword((TClass)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TInterface) {
      return _keyword((TInterface)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TMethod) {
      return _keyword((TMethod)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TStructGetter) {
      return _keyword((TStructGetter)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TStructSetter) {
      return _keyword((TStructSetter)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof N4InterfaceDeclaration) {
      return _keyword((N4InterfaceDeclaration)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof PrimitiveType) {
      return _keyword((PrimitiveType)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TClassifier) {
      return _keyword((TClassifier)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TEnum) {
      return _keyword((TEnum)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TFunction) {
      return _keyword((TFunction)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TGetter) {
      return _keyword((TGetter)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TSetter) {
      return _keyword((TSetter)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TStructField) {
      return _keyword((TStructField)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof N4ClassDefinition) {
      return _keyword((N4ClassDefinition)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof N4EnumDeclaration) {
      return _keyword((N4EnumDeclaration)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof N4GetterDeclaration) {
      return _keyword((N4GetterDeclaration)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof N4MethodDeclaration) {
      return _keyword((N4MethodDeclaration)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof N4SetterDeclaration) {
      return _keyword((N4SetterDeclaration)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof PropertyGetterDeclaration) {
      return _keyword((PropertyGetterDeclaration)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof PropertyNameValuePair) {
      return _keyword((PropertyNameValuePair)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof PropertySetterDeclaration) {
      return _keyword((PropertySetterDeclaration)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof BuiltInType) {
      return _keyword((BuiltInType)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TField) {
      return _keyword((TField)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TypeVariable) {
      return _keyword((TypeVariable)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof CatchVariable) {
      return _keyword((CatchVariable)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof ExportedVariableStatement) {
      return _keyword((ExportedVariableStatement)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof FormalParameter) {
      return _keyword((FormalParameter)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof FunctionDeclaration) {
      return _keyword((FunctionDeclaration)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof FunctionExpression) {
      return _keyword((FunctionExpression)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof N4ClassifierDefinition) {
      return _keyword((N4ClassifierDefinition)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof N4FieldDeclaration) {
      return _keyword((N4FieldDeclaration)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof ThisLiteral) {
      return _keyword((ThisLiteral)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof VariableDeclaration) {
      return _keyword((VariableDeclaration)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TVariable) {
      return _keyword((TVariable)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof Type) {
      return _keyword((Type)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof BreakStatement) {
      return _keyword((BreakStatement)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof ContinueStatement) {
      return _keyword((ContinueStatement)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof ParameterizedCallExpression) {
      return _keyword((ParameterizedCallExpression)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof PropertyAssignment) {
      return _keyword((PropertyAssignment)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof ReturnStatement) {
      return _keyword((ReturnStatement)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof ThrowStatement) {
      return _keyword((ThrowStatement)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof VariableStatement) {
      return _keyword((VariableStatement)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TFormalParameter) {
      return _keyword((TFormalParameter)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TMember) {
      return _keyword((TMember)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof N4MemberDeclaration) {
      return _keyword((N4MemberDeclaration)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof NamedImportSpecifier) {
      return _keyword((NamedImportSpecifier)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof ModuleFilterType) {
      return _keyword((ModuleFilterType)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof MemberAccessModifier) {
      return _keyword((MemberAccessModifier)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof TypeAccessModifier) {
      return _keyword((TypeAccessModifier)n4RoleDeclaration);
    } else if (n4RoleDeclaration instanceof EObject) {
      return _keyword((EObject)n4RoleDeclaration);
    } else if (n4RoleDeclaration == null) {
      return _keyword((Void)null);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(n4RoleDeclaration).toString());
    }
  }
}
