/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler.es.assistants;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.ModifierUtils;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.RelationalOperator;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.transpiler.TransformationAssistant;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.transform.SuperLiteralTransformation;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Create the constructor function for classes (as a function declaration).
 */
@SuppressWarnings("all")
public class ClassConstructorAssistant extends TransformationAssistant {
  @Inject
  private TypeAssistant typeAssistant;
  
  /**
   * Create the constructor function for classes (as a function declaration).
   */
  public FunctionDeclaration createCtorDecl(final N4ClassDeclaration classDecl, final SymbolTableEntryOriginal superClassSTE) {
    final FunctionDeclaration funDecl = TranspilerBuilderBlocks._FunDecl(classDecl.getName());
    final N4MethodDeclaration ownedCtor = classDecl.getOwnedCtor();
    if ((ownedCtor != null)) {
      EList<FormalParameter> _fpars = funDecl.getFpars();
      EList<FormalParameter> _fpars_1 = ownedCtor.getFpars();
      Iterables.<FormalParameter>addAll(_fpars, _fpars_1);
    } else {
      final TMethod templateCtor = this.getNearestConstructorInHierarchy(classDecl);
      if ((templateCtor != null)) {
        EList<FormalParameter> _fpars_2 = funDecl.getFpars();
        final Function1<TFormalParameter, FormalParameter> _function = (TFormalParameter it) -> {
          FormalParameter _xblockexpression = null;
          {
            final TypeRef typeRefIM = this.<TypeRef>copyAlienElement(it.getTypeRef());
            _xblockexpression = TranspilerBuilderBlocks._Fpar(it.getName(), it.isVariadic(), typeRefIM, AnnotationDefinition.SPEC.hasAnnotation(it));
          }
          return _xblockexpression;
        };
        List<FormalParameter> _map = ListExtensions.<TFormalParameter, FormalParameter>map(templateCtor.getFpars(), _function);
        Iterables.<FormalParameter>addAll(_fpars_2, _map);
      }
    }
    final Function1<FormalParameter, Boolean> _function_1 = (FormalParameter it) -> {
      return Boolean.valueOf(AnnotationDefinition.SPEC.hasAnnotation(it));
    };
    final FormalParameter specFpar = IterableExtensions.<FormalParameter>head(IterableExtensions.<FormalParameter>filter(funDecl.getFpars(), _function_1));
    final Block body = TranspilerBuilderBlocks._Block();
    funDecl.setBody(body);
    IdentifiableElement _originalTarget = null;
    if (superClassSTE!=null) {
      _originalTarget=superClassSTE.getOriginalTarget();
    }
    TObjectPrototype _errorType = RuleEnvironmentExtensions.errorType(this.getState().G);
    final boolean isDirectSubclassOfError = (_originalTarget == _errorType);
    Block _body = null;
    if (ownedCtor!=null) {
      _body=ownedCtor.getBody();
    }
    final boolean hasExplicitCtor = (_body != null);
    int _xifexpression = (int) 0;
    if (hasExplicitCtor) {
      _xifexpression = this.getSuperCallIndex(ownedCtor);
    } else {
      _xifexpression = (-1);
    }
    final int superCallIndex = _xifexpression;
    Statement _xifexpression_1 = null;
    if ((superCallIndex >= 0)) {
      _xifexpression_1 = ownedCtor.getBody().getStatements().get(superCallIndex);
    }
    final Statement explicitSuperCall = _xifexpression_1;
    final boolean hasExplicitSuperCall = (superCallIndex >= 0);
    if (hasExplicitSuperCall) {
      EList<Statement> _statements = body.getStatements();
      List<Statement> _subList = ownedCtor.getBody().getStatements().subList(0, superCallIndex);
      Iterables.<Statement>addAll(_statements, _subList);
    }
    if (isDirectSubclassOfError) {
      EList<Statement> _statements_1 = body.getStatements();
      Statement[] _createSubclassingErrorOddities = this.createSubclassingErrorOddities(classDecl, ((FormalParameter[])Conversions.unwrapArray(funDecl.getFpars(), FormalParameter.class)), explicitSuperCall);
      Iterables.<Statement>addAll(_statements_1, ((Iterable<? extends Statement>)Conversions.doWrapArray(_createSubclassingErrorOddities)));
      if (hasExplicitSuperCall) {
        ownedCtor.getBody().getStatements().remove(0);
      }
    } else {
      if (hasExplicitSuperCall) {
        EList<Statement> _statements_2 = body.getStatements();
        Statement _head = IterableExtensions.<Statement>head(ownedCtor.getBody().getStatements());
        _statements_2.add(_head);
      } else {
        ParameterizedTypeRef _superClassRef = classDecl.getSuperClassRef();
        boolean _tripleNotEquals = (_superClassRef != null);
        if (_tripleNotEquals) {
          EList<Statement> _statements_3 = body.getStatements();
          ExpressionStatement _createDefaultSuperCall = this.createDefaultSuperCall(classDecl, superClassSTE, ((FormalParameter[])Conversions.unwrapArray(funDecl.getFpars(), FormalParameter.class)));
          _statements_3.add(_createDefaultSuperCall);
        }
      }
    }
    EList<Statement> _statements_4 = body.getStatements();
    Statement[] _createFieldInitCode = this.createFieldInitCode(classDecl, specFpar);
    Iterables.<Statement>addAll(_statements_4, ((Iterable<? extends Statement>)Conversions.doWrapArray(_createFieldInitCode)));
    EList<Statement> _statements_5 = body.getStatements();
    Statement[] _createDelegationToFieldInitOfImplementedInterfaces = this.createDelegationToFieldInitOfImplementedInterfaces(classDecl, specFpar);
    Iterables.<Statement>addAll(_statements_5, ((Iterable<? extends Statement>)Conversions.doWrapArray(_createDelegationToFieldInitOfImplementedInterfaces)));
    if (hasExplicitCtor) {
      EList<Statement> _statements_6 = body.getStatements();
      EList<Statement> _statements_7 = ownedCtor.getBody().getStatements();
      Iterables.<Statement>addAll(_statements_6, _statements_7);
    }
    return funDecl;
  }
  
  private Statement[] createFieldInitCode(final N4ClassDeclaration classDecl, final FormalParameter specFpar) {
    final Function1<N4FieldDeclaration, Boolean> _function = (N4FieldDeclaration it) -> {
      return Boolean.valueOf(((!it.isStatic()) && (!this.isConsumedFromInterface(it))));
    };
    final List<N4FieldDeclaration> allFields = IterableExtensions.<N4FieldDeclaration>toList(IterableExtensions.<N4FieldDeclaration>filter(classDecl.getOwnedFields(), _function));
    if ((specFpar != null)) {
      final SymbolTableEntry specFparSTE = this.findSymbolTableEntryForElement(specFpar, true);
      final EList<TStructMember> structFields = specFpar.getDeclaredTypeRef().getStructuralMembers();
      final ArrayList<Statement> result = CollectionLiterals.<Statement>newArrayList();
      for (final N4FieldDeclaration field : allFields) {
        {
          final boolean isSpecced = (this.isPublic(field) || IterableExtensions.<TStructMember>exists(structFields, ((Function1<TStructMember, Boolean>) (TStructMember it) -> {
            String _name = it.getName();
            String _name_1 = field.getName();
            return Boolean.valueOf(Objects.equal(_name, _name_1));
          })));
          if (isSpecced) {
            Statement _createFieldInitCodeForSingleSpeccedField = this.createFieldInitCodeForSingleSpeccedField(field, specFparSTE);
            result.add(_createFieldInitCodeForSingleSpeccedField);
          } else {
            Statement _createFieldInitCodeForSingleField = this.createFieldInitCodeForSingleField(field);
            result.add(_createFieldInitCodeForSingleField);
          }
        }
      }
      final Function1<N4SetterDeclaration, Boolean> _function_1 = (N4SetterDeclaration it) -> {
        return Boolean.valueOf(((!it.isStatic()) && it.getDeclaredModifiers().contains(N4Modifier.PUBLIC)));
      };
      final List<N4SetterDeclaration> speccedSetters = IterableExtensions.<N4SetterDeclaration>toList(IterableExtensions.<N4SetterDeclaration>filter(classDecl.getOwnedSetters(), _function_1));
      final Function1<N4SetterDeclaration, Statement> _function_2 = (N4SetterDeclaration it) -> {
        return this.createFieldInitCodeForSingleSpeccedSetter(it, specFparSTE);
      };
      IfStatement __IfStmnt = TranspilerBuilderBlocks._IfStmnt(TranspilerBuilderBlocks._IdentRef(specFparSTE), TranspilerBuilderBlocks._Block(
        ((Statement[])Conversions.unwrapArray(ListExtensions.<N4SetterDeclaration, Statement>map(speccedSetters, _function_2), Statement.class))));
      result.add(__IfStmnt);
      return ((Statement[])Conversions.unwrapArray(result, Statement.class));
    } else {
      final Function1<N4FieldDeclaration, Statement> _function_3 = (N4FieldDeclaration it) -> {
        return this.createFieldInitCodeForSingleField(it);
      };
      return ((Statement[])Conversions.unwrapArray(ListExtensions.<N4FieldDeclaration, Statement>map(allFields, _function_3), Statement.class));
    }
  }
  
  private Statement createFieldInitCodeForSingleField(final N4FieldDeclaration fieldDecl) {
    final SymbolTableEntry fieldSTE = this.findSymbolTableEntryForElement(fieldDecl, true);
    ParameterizedPropertyAccessExpression_IM __PropertyAccessExpr = TranspilerBuilderBlocks._PropertyAccessExpr(TranspilerBuilderBlocks._ThisLiteral(), fieldSTE);
    Expression _xifexpression = null;
    Expression _expression = fieldDecl.getExpression();
    boolean _tripleNotEquals = (_expression != null);
    if (_tripleNotEquals) {
      _xifexpression = fieldDecl.getExpression();
    } else {
      _xifexpression = this.undefinedRef();
    }
    return TranspilerBuilderBlocks._ExprStmnt(
      TranspilerBuilderBlocks._AssignmentExpr(__PropertyAccessExpr, _xifexpression));
  }
  
  private Statement createFieldInitCodeForSingleSpeccedField(final N4FieldDeclaration fieldDecl, final SymbolTableEntry specFparSTE) {
    final SymbolTableEntry fieldSTE = this.findSymbolTableEntryForElement(fieldDecl, true);
    BinaryLogicalExpression __AND = TranspilerBuilderBlocks._AND(
      TranspilerBuilderBlocks._IdentRef(specFparSTE), 
      TranspilerBuilderBlocks._RelationalExpr(TranspilerBuilderBlocks._StringLiteralForSTE(fieldSTE), RelationalOperator.IN, TranspilerBuilderBlocks._IdentRef(specFparSTE)));
    ParameterizedPropertyAccessExpression_IM __PropertyAccessExpr = TranspilerBuilderBlocks._PropertyAccessExpr(specFparSTE, fieldSTE);
    Expression _xifexpression = null;
    Expression _expression = fieldDecl.getExpression();
    boolean _tripleNotEquals = (_expression != null);
    if (_tripleNotEquals) {
      _xifexpression = this.<Expression>copy(fieldDecl.getExpression());
    } else {
      _xifexpression = this.undefinedRef();
    }
    return TranspilerBuilderBlocks._ExprStmnt(
      TranspilerBuilderBlocks._AssignmentExpr(
        TranspilerBuilderBlocks._PropertyAccessExpr(TranspilerBuilderBlocks._ThisLiteral(), fieldSTE), 
        TranspilerBuilderBlocks._ConditionalExpr(__AND, __PropertyAccessExpr, _xifexpression)));
  }
  
  private Statement createFieldInitCodeForSingleSpeccedSetter(final N4SetterDeclaration setterDecl, final SymbolTableEntry specFparSTE) {
    final SymbolTableEntry setterSTE = this.findSymbolTableEntryForElement(setterDecl, true);
    return TranspilerBuilderBlocks._IfStmnt(
      TranspilerBuilderBlocks._RelationalExpr(
        TranspilerBuilderBlocks._StringLiteralForSTE(setterSTE), RelationalOperator.IN, TranspilerBuilderBlocks._IdentRef(specFparSTE)), 
      TranspilerBuilderBlocks._ExprStmnt(
        TranspilerBuilderBlocks._AssignmentExpr(
          TranspilerBuilderBlocks._PropertyAccessExpr(TranspilerBuilderBlocks._ThisLiteral(), setterSTE), 
          TranspilerBuilderBlocks._PropertyAccessExpr(specFparSTE, setterSTE))));
  }
  
  private ExpressionStatement createDefaultSuperCall(final N4ClassDeclaration classDecl, final SymbolTableEntry superClassSTE, final FormalParameter[] fpars) {
    final boolean variadicCase = ((!((List<FormalParameter>)Conversions.doWrapArray(fpars)).isEmpty()) && IterableExtensions.<FormalParameter>last(((Iterable<FormalParameter>)Conversions.doWrapArray(fpars))).isVariadic());
    String _xifexpression = null;
    if (variadicCase) {
      _xifexpression = "apply";
    } else {
      _xifexpression = "call";
    }
    final String genericMethodName = _xifexpression;
    final SymbolTableEntryOriginal prototypeSTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.objectType(this.getState().G), "prototype", false, true, true);
    final SymbolTableEntryOriginal constructorSTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.objectType(this.getState().G), "constructor", false, false, true);
    final SymbolTableEntryOriginal genericCallSTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.functionType(this.getState().G), genericMethodName, false, false, true);
    ParameterizedCallExpression __CallExpr = TranspilerBuilderBlocks._CallExpr();
    final Procedure1<ParameterizedCallExpression> _function = (ParameterizedCallExpression it) -> {
      it.setTarget(this.__NSSafe_PropertyAccessExpr(superClassSTE, prototypeSTE, constructorSTE, genericCallSTE));
      EList<Argument> _arguments = it.getArguments();
      Argument __Argument = TranspilerBuilderBlocks._Argument(TranspilerBuilderBlocks._ThisLiteral());
      _arguments.add(__Argument);
      if (variadicCase) {
        final SymbolTableEntryOriginal concatSTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.arrayType(this.getState().G), "concat", false, false, true);
        EList<Argument> _arguments_1 = it.getArguments();
        int _size = ((List<FormalParameter>)Conversions.doWrapArray(fpars)).size();
        int _minus = (_size - 1);
        final Function1<FormalParameter, SymbolTableEntry> _function_1 = (FormalParameter it_1) -> {
          return this.findSymbolTableEntryForElement(it_1, true);
        };
        final Function1<SymbolTableEntry, IdentifierRef_IM> _function_2 = (SymbolTableEntry it_1) -> {
          return TranspilerBuilderBlocks._IdentRef(it_1);
        };
        Argument __Argument_1 = TranspilerBuilderBlocks._Argument(
          TranspilerBuilderBlocks._CallExpr(
            TranspilerBuilderBlocks._PropertyAccessExpr(
              TranspilerBuilderBlocks._ArrLit(
                ((Expression[])Conversions.unwrapArray(IterableExtensions.<SymbolTableEntry, IdentifierRef_IM>map(IterableExtensions.<FormalParameter, SymbolTableEntry>map(IterableExtensions.<FormalParameter>take(((Iterable<FormalParameter>)Conversions.doWrapArray(fpars)), _minus), _function_1), _function_2), Expression.class))), concatSTE), 
            TranspilerBuilderBlocks._IdentRef(this.findSymbolTableEntryForElement(IterableExtensions.<FormalParameter>last(((Iterable<FormalParameter>)Conversions.doWrapArray(fpars))), true))));
        _arguments_1.add(__Argument_1);
      } else {
        EList<Argument> _arguments_2 = it.getArguments();
        final Function1<FormalParameter, SymbolTableEntry> _function_3 = (FormalParameter it_1) -> {
          return this.findSymbolTableEntryForElement(it_1, true);
        };
        final Function1<SymbolTableEntry, Argument> _function_4 = (SymbolTableEntry it_1) -> {
          return TranspilerBuilderBlocks._Argument(TranspilerBuilderBlocks._IdentRef(it_1));
        };
        List<Argument> _map = ListExtensions.<SymbolTableEntry, Argument>map(ListExtensions.<FormalParameter, SymbolTableEntry>map(((List<FormalParameter>)Conversions.doWrapArray(fpars)), _function_3), _function_4);
        Iterables.<Argument>addAll(_arguments_2, _map);
      }
    };
    ParameterizedCallExpression _doubleArrow = ObjectExtensions.<ParameterizedCallExpression>operator_doubleArrow(__CallExpr, _function);
    return TranspilerBuilderBlocks._ExprStmnt(_doubleArrow);
  }
  
  /**
   * To be inserted where the explicit or implicit super call would be located, normally.
   */
  private Statement[] createSubclassingErrorOddities(final N4ClassDeclaration classDecl, final FormalParameter[] fpars, final Statement explicitSuperCall) {
    final SymbolTableEntryOriginal ErrorSTE = this.getSymbolTableEntryOriginal(RuleEnvironmentExtensions.errorType(this.getState().G), true);
    IdentifierRef_IM __IdentRef = TranspilerBuilderBlocks._IdentRef(ErrorSTE);
    Expression[] _xifexpression = null;
    if ((explicitSuperCall != null)) {
      _xifexpression = SuperLiteralTransformation.getArgumentsFromExplicitSuperCall(explicitSuperCall);
    } else {
      final Function1<FormalParameter, SymbolTableEntry> _function = (FormalParameter it) -> {
        return this.findSymbolTableEntryForElement(it, true);
      };
      final Function1<SymbolTableEntry, IdentifierRef_IM> _function_1 = (SymbolTableEntry it) -> {
        return TranspilerBuilderBlocks._IdentRef(it);
      };
      _xifexpression = ((Expression[])Conversions.unwrapArray(ListExtensions.<SymbolTableEntry, IdentifierRef_IM>map(ListExtensions.<FormalParameter, SymbolTableEntry>map(((List<FormalParameter>)Conversions.doWrapArray(fpars)), _function), _function_1), Expression.class));
    }
    final VariableStatement firstLine = TranspilerBuilderBlocks._VariableStatement(
      TranspilerBuilderBlocks._VariableDeclaration("err", TranspilerBuilderBlocks._NewExpr(__IdentRef, _xifexpression)));
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("this.message = err.message;");
    _builder.newLine();
    _builder.append("this.name = this.constructor.n4type.name;");
    _builder.newLine();
    _builder.append("Object.defineProperty(this, \'stack\', { get: function() { return err.stack; }, set: function(value) { err.stack = value; } });");
    _builder.newLine();
    final ExpressionStatement remainingLines = TranspilerBuilderBlocks._ExprStmnt(TranspilerBuilderBlocks._Snippet(_builder.toString()));
    return new Statement[] { firstLine, remainingLines };
  }
  
  private Statement[] createDelegationToFieldInitOfImplementedInterfaces(final N4ClassDeclaration classDecl, final FormalParameter specFpar) {
    final ArrayList<ExpressionStatement> result = CollectionLiterals.<ExpressionStatement>newArrayList();
    final SymbolTableEntryInternal $fieldInitSTE = this.steFor_$fieldInit();
    final Function1<SymbolTableEntryOriginal, Boolean> _function = (SymbolTableEntryOriginal it) -> {
      IdentifiableElement _originalTarget = it.getOriginalTarget();
      boolean _builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation = N4JSLanguageUtils.builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation(((TInterface) _originalTarget));
      return Boolean.valueOf((!_builtInOrProvidedByRuntimeOrExternalWithoutN4JSAnnotation));
    };
    final Iterable<SymbolTableEntryOriginal> implementedIfcSTEs = IterableExtensions.<SymbolTableEntryOriginal>filter(this.typeAssistant.getSuperInterfacesSTEs(classDecl), _function);
    final LinkedHashSet<String> ownedInstanceDataFieldsSupressMixin = CollectionLiterals.<String>newLinkedHashSet();
    final Function1<N4FieldDeclaration, Boolean> _function_1 = (N4FieldDeclaration it) -> {
      boolean _isConsumedFromInterface = this.isConsumedFromInterface(it);
      return Boolean.valueOf((!_isConsumedFromInterface));
    };
    final Function1<N4FieldDeclaration, String> _function_2 = (N4FieldDeclaration it) -> {
      return it.getName();
    };
    Iterables.<String>addAll(ownedInstanceDataFieldsSupressMixin, IterableExtensions.<N4FieldDeclaration, String>map(IterableExtensions.<N4FieldDeclaration>filter(classDecl.getOwnedFields(), _function_1), _function_2));
    final Function1<N4GetterDeclaration, Boolean> _function_3 = (N4GetterDeclaration it) -> {
      boolean _isConsumedFromInterface = this.isConsumedFromInterface(it);
      return Boolean.valueOf((!_isConsumedFromInterface));
    };
    final Function1<N4GetterDeclaration, String> _function_4 = (N4GetterDeclaration it) -> {
      return it.getName();
    };
    Iterables.<String>addAll(ownedInstanceDataFieldsSupressMixin, IterableExtensions.<N4GetterDeclaration, String>map(IterableExtensions.<N4GetterDeclaration>filter(classDecl.getOwnedGetters(), _function_3), _function_4));
    final Function1<N4SetterDeclaration, Boolean> _function_5 = (N4SetterDeclaration it) -> {
      boolean _isConsumedFromInterface = this.isConsumedFromInterface(it);
      return Boolean.valueOf((!_isConsumedFromInterface));
    };
    final Function1<N4SetterDeclaration, String> _function_6 = (N4SetterDeclaration it) -> {
      return it.getName();
    };
    Iterables.<String>addAll(ownedInstanceDataFieldsSupressMixin, IterableExtensions.<N4SetterDeclaration, String>map(IterableExtensions.<N4SetterDeclaration>filter(classDecl.getOwnedSetters(), _function_5), _function_6));
    SymbolTableEntry _xifexpression = null;
    if ((specFpar != null)) {
      _xifexpression = this.findSymbolTableEntryForElement(specFpar, false);
    }
    final SymbolTableEntry specFparSTE = _xifexpression;
    Function0<Expression> _xifexpression_1 = null;
    if ((specFpar == null)) {
      final Function0<Expression> _function_7 = () -> {
        return this.undefinedRef();
      };
      _xifexpression_1 = _function_7;
    } else {
      final Function0<Expression> _function_8 = () -> {
        return TranspilerBuilderBlocks._IdentRef(specFparSTE);
      };
      _xifexpression_1 = _function_8;
    }
    final Function0<? extends Expression> refTo_specFpar_or_undefined = _xifexpression_1;
    for (final SymbolTableEntryOriginal implementedIfcSTE : implementedIfcSTEs) {
      final Function1<String, PropertyNameValuePair> _function_9 = (String it) -> {
        return TranspilerBuilderBlocks._PropertyNameValuePair(it, this.undefinedRef());
      };
      ExpressionStatement __ExprStmnt = TranspilerBuilderBlocks._ExprStmnt(
        TranspilerBuilderBlocks._CallExpr(
          this.__NSSafe_PropertyAccessExpr(implementedIfcSTE, $fieldInitSTE, this.steFor_call()), 
          TranspilerBuilderBlocks._ThisLiteral(), 
          refTo_specFpar_or_undefined.apply(), 
          TranspilerBuilderBlocks._ObjLit(
            ((PropertyAssignment[])Conversions.unwrapArray(IterableExtensions.<String, PropertyNameValuePair>map(ownedInstanceDataFieldsSupressMixin, _function_9), PropertyAssignment.class)))));
      result.add(__ExprStmnt);
    }
    return ((Statement[])Conversions.unwrapArray(result, Statement.class));
  }
  
  private int getSuperCallIndex(final N4MethodDeclaration ownedCtor) {
    Block _body = null;
    if (ownedCtor!=null) {
      _body=ownedCtor.getBody();
    }
    EList<Statement> _statements = null;
    if (_body!=null) {
      _statements=_body.getStatements();
    }
    final EList<Statement> stmnts = _statements;
    if (((stmnts != null) && (!stmnts.isEmpty()))) {
      int _size = ownedCtor.getBody().getStatements().size();
      ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
      for (final Integer i : _doubleDotLessThan) {
        {
          final Statement stmnt = stmnts.get((i).intValue());
          if ((stmnt instanceof ExpressionStatement)) {
            final Expression expr = ((ExpressionStatement)stmnt).getExpression();
            if ((expr instanceof ParameterizedCallExpression)) {
              boolean _isExplicitSuperCall = this.getState().info.isExplicitSuperCall(((ParameterizedCallExpression)expr));
              if (_isExplicitSuperCall) {
                return (i).intValue();
              }
            }
          }
        }
      }
    }
    return (-1);
  }
  
  private TMethod getNearestConstructorInHierarchy(final N4ClassDeclaration classDecl) {
    final TClass tClass = this.getState().info.getOriginalDefinedType(classDecl);
    return this.getNearestConstructorInHierarchy(tClass);
  }
  
  private TMethod getNearestConstructorInHierarchy(final TClassifier clazz) {
    TMethod _xifexpression = null;
    if ((clazz instanceof TClass)) {
      _xifexpression = ((TClass)clazz).getOwnedCtor();
    } else {
      TMethod _xifexpression_1 = null;
      if ((clazz instanceof TObjectPrototype)) {
        _xifexpression_1 = ((TObjectPrototype)clazz).getOwnedCtor();
      }
      _xifexpression = _xifexpression_1;
    }
    final TMethod ownedCtor = _xifexpression;
    if ((ownedCtor != null)) {
      return ownedCtor;
    } else {
      Type _xifexpression_2 = null;
      if ((clazz instanceof TClass)) {
        ParameterizedTypeRef _superClassRef = ((TClass)clazz).getSuperClassRef();
        Type _declaredType = null;
        if (_superClassRef!=null) {
          _declaredType=_superClassRef.getDeclaredType();
        }
        _xifexpression_2 = _declaredType;
      } else {
        Type _xifexpression_3 = null;
        if ((clazz instanceof TObjectPrototype)) {
          ParameterizedTypeRef _superType = ((TObjectPrototype)clazz).getSuperType();
          Type _declaredType_1 = null;
          if (_superType!=null) {
            _declaredType_1=_superType.getDeclaredType();
          }
          _xifexpression_3 = _declaredType_1;
        }
        _xifexpression_2 = _xifexpression_3;
      }
      final Type superType = _xifexpression_2;
      if ((superType instanceof TClassifier)) {
        return this.getNearestConstructorInHierarchy(((TClassifier)superType));
      }
    }
    return null;
  }
  
  private boolean isConsumedFromInterface(final N4MemberDeclaration memberDecl) {
    return this.getState().info.isConsumedFromInterface(memberDecl);
  }
  
  private boolean isPublic(final N4MemberDeclaration memberDecl) {
    final MemberAccessModifier accessModifier = ModifierUtils.convertToMemberAccessModifier(memberDecl.getDeclaredModifiers(), 
      memberDecl.getAnnotations());
    return (accessModifier == MemberAccessModifier.PUBLIC);
  }
}
