/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.AdditiveOperator;
import org.eclipse.n4js.n4JS.AnnotableN4MemberDeclaration;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.AnnotationList;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.ArrayPadding;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AssignmentOperator;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalOperator;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.CommaExpression;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.EmptyStatement;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.EqualityOperator;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionAnnotationList;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.IntLiteral;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSFactory;
import org.eclipse.n4js.n4JS.N4MemberAnnotationList;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.NumericLiteral;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.RelationalOperator;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.ThrowStatement;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableDeclarationOrBinding;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.VariableStatementKeyword;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.ImFactory;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.ParameterizedTypeRef_IM;
import org.eclipse.n4js.transpiler.im.Snippet;
import org.eclipse.n4js.transpiler.im.StringLiteralForSTE;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Builder methods for intermediate elements.
 */
@SuppressWarnings("all")
public class TranspilerBuilderBlocks {
  public static ImportDeclaration _ImportDecl(final ImportSpecifier... importSpecifiers) {
    final ImportDeclaration result = N4JSFactory.eINSTANCE.createImportDeclaration();
    result.setModule(null);
    EList<ImportSpecifier> _importSpecifiers = result.getImportSpecifiers();
    Iterable<ImportSpecifier> _filterNull = IterableExtensions.<ImportSpecifier>filterNull(((Iterable<ImportSpecifier>)Conversions.doWrapArray(importSpecifiers)));
    Iterables.<ImportSpecifier>addAll(_importSpecifiers, _filterNull);
    int _length = importSpecifiers.length;
    boolean _greaterThan = (_length > 0);
    result.setImportFrom(_greaterThan);
    return result;
  }
  
  public static NamedImportSpecifier _NamedImportSpecifier(final String importedElementName, final String alias, final boolean usedInCode) {
    final NamedImportSpecifier result = N4JSFactory.eINSTANCE.createNamedImportSpecifier();
    result.setImportedElement(null);
    result.setImportedElementAsText(importedElementName);
    result.setAlias(alias);
    result.setFlaggedUsedInCode(usedInCode);
    return result;
  }
  
  public static NamespaceImportSpecifier _NamespaceImportSpecifier(final String namespaceName, final boolean usedInCode) {
    final NamespaceImportSpecifier result = N4JSFactory.eINSTANCE.createNamespaceImportSpecifier();
    result.setAlias(namespaceName);
    result.setFlaggedUsedInCode(usedInCode);
    return result;
  }
  
  public static VariableStatement _VariableStatement(final boolean exported, final VariableDeclaration... varDecls) {
    return TranspilerBuilderBlocks._VariableStatement(exported, VariableStatementKeyword.VAR, varDecls);
  }
  
  public static VariableStatement _VariableStatement(final boolean exported, final VariableStatementKeyword keyword, final VariableDeclaration... varDecls) {
    if (exported) {
      return TranspilerBuilderBlocks._ExportedVariableStatement(keyword, varDecls);
    } else {
      return TranspilerBuilderBlocks._VariableStatement(keyword, varDecls);
    }
  }
  
  public static VariableStatement _VariableStatement(final VariableDeclaration... varDecls) {
    return TranspilerBuilderBlocks._VariableStatement(VariableStatementKeyword.VAR, varDecls);
  }
  
  public static VariableStatement _VariableStatement(final VariableStatementKeyword keyword, final VariableDeclaration... varDecls) {
    final VariableStatement result = N4JSFactory.eINSTANCE.createVariableStatement();
    result.setVarStmtKeyword(keyword);
    EList<VariableDeclarationOrBinding> _varDeclsOrBindings = result.getVarDeclsOrBindings();
    Iterables.<VariableDeclarationOrBinding>addAll(_varDeclsOrBindings, ((Iterable<? extends VariableDeclarationOrBinding>)Conversions.doWrapArray(varDecls)));
    return result;
  }
  
  public static ExportedVariableStatement _ExportedVariableStatement(final VariableStatementKeyword keyword, final VariableDeclaration... varDecls) {
    final ExportedVariableStatement result = N4JSFactory.eINSTANCE.createExportedVariableStatement();
    result.setVarStmtKeyword(keyword);
    EList<VariableDeclarationOrBinding> _varDeclsOrBindings = result.getVarDeclsOrBindings();
    Iterable<VariableDeclarationOrBinding> _filterNull = IterableExtensions.<VariableDeclarationOrBinding>filterNull(((Iterable<VariableDeclarationOrBinding>)Conversions.doWrapArray(varDecls)));
    Iterables.<VariableDeclarationOrBinding>addAll(_varDeclsOrBindings, _filterNull);
    return result;
  }
  
  public static VariableDeclaration _VariableDeclaration(final String name) {
    final VariableDeclaration result = N4JSFactory.eINSTANCE.createVariableDeclaration();
    result.setName(name);
    return result;
  }
  
  public static VariableDeclaration _VariableDeclaration(final String name, final Expression exp) {
    final VariableDeclaration result = N4JSFactory.eINSTANCE.createVariableDeclaration();
    result.setName(name);
    result.setExpression(exp);
    return result;
  }
  
  public static ExportDeclaration _ExportDeclaration(final ExportableElement exported) {
    final ExportDeclaration result = N4JSFactory.eINSTANCE.createExportDeclaration();
    result.setExportedElement(exported);
    return result;
  }
  
  public static ReturnStatement _ReturnStmnt() {
    final ReturnStatement result = N4JSFactory.eINSTANCE.createReturnStatement();
    return result;
  }
  
  public static ReturnStatement _ReturnStmnt(final Expression expr) {
    final ReturnStatement result = N4JSFactory.eINSTANCE.createReturnStatement();
    result.setExpression(expr);
    return result;
  }
  
  public static IfStatement _IfStmnt(final Expression condition, final Statement ifStmnt) {
    return TranspilerBuilderBlocks._IfStmnt(condition, ifStmnt, null);
  }
  
  public static IfStatement _IfStmnt(final Expression condition, final Statement ifStmnt, final Statement elseStmnt) {
    final IfStatement result = N4JSFactory.eINSTANCE.createIfStatement();
    result.setExpression(condition);
    result.setIfStmt(ifStmnt);
    result.setElseStmt(elseStmnt);
    return result;
  }
  
  public static ThrowStatement _ThrowStmnt(final Expression expression) {
    final ThrowStatement result = N4JSFactory.eINSTANCE.createThrowStatement();
    result.setExpression(expression);
    return result;
  }
  
  public static ConditionalExpression _ConditionalExpr(final Expression condition, final Expression trueExpr, final Expression falseExpr) {
    final ConditionalExpression result = N4JSFactory.eINSTANCE.createConditionalExpression();
    result.setExpression(condition);
    result.setTrueExpression(trueExpr);
    result.setFalseExpression(falseExpr);
    return result;
  }
  
  public static YieldExpression _YieldExpr(final Expression expr) {
    final YieldExpression result = N4JSFactory.eINSTANCE.createYieldExpression();
    result.setExpression(expr);
    return result;
  }
  
  public static ParameterizedCallExpression _CallExpr() {
    final ParameterizedCallExpression result = N4JSFactory.eINSTANCE.createParameterizedCallExpression();
    return result;
  }
  
  public static ParameterizedCallExpression _CallExpr(final Expression target, final Expression... arguments) {
    final ParameterizedCallExpression result = N4JSFactory.eINSTANCE.createParameterizedCallExpression();
    result.setTarget(target);
    EList<Argument> _arguments = result.getArguments();
    final Function1<Expression, Argument> _function = (Expression it) -> {
      return TranspilerBuilderBlocks._Argument(it);
    };
    Iterable<Argument> _map = IterableExtensions.<Expression, Argument>map(IterableExtensions.<Expression>filterNull(((Iterable<Expression>)Conversions.doWrapArray(arguments))), _function);
    Iterables.<Argument>addAll(_arguments, _map);
    return result;
  }
  
  public static Argument _Argument(final Expression expression) {
    return TranspilerBuilderBlocks._Argument(false, expression);
  }
  
  public static Argument _Argument(final boolean spread, final Expression expression) {
    final Argument result = N4JSFactory.eINSTANCE.createArgument();
    result.setSpread(spread);
    result.setExpression(expression);
    return result;
  }
  
  public static ExpressionStatement _ExprStmnt(final Expression expr) {
    final ExpressionStatement result = N4JSFactory.eINSTANCE.createExpressionStatement();
    result.setExpression(expr);
    return result;
  }
  
  public static AssignmentExpression _AssignmentExpr() {
    final AssignmentExpression result = N4JSFactory.eINSTANCE.createAssignmentExpression();
    result.setOp(AssignmentOperator.ASSIGN);
    return result;
  }
  
  public static AssignmentExpression _AssignmentExpr(final Expression lhs, final Expression rhs) {
    final AssignmentExpression result = N4JSFactory.eINSTANCE.createAssignmentExpression();
    result.setLhs(lhs);
    result.setOp(AssignmentOperator.ASSIGN);
    result.setRhs(rhs);
    return result;
  }
  
  public static ParameterizedPropertyAccessExpression_IM _PropertyAccessExpr() {
    final ParameterizedPropertyAccessExpression_IM result = ImFactory.eINSTANCE.createParameterizedPropertyAccessExpression_IM();
    return result;
  }
  
  public static ParameterizedPropertyAccessExpression_IM _PropertyAccessExpr(final SymbolTableEntry target, final SymbolTableEntry... properties) {
    return TranspilerBuilderBlocks._PropertyAccessExpr(TranspilerBuilderBlocks._IdentRef(target), properties);
  }
  
  public static ParameterizedPropertyAccessExpression_IM _PropertyAccessExpr(final Expression target, final SymbolTableEntry... properties) {
    if (((properties == null) || IterableExtensions.<SymbolTableEntry>exists(((Iterable<SymbolTableEntry>)Conversions.doWrapArray(properties)), ((Function1<SymbolTableEntry, Boolean>) (SymbolTableEntry it) -> {
      return Boolean.valueOf((it == null));
    })))) {
      throw new IllegalArgumentException("none of the properties may be null");
    }
    ParameterizedPropertyAccessExpression_IM result = ImFactory.eINSTANCE.createParameterizedPropertyAccessExpression_IM();
    result.setTarget(target);
    int _length = properties.length;
    boolean _greaterThan = (_length > 0);
    if (_greaterThan) {
      result.setRewiredTarget(properties[0]);
      int _length_1 = properties.length;
      ExclusiveRange _doubleDotLessThan = new ExclusiveRange(1, _length_1, true);
      for (final Integer idx : _doubleDotLessThan) {
        {
          final ParameterizedPropertyAccessExpression_IM newResult = ImFactory.eINSTANCE.createParameterizedPropertyAccessExpression_IM();
          newResult.setTarget(result);
          newResult.setRewiredTarget(properties[(idx).intValue()]);
          result = newResult;
        }
      }
    }
    return result;
  }
  
  public static IndexedAccessExpression _IndexAccessExpr() {
    return TranspilerBuilderBlocks._IndexAccessExpr(((Expression) null), null);
  }
  
  public static IndexedAccessExpression _IndexAccessExpr(final SymbolTableEntry target, final Expression index) {
    return TranspilerBuilderBlocks._IndexAccessExpr(TranspilerBuilderBlocks._IdentRef(target), index);
  }
  
  public static IndexedAccessExpression _IndexAccessExpr(final Expression target, final Expression index) {
    final IndexedAccessExpression result = N4JSFactory.eINSTANCE.createIndexedAccessExpression();
    result.setTarget(target);
    result.setIndex(index);
    return result;
  }
  
  public static NewExpression _NewExpr(final Expression callee, final Expression... arguments) {
    final NewExpression result = N4JSFactory.eINSTANCE.createNewExpression();
    result.setCallee(callee);
    boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.<Expression>filterNull(((Iterable<Expression>)Conversions.doWrapArray(arguments))));
    boolean _not = (!_isEmpty);
    result.setWithArgs(_not);
    EList<Argument> _arguments = result.getArguments();
    final Function1<Expression, Argument> _function = (Expression it) -> {
      return TranspilerBuilderBlocks._Argument(it);
    };
    Iterable<Argument> _map = IterableExtensions.<Expression, Argument>map(IterableExtensions.<Expression>filterNull(((Iterable<Expression>)Conversions.doWrapArray(arguments))), _function);
    Iterables.<Argument>addAll(_arguments, _map);
    return result;
  }
  
  public static RelationalExpression _RelationalExpr(final Expression lhs, final RelationalOperator op, final Expression rhs) {
    final RelationalExpression result = N4JSFactory.eINSTANCE.createRelationalExpression();
    result.setLhs(lhs);
    result.setOp(op);
    result.setRhs(rhs);
    return result;
  }
  
  public static EqualityExpression _EqualityExpr(final Expression lhs, final EqualityOperator op, final Expression rhs) {
    final EqualityExpression result = N4JSFactory.eINSTANCE.createEqualityExpression();
    result.setLhs(lhs);
    result.setOp(op);
    result.setRhs(rhs);
    return result;
  }
  
  public static UnaryExpression _NOT(final Expression expr) {
    return TranspilerBuilderBlocks._UnaryExpr(UnaryOperator.NOT, expr);
  }
  
  public static BinaryLogicalExpression _OR(final Expression lhs, final Expression rhs) {
    return TranspilerBuilderBlocks._BinaryLogicalExpr(lhs, BinaryLogicalOperator.OR, rhs);
  }
  
  public static BinaryLogicalExpression _AND(final Expression lhs, final Expression rhs) {
    return TranspilerBuilderBlocks._BinaryLogicalExpr(lhs, BinaryLogicalOperator.AND, rhs);
  }
  
  public static Expression _AND(final Iterable<Expression> operands) {
    final Function2<Expression, Expression, Expression> _function = (Expression op1, Expression op2) -> {
      return TranspilerBuilderBlocks._AND(op1, op2);
    };
    return IterableExtensions.<Expression>reduce(operands, _function);
  }
  
  public static UnaryExpression _UnaryExpr(final UnaryOperator op, final Expression expr) {
    final UnaryExpression result = N4JSFactory.eINSTANCE.createUnaryExpression();
    result.setOp(op);
    result.setExpression(expr);
    return result;
  }
  
  public static BinaryLogicalExpression _BinaryLogicalExpr(final Expression lhs, final BinaryLogicalOperator op, final Expression rhs) {
    final BinaryLogicalExpression result = N4JSFactory.eINSTANCE.createBinaryLogicalExpression();
    result.setLhs(lhs);
    result.setOp(op);
    result.setRhs(rhs);
    return result;
  }
  
  public static CommaExpression _CommaExpression(final Expression... expressions) {
    final CommaExpression result = N4JSFactory.eINSTANCE.createCommaExpression();
    EList<Expression> _exprs = result.getExprs();
    Iterables.<Expression>addAll(_exprs, ((Iterable<? extends Expression>)Conversions.doWrapArray(expressions)));
    return result;
  }
  
  public static AdditiveExpression _AdditiveExpression(final Expression lhs, final AdditiveOperator op, final Expression rhs) {
    final AdditiveExpression result = N4JSFactory.eINSTANCE.createAdditiveExpression();
    result.setLhs(lhs);
    result.setOp(op);
    result.setRhs(rhs);
    return result;
  }
  
  public static AdditiveExpression _AdditiveExpression(final AdditiveOperator op, final Expression... operands) {
    if (((operands == null) || IterableExtensions.<Expression>exists(((Iterable<Expression>)Conversions.doWrapArray(operands)), ((Function1<Expression, Boolean>) (Expression it) -> {
      return Boolean.valueOf((it == null));
    })))) {
      throw new IllegalArgumentException("none of the operands may be null");
    }
    int _size = ((List<Expression>)Conversions.doWrapArray(operands)).size();
    boolean _lessThan = (_size < 2);
    if (_lessThan) {
      throw new IllegalArgumentException("need at least two operands");
    }
    AdditiveExpression result = N4JSFactory.eINSTANCE.createAdditiveExpression();
    result.setLhs(operands[0]);
    result.setOp(op);
    result.setRhs(operands[1]);
    int _length = operands.length;
    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(2, _length, true);
    for (final Integer idx : _doubleDotLessThan) {
      {
        final AdditiveExpression newResult = N4JSFactory.eINSTANCE.createAdditiveExpression();
        newResult.setLhs(result);
        newResult.setOp(op);
        newResult.setRhs(operands[(idx).intValue()]);
        result = newResult;
      }
    }
    return result;
  }
  
  public static ObjectLiteral _ObjLit() {
    return TranspilerBuilderBlocks._ObjLit(((PropertyAssignment[]) null));
  }
  
  /**
   * Convenience method for creating object literals that only contain {@link PropertyNameValuePair}s.
   * It is legal to pass in one or more <code>null</code> values (they will be ignored).
   */
  public static ObjectLiteral _ObjLit(final Pair<String, Expression>... nameValuePairs) {
    final Function1<Pair<String, Expression>, PropertyNameValuePair> _function = (Pair<String, Expression> it) -> {
      return TranspilerBuilderBlocks._PropertyNameValuePair(it.getKey(), it.getValue());
    };
    return TranspilerBuilderBlocks._ObjLit(((PropertyAssignment[])Conversions.unwrapArray(IterableExtensions.<Pair<String, Expression>, PropertyNameValuePair>map(IterableExtensions.<Pair<String, Expression>>filterNull(((Iterable<Pair<String, Expression>>)Conversions.doWrapArray(nameValuePairs))), _function), PropertyAssignment.class)));
  }
  
  public static ObjectLiteral _ObjLit(final PropertyAssignment... pas) {
    final ObjectLiteral result = N4JSFactory.eINSTANCE.createObjectLiteral();
    if ((pas != null)) {
      EList<PropertyAssignment> _propertyAssignments = result.getPropertyAssignments();
      Iterable<PropertyAssignment> _filterNull = IterableExtensions.<PropertyAssignment>filterNull(((Iterable<PropertyAssignment>)Conversions.doWrapArray(pas)));
      Iterables.<PropertyAssignment>addAll(_propertyAssignments, _filterNull);
    }
    return result;
  }
  
  public static PropertyNameValuePair _PropertyNameValuePair(final String name, final Expression value) {
    final PropertyNameValuePair result = N4JSFactory.eINSTANCE.createPropertyNameValuePair();
    result.setDeclaredName(TranspilerBuilderBlocks._LiteralOrComputedPropertyName(name));
    result.setExpression(value);
    return result;
  }
  
  public static ArrayLiteral _ArrLit() {
    return TranspilerBuilderBlocks._ArrLit(((ArrayElement[]) null));
  }
  
  public static ArrayLiteral _ArrLit(final Expression... elements) {
    final Function1<Expression, ArrayElement> _function = (Expression it) -> {
      return TranspilerBuilderBlocks._ArrayElement(it);
    };
    return TranspilerBuilderBlocks._ArrLit(((ArrayElement[])Conversions.unwrapArray(IterableExtensions.<Expression, ArrayElement>map(IterableExtensions.<Expression>filterNull(((Iterable<Expression>)Conversions.doWrapArray(elements))), _function), ArrayElement.class)));
  }
  
  public static ArrayLiteral _ArrLit(final ArrayElement... elements) {
    final ArrayLiteral result = N4JSFactory.eINSTANCE.createArrayLiteral();
    if ((elements != null)) {
      EList<ArrayElement> _elements = result.getElements();
      Iterable<ArrayElement> _filterNull = IterableExtensions.<ArrayElement>filterNull(((Iterable<ArrayElement>)Conversions.doWrapArray(elements)));
      Iterables.<ArrayElement>addAll(_elements, _filterNull);
    }
    return result;
  }
  
  public static ArrayElement _ArrayElement(final Expression expression) {
    return TranspilerBuilderBlocks._ArrayElement(false, expression);
  }
  
  public static ArrayElement _ArrayElement(final boolean spread, final Expression expression) {
    final ArrayElement result = N4JSFactory.eINSTANCE.createArrayElement();
    result.setSpread(spread);
    result.setExpression(expression);
    return result;
  }
  
  public static ArrayPadding _ArrayPadding() {
    final ArrayPadding result = N4JSFactory.eINSTANCE.createArrayPadding();
    return result;
  }
  
  public static FunctionDeclaration _FunDecl(final String name, final Statement... statements) {
    return TranspilerBuilderBlocks._FunDecl(name, new FormalParameter[] {}, statements);
  }
  
  public static FunctionDeclaration _FunDecl(final String name, final FormalParameter[] fpars, final Statement... statements) {
    final FunctionDeclaration result = N4JSFactory.eINSTANCE.createFunctionDeclaration();
    result.setName(name);
    EList<FormalParameter> _fpars = result.getFpars();
    Iterables.<FormalParameter>addAll(_fpars, ((Iterable<? extends FormalParameter>)Conversions.doWrapArray(fpars)));
    result.setBody(TranspilerBuilderBlocks._Block(statements));
    return result;
  }
  
  public static FunctionExpression _FunExpr(final boolean async, final Statement... statements) {
    return TranspilerBuilderBlocks._FunExpr(async, null, new FormalParameter[] {}, statements);
  }
  
  public static FunctionExpression _FunExpr(final boolean async, final String name, final Statement... statements) {
    return TranspilerBuilderBlocks._FunExpr(async, name, new FormalParameter[] {}, statements);
  }
  
  public static FunctionExpression _FunExpr(final boolean async, final String name, final FormalParameter... formalParams) {
    return TranspilerBuilderBlocks._FunExpr(async, name, formalParams, new Statement[] {});
  }
  
  public static FunctionExpression _FunExpr(final boolean async, final String name, final FormalParameter[] fpars, final Statement... statements) {
    if ((((statements != null) && (statements.length == 1)) && (statements[0] instanceof Block))) {
      Statement _get = statements[0];
      return TranspilerBuilderBlocks._FunExprWithBlock(async, name, fpars, ((Block) _get));
    }
    final FunctionExpression result = N4JSFactory.eINSTANCE.createFunctionExpression();
    result.setDeclaredAsync(async);
    result.setName(name);
    EList<FormalParameter> _fpars = result.getFpars();
    Iterables.<FormalParameter>addAll(_fpars, ((Iterable<? extends FormalParameter>)Conversions.doWrapArray(fpars)));
    result.setBody(TranspilerBuilderBlocks._Block(statements));
    return result;
  }
  
  public static FormalParameter _FormalParameter(final String name) {
    final FormalParameter result = N4JSFactory.eINSTANCE.createFormalParameter();
    result.setName(name);
    return result;
  }
  
  public static FunctionExpression _FunExpr(final boolean async, final String name, final FormalParameter[] fpars, final Block block) {
    return TranspilerBuilderBlocks._FunExprWithBlock(async, name, fpars, block);
  }
  
  private static FunctionExpression _FunExprWithBlock(final boolean async, final String name, final FormalParameter[] fpars, final Block block) {
    final FunctionExpression result = N4JSFactory.eINSTANCE.createFunctionExpression();
    result.setDeclaredAsync(async);
    result.setName(name);
    EList<FormalParameter> _fpars = result.getFpars();
    Iterables.<FormalParameter>addAll(_fpars, ((Iterable<? extends FormalParameter>)Conversions.doWrapArray(fpars)));
    result.setBody(block);
    return result;
  }
  
  public static N4MemberDeclaration _N4MemberDecl(final TMember template, final Statement... statements) {
    if (((template instanceof TField) && (!((List<Statement>)Conversions.doWrapArray(statements)).isEmpty()))) {
      throw new IllegalArgumentException("fields cannot have statements");
    }
    EObject _switchResult = null;
    boolean _matched = false;
    if (template instanceof TField) {
      _matched=true;
      _switchResult = N4JSFactory.eINSTANCE.createN4FieldDeclaration();
    }
    if (!_matched) {
      if (template instanceof TGetter) {
        _matched=true;
        _switchResult = N4JSFactory.eINSTANCE.createN4GetterDeclaration();
      }
    }
    if (!_matched) {
      if (template instanceof TSetter) {
        _matched=true;
        _switchResult = N4JSFactory.eINSTANCE.createN4SetterDeclaration();
      }
    }
    if (!_matched) {
      if (template instanceof TMethod) {
        _matched=true;
        _switchResult = N4JSFactory.eINSTANCE.createN4MethodDeclaration();
      }
    }
    if (!_matched) {
      String _name = template.eClass().getName();
      String _plus = ("unsupported subtype of TMember: " + _name);
      throw new IllegalArgumentException(_plus);
    }
    final EObject result = ((EObject)_switchResult);
    ((PropertyNameOwner)result).setDeclaredName(TranspilerBuilderBlocks._LiteralOrComputedPropertyName(template.getName()));
    if ((result instanceof FunctionOrFieldAccessor)) {
      ((FunctionOrFieldAccessor)result).setBody(TranspilerBuilderBlocks._Block(((Statement[])Conversions.unwrapArray(IterableExtensions.<Statement>filterNull(((Iterable<Statement>)Conversions.doWrapArray(statements))), Statement.class))));
    }
    if ((template instanceof TSetter)) {
      String _elvis = null;
      TFormalParameter _fpar = ((TSetter)template).getFpar();
      String _name_1 = null;
      if (_fpar!=null) {
        _name_1=_fpar.getName();
      }
      if (_name_1 != null) {
        _elvis = _name_1;
      } else {
        _elvis = "value";
      }
      final String fparName = _elvis;
      ((N4SetterDeclaration) result).setFpar(TranspilerBuilderBlocks._Fpar(fparName));
    }
    if ((template instanceof TMethod)) {
      EList<FormalParameter> _fpars = ((N4MethodDeclaration) result).getFpars();
      final Function1<TFormalParameter, FormalParameter> _function = (TFormalParameter it) -> {
        return TranspilerBuilderBlocks._Fpar(it.getName());
      };
      List<FormalParameter> _map = ListExtensions.<TFormalParameter, FormalParameter>map(((TMethod)template).getFpars(), _function);
      Iterables.<FormalParameter>addAll(_fpars, _map);
      ((N4MethodDeclaration) result).setDeclaredAsync(((TMethod)template).isDeclaredAsync());
    }
    boolean _isStatic = template.isStatic();
    if (_isStatic) {
      EList<N4Modifier> _declaredModifiers = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
      _declaredModifiers.add(N4Modifier.STATIC);
    }
    MemberAccessModifier _memberAccessModifier = template.getMemberAccessModifier();
    if (_memberAccessModifier != null) {
      switch (_memberAccessModifier) {
        case PUBLIC:
          EList<N4Modifier> _declaredModifiers_1 = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
          _declaredModifiers_1.add(N4Modifier.PUBLIC);
          break;
        case PUBLIC_INTERNAL:
          EList<N4Modifier> _declaredModifiers_2 = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
          _declaredModifiers_2.add(N4Modifier.PUBLIC);
          EList<Annotation> _annotations = TranspilerBuilderBlocks.getOrCreateMemberAnnotationList(((AnnotableN4MemberDeclaration)result)).getAnnotations();
          Annotation __Annotation = TranspilerBuilderBlocks._Annotation(AnnotationDefinition.INTERNAL);
          _annotations.add(__Annotation);
          break;
        case PROTECTED:
          EList<N4Modifier> _declaredModifiers_3 = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
          _declaredModifiers_3.add(N4Modifier.PROTECTED);
          break;
        case PROTECTED_INTERNAL:
          EList<N4Modifier> _declaredModifiers_4 = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
          _declaredModifiers_4.add(N4Modifier.PROTECTED);
          EList<Annotation> _annotations_1 = TranspilerBuilderBlocks.getOrCreateMemberAnnotationList(((AnnotableN4MemberDeclaration)result)).getAnnotations();
          Annotation __Annotation_1 = TranspilerBuilderBlocks._Annotation(AnnotationDefinition.INTERNAL);
          _annotations_1.add(__Annotation_1);
          break;
        case PROJECT:
          EList<N4Modifier> _declaredModifiers_5 = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
          _declaredModifiers_5.add(N4Modifier.PROJECT);
          break;
        case PRIVATE:
          EList<N4Modifier> _declaredModifiers_6 = ((AnnotableN4MemberDeclaration)result).getDeclaredModifiers();
          _declaredModifiers_6.add(N4Modifier.PRIVATE);
          break;
        case UNDEFINED:
          break;
        default:
          break;
      }
    }
    return ((AnnotableN4MemberDeclaration)result);
  }
  
  private static N4MemberAnnotationList getOrCreateMemberAnnotationList(final AnnotableN4MemberDeclaration memberDecl) {
    N4MemberAnnotationList annList = memberDecl.getAnnotationList();
    if ((annList == null)) {
      annList = N4JSFactory.eINSTANCE.createN4MemberAnnotationList();
      memberDecl.setAnnotationList(annList);
    }
    return annList;
  }
  
  public static N4MethodDeclaration _N4MethodDecl(final String name, final Statement... statements) {
    final N4MethodDeclaration result = N4JSFactory.eINSTANCE.createN4MethodDeclaration();
    result.setDeclaredName(TranspilerBuilderBlocks._LiteralOrComputedPropertyName(name));
    result.setBody(TranspilerBuilderBlocks._Block(((Statement[])Conversions.unwrapArray(IterableExtensions.<Statement>filterNull(((Iterable<Statement>)Conversions.doWrapArray(statements))), Statement.class))));
    return result;
  }
  
  public static FormalParameter _Fpar() {
    return TranspilerBuilderBlocks._Fpar(null, false, null, false);
  }
  
  public static FormalParameter _Fpar(final String name) {
    return TranspilerBuilderBlocks._Fpar(name, false, null, false);
  }
  
  public static FormalParameter _Fpar(final String name, final boolean variadic) {
    return TranspilerBuilderBlocks._Fpar(name, variadic, null, false);
  }
  
  public static FormalParameter _Fpar(final String name, final boolean variadic, final TypeRef typeRef, final boolean isSpecFpar) {
    final FormalParameter result = N4JSFactory.eINSTANCE.createFormalParameter();
    result.setName(name);
    result.setVariadic(variadic);
    result.setDeclaredTypeRef(TypeUtils.<TypeRef>copy(typeRef));
    if (isSpecFpar) {
      EList<Annotation> _annotations = result.getAnnotations();
      Annotation __Annotation = TranspilerBuilderBlocks._Annotation(AnnotationDefinition.SPEC);
      _annotations.add(__Annotation);
    }
    return result;
  }
  
  public static Annotation _Annotation(final AnnotationDefinition annDef) {
    final Annotation result = N4JSFactory.eINSTANCE.createAnnotation();
    result.setName(annDef.name);
    return result;
  }
  
  public static AnnotationList _AnnotationList(final List<AnnotationDefinition> annDef) {
    final AnnotationList result = N4JSFactory.eINSTANCE.createAnnotationList();
    if ((annDef != null)) {
      EList<Annotation> _annotations = result.getAnnotations();
      final Function1<AnnotationDefinition, Annotation> _function = (AnnotationDefinition it) -> {
        return TranspilerBuilderBlocks._Annotation(it);
      };
      List<Annotation> _map = ListExtensions.<AnnotationDefinition, Annotation>map(annDef, _function);
      Iterables.<Annotation>addAll(_annotations, _map);
    }
    return result;
  }
  
  public static ExpressionAnnotationList _ExprAnnoList(final Annotation[] annotations) {
    final ExpressionAnnotationList result = N4JSFactory.eINSTANCE.createExpressionAnnotationList();
    EList<Annotation> _annotations = result.getAnnotations();
    Iterables.<Annotation>addAll(_annotations, ((Iterable<? extends Annotation>)Conversions.doWrapArray(annotations)));
    return result;
  }
  
  public static Block _Block(final Statement... statements) {
    final Block result = N4JSFactory.eINSTANCE.createBlock();
    EList<Statement> _statements = result.getStatements();
    Iterable<Statement> _filterNull = IterableExtensions.<Statement>filterNull(((Iterable<Statement>)Conversions.doWrapArray(statements)));
    Iterables.<Statement>addAll(_statements, _filterNull);
    return result;
  }
  
  public static ParenExpression _Parenthesis(final Expression expr) {
    final ParenExpression result = N4JSFactory.eINSTANCE.createParenExpression();
    result.setExpression(expr);
    return result;
  }
  
  public static NullLiteral _NULL() {
    return N4JSFactory.eINSTANCE.createNullLiteral();
  }
  
  public static BooleanLiteral _TRUE() {
    return TranspilerBuilderBlocks._BooleanLiteral(true);
  }
  
  public static BooleanLiteral _FALSE() {
    return TranspilerBuilderBlocks._BooleanLiteral(false);
  }
  
  public static BooleanLiteral _BooleanLiteral(final boolean value) {
    final BooleanLiteral result = N4JSFactory.eINSTANCE.createBooleanLiteral();
    result.setTrue(value);
    return result;
  }
  
  public static NumericLiteral _NumericLiteral(final int num) {
    final NumericLiteral result = N4JSFactory.eINSTANCE.createNumericLiteral();
    result.setValue(BigDecimal.valueOf(num));
    return result;
  }
  
  public static StringLiteral _StringLiteral(final String s, final String rawValue) {
    final StringLiteral result = TranspilerBuilderBlocks._StringLiteral(s);
    result.setRawValue(rawValue);
    return result;
  }
  
  public static StringLiteral _StringLiteral(final String s) {
    final StringLiteral result = N4JSFactory.eINSTANCE.createStringLiteral();
    result.setValue(s);
    return result;
  }
  
  public static StringLiteral _StringLiteralForSTE(final SymbolTableEntry symbolTableEntry) {
    return TranspilerBuilderBlocks._StringLiteralForSTE(symbolTableEntry, false);
  }
  
  public static StringLiteral _StringLiteralForSTE(final SymbolTableEntry symbolTableEntry, final boolean useExportedName) {
    final StringLiteralForSTE result = ImFactory.eINSTANCE.createStringLiteralForSTE();
    result.setEntry(symbolTableEntry);
    result.setUseExportedName(useExportedName);
    return result;
  }
  
  public static IntLiteral _IntLiteral(final int i) {
    final IntLiteral result = N4JSFactory.eINSTANCE.createIntLiteral();
    result.setValue(BigDecimal.valueOf(i));
    return result;
  }
  
  public static ThisLiteral _ThisLiteral() {
    final ThisLiteral result = N4JSFactory.eINSTANCE.createThisLiteral();
    return result;
  }
  
  public static SuperLiteral _SuperLiteral() {
    final SuperLiteral result = N4JSFactory.eINSTANCE.createSuperLiteral();
    return result;
  }
  
  public static EmptyStatement _emptyStatement() {
    return N4JSFactory.eINSTANCE.createEmptyStatement();
  }
  
  /**
   * generic export where the {@code steExportedElement} is exported under its name.
   */
  public static ParameterizedCallExpression _N4ExportExpr(final SymbolTableEntry steExportedElement, final SymbolTableEntry symbolFor_n4Export) {
    return TranspilerBuilderBlocks._N4ExportExpr(steExportedElement, TranspilerBuilderBlocks._IdentRef(steExportedElement), symbolFor_n4Export);
  }
  
  /**
   * export of {@code expression}-to-be-evaluated under the name of {@code steExportedElement}
   */
  public static ParameterizedCallExpression _N4ExportExpr(final SymbolTableEntry steExportedElement, final Expression expression, final SymbolTableEntry symbolFor_n4Export) {
    ParameterizedCallExpression __CallExpr = TranspilerBuilderBlocks._CallExpr();
    final Procedure1<ParameterizedCallExpression> _function = (ParameterizedCallExpression it) -> {
      it.setTarget(TranspilerBuilderBlocks._IdentRef(symbolFor_n4Export));
      EList<Argument> _arguments = it.getArguments();
      Argument __Argument = TranspilerBuilderBlocks._Argument(TranspilerBuilderBlocks._StringLiteralForSTE(steExportedElement, true));
      _arguments.add(__Argument);
      EList<Argument> _arguments_1 = it.getArguments();
      Argument __Argument_1 = TranspilerBuilderBlocks._Argument(expression);
      _arguments_1.add(__Argument_1);
    };
    return ObjectExtensions.<ParameterizedCallExpression>operator_doubleArrow(__CallExpr, _function);
  }
  
  public static N4EnumDeclaration _EnumDeclaration(final String name, final List<N4EnumLiteral> literals) {
    final N4EnumDeclaration result = N4JSFactory.eINSTANCE.createN4EnumDeclaration();
    result.setName(name);
    EList<N4EnumLiteral> _literals = result.getLiterals();
    Iterables.<N4EnumLiteral>addAll(_literals, literals);
    return result;
  }
  
  public static N4EnumLiteral _EnumLiteral(final String name, final String value) {
    final N4EnumLiteral result = N4JSFactory.eINSTANCE.createN4EnumLiteral();
    result.setName(name);
    result.setValue(value);
    return result;
  }
  
  public static N4ClassDeclaration _N4ClassDeclaration(final String name) {
    final N4ClassDeclaration result = N4JSFactory.eINSTANCE.createN4ClassDeclaration();
    result.setName(name);
    return result;
  }
  
  public static N4InterfaceDeclaration _N4InterfaceDeclaration(final String name) {
    final N4InterfaceDeclaration result = N4JSFactory.eINSTANCE.createN4InterfaceDeclaration();
    result.setName(name);
    return result;
  }
  
  public static LiteralOrComputedPropertyName _LiteralOrComputedPropertyName(final String name) {
    final LiteralOrComputedPropertyName result = N4JSFactory.eINSTANCE.createLiteralOrComputedPropertyName();
    result.setLiteralName(name);
    return result;
  }
  
  public static IdentifierRef_IM _IdentRef(final SymbolTableEntry symbolTableEntry) {
    if ((symbolTableEntry == null)) {
      throw new IllegalArgumentException("when creating an IdentifierRef_IM: symbol table entry may not be null");
    }
    final IdentifierRef_IM result = ImFactory.eINSTANCE.createIdentifierRef_IM();
    result.setRewiredTarget(symbolTableEntry);
    return result;
  }
  
  public static ParameterizedTypeRef_IM _ParameterizedTypeRef(final SymbolTableEntry symbolTableEntry) {
    if ((symbolTableEntry == null)) {
      throw new IllegalArgumentException("when creating an ParameterizedTypeRef_IM: symbol table entry may not be null");
    }
    final ParameterizedTypeRef_IM result = ImFactory.eINSTANCE.createParameterizedTypeRef_IM();
    result.setRewiredTarget(symbolTableEntry);
    return result;
  }
  
  public static SymbolTableEntry _SymbolTableEntry(final String name) {
    throw new UnsupportedOperationException("do not manually create symbol table entries; use methods #createSymbolTableEntry() or #getSymbolTableEntry() instead");
  }
  
  public static ExpressionStatement _SnippetAsStmnt(final String code) {
    return TranspilerBuilderBlocks._ExprStmnt(TranspilerBuilderBlocks._Snippet(code));
  }
  
  public static Snippet _Snippet(final String code) {
    final Snippet result = ImFactory.eINSTANCE.createSnippet();
    result.setCode(code);
    return result;
  }
}
