/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.navigator.internal.DropDownAction;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SelectWorkingSetDropDownAction
extends DropDownAction {
    @Inject
    private WorkingSetManagerBroker workingSetManagerBroker;

    public SelectWorkingSetDropDownAction() {
        super((ImageDescriptor)ImageDescriptorCache.ImageRef.WORKING_SET.asImageDescriptor().orNull());
        this.setToolTipText("Select Active Working Set Manager");
    }

    @Override
    protected void createMenuItems(Menu parent) {
        Collection<WorkingSetManager> managers = this.workingSetManagerBroker.getWorkingSetManagers();
        for (final WorkingSetManager manager : managers) {
            MenuItem item = new MenuItem(parent, 32);
            item.setText(manager.getLabel());
            item.setImage((Image)manager.getImage().orNull());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectWorkingSetDropDownAction.this.workingSetManagerBroker.setActiveManager(manager);
                }
            });
            item.setSelection(this.workingSetManagerBroker.isActiveManager(manager));
        }
        final WorkingSetManager activeManager = this.workingSetManagerBroker.getActiveManager();
        if (activeManager != null) {
            this.createSeparator(parent);
            MenuItem item = new MenuItem(parent, 32);
            item.setText("Configure " + activeManager.getLabel() + "...");
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    activeManager.configure();
                    SelectWorkingSetDropDownAction.this.workingSetManagerBroker.refreshNavigator();
                }
            });
        }
    }
}

