/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods.scoping;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.scoping.utils.UnresolvableObjectDescription;
import org.eclipse.n4js.xpect.methods.scoping.EObjectDescriptionToNameWithPositionMapper;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

class IsInScopeWithOptionalPositionPredicate
implements Predicate<String> {
    private final IQualifiedNameConverter converter;
    private final IScope scope;
    private final URI currentURI;
    private final boolean withLineNumber;

    public IsInScopeWithOptionalPositionPredicate(IQualifiedNameConverter converter, URI currentURI, boolean withLineNumber, IScope scope) {
        this.converter = converter;
        this.scope = scope;
        this.currentURI = currentURI;
        this.withLineNumber = withLineNumber;
    }

    public boolean apply(String nameWithPosition) {
        String name = EObjectDescriptionToNameWithPositionMapper.getNameFromNameWithPosition(nameWithPosition);
        String position = EObjectDescriptionToNameWithPositionMapper.getPositionFromNameWithPosition(nameWithPosition);
        QualifiedName qualifiedName = this.converter.toQualifiedName(name);
        IEObjectDescription desc = this.scope.getSingleElement(qualifiedName);
        if (desc != null && !(desc instanceof IEObjectDescriptionWithError) && !(desc instanceof UnresolvableObjectDescription)) {
            if (!Strings.isNullOrEmpty((String)position)) {
                String nameWithPositionOfScopeELement = EObjectDescriptionToNameWithPositionMapper.descriptionToNameWithPosition(this.currentURI, this.withLineNumber, desc);
                String positionOfScopeElement = EObjectDescriptionToNameWithPositionMapper.getPositionFromNameWithPosition(nameWithPositionOfScopeELement);
                if (position.equals(positionOfScopeElement)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

