/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.projectModel.IN4JSProject;

public class N4JSExternalProject
extends ExternalProject {
    public static final String NATURE_ID = "org.eclipse.xtext.ui.shared.xtextNature";
    public static final String BUILDER_ID = "org.eclipse.xtext.ui.shared.xtextBuilder";
    private final IN4JSProject externalPackage;
    private final Collection<IBuildConfiguration> referencedBuildConfigs;

    public N4JSExternalProject(File file, IN4JSProject externalPackage) {
        super(file, NATURE_ID, BUILDER_ID);
        this.externalPackage = externalPackage;
        this.referencedBuildConfigs = Sets.newHashSet();
    }

    public IBuildConfiguration[] internalGetReferencedBuildConfigs(String configName, boolean includeMissing) {
        IBuildConfiguration[] filteredConfigs = (IBuildConfiguration[])FluentIterable.from(this.referencedBuildConfigs).filter(config -> includeMissing ? true : config.getProject().exists()).toArray(IBuildConfiguration.class);
        return filteredConfigs;
    }

    boolean add(IBuildConfiguration config) {
        return this.referencedBuildConfigs.add(config);
    }

    public IN4JSProject getIProject() {
        return this.externalPackage;
    }

    public ImmutableList<? extends IN4JSProject> getAllDirectDependencies() {
        return this.getIProject().getAllDirectDependencies();
    }

    public Iterable<String> getAllDirectDependencyIds() {
        return FluentIterable.from(this.getAllDirectDependencies()).transform(p -> p.getProjectName()).toSet();
    }
}

