/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
final class N4JSPreProcessor {
    N4JSPreProcessor() {
    }

    public void process(Script script, N4JSResource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return;
        }
        BuiltInTypeScope builtInTypes = BuiltInTypeScope.get((ResourceSet)resourceSet);
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)resource.getScript().eAllContents());
        for (EObject node : _iterable) {
            this.processNode(node, resource, builtInTypes);
        }
    }

    private void _processNode(EObject astNode, N4JSResource resource, BuiltInTypeScope builtInTypes) {
    }

    private void _processNode(ParameterizedTypeRef typeRef, N4JSResource resource, BuiltInTypeScope builtInTypes) {
        boolean _isArrayTypeLiteral = typeRef.isArrayTypeLiteral();
        if (_isArrayTypeLiteral) {
            typeRef.setDeclaredType((Type)builtInTypes.getArrayType());
        }
    }

    private void processNode(EObject typeRef, N4JSResource resource, BuiltInTypeScope builtInTypes) {
        if (typeRef instanceof ParameterizedTypeRef) {
            this._processNode((ParameterizedTypeRef)typeRef, resource, builtInTypes);
            return;
        }
        if (typeRef != null) {
            this._processNode(typeRef, resource, builtInTypes);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(new Object[]{typeRef, resource, builtInTypes}).toString());
    }
}

