/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.helper;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;

public class FolderContainmentHelper {
    @Inject
    private IN4JSCore n4jsCore;

    public boolean isContainedInOutputFolder(URI uri) {
        URI absoluteOutputLocation;
        IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(uri).orNull();
        return project != null && (absoluteOutputLocation = FolderContainmentHelper.getOutputURI(project)) != null && this.isContained(uri, absoluteOutputLocation);
    }

    public boolean isContainedInSourceContainer(URI uri) {
        Optional<? extends IN4JSSourceContainer> container = this.n4jsCore.findN4JSSourceContainer(uri);
        return container.isPresent();
    }

    public boolean isOutputContainedInSourceContainer(IN4JSProject project) {
        URI absoluteOutputLocation = FolderContainmentHelper.getOutputURI(project);
        if (absoluteOutputLocation != null) {
            return this.isContainedInSourceContainer(absoluteOutputLocation);
        }
        return false;
    }

    public boolean isContained(URI uri, URI container) {
        Path path = new File(uri.toString()).toPath().normalize();
        Path containerPath = new File(container.toString()).toPath().normalize();
        return path.startsWith(containerPath);
    }

    private static URI getOutputURI(IN4JSProject project) {
        String outputPathName = project.getOutputPath();
        if (outputPathName != null) {
            URI projectLocation = FolderContainmentHelper.appendTrailingSlash(project.getLocation());
            URI relativeOutputURI = URI.createURI((String)outputPathName);
            URI absoluteOutputLocation = relativeOutputURI.resolve(projectLocation);
            return absoluteOutputLocation;
        }
        return null;
    }

    private static URI appendTrailingSlash(URI uri) {
        if (!uri.isPrefix()) {
            return uri.appendSegment("");
        }
        return uri;
    }
}

