/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.common.unicode.generator;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.n4js.common.unicode.CharTypes;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;

@SuppressWarnings("all")
public class UnicodeGrammarGenerator {
  /**
   * This generator isn't called by the GenerateUnicode.mwe2, this have to be done manually
   */
  public static void main(final String[] args) throws IOException {
    new UnicodeGrammarGenerator();
  }
  
  /**
   * The write-on-instantiation allows to use this generator in mwe2 as #bean
   */
  public UnicodeGrammarGenerator() throws IOException {
    CharSequence _generateUnicodeRules = UnicodeGrammarGenerator.generateUnicodeRules();
    File _file = new File("grammar-gen/org/eclipse/n4js/common/unicode/Unicode.xtext");
    Files.write(_generateUnicodeRules, _file, Charsets.UTF_8);
  }
  
  public static CharSequence generateUnicodeRules() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Copyright (c) 2016 NumberFour AG.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* All rights reserved. This program and the accompanying materials");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* are made available under the terms of the Eclipse Public License v1.0");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* which accompanies this distribution, and is available at");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* http://www.eclipse.org/legal/epl-v10.html");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Contributors:");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*   NumberFour AG - Initial API and implementation");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// Important note:");
    _builder.newLine();
    _builder.append("// This grammar is auto generated by the");
    _builder.newLine();
    _builder.append("// org.eclipse.n4js.common.unicode.generator.UnicodeGrammarGenerator");
    _builder.newLine();
    _builder.append("//");
    _builder.newLine();
    _builder.append("// Rather than editing this manually, update the generator instead!");
    _builder.newLine();
    _builder.newLine();
    _builder.append("grammar org.eclipse.n4js.common.unicode.Unicode");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import \"http://www.eclipse.org/emf/2002/Ecore\" as ecore");
    _builder.newLine();
    _builder.newLine();
    _builder.append("terminal fragment HEX_DIGIT:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("(DECIMAL_DIGIT_FRAGMENT|\'a\'..\'f\'|\'A\'..\'F\')");
    _builder.newLine();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment DECIMAL_INTEGER_LITERAL_FRAGMENT:");
    _builder.newLine();
    _builder.append("\t  ");
    _builder.append("\'0\'");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("| \'1\'..\'9\' DECIMAL_DIGIT_FRAGMENT*");
    _builder.newLine();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment DECIMAL_DIGIT_FRAGMENT:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\'0\'..\'9\'");
    _builder.newLine();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment ZWJ:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\'\\u200D\'");
    _builder.newLine();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment ZWNJ:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\'\\u200C\'");
    _builder.newLine();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment BOM:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\'\\uFEFF\'");
    _builder.newLine();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment WHITESPACE_FRAGMENT:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\'\\u0009\' | \'\\u000B\' | \'\\u000C\' | \'\\u0020\' | \'\\u00A0\' | BOM | UNICODE_SPACE_SEPARATOR_FRAGMENT");
    _builder.newLine();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment LINE_TERMINATOR_FRAGMENT:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\'\\u000A\' | \'\\u000D\' | \'\\u2028\' | \'\\u2029\'");
    _builder.newLine();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment LINE_TERMINATOR_SEQUENCE_FRAGMENT:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\'\\u000A\' | \'\\u000D\' \'\\u000A\'? | \'\\u2028\' | \'\\u2029\'");
    _builder.newLine();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment SL_COMMENT_FRAGMENT:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\'//\' (!LINE_TERMINATOR_FRAGMENT)*");
    _builder.newLine();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment ML_COMMENT_FRAGMENT:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("\'/*\' -> \'*/\'");
    _builder.newLine();
    _builder.append(";");
    _builder.newLine();
    _builder.newLine();
    _builder.append("terminal fragment UNICODE_COMBINING_MARK_FRAGMENT:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// any character in the Unicode categories");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ―Non-spacing mark (Mn)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ―Combining spacing mark (Mc)");
    _builder.newLine();
    _builder.append("\t");
    final Function1<Integer, Boolean> _function = (Integer it) -> {
      return Boolean.valueOf(CharTypes.isCombiningMark((it).intValue()));
    };
    StringWriter _generateUnicodeRules = UnicodeGrammarGenerator.generateUnicodeRules(_function);
    _builder.append(_generateUnicodeRules, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment UNICODE_DIGIT_FRAGMENT:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// any character in the Unicode categories");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ―Decimal number (Nd)");
    _builder.newLine();
    _builder.append("\t");
    final Function1<Integer, Boolean> _function_1 = (Integer it) -> {
      return Boolean.valueOf(CharTypes.isDigit((it).intValue()));
    };
    StringWriter _generateUnicodeRules_1 = UnicodeGrammarGenerator.generateUnicodeRules(_function_1);
    _builder.append(_generateUnicodeRules_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment UNICODE_CONNECTOR_PUNCTUATION_FRAGMENT:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// any character in the Unicode categories");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ―Connector punctuation (Pc)");
    _builder.newLine();
    _builder.append("\t");
    final Function1<Integer, Boolean> _function_2 = (Integer it) -> {
      return Boolean.valueOf(CharTypes.isConnectorPunctuation((it).intValue()));
    };
    StringWriter _generateUnicodeRules_2 = UnicodeGrammarGenerator.generateUnicodeRules(_function_2);
    _builder.append(_generateUnicodeRules_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment UNICODE_LETTER_FRAGMENT:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// any character in the Unicode categories");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ―Uppercase letter (Lu)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ―Lowercase letter (Ll)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ―Titlecase letter (Lt)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ―Modifier letter (Lm)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ―Other letter (Lo)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ―Letter number (Nl)");
    _builder.newLine();
    _builder.append("\t");
    final Function1<Integer, Boolean> _function_3 = (Integer it) -> {
      return Boolean.valueOf(CharTypes.isLetter((it).intValue()));
    };
    StringWriter _generateUnicodeRules_3 = UnicodeGrammarGenerator.generateUnicodeRules(_function_3);
    _builder.append(_generateUnicodeRules_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment UNICODE_SPACE_SEPARATOR_FRAGMENT:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// any character in the Unicode categories");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// ―space separator (Zs)");
    _builder.newLine();
    _builder.append("\t");
    final Function1<Integer, Boolean> _function_4 = (Integer it) -> {
      return Boolean.valueOf(CharTypes.isSpaceSeparator((it).intValue()));
    };
    StringWriter _generateUnicodeRules_4 = UnicodeGrammarGenerator.generateUnicodeRules(_function_4);
    _builder.append(_generateUnicodeRules_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append(";");
    _builder.newLine();
    _builder.append("terminal fragment ANY_OTHER:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(".");
    _builder.newLine();
    _builder.append(";");
    _builder.newLine();
    return _builder;
  }
  
  public static StringWriter generateUnicodeRules(final Function1<? super Integer, ? extends Boolean> guard) {
    Character prev = null;
    boolean run = false;
    boolean first = true;
    char c = Character.MIN_VALUE;
    final StringWriter result = new StringWriter();
    final PrintWriter printer = new PrintWriter(result, true);
    while (true) {
      {
        Boolean _apply = guard.apply(Integer.valueOf(((int) c)));
        if ((_apply).booleanValue()) {
          if ((!run)) {
            prev = Character.valueOf(c);
            run = true;
          }
        } else {
          if (run) {
            if ((!first)) {
              printer.print("| ");
            } else {
              printer.print("  ");
              first = false;
            }
            String _padStart = Strings.padStart(Integer.toHexString((prev).charValue()).toUpperCase(), 4, '0');
            String _plus = ("\'\\u" + _padStart);
            String _plus_1 = (_plus + "\'");
            printer.print(_plus_1);
            char _charValue = prev.charValue();
            boolean _equals = (_charValue == (c - 1));
            if (_equals) {
              printer.println();
            } else {
              String _padStart_1 = Strings.padStart(Integer.toHexString((c - 1)).toUpperCase(), 4, '0');
              String _plus_2 = ("..\'\\u" + _padStart_1);
              String _plus_3 = (_plus_2 + "\'");
              printer.println(_plus_3);
            }
            prev = null;
            run = false;
          }
        }
        c = ((char) (c + 1));
        if ((c == Character.MAX_VALUE)) {
          return result;
        }
      }
    }
  }
}
