package org.eclipse.n4js.json.validation;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.n4js.utils.NLS;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

@NLS(propertyFileName = "messages")
@SuppressWarnings("all")
public class JSONIssueCodes {
  private final static String BUNDLE_NAME = JSONIssueCodes.class.getPackage().getName() + ".messages";
  
  private final static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
  
  private final static String INITIALIZER = new Function0<String>() {
        public String apply() {
          org.eclipse.osgi.util.NLS.initializeMessages(BUNDLE_NAME, JSONIssueCodes.class);
          return "";
        }
      }.apply();;
  
  private static String getString(final String key) {
    try {
    	String value = RESOURCE_BUNDLE.getString(key);
    	String[] parts = value.split(";;;");
    	return parts[1];
    } catch (MissingResourceException e) {
    	return '!' + key + '!';
    }
  }
  
  public static Severity getDefaultSeverity(final String key) {
    try {
    	String value = RESOURCE_BUNDLE.getString(key);
    	String[] parts = value.split(";;;");
    	String defaultSeverity = parts[0];
    	return Severity.valueOf(defaultSeverity.toUpperCase());
    } catch (MissingResourceException e) {
    	return null;
    }
  }
  
  public final static String JSON_COMMENT_UNSUPPORTED = "JSON_COMMENT_UNSUPPORTED";
  
  /**
   * Comments are not a valid JSON construct.
   */
  public static String getMessageForJSON_COMMENT_UNSUPPORTED() {
    return org.eclipse.osgi.util.NLS.bind(getString(JSON_COMMENT_UNSUPPORTED), new Object [] {  });
  }
  
  public final static String JSON_DUPLICATE_KEY = "JSON_DUPLICATE_KEY";
  
  /**
   * Property {0} duplicates property {0} (line {1}).
   */
  public static String getMessageForJSON_DUPLICATE_KEY(final Object param0, final Object param1) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSON_DUPLICATE_KEY), new Object [] { param0, param1 });
  }
  
  public final static String JSON_EMPTY_STRING = "JSON_EMPTY_STRING";
  
  /**
   * Value for property "{0}" must not be empty.
   */
  public static String getMessageForJSON_EMPTY_STRING(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSON_EMPTY_STRING), new Object [] { param0 });
  }
  
  public final static String JSON_EXPECTED_DIFFERENT_VALUE_TYPE = "JSON_EXPECTED_DIFFERENT_VALUE_TYPE";
  
  /**
   * Expected {0} instead of {1} {2}.
   */
  public static String getMessageForJSON_EXPECTED_DIFFERENT_VALUE_TYPE(final Object param0, final Object param1, final Object param2) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSON_EXPECTED_DIFFERENT_VALUE_TYPE), new Object [] { param0, param1, param2 });
  }
  
  public final static String JSON_INVALID_DOUBLE_VALUE = "JSON_INVALID_DOUBLE_VALUE";
  
  /**
   * Invalid decimal number value.
   */
  public static String getMessageForJSON_INVALID_DOUBLE_VALUE() {
    return org.eclipse.osgi.util.NLS.bind(getString(JSON_INVALID_DOUBLE_VALUE), new Object [] {  });
  }
  
  public final static String JSON_MISSING_PROPERTY = "JSON_MISSING_PROPERTY";
  
  /**
   * Missing mandatory property {0}.
   */
  public static String getMessageForJSON_MISSING_PROPERTY(final Object param0) {
    return org.eclipse.osgi.util.NLS.bind(getString(JSON_MISSING_PROPERTY), new Object [] { param0 });
  }
}
