/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.regex.tests;

import org.eclipse.xtend2.lib.StringConcatenation;
import org.junit.Assert;
import org.junit.Test;

@SuppressWarnings("all")
public abstract class AbstractErrorTests extends Assert {
  public abstract void assertInvalid(final CharSequence expression);
  
  @Test
  public void testAssertionWithQuantifier() {
    this.assertInvalid("/^*/");
  }
  
  @Test
  public void testUnclosedCharacterLiteral() {
    this.assertInvalid("/[/");
  }
  
  @Test
  public void testQuantifierOnLookAhead() {
    this.assertInvalid("/(?=a)+/");
  }
  
  @Test
  public void testWikipedia() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/(?<=\\.) {2,}(?=[A-Z])/");
    this.assertInvalid(_builder);
  }
}
