/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.filechecker;

import com.google.common.base.Joiner;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.n4js.filechecker.AbstractFileChecker;
import org.eclipse.n4js.filechecker.CRHStatsPrinter;
import org.eclipse.n4js.filechecker.FullReport;
import org.eclipse.n4js.filechecker.Report;
import org.eclipse.n4js.filechecker.ReportUtils;

public class FileChecker
extends AbstractFileChecker {
    private static final Mode MODE = Mode.NORMAL;
    private static final boolean FIX_FILE_ENDING = false;
    private static final boolean FIX_TRAILING_WHITE_SPACE = false;
    private static final int DEPTH_OF_PROJECTS = MODE == Mode.Xpect ? 1 : 2;
    private static final String[] REPOS = new String[]{"n4js", "n4js-n4"};
    private static final String[] REPOS_MANDATORY = new String[]{"n4js"};
    private static final String[] XSEMANTICS_REPOS = new String[]{"xsemantics"};
    private static final String[] XSEMANTICS_REPOS_MANDATORY = XSEMANTICS_REPOS;
    private static final String[] Xpect_REPOS = new String[]{"Xpect"};
    private static final String[] Xpect_REPOS_MANDATORY = Xpect_REPOS;
    private static final String PROVIDER_NAME = "Eclipse " + (MODE == Mode.XSEMANTICS ? "Xsemantics" : (MODE == Mode.Xpect ? "Xpect" : "N4JS")) + " Project";
    private static final String PROVIDER_NAME_N4 = "NumberFour AG";
    private static final String FILE_NAME__DOT_PROJECT = ".project";
    private static final String FILE_NAME__PLUGIN_PROPERTIES = "plugin.properties";
    private static final String FILE_NAME__MANIFEST_MF = "MANIFEST.MF";
    private static final String FILE_NAME__FEATURE_PROPERTIES = "feature.properties";
    private static final String FILE_NAME__FEATURE_XML = "feature.xml";
    private static final String FILE_NAME__NOTICE_HTML = "notice.html";
    private static final String FILE_NAME__ABOUT_HTML = "about.html";
    private static final String FILE_NAME__ABOUT_HTML_TEMPLATE = "about.html_TEMPLATE";
    private static final String FILE_NAME__LICENSE_HTML = "license.html";
    private static final String FILE_NAME__EPL = "EPL-1.0.html";
    private static final String[] FILE_EXTENSIONS = new String[]{".java", ".fj", ".xtend", ".xtext", ".xcore", ".xsemantics", ".xml", ".mwe2", ".adoc", "Jenkinsfile", ".xt", ".n4jsx", ".n4jsd"};
    private static final String[] IGNORED_FILES = new String[]{"third-party.txt", ".antlr-generator-3.2.0-patch.jar", "plugins/org.eclipse.n4js.regex/model/generated/RegularExpression.genmodel", "prepareInitialCommit.sh"};
    private static final String[] IGNORED_FOLDERS = new String[]{"xtend-gen", "docs/org.eclipse.n4js.doc/src-gen", "docs/org.eclipse.n4js.doc/generated-docs", "tools/org.eclipse.n4js.hlc/target/wsp", ".github", ".git"};
    private static final String[] GENERATED_FOLDERS = new String[]{"src-gen", "emf-gen", "xsemantics-gen"};
    private static final String[] BANNED_EXTENSIONS = new String[]{".jar", ".zip"};
    private static final String[] BANNED_WORDS = new String[]{"Copyright", "License", "numberfour.jira.com", "jira.numberfour.eu"};
    private static final String[] BANNED_WORDS_WHITELIST = new String[]{String.valueOf(AbstractFileChecker.class.getSimpleName()) + ".java", String.valueOf(FileChecker.class.getSimpleName()) + ".java", String.valueOf(Report.class.getSimpleName()) + ".java", String.valueOf(FullReport.class.getSimpleName()) + ".java", String.valueOf(ReportUtils.class.getSimpleName()) + ".java", String.valueOf(CRHStatsPrinter.class.getSimpleName()) + ".java", "prepareInitialCommit.sh", "notice.html", "about.html", "about.html_TEMPLATE", "license.html", "EPL-1.0.html", "epl-v10.html", "asl-v20.txt", "LICENSE", "LICENSE.md", "license", "license.adoc", "licenses.adoc", "README.md", "README.adoc", "readme.md", "package.json", "copyrightheader.adoc", "n4js/docs/org.eclipse.n4js.doc/src/userguides/index.adoc", "n4js/docs/org.eclipse.n4js.spec/N4JSSpec.adoc", "docs/index.html", "acronyms.adoc", "scripts/highlight.min.js", "styles/adoc-readthedocs.css", "styles/foundation.css", "styles/foundation.css", "n4js-libraries/eu.numberfour.mangelhaft.reporter.ide/messages.md", "n4js-libraries/n4js-node/src/js/n4js-cli.js", "plugins/org.eclipse.n4js.runner/res/ide-nodejs-env/n4js-node/n4js-cli.js", "plugins/org.eclipse.n4js.external.libraries/runtime/n4js-node/src/js/n4js-cli.js", "n4js-libraries/n4js-node-mangelhaft/src/js/n4js-mangelhaft-cli.js", "plugins/org.eclipse.n4js.runner/res/ide-nodejs-env/n4js-node-mangelhaft/n4js-mangelhaft-cli.js", "plugins/org.eclipse.n4js.external.libraries/runtime/n4js-node-mangelhaft/src/js/n4js-mangelhaft-cli.js", "n4js-libraries/n4js-node-mangelhaft/tests/npm-test.sh", "plugins/org.eclipse.n4js.external.libraries/runtime/n4js-node-mangelhaft/tests/npm-test.sh", "plugins/org.eclipse.n4js.external.libraries/src/org/eclipse/n4js/external/libraries/PackageJson.java", "plugins/org.eclipse.n4js.external.libraries/src/org/eclipse/n4js/external/libraries/TargetPlatformFactory.xtend", "plugins/org.eclipse.n4js.runner/schema/org.eclipse.n4js.runner.runners.exsd", "plugins/org.eclipse.n4js.utils/schema/org.eclipse.n4js.utils.fileExtensions.exsd", "plugins/org.eclipse.n4js.common.unicode/src/org/eclipse/n4js/common/unicode/generator/UnicodeGrammarGenerator.xtend", "tests/org.eclipse.n4js.n4ide.spec.tests/Xpect-test/Ch05_04_01_02__Organize_Imports/organize_imports/GHOLD_103/GHOLD_103.txt", "tests/org.eclipse.n4js.smoke.tests/src/org/eclipse/n4js/smoke/tests/GeneratedSmokeTestCases2.xtend", "tests/org.eclipse.n4js.lang.tests/src/org/eclipse/n4js/tests/contentassist/NodeModelTokenSourceTest.xtend", "releng/org.eclipse.n4js.targetplatform/N4JS.setup", "releng/org.eclipse.n4js.targetplatform/org.eclipse.n4js.targetplatform.target", "builds/org.eclipse.n4js.product.build/org.eclipse.n4js.product.product", "plugins/org.eclipse.n4js/src/org/eclipse/n4js/GenerateN4JS.mwe2", "plugins/org.eclipse.n4js.common.unicode/src/org/eclipse/n4js/common/unicode/GenerateUnicode.mwe2", "plugins/org.eclipse.n4js.n4jsx/src/org/eclipse/n4js/n4jsx/GenerateN4JSX.mwe2", "plugins/org.eclipse.n4js.regex/src/org/eclipse/n4js/regex/GenerateRegularExpression.mwe2", "plugins/org.eclipse.n4js.ts/src/org/eclipse/n4js/ts/GenerateTypes.mwe2", "plugins/org.eclipse.n4js.jsdoc/emf-gen/org/eclipse/n4js/jsdoc/dom/DomPackage.java", "plugins/org.eclipse.n4js.model/emf-gen/org/eclipse/n4js/n4JS/N4JSPackage.java", "plugins/org.eclipse.n4js.model/emf-gen/org/eclipse/n4js/projectDescription/ProjectDescriptionPackage.java", "plugins/org.eclipse.n4js.n4jsx.model/emf-gen/org/eclipse/n4js/n4jsx/n4JSX/N4JSXPackage.java", "plugins/org.eclipse.n4js.transpiler/emf-gen/org/eclipse/n4js/transpiler/im/ImPackage.java", "plugins/org.eclipse.n4js.ts.model/emf-gen/org/eclipse/n4js/ts/typeRefs/TypeRefsPackage.java", "plugins/org.eclipse.n4js.ts.model/emf-gen/org/eclipse/n4js/ts/types/TypesPackage.java", "plugins/org.eclipse.n4js.utils/emf-gen/org/eclipse/n4js/utils/validation/ValidationPackage.java", "tools/org.eclipse.n4js.hlc/src/main/resources/org/eclipse/emf/ecore/plugin/plugin.properties", "plugins/org.eclipse.n4js.environments/src-env/env/builtin_js.n4ts"};
    private static final String[] XSEMANTICS_BANNED_WORDS_WHITELIST = new String[]{"notice.html", "about.html", "about.html_TEMPLATE", "EPL-1.0.html", "LICENSE", "README.md", "plugins/it.xsemantics.dsl/model/custom/Xsemantics.ecore", "plugins/it.xsemantics.dsl/model/custom/Xsemantics.genmodel", "plugins/it.xsemantics.dsl/src/it/xsemantics/dsl/jvmmodel/XsemanticsJvmModelInferrer.xtend", "plugins/it.xsemantics.dsl/src/it/xsemantics/dsl/Xsemantics.xtext", "/Users/mark-oliver.reiser/Home/Prog/Java/n4js-main/git-repo/xsemantics/doc/it.xsemantics.doc/contents/00-Main.html", "/Users/mark-oliver.reiser/Home/Prog/Java/n4js-main/git-repo/xsemantics/doc/it.xsemantics.doc/contents/00-Main_12.html", "/Users/mark-oliver.reiser/Home/Prog/Java/n4js-main/git-repo/xsemantics/doc/it.xsemantics.doc/contents/XsemanticsSyntax.html", "/Users/mark-oliver.reiser/Home/Prog/Java/n4js-main/git-repo/xsemantics/doc/it.xsemantics.doc/xdoc/00-Main.xdoc", "/Users/mark-oliver.reiser/Home/Prog/Java/n4js-main/git-repo/xsemantics/doc/it.xsemantics.doc/xdoc/XsemanticsSyntax.xdoc", "tests/it.xsemantics.dsl.tests/tests_input_files/header_test.xsemantics", "tests/it.xsemantics.dsl.tests/src/it/xsemantics/dsl/tests/generator/XsemanticsGeneratedFileHeaderTest.xtend"};
    private static final String[] Xpect_BANNED_WORDS_WHITELIST = new String[]{"notice.html", "about.html", "about.html_TEMPLATE", "EPL-1.0.html", "org.eclipse.xpect/model/Xpect.genmodel"};
    private static final String[] COPYRIGHT_TEXT_N4JS = new String[]{"Copyright (c) 2016 NumberFour AG.", "All rights reserved. This program and the accompanying materials", "are made available under the terms of the Eclipse Public License v1.0", "which accompanies this distribution, and is available at", "http://www.eclipse.org/legal/epl-v10.html", "", "Contributors:", "  NumberFour AG - Initial API and implementation"};
    private static final String[] COPYRIGHT_TEXT_XSEMANTICS = new String[]{"Copyright (c) 2013-2017 Lorenzo Bettini.", "All rights reserved. This program and the accompanying materials", "are made available under the terms of the Eclipse Public License v1.0", "which accompanies this distribution, and is available at", "http://www.eclipse.org/legal/epl-v10.html", "", "Contributors:", "  Lorenzo Bettini - Initial contribution and API"};
    private static final String[] COPYRIGHT_TEXT_Xpect = new String[]{"Copyright (c) 2012-2017 TypeFox GmbH and itemis AG.", "All rights reserved. This program and the accompanying materials", "are made available under the terms of the Eclipse Public License v1.0", "which accompanies this distribution, and is available at", "http://www.eclipse.org/legal/epl-v10.html", "", "Contributors:", "  Moritz Eysholdt - Initial contribution and API"};
    private static final String[] COPYRIGHT_TEXT = MODE == Mode.XSEMANTICS ? COPYRIGHT_TEXT_XSEMANTICS : (MODE == Mode.Xpect ? COPYRIGHT_TEXT_Xpect : COPYRIGHT_TEXT_N4JS);
    private static final String COPYRIGHT_TEXT_SHORT = "Generated by N4JS transpiler; for copyright see original N4JS source file.";
    private static final String COPYRIGHT_HEADER = ("/**\n * " + Joiner.on((String)"\n * ").join((Object[])COPYRIGHT_TEXT) + "\n" + " */").replace("\n * \n", "\n *\n");
    private static final String COPYRIGHT_HEADER_V2 = COPYRIGHT_HEADER.replace("/**\n", "/*******************************************************************************\n").replace(" */", " *******************************************************************************/");
    private static final String COPYRIGHT_HEADER_JS = ("/*\n * " + Joiner.on((String)"\n * ").join((Object[])COPYRIGHT_TEXT) + "\n" + " */").replace("\n * \n", "\n *\n");
    private static final String COPYRIGHT_HEADER_XML = "<!--\n" + Joiner.on((String)"\n").join((Object[])COPYRIGHT_TEXT) + "\n" + "-->";
    private static final String COPYRIGHT_HEADER_HTML = "<!--\n" + Joiner.on((String)"\n").join((Object[])COPYRIGHT_TEXT) + "\n" + "-->";
    private static final String COPYRIGHT_HEADER_ADOC = "////\n" + Joiner.on((String)"\n").join((Object[])COPYRIGHT_TEXT) + "\n" + "////";
    private static final String COPYRIGHT_HEADER_TEX = ("%\n% " + Joiner.on((String)"\n% ").join((Object[])COPYRIGHT_TEXT) + "\n" + "%").replace(" \n", "\n");
    private static final String COPYRIGHT_HEADER_SH = ("#\n# " + Joiner.on((String)"\n# ").join((Object[])COPYRIGHT_TEXT) + "\n" + "#").replace(" \n", "\n");
    private static final String COPYRIGHT_GEN_MODEL_PROPERTY = "copyrightText=\"" + Joiner.on((String)"\\n").join((Object[])COPYRIGHT_TEXT) + "\"";
    private static final String COPYRIGHT_HEADER_JS_SHORT = "// Generated by N4JS transpiler; for copyright see original N4JS source file.";
    private static final String COPYRIGHT_HEADER_TXT = "*******************************************************************************\n" + Joiner.on((String)"\n").join((Object[])COPYRIGHT_TEXT) + "\n" + "*******************************************************************************";
    private static final String COPYRIGHT_KEYWORD_IN_XSEMANTICS = "copyright\n\"" + Joiner.on((String)"\n").join((Object[])COPYRIGHT_TEXT) + '\"';
    private static final String COPYRIGHT_HEADER_EMF_CODE_XTEXT_GENMODEL_BUG = COPYRIGHT_HEADER.replace("/**\n", "/**\n * *\n").replace("\n *\n", "\n *  *\n");
    private static final String COPYRIGHT_HEADER_EMF_CODE_VIA_XCORE = COPYRIGHT_HEADER.replace("\n *\n", "\n * \n");
    private static final String PATTERN_FEATURE_TAG = String.valueOf(Pattern.quote("<feature")) + "\\s.*" + Pattern.quote("provider-name=\"%providerName\"") + "\\s+" + Pattern.quote("license-feature=\"org.eclipse.license\"") + "\\s+" + Pattern.quote("license-feature-version=\"1.0.1.v20140414-1359\"") + ".*" + Pattern.quote(">");
    private static final String PATTERN_COPYRIGHT_TAG = String.valueOf(Pattern.quote("<copyright>")) + "\\s*" + Pattern.quote(Joiner.on((String)"\n").join((Object[])COPYRIGHT_TEXT)) + "\\s*" + Pattern.quote("</copyright>");
    private static final String PATTERN_LICENSE_TAG = String.valueOf(Pattern.quote("<license url=\"%licenseURL\">")) + "\\s*" + Pattern.quote("%license") + "\\s*" + Pattern.quote("</license>");
    private static final String PATTERN_JAVA_IMPORTS = "package [^;]*;\\n(\\s*((// .*)|(import [^;]*;))\\n)*\\s*";
    private static final Pattern PATTERN_FEATURE_TAG_COMPILED = Pattern.compile(PATTERN_FEATURE_TAG, 32);
    private static final Pattern PATTERN_COPYRIGHT_TAG_COMPILED = Pattern.compile(PATTERN_COPYRIGHT_TAG);
    private static final Pattern PATTERN_LICENSE_TAG_COMPILED = Pattern.compile(PATTERN_LICENSE_TAG);
    private static final Pattern PATTERN_JAVA_IMPORTS_COMPILED = Pattern.compile("package [^;]*;\\n(\\s*((// .*)|(import [^;]*;))\\n)*\\s*");

    @Override
    protected String[] getRepos() {
        switch (MODE) {
            case XSEMANTICS: {
                return XSEMANTICS_REPOS;
            }
            case Xpect: {
                return Xpect_REPOS;
            }
        }
        return REPOS;
    }

    @Override
    protected String[] getReposMandatory() {
        switch (MODE) {
            case XSEMANTICS: {
                return XSEMANTICS_REPOS_MANDATORY;
            }
            case Xpect: {
                return Xpect_REPOS_MANDATORY;
            }
        }
        return REPOS_MANDATORY;
    }

    @Override
    protected boolean isIgnored(Path path, String pathStr) {
        if (path.endsWith("pom.xml")) {
            return false;
        }
        if (FileChecker.isFile(pathStr, IGNORED_FILES)) {
            return true;
        }
        if (FileChecker.isBelowFolder(pathStr, IGNORED_FOLDERS)) {
            return true;
        }
        if (FileChecker.hasExtension(path, ".prefs")) {
            return true;
        }
        return FileChecker.hasExtension(path, ".bib");
    }

    private static final void fixCopyrightHeader(Path path, String content) {
        if (FileChecker.hasExtension(path, ".xml")) {
            int preambleLen = COPYRIGHT_HEADER_XML.indexOf(10) + 1;
            String preamble = COPYRIGHT_HEADER_XML.substring(0, preambleLen);
            if (!content.startsWith(preamble)) {
                throw new IllegalStateException("cannot fix copyright header of file " + path + ": does not start with preamble:\n" + preamble);
            }
            String contentToKeep = content.substring(preambleLen);
            FileChecker.writeFile(path, String.valueOf(COPYRIGHT_HEADER_XML) + '\n' + contentToKeep);
        } else if (FileChecker.hasExtension(path, ".mwe2")) {
            FileChecker.writeFile(path, String.valueOf(COPYRIGHT_HEADER) + '\n' + content);
        } else {
            throw new UnsupportedOperationException("cannot fix copyright header due to supported file extension: " + path);
        }
    }

    @Override
    protected void checkFile(Path path, String content, boolean isRegisteredAsThirdParty, Report report) {
        String[] moreCRHs;
        if (!isRegisteredAsThirdParty) {
            if (path.endsWith(FILE_NAME__PLUGIN_PROPERTIES) || path.endsWith(FILE_NAME__FEATURE_PROPERTIES)) {
                this.checkFilePluginOrFeatureProperties(path, content, report);
            } else if (path.endsWith(FILE_NAME__MANIFEST_MF)) {
                this.checkFileManifestMF(path, content, report);
            } else if (path.endsWith(FILE_NAME__FEATURE_XML)) {
                this.checkFileFeatureXML(path, content, report);
            }
        }
        if (FileChecker.hasExtension(path, FileChecker.concat(FILE_EXTENSIONS, moreCRHs = new String[]{".xml", ".html", ".sh", ".tex", ".grammar", "adoc", "n4ts", "n4js", "n4jsx", "n4jsd", "xt_IN_FOLDER_my", "xt_", "xt_IN_FOLDER_P", "xt_IN_FOLDER_p", "xt.DISABLED", ".idx", ".js", ".ant", ".css", ".txt", ".mwe2txt", ".oldxsem", ".md", ".xtypes", ".xcoretxt", ".yml", ".fjcached", ".xpt", ".def"}))) {
            if (FileChecker.hasCorrectCopyrightHeader(path, content)) {
                report.setToHasCRH();
            } else {
                path.toString().endsWith(".mwe2");
            }
        }
        if (FileChecker.hasExtension(path, ".xml")) {
            if (!FileChecker.hasCorrectCopyrightHeader(path, content)) {
                report.problems.add("does not contain correct copyright header");
            }
        } else if (FileChecker.hasExtension(path, BANNED_EXTENSIONS)) {
            if (!isRegisteredAsThirdParty) {
                report.problems.add("file has a banned file extension (add to third-party.txt or to IGNORED_FILES)");
            }
        } else {
            String bannedWord;
            if (FileChecker.hasExtension(path, FILE_EXTENSIONS)) {
                this.checkCommonFiles(path, content, isRegisteredAsThirdParty, report);
            }
            if (!(isRegisteredAsThirdParty || FileChecker.inN4Repo(path) || FileChecker.canContainBannedWord(path) || (bannedWord = FileChecker.containsBannedWord(path, content)) == null)) {
                report.problems.add("must not contain banned word '" + bannedWord + "'");
            }
        }
    }

    private static String[] concat(String[] a, String[] b) {
        String[] array = new String[a.length + b.length];
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    private void checkCommonFiles(Path path, String content, boolean isRegisteredAsThirdParty, Report report) {
        if (content.contains("\r")) {
            report.problems.add("contains invalid line endings (i.e. contains carriage return: '\\r')");
        } else {
            if (!FileChecker.hasExtension(path, ".xt") && !FileChecker.isBelowFolder(path.toString(), GENERATED_FOLDERS) && MODE != Mode.XSEMANTICS && MODE != Mode.Xpect) {
                int lineNumber;
                char char2ndToLast;
                int len = content.length();
                char charLast = len > 0 ? content.charAt(len - 1) : (char)'\u0000';
                char c = char2ndToLast = len > 1 ? content.charAt(len - 2) : (char)'\u0000';
                if (len > 0 && (charLast != '\n' || char2ndToLast == '\n')) {
                    report.problems.add("does not end with a single empty line");
                }
                if ((lineNumber = FileChecker.containsTrailingWhiteSpace(content)) > 0) {
                    report.problems.add("must not contain lines with trailing white-space (line " + lineNumber + ")");
                }
            }
            if (!isRegisteredAsThirdParty && !FileChecker.hasCorrectCopyrightHeader(path, content)) {
                report.problems.add("does not contain correct copyright header");
            }
            if (!isRegisteredAsThirdParty && FileChecker.hasExtension(path, ".xcore") && !content.contains(COPYRIGHT_GEN_MODEL_PROPERTY)) {
                report.problems.add(".xcore file does not contain correct 'copyrightText' genModel property");
            }
            if (!isRegisteredAsThirdParty && MODE != Mode.XSEMANTICS && MODE != Mode.Xpect && !FileChecker.hasExtension(path, ".adoc") && content.contains("@author")) {
                report.problems.add("must not contain author tags");
            }
        }
    }

    private void checkFilePluginOrFeatureProperties(Path path, String content, Report report) {
        String providerName;
        String kind = path.getFileName().toString().startsWith("feature.") ? "feature" : "plugin";
        String pluginName = path.getName(path.getNameCount() - 2).toString();
        String string = providerName = FileChecker.inN4Repo(path) ? PROVIDER_NAME_N4 : PROVIDER_NAME;
        if (!content.contains(String.valueOf(kind) + "Name = " + pluginName)) {
            report.problems.add("property " + kind + "Name missing or value != name of containing folder");
        }
        if (!content.contains("providerName = " + providerName)) {
            report.problems.add("property providerName missing or does not have value \"" + providerName + "\"");
        }
    }

    private void checkFileManifestMF(Path path, String content, Report report) {
        String bundleSymbolicName = path.getName(path.getNameCount() - 3).toString();
        String bundleSymbolicNamePropertyAndValue = "Bundle-SymbolicName: " + bundleSymbolicName;
        if (!content.contains(String.valueOf(bundleSymbolicNamePropertyAndValue) + "\n") && !content.contains(String.valueOf(bundleSymbolicNamePropertyAndValue) + ";")) {
            report.problems.add("property 'Bundle-SymbolicName' missing or has incorrect value");
        }
        if (MODE != Mode.XSEMANTICS && MODE != Mode.Xpect && !content.contains("Bundle-Name: %pluginName")) {
            report.problems.add("property 'Bundle-Name' missing or does not have value \"%pluginName\"");
        }
        if (!content.contains("Bundle-Vendor: %providerName")) {
            report.problems.add("property 'Bundle-Vendor' missing or does not have value \"%providerName\"");
        }
        if (this.countSubstring(content, "Bundle-Name") > 1) {
            report.problems.add("property 'Bundle-Vendor' provided more than once");
        }
        if (this.countSubstring(content, "Bundle-Vendor") > 1) {
            report.problems.add("property 'Bundle-Vendor' provided more than once");
        }
    }

    private void checkFileFeatureXML(Path path, String content, Report report) {
        if (FileChecker.inN4Repo(path)) {
            return;
        }
        if (!this.containsPattern(content, PATTERN_FEATURE_TAG_COMPILED)) {
            report.problems.add("tag 'feature' missing or attributes 'provider-name', 'license-feature' are incorrect");
        }
        if (!this.containsPattern(content, PATTERN_COPYRIGHT_TAG_COMPILED)) {
            report.problems.add("tag 'copyright' missing or has an incorrect value");
        }
        if (!this.containsPattern(content, PATTERN_LICENSE_TAG_COMPILED)) {
            report.problems.add("tag 'license' missing or has an incorrect value");
        }
    }

    @Override
    protected void checkFolder(Path path, int depth, Report report) {
        if (depth == 0) {
            this.checkFolderRepositoryRoot(path, report);
        } else if (depth == DEPTH_OF_PROJECTS && !path.endsWith(".git")) {
            this.checkFolderProjectRoot(path, report);
        }
    }

    private void checkFolderRepositoryRoot(Path path, Report report) {
        if (FileChecker.inN4Repo(path)) {
            return;
        }
        this.assertContainsFileWithName(path, FILE_NAME__NOTICE_HTML, report);
        this.assertContainsFileWithName(path, FILE_NAME__EPL, report);
    }

    private void checkFolderProjectRoot(Path path, Report report) {
        boolean isFeatureBundle;
        if (!this.containsFileWithName(path, FILE_NAME__DOT_PROJECT)) {
            report.problems.add("folder on level 2 does not contain an Eclipse '.project' file");
        }
        boolean bl = isFeatureBundle = FileChecker.isBelowFolder(path.toString(), "features") || this.containsFileWithName(path, FILE_NAME__FEATURE_XML);
        if (FileChecker.inN4Repo(path)) {
            if (!isFeatureBundle) {
                this.assertContainsFileWithName(path, FILE_NAME__PLUGIN_PROPERTIES, report);
            }
        } else if (isFeatureBundle) {
            if (this.containsFileWithName(path, FILE_NAME__LICENSE_HTML)) {
                report.problems.add("feature bundles should not contain a 'license.html' file (because we are using property license-feature in feature.xml)");
            }
            if (this.containsFileWithName(path, FILE_NAME__ABOUT_HTML)) {
                report.problems.add("feature bundles should not contain an 'about.html' file");
            }
            this.assertContainsFileWithName(path, FILE_NAME__FEATURE_PROPERTIES, report);
        } else {
            this.assertContainsFileWithName(path, FILE_NAME__ABOUT_HTML, report);
            this.assertContainsFileWithName(path, FILE_NAME__PLUGIN_PROPERTIES, report);
        }
    }

    private static boolean hasCorrectCopyrightHeader(Path path, String content) {
        return FileChecker.beginIndexWithoutCopyrightHeader(path, content) > 0;
    }

    private void assertContainsFileWithName(Path path, String fileName, Report report) {
        if (!this.containsFileWithName(path, fileName)) {
            report.problems.add("folder missing required file: " + fileName);
        }
    }

    private static int beginIndexWithoutCopyrightHeader(Path path, String content) {
        if (FileChecker.hasExtension(path, ".xml", ".ant", ".md", ".def")) {
            return FileChecker.beginIndexWithoutCopyrightHeader(content, COPYRIGHT_HEADER_XML, "<?xml ");
        }
        if (FileChecker.hasExtension(path, ".html")) {
            return FileChecker.beginIndexWithoutCopyrightHeader(content, COPYRIGHT_HEADER_HTML, "<!DOCTYPE ");
        }
        if (FileChecker.hasExtension(path, ".adoc")) {
            return FileChecker.beginIndexWithoutCopyrightHeader(content, COPYRIGHT_HEADER_ADOC, new String[0]);
        }
        if (FileChecker.hasExtension(path, ".n4js", "n4jsx", ".n4jsd", ".n4ts", ".xt", "xt_IN_FOLDER_my", "xt_", "xt_IN_FOLDER_P", "xt_IN_FOLDER_p", "xt.DISABLED")) {
            if (MODE == Mode.Xpect) {
                return FileChecker.beginIndexWithoutCopyrightHeader(content, COPYRIGHT_HEADER_V2, new String[0]);
            }
            return FileChecker.beginIndexWithoutCopyrightHeader(content, COPYRIGHT_HEADER_JS, new String[0]);
        }
        if (FileChecker.hasExtension(path, ".js")) {
            int startPos = FileChecker.beginIndexWithoutCopyrightHeader(content, COPYRIGHT_HEADER_JS, new String[0]);
            int startPosShort = FileChecker.beginIndexWithoutCopyrightHeader(content, COPYRIGHT_HEADER_JS_SHORT, new String[0]);
            return Math.max(startPos, startPosShort);
        }
        if (FileChecker.hasExtension(path, ".tex")) {
            return FileChecker.beginIndexWithoutCopyrightHeader(content, COPYRIGHT_HEADER_TEX, new String[0]);
        }
        if (FileChecker.hasExtension(path, ".sh", ".idx", ".yml")) {
            return FileChecker.beginIndexWithoutCopyrightHeader(content, COPYRIGHT_HEADER_SH, "#!/");
        }
        if (FileChecker.hasExtension(path, ".txt")) {
            return FileChecker.beginIndexWithoutCopyrightHeader(content, COPYRIGHT_HEADER_TXT, new String[0]);
        }
        int base = 0;
        if (FileChecker.isBelowFolder(path.toString(), GENERATED_FOLDERS)) {
            Matcher m;
            if (FileChecker.hasExtension(path, ".java") && (m = PATTERN_JAVA_IMPORTS_COMPILED.matcher(content)).lookingAt()) {
                base = m.end();
                content = content.substring(base);
            }
            if (FileChecker.startsWithCopyrightHeader(content, COPYRIGHT_HEADER_EMF_CODE_XTEXT_GENMODEL_BUG)) {
                return base + COPYRIGHT_HEADER_EMF_CODE_XTEXT_GENMODEL_BUG.length();
            }
            if (FileChecker.startsWithCopyrightHeader(content, COPYRIGHT_HEADER_EMF_CODE_VIA_XCORE)) {
                return base + COPYRIGHT_HEADER_EMF_CODE_VIA_XCORE.length();
            }
        }
        if (FileChecker.startsWithCopyrightHeader(content, COPYRIGHT_HEADER)) {
            return base + COPYRIGHT_HEADER.length();
        }
        if ((MODE == Mode.XSEMANTICS || MODE == Mode.Xpect) && FileChecker.startsWithCopyrightHeader(content, COPYRIGHT_HEADER_V2)) {
            return base + COPYRIGHT_HEADER_V2.length();
        }
        return 0;
    }

    private static int beginIndexWithoutCopyrightHeader(String content, String header, String ... skipHeaderLines) {
        int offset = 0;
        if (skipHeaderLines != null && skipHeaderLines.length > 0) {
            String[] stringArray = skipHeaderLines;
            int n = skipHeaderLines.length;
            int n2 = 0;
            while (n2 < n) {
                String skipLine = stringArray[n2];
                if (content.startsWith(skipLine)) {
                    offset = content.indexOf("\n") + 1;
                }
                ++n2;
            }
        }
        int startPos = FileChecker.startsWithCopyrightHeader(content, header, offset) ? header.length() : 0;
        return startPos;
    }

    private static boolean startsWithCopyrightHeader(String content, String header) {
        return FileChecker.startsWithCopyrightHeader(content, header, 0);
    }

    private static boolean startsWithCopyrightHeader(String content, String header, int offset) {
        if (content.startsWith(header, offset)) {
            return true;
        }
        return content.startsWith(header.replace(" 2016 ", " 2017 "), offset);
    }

    private static boolean canContainBannedWord(Path path) {
        String[] whiteList;
        switch (MODE) {
            case XSEMANTICS: {
                whiteList = XSEMANTICS_BANNED_WORDS_WHITELIST;
                break;
            }
            case Xpect: {
                whiteList = Xpect_BANNED_WORDS_WHITELIST;
                break;
            }
            default: {
                whiteList = BANNED_WORDS_WHITELIST;
            }
        }
        String[] stringArray = whiteList;
        int n = whiteList.length;
        int n2 = 0;
        while (n2 < n) {
            String whitelisted = stringArray[n2];
            if (path.endsWith(whitelisted)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String containsBannedWord(Path path, String content) {
        return FileChecker.containsWord(path, content, true, BANNED_WORDS);
    }

    private static String containsWord(Path path, String content, boolean skipCopyrightHeader, String ... words) {
        int idx;
        if (skipCopyrightHeader) {
            int beginIndex = FileChecker.beginIndexWithoutCopyrightHeader(path, content);
            content = content.substring(beginIndex);
            if (FileChecker.hasExtension(path, ".xcore")) {
                content = content.replace("copyrightFields=\"false\",", "");
                content = content.replace(COPYRIGHT_GEN_MODEL_PROPERTY, "");
                content = content.replace(COPYRIGHT_GEN_MODEL_PROPERTY.replace(" 2016 ", " 2017 "), "");
            }
        }
        if (FileChecker.hasExtension(path, ".xsemantics") && (idx = content.indexOf(COPYRIGHT_KEYWORD_IN_XSEMANTICS)) >= 0) {
            content = String.valueOf(content.substring(0, idx)) + content.substring(idx + COPYRIGHT_KEYWORD_IN_XSEMANTICS.length());
        }
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (content.contains(word) || content.contains(word.toLowerCase()) || content.contains(word.toUpperCase())) {
                return word;
            }
            ++n2;
        }
        return null;
    }

    private int countSubstring(String content, String substr) {
        int cnt = 0;
        int i = 0;
        while ((i = content.indexOf(substr, i)) >= 0) {
            ++cnt;
            i += substr.length();
        }
        return cnt;
    }

    public static void main(String[] args) {
        boolean success = new FileChecker().run(args);
        System.exit(success ? 0 : 1);
    }

    private static enum Mode {
        NORMAL,
        XSEMANTICS,
        Xpect;

    }
}

