/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.n4js.smith.ui.ASTGraphProvider;
import org.eclipse.n4js.smith.ui.Activator;
import org.eclipse.n4js.smith.ui.CFGraphProvider;
import org.eclipse.n4js.smith.ui.editoroverlay.EditorOverlay;
import org.eclipse.n4js.smith.ui.graph.ASTGraph;
import org.eclipse.n4js.smith.ui.graph.CFGraph;
import org.eclipse.n4js.smith.ui.graph.Graph;
import org.eclipse.n4js.smith.ui.graph.GraphList;
import org.eclipse.n4js.smith.ui.graph.GraphProvider;
import org.eclipse.n4js.smith.ui.graph.GraphType;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class SourceGraphView
extends ViewPart {
    private GraphList graphList;
    private ASTGraphProvider astGraphProvider;
    private CFGraphProvider cfGraphProvider;
    private XtextEditor activeEditor = null;
    private boolean paused = true;
    private final DateFormat dateFormat = new SimpleDateFormat("hh:mm:ss.SSS");
    private final EditorOverlay editorOverlay = new EditorOverlay();

    public SourceGraphView() {
        Activator.getInstance().setViewInstance(this);
    }

    private void updateActiveEditor() {
        XtextEditor xeddy;
        IWorkbenchPartSite site = this.getSite();
        IWorkbenchPage page = site != null ? site.getPage() : null;
        IEditorPart eddy = page != null ? page.getActiveEditor() : null;
        XtextEditor xtextEditor = xeddy = eddy instanceof XtextEditor ? (XtextEditor)eddy : null;
        if (this.activeEditor != xeddy) {
            this.activeEditor = xeddy;
            this.onActiveEditorChanged();
        }
    }

    protected void onActiveEditorChanged() {
    }

    public void createPartControl(Composite parent) {
        this.getSite().getPage().addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                SourceGraphView.this.updateActiveEditor();
            }

            public void partDeactivated(IWorkbenchPart part) {
                SourceGraphView.this.updateActiveEditor();
            }

            public void partOpened(IWorkbenchPart part) {
                SourceGraphView.this.updateActiveEditor();
            }

            public void partClosed(IWorkbenchPart part) {
                SourceGraphView.this.updateActiveEditor();
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }
        });
        this.graphList = new GraphList(parent, 0, this.editorOverlay);
        this.astGraphProvider = new ASTGraphProvider();
        this.cfGraphProvider = new CFGraphProvider();
        this.createAction("AST Snapshot", 1, "Take an AST snapshot.", Activator.getInstance().ICON_GRAPH_AST, this::onTakeASTSnapshot);
        this.createAction("CFG Snapshot", 1, "Take a CFG snapshot.", Activator.getInstance().ICON_GRAPH_CF, this::onTakeCFGSnapshot);
        this.createAction("Pause", 2, "Suspend accepting snapshots that were triggered programmatically.", Activator.getInstance().ICON_PAUSE, this::onPause).setChecked(this.paused);
        this.createAction("Delete", 1, "Delete selected snapshots from history.", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"), this::onDelete);
    }

    private Action createAction(String label, int style, String tooltip, ImageDescriptor image, final Consumer<Action> onRun) {
        Action result = new Action(label, style){

            public void run() {
                onRun.accept(this);
            }
        };
        result.setText(label);
        result.setToolTipText(tooltip);
        result.setImageDescriptor(image);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)result);
        return result;
    }

    public static final void show(String label, Object root) {
        SourceGraphView view = SourceGraphView.findInstance();
        if (view != null && !view.paused) {
            view.showASTGraph(label, root);
        }
    }

    public void showASTGraph(String label, Object root) {
        if (!(root instanceof ResourceSet || root instanceof Resource || root instanceof EObject)) {
            throw new IllegalArgumentException("root must be a ResourceSet, Resource, or EObject");
        }
        if (this.graphList.isDisposed()) {
            return;
        }
        ASTGraph graph = new ASTGraph();
        GraphType graphType = GraphType.AST;
        graph.build(this.astGraphProvider, root);
        this.showGraph(label, graph, graphType);
    }

    public <GP extends GraphProvider<?, ?>> void showGraph(String label, Graph<GP> graph, GraphType graphType, GP graphProvider, Object root) {
        ResourceSet rs;
        if (!(root instanceof ResourceSet || root instanceof Resource || root instanceof EObject)) {
            throw new IllegalArgumentException("root must be a ResourceSet, Resource, or EObject");
        }
        if (this.graphList.isDisposed()) {
            return;
        }
        ResourceType resourceType = null;
        if (root instanceof ResourceSet) {
            rs = (ResourceSet)root;
            if (rs.getResources().isEmpty()) {
                return;
            }
            resourceType = ResourceType.getResourceType((Resource)((Resource)rs.getResources().get(0)));
        }
        if (root instanceof Resource) {
            rs = (Resource)root;
            resourceType = ResourceType.getResourceType((Resource)rs);
        }
        if (root instanceof EObject) {
            EObject eo = (EObject)root;
            resourceType = ResourceType.getResourceType((EObject)eo);
        }
        if (resourceType != null) {
            boolean supportedCFG = false;
            supportedCFG |= resourceType == ResourceType.JS;
            supportedCFG |= resourceType == ResourceType.JSX;
            supportedCFG |= resourceType == ResourceType.N4JS;
            if (supportedCFG |= resourceType == ResourceType.N4JSX) {
                graph.build(graphProvider, root);
                this.showGraph(label, graph, graphType);
            }
        }
    }

    public void showGraph(final String label, final Graph<?> graph, final GraphType graphType) {
        if (this.graphList.isDisposed()) {
            return;
        }
        final String prefix = String.valueOf(this.getTimeStamp()) + ": ";
        if (Display.getCurrent() != null) {
            this.graphList.addGraph(String.valueOf(prefix) + label, graph, graphType, true);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SourceGraphView.this.graphList.addGraph(String.valueOf(prefix) + label, graph, graphType, true);
                }
            });
        }
    }

    protected String getTimeStamp() {
        return this.dateFormat.format(new Date());
    }

    public void setFocus() {
        this.graphList.setFocus();
    }

    protected void onTakeASTSnapshot(Action action) {
        if (this.activeEditor != null) {
            this.activeEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

                public Boolean exec(XtextResource state) throws Exception {
                    SourceGraphView.this.showGraph("manual", new ASTGraph(), GraphType.AST, SourceGraphView.this.astGraphProvider, state.getResourceSet());
                    return null;
                }
            });
        }
    }

    protected void onTakeCFGSnapshot(Action action) {
        if (this.activeEditor != null) {
            this.activeEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

                public Boolean exec(XtextResource state) throws Exception {
                    SourceGraphView.this.showGraph("manual", new CFGraph(), GraphType.CFG, SourceGraphView.this.cfGraphProvider, state.getResourceSet());
                    return null;
                }
            });
        }
    }

    protected void onTakeDFGSnapshot(Action action) {
        if (this.activeEditor != null) {
            this.activeEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

                public Boolean exec(XtextResource state) throws Exception {
                    SourceGraphView.this.showGraph("manual", new ASTGraph(), GraphType.DFG, SourceGraphView.this.astGraphProvider, state.getResourceSet());
                    return null;
                }
            });
        }
    }

    protected void onPause(Action action) {
        this.paused = action.isChecked();
    }

    protected void onDelete(Action action) {
        this.graphList.removeSelectedGraphs(true);
    }

    private static final SourceGraphView findInstance() {
        return Activator.getInstance().getViewInstance();
    }
}

