/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.typesbuilder;

import com.google.inject.Inject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesbuilder.AbstractFunctionDefinitionTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
class N4JSGetterTypesBuilder extends AbstractFunctionDefinitionTypesBuilder {
  @Inject
  @Extension
  private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;
  
  boolean relinkGetter(final N4GetterDeclaration n4Getter, final TClassifier classifierType, final boolean preLinkingPhase, final int idx) {
    if (((n4Getter.getName() == null) && (!n4Getter.hasComputedPropertyName()))) {
      return false;
    }
    TMember _get = classifierType.getOwnedMembers().get(idx);
    final TGetter getterType = ((TGetter) _get);
    this._n4JSTypesBuilderHelper.ensureEqualName(n4Getter, getterType);
    getterType.setAstElement(n4Getter);
    n4Getter.setDefinedGetter(getterType);
    return true;
  }
  
  TGetter createGetter(final N4GetterDeclaration n4Getter, final TClassifier classifierType, final boolean preLinkingPhase) {
    TGetter _xblockexpression = null;
    {
      if (((n4Getter.getName() == null) && (!n4Getter.hasComputedPropertyName()))) {
        return null;
      }
      final TGetter getterType = TypesFactory.eINSTANCE.createTGetter();
      this._n4JSTypesBuilderHelper.setMemberName(getterType, n4Getter);
      getterType.setDeclaredAbstract(n4Getter.isAbstract());
      getterType.setDeclaredStatic(n4Getter.isDeclaredStatic());
      getterType.setDeclaredFinal(n4Getter.isDeclaredFinal());
      getterType.setOptional(n4Getter.isOptional());
      getterType.setDeclaredOverride(AnnotationDefinition.OVERRIDE.hasAnnotation(n4Getter));
      getterType.setHasNoBody(((n4Getter.getBody() == null) && (!AnnotationDefinition.PROVIDES_DEFAULT_IMPLEMENTATION.hasAnnotation(n4Getter))));
      final BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get(n4Getter.eResource().getResourceSet());
      this.setMemberAccessModifier(getterType, n4Getter);
      this.setReturnTypeConsideringThis(getterType, n4Getter, builtInTypeScope, preLinkingPhase);
      this._n4JSTypesBuilderHelper.setDeclaredThisTypeFromAnnotation(getterType, n4Getter, preLinkingPhase);
      this._n4JSTypesBuilderHelper.copyAnnotations(getterType, n4Getter, preLinkingPhase);
      getterType.setAstElement(n4Getter);
      n4Getter.setDefinedGetter(getterType);
      _xblockexpression = getterType;
    }
    return _xblockexpression;
  }
  
  private void setMemberAccessModifier(final TGetter getterType, final N4GetterDeclaration n4Getter) {
    final Procedure1<MemberAccessModifier> _function = (MemberAccessModifier modifier) -> {
      getterType.setDeclaredMemberAccessModifier(modifier);
    };
    this._n4JSTypesBuilderHelper.setMemberAccessModifier(_function, n4Getter.getDeclaredModifiers(), n4Getter.getAnnotations());
  }
  
  /**
   * Sets the return type. If the declared return type is 'this', a ComputedTypeRef will
   * be created to generate a bound this type.
   */
  private void setReturnTypeConsideringThis(final TGetter getterType, final N4GetterDeclaration getterDecl, final BuiltInTypeScope builtInTypeScope, final boolean preLinkingPhase) {
    TypeRef _declaredTypeRef = getterDecl.getDeclaredTypeRef();
    if ((_declaredTypeRef instanceof ThisTypeRef)) {
      getterType.setDeclaredTypeRef(TypeUtils.createDeferredTypeRef());
    } else {
      this.setReturnType(getterType, getterDecl, builtInTypeScope, preLinkingPhase);
    }
  }
}
