/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.validation;

import com.google.common.base.Objects;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.typesystem.utils.Result;
import org.eclipse.n4js.utils.validation.DelegatingValidationMessageAcceptor;
import org.eclipse.n4js.validation.AbstractN4JSValidator;
import org.eclipse.n4js.validation.validators.IDEBUGValidator;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class AbstractMessageAdjustingN4JSValidator extends AbstractN4JSValidator {
  /**
   * This class introduces for reuse the utility method {@link #isCanceled}
   */
  protected static class MethodWrapperCancelable extends AbstractDeclarativeValidator.MethodWrapper {
    protected MethodWrapperCancelable(final AbstractDeclarativeValidator instance, final Method m) {
      super(instance, m);
    }
    
    /**
     * Returns the {@link CancelIndicator} tracked by the current {@link State}.
     * <p>
     * Before calling a validation method, this method is used to check for pending cancellation requests.
     * To keep the UI responsive, such request may be serviced by
     * (a) skipping validation; or (b) throwing a {@code OperationCanceledException} or {@code OperationCanceledError}.
     */
    protected CancelIndicator getCancelIndicator(final AbstractDeclarativeValidator.State state) {
      if ((null != state.context)) {
        Object _get = state.context.get(CancelableDiagnostician.CANCEL_INDICATOR);
        final CancelIndicator cancelIndicator = ((CancelIndicator) _get);
        if ((null != cancelIndicator)) {
          return cancelIndicator;
        }
      }
      return null;
    }
  }
  
  public boolean createTypeError(final Result result, final EObject source) {
    boolean _xblockexpression = false;
    {
      boolean _isFailure = result.isFailure();
      if (_isFailure) {
        final String msg = result.getCompiledFailureMessage();
        this.getMessageAcceptor().acceptError(msg, source, null, 
          ValidationMessageAcceptor.INSIGNIFICANT_INDEX, "org.eclipse.n4js.TypeErrorIssueCode");
        return true;
      }
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  public AbstractMessageAdjustingN4JSValidator() {
    abstract class __AbstractMessageAdjustingN4JSValidator_1 extends DelegatingValidationMessageAcceptor {
      __AbstractMessageAdjustingN4JSValidator_1(final ValidationMessageAcceptor arg0) {
        super(arg0);
      }
      
      abstract String adjustedBug(final String message, final EObject source, final Severity severity);
    }
    
    ValidationMessageAcceptor _messageAcceptor = this.getMessageAcceptor();
    __AbstractMessageAdjustingN4JSValidator_1 ___AbstractMessageAdjustingN4JSValidator_1 = new __AbstractMessageAdjustingN4JSValidator_1(_messageAcceptor) {
      @Override
      public void acceptError(final String message, final EObject object, final int offset, final int length, final String code, final String... issueData) {
        final String bugMessage = this.adjustedBug(message, object, Severity.ERROR);
        if ((bugMessage != null)) {
          this.delegate.acceptWarning(bugMessage, object, offset, length, code, issueData);
        } else {
          this.delegate.acceptError(message, object, offset, length, code, issueData);
        }
      }
      
      @Override
      public void acceptError(final String message, final EObject object, final EStructuralFeature feature, final int index, final String code, final String... issueData) {
        final String bugMessage = this.adjustedBug(message, object, Severity.ERROR);
        if ((bugMessage != null)) {
          this.delegate.acceptWarning(bugMessage, object, feature, index, code, issueData);
        } else {
          this.delegate.acceptError(message, object, feature, index, code, issueData);
        }
      }
      
      String adjustedBug(final String message, final EObject source, final Severity severity) {
        boolean _equals = Objects.equal(severity, Severity.ERROR);
        if (_equals) {
          final AnnotableElement annotableElement = EcoreUtil2.<AnnotableElement>getContainerOfType(source, AnnotableElement.class);
          final Iterable<Annotation> idebugs = AnnotationDefinition.IDEBUG.getAllAnnotations(annotableElement);
          final Function1<Annotation, Boolean> _function = (Annotation a) -> {
            int _size = a.getArgs().size();
            boolean _equals_1 = (_size == 2);
            if (_equals_1) {
              final String filterMessageText = a.getArgs().get(1).getValueAsString();
              boolean _endsWith = filterMessageText.endsWith("…");
              if (_endsWith) {
                int _length = filterMessageText.length();
                int _minus = (_length - 1);
                return Boolean.valueOf(message.startsWith(filterMessageText.substring(0, _minus)));
              } else {
                return Boolean.valueOf(message.equals(filterMessageText));
              }
            }
            return Boolean.valueOf(false);
          };
          final Annotation annotation = IterableExtensions.<Annotation>head(IterableExtensions.<Annotation>filter(idebugs, _function));
          if ((null != annotation)) {
            IDEBUGValidator.getUsedAnnotations(AbstractMessageAdjustingN4JSValidator.this.getContext()).add(annotation);
            final String bugID = annotation.getArgs().get(0).getValueAsString();
            return ((("IDEBUG-" + bugID) + ": ") + message);
          }
        }
        return null;
      }
    };
    this.setMessageAcceptor(___AbstractMessageAdjustingN4JSValidator_1);
  }
  
  @Override
  protected List<EPackage> getEPackages() {
    final List<EPackage> result = super.getEPackages();
    result.add(EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/n4js/utils/Validation"));
    return result;
  }
}
