/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.tests.helper.documentprovider;

import com.google.common.base.Objects;
import org.eclipse.core.internal.events.NotificationManager;
import org.eclipse.core.internal.events.ResourceChangeEvent;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IResourceChangeEvent;

/**
 * This class counts the number of broadcastChange method calls.
 */
@SuppressWarnings("all")
public class CountPostChangeBroadcastChangeNotificationManager extends NotificationManager {
  private Thread mainThread;
  
  private int countPostChangeBroadcastTriggered;
  
  public CountPostChangeBroadcastChangeNotificationManager(final Workspace workspace, final Thread mainThread) {
    super(workspace);
    this.mainThread = mainThread;
  }
  
  @Override
  public void broadcastChanges(final ElementTree lastState, final ResourceChangeEvent event, final boolean lockTree) {
    if ((Objects.equal(Thread.currentThread(), this.mainThread) && (event.getType() == IResourceChangeEvent.POST_CHANGE))) {
      this.countPostChangeBroadcastTriggered++;
    }
    super.broadcastChanges(lastState, event, lockTree);
  }
  
  public int numberPostChangeTriggered() {
    return this.countPostChangeBroadcastTriggered;
  }
}
