/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;
import org.eclipse.xtext.validation.Issue;
import org.junit.Assert;

public class N4JSValidationTestHelper
extends ValidationTestHelper {
    public void assertNoIssuesExcept(EObject model, String ... exceptionIssueCodes) {
        Resource resource = model.eResource();
        List issues = this.validate(resource);
        if (this.removeIssuesWithCode(issues, exceptionIssueCodes).size() > 0) {
            Assert.fail((String)("Expected no issues, but got :" + this.getIssuesAsString(resource, issues, new StringBuilder())));
        }
    }

    private List<Issue> removeIssuesWithCode(List<Issue> issues, String ... codes) {
        List<String> excludedIssueCodesList = Arrays.asList(codes);
        return issues.stream().filter(issue -> !excludedIssueCodesList.contains(issue.getCode())).collect(Collectors.toList());
    }

    public void assertNoDanglingReferences(EObject root) {
        ArrayList<String> errMsgs = new ArrayList<String>();
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            EObject currObj = (EObject)iter.next();
            if (currObj == null || currObj.eIsProxy()) continue;
            block1: for (EReference currRef : currObj.eClass().getEAllReferences()) {
                if (currRef.isContainment() || currRef.isContainer() || currRef.getEOpposite() != null) continue;
                if (currRef.isMany()) {
                    EList targets = (EList)currObj.eGet((EStructuralFeature)currRef, false);
                    for (EObject currTarget : targets) {
                        if (!N4JSValidationTestHelper.isDangling(currTarget)) continue;
                        errMsgs.add(N4JSValidationTestHelper.getErrorInfoForDanglingEObject(currObj, currRef));
                        continue block1;
                    }
                    continue;
                }
                EObject target = (EObject)currObj.eGet((EStructuralFeature)currRef, false);
                if (!N4JSValidationTestHelper.isDangling(target)) continue;
                errMsgs.add(N4JSValidationTestHelper.getErrorInfoForDanglingEObject(currObj, currRef));
            }
        }
        if (!errMsgs.isEmpty()) {
            Assert.fail((String)("Expected no dangling references, but found the following: " + Joiner.on((String)"; ").join(errMsgs) + "."));
        }
    }

    private static final boolean isDangling(EObject target) {
        return target != null && target.eResource() == null;
    }

    private static final String getErrorInfoForDanglingEObject(EObject base, EReference ref) {
        return "in " + base.eClass().getName() + " at " + EcoreUtil.getURI((EObject)base) + " via reference " + ref.getName();
    }
}

