/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.organize.imports;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.n4js.ui.organize.imports.BreakException;
import org.eclipse.n4js.ui.organize.imports.Interaction;
import org.eclipse.n4js.ui.organize.imports.MultiElementListSelectionDialog;
import org.eclipse.n4js.utils.collections.Multimaps3;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Utility for handling disambiguation of the imports.
 */
@SuppressWarnings("all")
public class DisambiguateUtil {
  /**
   * Depending on interaction-mode:
   * Present a user dialog and let the user choose a distinct import for each unresolved problem.
   * 
   * For each key in {@code multiMap} exactly one solution is returned.
   */
  public static <T extends Object> List<T> disambiguate(final Multimap<String, T> multiMapName2Candidates, final Interaction interaction, final ILabelProvider importProvidedElementLabelprovider) throws BreakException {
    boolean _isEmpty = multiMapName2Candidates.isEmpty();
    if (_isEmpty) {
      return CollectionLiterals.<T>newArrayList();
    }
    if (interaction != null) {
      switch (interaction) {
        case breakBuild:
          List<String> _list = IterableExtensions.<String>toList(multiMapName2Candidates.keySet());
          String _plus = ("Cannot automatically disambiguate the imports of " + _list);
          throw new BreakException(_plus);
        case takeFirst:
          return DisambiguateUtil.<T>takefirst(multiMapName2Candidates);
        case queryUser:
          return DisambiguateUtil.<T>askUser(multiMapName2Candidates, importProvidedElementLabelprovider);
        default:
          throw new RuntimeException(("Unsupported interaction " + interaction));
      }
    } else {
      throw new RuntimeException(("Unsupported interaction " + interaction));
    }
  }
  
  /**
   * Takes first result available.
   */
  private static <T extends Object> List<T> askUser(final Multimap<String, T> multimap, final ILabelProvider importProvidedElementLabelprovider) throws BreakException.UserCanceledBreakException {
    final ArrayList<T> result = CollectionLiterals.<T>newArrayList();
    final Object[][] openChoices = Multimaps3.<T>createOptions(multimap);
    final MultiElementListSelectionDialog dialog = new MultiElementListSelectionDialog(null, importProvidedElementLabelprovider);
    dialog.setTitle("Organize Imports");
    dialog.setMessage("Choose type to import:");
    dialog.setElements(openChoices);
    int _open = dialog.open();
    boolean _equals = (_open == Window.OK);
    if (_equals) {
      final Object[] res = dialog.getResult();
      for (int i = 0; (i < res.length); i++) {
        {
          Object _get = res[i];
          final Object[] array = ((Object[]) _get);
          int _length = array.length;
          boolean _greaterThan = (_length > 0);
          if (_greaterThan) {
            Object _get_1 = array[0];
            result.add(((T) _get_1));
          }
        }
      }
    } else {
      throw new BreakException.UserCanceledBreakException("User canceled.");
    }
    return result;
  }
  
  /**
   * Takes first result available.
   */
  private static <T extends Object> List<T> takefirst(final Multimap<String, T> multimap) {
    final ArrayList<T> result = CollectionLiterals.<T>newArrayList();
    Set<String> _keySet = multimap.keySet();
    for (final String name : _keySet) {
      T _head = IterableExtensions.<T>head(multimap.get(name));
      result.add(_head);
    }
    return result;
  }
}
