/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.n4js.formatting2.N4JSFormatterPreferenceKeys;
import org.eclipse.n4js.xpect.config.Preference;
import org.eclipse.n4js.xpect.config.Preferences;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.expectation.impl.TargetSyntaxSupport;
import org.eclipse.xpect.parameter.IStatementRelatedRegion;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.util.XtextTargetSyntaxSupport;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ExceptionAcceptor;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegion;

@XpectImport(value={TextRegionAccessFactory.class, Preferences.class, Preference.class})
public class FormatterXpectMethod {
    @Inject
    private Provider<IFormatter2> formatterProvider;
    @Inject
    private Provider<FormatterRequest> formatterRequestProvider;

    @Xpect
    @ParameterParser(syntax="arg1=INT")
    public void formattedLines(@StringExpectation(whitespaceSensitive=true) IStringExpectation exp, int lines, XpectInvocation inv, TargetSyntaxSupport syntax, ITextRegionAccess reg, ISetupInitializer<Preferences> prefInit) {
        ITextSegment region = this.findRegion(lines, inv, syntax, reg);
        Preferences prefs = new Preferences();
        prefs.put(N4JSFormatterPreferenceKeys.FORMAT_PARENTHESIS, true);
        prefs.put(FormatterPreferenceKeys.lineSeparator, "\n");
        prefInit.initialize((Object)prefs);
        IFormatter2 formatter = (IFormatter2)this.formatterProvider.get();
        FormatterRequest request = (FormatterRequest)this.formatterRequestProvider.get();
        request.setTextRegionAccess(reg);
        request.setExceptionHandler((IAcceptor)ExceptionAcceptor.THROWING);
        request.setAllowIdentityEdits(true);
        request.setFormatUndefinedHiddenRegionsOnly(false);
        request.addRegion((ITextRegion)region);
        request.setPreferences((ITypedPreferenceValues)prefs);
        List replacements = formatter.format(request);
        String fmt = reg.getRewriter().renderToString((Iterable)replacements);
        ITextSegment doc = reg.regionForDocument();
        int endIndex = region.getEndOffset() + (fmt.length() - doc.getLength()) - 1;
        String selection = fmt.substring(region.getOffset(), endIndex);
        exp.assertEquals((Object)selection);
    }

    private ITextSegment findRegion(int lines, XpectInvocation inv, TargetSyntaxSupport syntax, ITextRegionAccess reg) {
        XtextResource resource = ((XtextTargetSyntaxSupport)syntax).getResource();
        IStatementRelatedRegion region2 = inv.getExtendedRegion();
        int end = region2.getOffset() + region2.getLength();
        ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)end);
        int offset = node.getTotalEndOffset();
        ITextSegment region = this.getRegionForLines(reg, offset, lines);
        return region;
    }

    private ITextSegment getRegionForLines(ITextRegionAccess regions, int offset, int lines) {
        ILineRegion firstLine;
        ILineRegion lastLine = firstLine = regions.regionForLineAtOffset(offset);
        int i = 1;
        while (i < lines) {
            ILineRegion next = lastLine.getNextLine();
            if (next == null) break;
            lastLine = next;
            ++i;
        }
        int firstLineOffset = firstLine.getOffset();
        ITextSegment region = regions.regionForOffset(firstLineOffset, lastLine.getEndOffset() - firstLineOffset + 1);
        return region;
    }

    @XpectSetupFactory
    public static class TextRegionAccessFactory {
        private final ITextRegionAccess regionAccess;

        public TextRegionAccessFactory(@ThisResource XtextResource resource) {
            TextRegionAccessBuilder builder = (TextRegionAccessBuilder)resource.getResourceServiceProvider().get(TextRegionAccessBuilder.class);
            this.regionAccess = builder.forNodeModel(resource).create();
        }

        @Creates
        public ITextRegionAccess getTextRegionAccess() {
            return this.regionAccess;
        }
    }
}

