/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.json.parser.antlr;

import com.google.inject.Inject;
import org.eclipse.n4js.json.parser.antlr.internal.InternalJSONParser;
import org.eclipse.n4js.json.services.JSONGrammarAccess;
import org.eclipse.xtext.parser.antlr.AbstractAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;

public class JSONParser extends AbstractAntlrParser {

	@Inject
	private JSONGrammarAccess grammarAccess;

	@Override
	protected void setInitialHiddenTokens(XtextTokenStream tokenStream) {
		tokenStream.setInitialHiddenTokens("RULE_WS", "RULE_EOL", "RULE_ML_COMMENT", "RULE_SL_COMMENT");
	}
	

	@Override
	protected InternalJSONParser createParser(XtextTokenStream stream) {
		return new InternalJSONParser(stream, getGrammarAccess());
	}

	@Override 
	protected String getDefaultRuleName() {
		return "JSONDocument";
	}

	public JSONGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(JSONGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
}
