/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.tests.codegen;

import java.util.List;
import org.eclipse.n4js.tests.codegen.Classifier;
import org.eclipse.n4js.tests.codegen.Interface;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Generates the code for a class.
 */
@SuppressWarnings("all")
public class Class extends Classifier<Class> {
  private String superClass;
  
  private List<String> implementedInterfaces;
  
  /**
   * Creates a new instance with the given parameters.
   * 
   * @param name the name of the class
   */
  public Class(final String name) {
    super(name);
  }
  
  /**
   * Sets the super class.
   * 
   * @param superClass the super class or interface.
   */
  public Class setSuperClass(final Class superClass) {
    return this.setSuperClass(superClass.getName());
  }
  
  /**
   * Sets the super class.
   * 
   * @param superClass the name of the super class or interface.
   */
  public Class setSuperClass(final String superClass) {
    this.superClass = superClass;
    return this;
  }
  
  /**
   * Adds an interface implemented by the class to be built.
   * 
   * @param implementedInterface the name of the interface to implement
   * 
   * @return this builder
   */
  public Class addInterface(final Interface implementedInterface) {
    return this.addInterface(implementedInterface.getName());
  }
  
  /**
   * Adds an interface implemented by the class to be built.
   * 
   * @param implementedInterface the interface to implement
   */
  public Class addInterface(final String implementedInterface) {
    if ((this.implementedInterfaces == null)) {
      this.implementedInterfaces = CollectionLiterals.<String>newLinkedList();
    }
    this.implementedInterfaces.add(implementedInterface);
    return this;
  }
  
  @Override
  protected CharSequence generateType() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("class ");
    return _builder;
  }
  
  @Override
  protected CharSequence generateTypeRelations() {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generateSuperClass = this.generateSuperClass();
    _builder.append(_generateSuperClass);
    CharSequence _generateImplementedInterfaces = this.generateImplementedInterfaces();
    _builder.append(_generateImplementedInterfaces);
    return _builder;
  }
  
  private CharSequence generateSuperClass() {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(this.superClass);
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        _builder.append(" extends ");
        _builder.append(this.superClass);
      }
    }
    return _builder;
  }
  
  private CharSequence generateImplementedInterfaces() {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.implementedInterfaces);
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        {
          boolean _hasElements = false;
          for(final String i : this.implementedInterfaces) {
            if (!_hasElements) {
              _hasElements = true;
              _builder.append(" implements ");
            } else {
              _builder.appendImmediate(", ", "");
            }
            _builder.append(i);
          }
        }
      }
    }
    return _builder;
  }
}
