/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.tests.parser;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.N4JSInjectorProvider;
import org.eclipse.n4js.N4JSParseHelper;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.testing.InjectWith;
import org.eclipse.xtext.testing.XtextRunner;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(XtextRunner.class)
@InjectWith(N4JSInjectorProvider.class)
@SuppressWarnings("all")
public abstract class AbstractParserTest extends Assert {
  @Inject
  @Extension
  protected N4JSParseHelper _n4JSParseHelper;
  
  protected Script parseJSSuccessfully(final CharSequence js) {
    try {
      final Script script = this._n4JSParseHelper.parseUnrestricted(js);
      final Function1<Resource.Diagnostic, CharSequence> _function = (Resource.Diagnostic it) -> {
        int _line = it.getLine();
        String _plus = (Integer.valueOf(_line) + ": ");
        String _message = it.getMessage();
        return (_plus + _message);
      };
      Assert.assertTrue(IterableExtensions.<Resource.Diagnostic>join(script.eResource().getErrors(), "\n", _function), script.eResource().getErrors().isEmpty());
      return script;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected Script parseJSWithError(final CharSequence js) {
    try {
      final Script script = this._n4JSParseHelper.parseUnrestricted(js);
      final EList<Resource.Diagnostic> errors = script.eResource().getErrors();
      Assert.assertFalse(errors.toString(), errors.isEmpty());
      return script;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected Script parseESSuccessfully(final CharSequence js) {
    return this.parseJSSuccessfully(js);
  }
  
  protected Script parseESWithError(final CharSequence js) {
    return this.parseJSWithError(js);
  }
  
  protected Script parseN4jsSuccessfully(final CharSequence js) {
    try {
      final Script script = this._n4JSParseHelper.parseN4js(js);
      final Function1<Resource.Diagnostic, CharSequence> _function = (Resource.Diagnostic it) -> {
        int _line = it.getLine();
        String _plus = (Integer.valueOf(_line) + ": ");
        String _message = it.getMessage();
        return (_plus + _message);
      };
      Assert.assertTrue(IterableExtensions.<Resource.Diagnostic>join(script.eResource().getErrors(), "\n", _function), script.eResource().getErrors().isEmpty());
      return script;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected Script parseN4jsWithError(final CharSequence js) {
    try {
      final Script script = this._n4JSParseHelper.parseN4js(js);
      final EList<Resource.Diagnostic> errors = script.eResource().getErrors();
      Assert.assertFalse(errors.toString(), errors.isEmpty());
      return script;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * Used in tests to eliminate the suspicious paren expression
   */
  protected Expression unwrap(final Expression it) {
    boolean _matched = false;
    if (it instanceof ParenExpression) {
      _matched=true;
      return ((ParenExpression)it).getExpression();
    }
    Assert.fail(("Expected ParenExpression but got" + it));
    return null;
  }
  
  protected String getText(final Expression it) {
    return NodeModelUtils.getTokenText(NodeModelUtils.findActualNodeFor(it));
  }
  
  protected String getPropertyText(final ParameterizedPropertyAccessExpression it) {
    return NodeModelUtils.getTokenText(
      IterableExtensions.<INode>head(NodeModelUtils.findNodesForFeature(it, N4JSPackage.Literals.PARAMETERIZED_PROPERTY_ACCESS_EXPRESSION__PROPERTY)));
  }
}
