/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.n4js.ts.ui.search.LabelledReferenceDescription;
import org.eclipse.n4js.ui.labeling.N4JSLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.label.DefaultDescriptionLabelProvider;
import org.eclipse.xtext.ui.label.DefaultEditorImageUtil;
import org.eclipse.xtext.xbase.lib.InputOutput;

/**
 * Provides labels for a IEObjectDescriptions and IResourceDescriptions.
 * <br/><br/>
 * Everytime \@org.eclipse.xtext.ui.resource.ResourceServiceDescriptionLabelProvider private ILabelProvider labelProvider;
 * is used this label provider is injected.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#labelProvider
 */
@SuppressWarnings("all")
public class N4JSDescriptionLabelProvider extends DefaultDescriptionLabelProvider {
  @Inject
  private N4JSLabelProvider labelProvider;
  
  @Inject
  private DefaultEditorImageUtil imageUtil;
  
  @Override
  public Object text(final Object obj) {
    return InputOutput.<Object>println(obj);
  }
  
  /**
   * Custom label for labeled reference description.
   */
  public String text(final LabelledReferenceDescription description) {
    String _label = description.getLabel();
    String _plus = (_label + " : line number ");
    int _line = description.getLine();
    final String text = (_plus + Integer.valueOf(_line));
    return text;
  }
  
  /**
   * Custom image for labeled reference description. Reuse N4JSLabelProvider used by the outline view.
   */
  public Image image(final LabelledReferenceDescription element) {
    final Image image = this.labelProvider.getImage(element.getDisplayEObject());
    return image;
  }
  
  @Override
  public Image getImageForURI(final URI uri) {
    final String fileName = uri.lastSegment();
    final ImageDescriptor imageDescriptor = this.imageUtil.getDefaultEditorImageDescriptor(fileName);
    final Image image = this.convertToImage(imageDescriptor);
    return image;
  }
}
