/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.labeling.helper;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.n4js.ui.labeling.helper.ImageDescriptionHelper;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * Returns image descriptions for overlays used in this project.
 */
@SuppressWarnings("all")
public class N4JSImageDescriptionLibrary {
  @Extension
  private ImageDescriptionHelper imageDescriptionHelper;
  
  public void setImageDescriptionHelper(final ImageDescriptionHelper imageDescriptionHelper) {
    this.imageDescriptionHelper = imageDescriptionHelper;
  }
  
  public ImageDescriptor createAbstractImageDecorator() {
    return this.imageDescriptionHelper.createSimpleImageDescriptor("abstract_co.gif");
  }
  
  public ImageDescriptor createStaticImageDecorator() {
    return this.imageDescriptionHelper.createSimpleImageDescriptor("static_co.gif");
  }
  
  public ImageDescriptor createFinalImageDecorator() {
    return this.imageDescriptionHelper.createSimpleImageDescriptor("final_co.gif");
  }
  
  public ImageDescriptor createConstImageDecorator() {
    return this.imageDescriptionHelper.createSimpleImageDescriptor("c_ovr.gif");
  }
  
  public ImageDescriptor createPublicInternalVisibleImageDecorator() {
    return this.imageDescriptionHelper.createSimpleImageDescriptor("protected_co.gif");
  }
  
  public ImageDescriptor createProjectVisibleImageDecorator() {
    return this.imageDescriptionHelper.createSimpleImageDescriptor("default_co.gif");
  }
  
  public ImageDescriptor createPrivateVisibleImageDecorator() {
    return this.imageDescriptionHelper.createSimpleImageDescriptor("private_co.gif");
  }
  
  public ImageDescriptor createConstructorImageDecorator() {
    return this.imageDescriptionHelper.createSimpleImageDescriptor("c_ovr.gif");
  }
  
  public ImageDescriptor createSetterImageDecorator() {
    return this.imageDescriptionHelper.createSimpleImageDescriptor("function_ovr.gif");
  }
  
  public ImageDescriptor createGetterImageDecorator() {
    return this.imageDescriptionHelper.createSimpleImageDescriptor("function_inv_ovr.gif");
  }
}
