/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.xpect.ui.methods.quickfix;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * Tokenize on linebreak only.
 */
@SuppressWarnings("all")
public class LineBasedTokenizer implements Function<String, Iterable<String>> {
  @Override
  public Iterable<String> apply(final String input) {
    final Function1<String, List<String>> _function = (String it) -> {
      return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(it, "\n"));
    };
    return Iterables.<String>concat(ListExtensions.<String, List<String>>map(((List<String>)Conversions.doWrapArray(input.split("\\n"))), _function));
  }
}
