/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.utils.FindReferenceHelper;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.n4js.xpect.methods.scoping.IN4JSCommaSeparatedValuesExpectation;
import org.eclipse.n4js.xpect.methods.scoping.N4JSCommaSeparatedValuesExpectation;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.runner.XpectRunner;
import org.eclipse.xpect.xtext.lib.setup.XtextStandaloneSetup;
import org.eclipse.xpect.xtext.lib.setup.XtextWorkspaceSetup;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.junit.runner.RunWith;

@RunWith(value=XpectRunner.class)
@XpectImport(value={XtextStandaloneSetup.class, XtextWorkspaceSetup.class})
public class FindReferencesXpectMethod {
    @Inject
    private EObjectAtOffsetHelper offsetHelper;
    @Inject
    private FindReferenceHelper findReferenceHelper;

    @Xpect
    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    public void findReferences(@N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion offset) {
        EObject context = offset.getEObject();
        EObject argEObj = this.offsetHelper.resolveElementAt((XtextResource)context.eResource(), offset.getOffset());
        if (argEObj == null) {
            argEObj = context;
        }
        EObject eObj = argEObj;
        if (argEObj instanceof ParameterizedTypeRef) {
            eObj = ((ParameterizedTypeRef)argEObj).getDeclaredType();
        }
        List refs = this.findReferenceHelper.findReferences(eObj);
        ArrayList result = Lists.newArrayList();
        for (EObject ref : refs) {
            String moduleName;
            if (ref instanceof PropertyNameOwner) {
                ref = ((PropertyNameOwner)ref).getDeclaredName();
            }
            ICompositeNode srcNode = NodeModelUtils.getNode((EObject)ref);
            int line = srcNode.getStartLine();
            if (ref.eResource() instanceof N4JSResource) {
                N4JSResource n4jsResource = (N4JSResource)ref.eResource();
                moduleName = n4jsResource.getModule().getQualifiedName();
            } else {
                moduleName = "(unknown resource)";
            }
            String text = NodeModelUtils.getTokenText((INode)srcNode);
            if (ref instanceof GenericDeclaration) {
                text = ((GenericDeclaration)ref).getDefinedType().getName();
            }
            String resultText = String.valueOf(moduleName) + " - " + text + " - " + line;
            result.add(resultText);
        }
        expectation.assertEquals(result);
    }
}

