/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.utils;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.scoping.utils.ImportSpecifierUtil;
import org.eclipse.n4js.scoping.utils.ImportType;
import org.eclipse.n4js.scoping.utils.IssueCodeBasedEObjectDescription;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ProjectImportEnablingScope
implements IScope {
    private final IN4JSCore n4jsCore;
    private final IN4JSProject contextProject;
    private final Optional<ImportDeclaration> importDeclaration;
    private final IScope parent;
    private final IScope delegate;
    private final N4JSModel n4jsModel;

    public static IScope create(IN4JSCore n4jsCore, N4JSModel n4jsModel, Resource resource, Optional<ImportDeclaration> importDecl, IScope parent, IScope delegate) {
        if (n4jsCore == null || resource == null || importDecl == null || parent == null) {
            throw new IllegalArgumentException("none of the arguments may be null");
        }
        if (importDecl.isPresent() && ((ImportDeclaration)importDecl.get()).eResource() != resource) {
            throw new IllegalArgumentException("given import declaration must be contained in the given resource");
        }
        Optional<? extends IN4JSProject> contextProject = n4jsCore.findProject(resource.getURI());
        if (!contextProject.isPresent()) {
            return parent;
        }
        return new ProjectImportEnablingScope(n4jsCore, n4jsModel, (IN4JSProject)contextProject.get(), importDecl, parent, delegate);
    }

    private ProjectImportEnablingScope(IN4JSCore n4jsCore, N4JSModel n4jsModel, IN4JSProject contextProject, Optional<ImportDeclaration> importDecl, IScope parent, IScope delegate) {
        if (n4jsCore == null || contextProject == null || importDecl == null || parent == null) {
            throw new IllegalArgumentException("none of the arguments may be null");
        }
        this.n4jsCore = n4jsCore;
        this.n4jsModel = n4jsModel;
        this.contextProject = contextProject;
        this.parent = parent;
        this.importDeclaration = importDecl;
        this.delegate = delegate;
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        Iterable<IEObjectDescription> result = this.getElements(name);
        int size = Iterables.size(result);
        if (size == 1) {
            return result.iterator().next();
        }
        if (size == 2) {
            IEObjectDescription first = (IEObjectDescription)Iterables.get(result, (int)0);
            IEObjectDescription second = (IEObjectDescription)Iterables.get(result, (int)1);
            String firstExtension = first.getEObjectURI().fileExtension();
            String secondExtension = second.getEObjectURI().fileExtension();
            if ("js".equals(firstExtension) && "n4jsd".equals(secondExtension)) {
                return second;
            }
            if ("n4jsd".equals(firstExtension) && "js".equals(secondExtension)) {
                return first;
            }
        }
        if (!this.importDeclaration.isPresent()) {
            return null;
        }
        StringBuilder sbErrrorMessage = new StringBuilder("Cannot resolve import target ::");
        ImportType importType = this.computeImportType(name, this.contextProject);
        switch (importType) {
            case PROJECT_IMPORT: {
                sbErrrorMessage.append(" resolving project import :");
                break;
            }
            case COMPLETE_IMPORT: {
                sbErrrorMessage.append(" resolving full module import :");
                break;
            }
            case SIMPLE_IMPORT: {
                sbErrrorMessage.append(" resolving simple module import :");
                break;
            }
            case PROJECT_IMPORT_NO_MAIN: {
                sbErrrorMessage.append(" no main module in target project");
                break;
            }
            default: {
                sbErrrorMessage.append(" unrecognized import structure :");
            }
        }
        if (!importType.equals((Object)ImportType.PROJECT_IMPORT_NO_MAIN)) {
            if (size == 0) {
                sbErrrorMessage.append(" found no matching modules");
            } else {
                sbErrrorMessage.append(" found multiple matching modules ");
                sbErrrorMessage.append(IterableExtensions.join(result, (CharSequence)","));
            }
        }
        EObject originalProxy = (EObject)((ImportDeclaration)this.importDeclaration.get()).eGet((EStructuralFeature)N4JSPackage.eINSTANCE.getImportDeclaration_Module(), false);
        return new IssueCodeBasedEObjectDescription(EObjectDescription.create((String)"impDecl", (EObject)originalProxy), sbErrrorMessage.toString(), "IMP_UNRESOLVED");
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        switch (this.computeImportType(name, this.contextProject)) {
            case PROJECT_IMPORT: {
                String firstSegment = name.getFirstSegment();
                IN4JSProject targetProject = this.findProject(firstSegment, this.contextProject);
                QualifiedName mainModule = ImportSpecifierUtil.getMainModuleOfProject(targetProject);
                return this.getElementsWithDesiredProjectName(mainModule, targetProject.getProjectName());
            }
            case COMPLETE_IMPORT: {
                String firstSegment = name.getFirstSegment();
                IN4JSProject targetProject = this.findProject(firstSegment, this.contextProject);
                return this.getElementsWithDesiredProjectName(name.skipFirst(1), targetProject.getProjectName());
            }
            case SIMPLE_IMPORT: {
                return this.parent.getElements(name);
            }
        }
        return Collections.emptyList();
    }

    public IEObjectDescription getSingleElement(EObject object) {
        return this.parent.getSingleElement(object);
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        return this.parent.getElements(object);
    }

    public Iterable<IEObjectDescription> getAllElements() {
        return this.parent.getAllElements();
    }

    private Collection<IEObjectDescription> getElementsWithDesiredProjectName(QualifiedName moduleSpecifier, String projectName) {
        Iterable moduleSpecifierMatchesWithPossibleDuplicates = this.delegate.getElements(moduleSpecifier);
        HashMap<String, IEObjectDescription> result = new HashMap<String, IEObjectDescription>();
        for (IEObjectDescription desc : moduleSpecifierMatchesWithPossibleDuplicates) {
            IN4JSProject containingProject = (IN4JSProject)this.n4jsCore.findProject(desc.getEObjectURI()).orNull();
            if (containingProject == null || !projectName.equals(containingProject.getProjectName())) continue;
            result.put(desc.getEObjectURI().toString(), desc);
        }
        return result.values();
    }

    private IN4JSProject findProject(String projectName, IN4JSProject project) {
        if (Objects.equals(project.getProjectName(), projectName)) {
            return project;
        }
        Iterable<IN4JSProject> dependencies = this.n4jsModel.getSortedDependencies(project);
        for (IN4JSProject p : dependencies) {
            if (Objects.equals(p.getDefinesPackageName(), projectName)) {
                return p;
            }
            if (!Objects.equals(p.getProjectName(), projectName)) continue;
            return p;
        }
        return null;
    }

    private ImportType computeImportType(QualifiedName name, IN4JSProject project) {
        String firstSegment = name.getFirstSegment();
        IN4JSProject targetProject = this.findProject(firstSegment, project);
        boolean firstSegmentIsProjectName = targetProject != null;
        return ImportSpecifierUtil.computeImportType(name, firstSegmentIsProjectName, targetProject);
    }
}

