/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.CatchVariable;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.LocalArgumentsVariable;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassExpression;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDefinition;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.PropertyGetterDeclaration;
import org.eclipse.n4js.n4JS.PropertySetterDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.SetterDeclaration;
import org.eclipse.n4js.n4JS.Variable;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableEnvironmentElement;
import org.eclipse.n4js.n4JS.VersionedElement;
import org.eclipse.n4js.n4JS.extensions.SourceElementExtensions;
import org.eclipse.n4js.n4idl.versioning.VersionUtils;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.scoping.builtin.GlobalObjectScope;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.n4js.validation.ValidatorMessageHelper;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class N4JSDeclaredNameValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private IResourceScopeCache cache;
    @Inject
    private ValidatorMessageHelper messageHelper;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private SourceElementExtensions sourceElementExtensions;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;
    public static final HashSet<String> BASE_JS_TYPES = Sets.newHashSet((Object[])new String[]{"Object", "Function", "Array", "String", "Boolean", "Number", "Math", "Date", "RegExp", "Error", "JSON"});
    public static final HashSet<String> BASE_GLOBAL_NAMES = Sets.newHashSet((Object[])new String[]{"number", "string", "boolean", "any", "pathSelector", "i18nKey", "typeName", "N4Object", "N4Class", "N4Enum"});

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkNameConflicts(ObjectLiteral objectLiteral) {
        Functions.Function1 _function = it -> {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.findName((EObject)it));
            return !_isNullOrEmpty;
        };
        Function<EObject, String> _function_1 = it -> this.findName((EObject)it);
        Functions.Function2 _function_2 = (name, lstEO) -> {
            int _size = lstEO.size();
            return _size > 1;
        };
        BiConsumer<String, List> _function_3 = (name, lstEO) -> {
            Comparator _function_4 = (e1, e2) -> Integer.valueOf(NodeModelUtils.getNode((EObject)e1).getOffset()).compareTo(NodeModelUtils.getNode((EObject)e2).getOffset());
            lstEO.sort(_function_4);
            ListIterator<EObject> iter = lstEO.listIterator();
            EObject baseEO = (EObject)iter.next();
            Consumer<EObject> _function_5 = dupeEO -> {
                if (baseEO instanceof PropertyGetterDeclaration && dupeEO instanceof PropertySetterDeclaration || baseEO instanceof PropertySetterDeclaration && dupeEO instanceof PropertyGetterDeclaration) {
                    return;
                }
                this.addIssue(StringExtensions.toFirstUpper((String)IssueCodes.getMessageForAST_NAME_DUPLICATE_ERR(this.messageHelper.description((EObject)dupeEO, (String)name), this.messageHelper.descriptionWithLine(baseEO, (String)name))), (EObject)dupeEO, this.findNameEAttribute((EObject)dupeEO), "AST_NAME_DUPLICATE_ERR", new String[0]);
            };
            iter.forEachRemaining(_function_5);
        };
        MapExtensions.filter(IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)objectLiteral.getPropertyAssignments(), (Functions.Function1)_function)).stream().collect(Collectors.groupingBy(_function_1)), (Functions.Function2)_function_2).forEach(_function_3);
    }

    @Check
    public void checkExportableNameConflictsWithBuiltIn(ExportableElement exportableElement) {
        boolean _hasAnnotation;
        if (exportableElement instanceof AnnotableElement && (_hasAnnotation = AnnotationDefinition.GLOBAL.hasAnnotation((AnnotableElement)exportableElement))) {
            boolean _isPolyfill = N4JSLanguageUtils.isPolyfill((AnnotableElement)exportableElement);
            if (_isPolyfill) {
                return;
            }
            String name = this.getDeclaredName((EObject)exportableElement);
            if (name != null) {
                boolean _contains = BASE_JS_TYPES.contains(name);
                if (_contains) {
                    IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(exportableElement.eResource().getURI()).get();
                    if (project == null || project.getProjectType() != ProjectType.RUNTIME_ENVIRONMENT) {
                        this.addIssue(IssueCodes.getMessageForAST_GLOBAL_JS_NAME_CONFLICT(name), (EObject)exportableElement, "AST_GLOBAL_JS_NAME_CONFLICT");
                    }
                } else {
                    boolean _contains_1 = BASE_GLOBAL_NAMES.contains(name);
                    if (_contains_1) {
                        this.addIssue(IssueCodes.getMessageForAST_GLOBAL_NAME_CONFLICT(name), (EObject)exportableElement, "AST_GLOBAL_NAME_CONFLICT");
                    }
                }
            }
        }
    }

    @Check
    public void checkNameConflicts(Script script) {
        this.checkNameConflicts((VariableEnvironmentElement)script, Collections.emptySet());
    }

    private void checkNameConflicts(VariableEnvironmentElement scope, Set<String> outerNames) {
        List localNames = IterableExtensions.toList(this.getDeclaredNames(scope));
        this.checkGlobalNamesConflict(scope, IterableExtensions.toList(this.getDeclaredNamesForGlobalScopeComparison(scope)));
        HashSet<String> localNamesNoDuplicates = new HashSet<String>(localNames);
        this.checkLocalScopeNamesConflict(scope, localNames, localNamesNoDuplicates);
        HashSet<String> allNamesNoDuplicates = new HashSet<String>(outerNames);
        allNamesNoDuplicates.addAll(localNamesNoDuplicates);
        this.checkOuterScopesNamesConflict(scope, localNames, localNamesNoDuplicates, allNamesNoDuplicates, outerNames);
        Procedures.Procedure1 _function = it -> this.checkNameConflicts((VariableEnvironmentElement)it, (Set<String>)allNamesNoDuplicates);
        IteratorExtensions.forEach(this.getNestedScopes(scope), (Procedures.Procedure1)_function);
    }

    private void checkGlobalNamesConflict(VariableEnvironmentElement scope, List<String> localNames) {
        List<String> globalNames = this.findGlobalNames(scope.eResource());
        HashSet<String> globalNamesConflicts = new HashSet<String>(globalNames);
        boolean _retainAll = globalNamesConflicts.retainAll(localNames);
        if (_retainAll) {
            Functions.Function1 _function = it -> globalNamesConflicts.contains(this.getDeclaredNameForGlobalScopeComparision((EObject)it));
            Consumer<EObject> _function_1 = it -> {
                boolean _notEquals;
                EObject innerScopeObject = it;
                String name = this.getDeclaredNameForGlobalScopeComparision(innerScopeObject);
                boolean bl = _notEquals = !Objects.equal((Object)name, (Object)"eval");
                if (_notEquals) {
                    Functions.Function1 _function_2 = m -> name.equals(m.getName());
                    TMember globalObjectMemeber = (TMember)IterableExtensions.findFirst(this.findGlobalMembers(scope.eResource()), (Functions.Function1)_function_2);
                    this.addIssue(StringExtensions.toFirstUpper((String)IssueCodes.getMessageForAST_GLOBAL_NAME_SHADOW_ERR(this.messageHelper.description(innerScopeObject, name), this.messageHelper.description((EObject)globalObjectMemeber, name))), innerScopeObject, this.findNameEAttribute(innerScopeObject), "AST_GLOBAL_NAME_SHADOW_ERR", new String[0]);
                }
            };
            IterableExtensions.filter(this.getNameDeclarations(scope), (Functions.Function1)_function).forEach(_function_1);
        }
    }

    private void checkLocalScopeNamesConflict(VariableEnvironmentElement scope, List<String> localNames, Set<String> localNamesNoDuplicates) {
        int _size_1;
        int _size;
        boolean _lessThan;
        if (scope instanceof Block && scope.eContainer() instanceof FunctionOrFieldAccessor && ((FunctionOrFieldAccessor)scope.eContainer()).getBody() == scope) {
            EObject _eContainer = scope.eContainer();
            this.checkLocalScopeNamesConflict_letConstSpecialCase((FunctionOrFieldAccessor)_eContainer);
        }
        boolean bl = _lessThan = (_size = localNamesNoDuplicates.size()) < (_size_1 = localNames.size());
        if (_lessThan) {
            ArrayList<String> temp = new ArrayList<String>(localNames);
            Consumer<String> _function = it -> temp.remove(it);
            localNamesNoDuplicates.forEach(_function);
            HashSet<String> localNamesDuplicatesLocally = new HashSet<String>(temp);
            for (String n : localNamesDuplicatesLocally) {
                Function<EObject, String> _function_1 = it -> this.getDeclaredName((EObject)it);
                Functions.Function2 _function_2 = (name, lstEO) -> {
                    int _size_2 = lstEO.size();
                    return _size_2 > 1;
                };
                BiConsumer<String, List> _function_3 = (name, lstEO) -> {
                    Comparator _function_4 = (e1, e2) -> {
                        ICompositeNode n1 = NodeModelUtils.getNode((EObject)e1);
                        ICompositeNode n2 = NodeModelUtils.getNode((EObject)e2);
                        int _xifexpression = 0;
                        if (n1 == null || n2 == null) {
                            _xifexpression = 0;
                        } else {
                            int _offset = n1.getOffset();
                            int _offset_1 = n2.getOffset();
                            _xifexpression = _offset - _offset_1;
                        }
                        return _xifexpression;
                    };
                    lstEO.sort(_function_4);
                    ListIterator<EObject> iter = lstEO.listIterator();
                    EObject baseEO = (EObject)iter.next();
                    Consumer<EObject> _function_5 = dupeEO -> {
                        if (baseEO instanceof N4ClassExpression || dupeEO instanceof N4ClassExpression) {
                            return;
                        }
                        if (baseEO instanceof LocalArgumentsVariable || dupeEO instanceof LocalArgumentsVariable) {
                            return;
                        }
                        boolean _equals = baseEO.equals(scope);
                        if (_equals) {
                            if (dupeEO instanceof FormalParameter) {
                                this.addIssue(StringExtensions.toFirstUpper((String)IssueCodes.getMessageForAST_NAME_SHADOW_ERR(this.messageHelper.description((EObject)dupeEO, (String)name), this.messageHelper.description(baseEO, (String)name))), (EObject)dupeEO, this.findNameEAttribute((EObject)dupeEO), "AST_NAME_SHADOW_ERR", new String[0]);
                            } else {
                                this.addIssue(StringExtensions.toFirstUpper((String)IssueCodes.getMessageForAST_NAME_SHADOW_ERR(this.messageHelper.description((EObject)dupeEO, (String)name), this.messageHelper.descriptionWithLine(baseEO, (String)name))), (EObject)dupeEO, this.findNameEAttribute((EObject)dupeEO), "AST_NAME_SHADOW_ERR", new String[0]);
                            }
                            return;
                        }
                        if (dupeEO instanceof FormalParameter) {
                            this.addIssue(StringExtensions.toFirstUpper((String)IssueCodes.getMessageForAST_NAME_DUPLICATE_ERR(this.messageHelper.description((EObject)dupeEO, (String)name), this.messageHelper.description(baseEO, (String)name))), (EObject)dupeEO, this.findNameEAttribute((EObject)dupeEO), "AST_NAME_DUPLICATE_ERR", new String[0]);
                        } else {
                            boolean _not;
                            if (dupeEO instanceof NamedImportSpecifier && baseEO instanceof NamedImportSpecifier || dupeEO instanceof NamespaceImportSpecifier && baseEO instanceof NamespaceImportSpecifier) {
                                return;
                            }
                            boolean bl = _not = !(dupeEO instanceof N4ClassDeclaration) || !(baseEO instanceof ImportSpecifier) || !N4JSLanguageUtils.isPolyfill((AnnotableElement)((N4ClassDeclaration)dupeEO));
                            if (_not) {
                                this.addIssue(StringExtensions.toFirstUpper((String)IssueCodes.getMessageForAST_NAME_DUPLICATE_ERR(this.messageHelper.description((EObject)dupeEO, (String)name), this.messageHelper.descriptionWithLine(baseEO, (String)name))), (EObject)dupeEO, this.findNameEAttribute((EObject)dupeEO), "AST_NAME_DUPLICATE_ERR", new String[0]);
                            }
                        }
                    };
                    iter.forEachRemaining(_function_5);
                };
                MapExtensions.filter(IterableExtensions.toList(this.getNameDeclarations(scope, n)).stream().collect(Collectors.groupingBy(_function_1)), (Functions.Function2)_function_2).forEach(_function_3);
            }
        }
    }

    private void checkLocalScopeNamesConflict_letConstSpecialCase(FunctionOrFieldAccessor fun) {
        Block block = fun.getBody();
        Object _switchResult = null;
        boolean _matched = false;
        if (fun instanceof FunctionDefinition) {
            _matched = true;
            _switchResult = ((FunctionDefinition)fun).getFpars();
        }
        if (!_matched && fun instanceof SetterDeclaration) {
            _matched = true;
            FormalParameter _fpar = ((SetterDeclaration)fun).getFpar();
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new FormalParameter[]{_fpar}));
        }
        if (!_matched) {
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        EList fpars = _switchResult;
        Functions.Function1 _function = it -> it.getName();
        Set fparNames = IterableExtensions.toSet((Iterable)ListExtensions.map((List)fpars, (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> N4JSASTUtils.isBlockScoped((IdentifiableElement)it);
        Iterable declaredLetConst = IterableExtensions.filter((Iterable)Iterables.filter(this.getNameDeclarations((VariableEnvironmentElement)block), VariableDeclaration.class), (Functions.Function1)_function_1);
        Functions.Function1 _function_2 = it -> fparNames.contains(this.getDeclaredName((EObject)it));
        Consumer<VariableDeclaration> _function_3 = arg_0 -> this.lambda$19((List)fpars, arg_0);
        IterableExtensions.filter((Iterable)declaredLetConst, (Functions.Function1)_function_2).forEach(_function_3);
    }

    private void checkOuterScopesNamesConflict(VariableEnvironmentElement scope, List<String> localNames, Set<String> localNamesNoDuplicates, Set<String> allNamesNoDuplicates, Set<String> outerNames) {
        int _size_2;
        int _size_1;
        int _plus;
        boolean _lessThan;
        int _size = allNamesNoDuplicates.size();
        boolean bl = _lessThan = _size < (_plus = (_size_1 = outerNames.size()) + (_size_2 = localNamesNoDuplicates.size()));
        if (_lessThan) {
            ArrayList<String> temp = new ArrayList<String>(localNamesNoDuplicates);
            temp.addAll(outerNames);
            Consumer<String> _function = it -> temp.remove(it);
            allNamesNoDuplicates.forEach(_function);
            HashSet<String> localNamesDuplicatesGlobally = new HashSet<String>(temp);
            for (String n : localNamesDuplicatesGlobally) {
                boolean _equals = n.equals("arguments");
                if (_equals) {
                    return;
                }
                Consumer<EObject> _function_1 = it -> {
                    EObject conflict = null;
                    EObject conflictContainer = scope.eContainer();
                    while (conflict == null) {
                        if (conflictContainer == null) {
                            return;
                        }
                        Iterable<EObject> z = this.findOuterDeclaration(conflictContainer, n);
                        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(z);
                        if (_isNullOrEmpty) {
                            conflictContainer = conflictContainer.eContainer();
                            continue;
                        }
                        EObject outerScopeObject = conflict = (EObject)IterableExtensions.head(z);
                        EObject innerScopeObject = it;
                        String name = n;
                        if (outerScopeObject instanceof N4ClassExpression || innerScopeObject instanceof N4ClassExpression) {
                            return;
                        }
                        if (outerScopeObject instanceof FunctionDeclaration || outerScopeObject instanceof FunctionExpression) {
                            boolean _equals_2;
                            if (innerScopeObject instanceof FunctionExpression || innerScopeObject instanceof N4ClassExpression) {
                                return;
                            }
                            if (innerScopeObject instanceof FormalParameter && outerScopeObject instanceof FunctionDefinition && innerScopeObject.eContainer() == outerScopeObject) {
                                this.addIssue(StringExtensions.toFirstUpper((String)IssueCodes.getMessageForAST_NAME_SHADOW_ERR(this.messageHelper.description(innerScopeObject, name), this.messageHelper.description(outerScopeObject, name))), innerScopeObject, this.findNameEAttribute(innerScopeObject), "AST_NAME_SHADOW_ERR", new String[0]);
                                return;
                            }
                            boolean _equals_1 = outerScopeObject.equals(scope);
                            boolean bl = _equals_2 = !_equals_1;
                            if (_equals_2) {
                                return;
                            }
                            this.addIssue(StringExtensions.toFirstUpper((String)IssueCodes.getMessageForAST_NAME_SHADOW_ERR(this.messageHelper.description(innerScopeObject, name), this.messageHelper.descriptionWithLine(outerScopeObject, name))), innerScopeObject, this.findNameEAttribute(innerScopeObject), "AST_NAME_SHADOW_ERR", new String[0]);
                            return;
                        }
                        if (innerScopeObject instanceof CatchVariable) {
                            if (outerScopeObject instanceof CatchVariable) {
                                boolean _isN4JSMode = this.jsVariantHelper.isN4JSMode(innerScopeObject);
                                if (_isN4JSMode) {
                                    this.addIssue(StringExtensions.toFirstUpper((String)IssueCodes.getMessageForAST_NAME_SHADOW_WARN(this.messageHelper.description(innerScopeObject, name), this.messageHelper.descriptionWithLine(outerScopeObject, name))), innerScopeObject, this.findNameEAttribute(innerScopeObject), "AST_NAME_SHADOW_WARN", new String[0]);
                                    return;
                                }
                                return;
                            }
                            this.addIssue(StringExtensions.toFirstUpper((String)IssueCodes.getMessageForAST_NAME_SHADOW_ERR(this.messageHelper.description(innerScopeObject, name), this.messageHelper.descriptionWithLine(outerScopeObject, name))), innerScopeObject, this.findNameEAttribute(innerScopeObject), "AST_NAME_SHADOW_ERR", new String[0]);
                            return;
                        }
                        return;
                    }
                };
                IterableExtensions.toList(this.getNameDeclarations(scope, n)).forEach(_function_1);
            }
        }
    }

    private Iterable<EObject> findOuterDeclaration(EObject scope, String name) {
        Functions.Function1 _function = it -> name.equals(this.getDeclaredName((EObject)it));
        Iterable decl = IterableExtensions.filter((Iterable)scope.eContents(), (Functions.Function1)_function);
        return decl;
    }

    public List<String> findGlobalNames(Resource resource) {
        Provider _function = () -> {
            Functions.Function1 _function_1 = it -> {
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getName());
                return !_isNullOrEmpty;
            };
            Functions.Function1 _function_2 = it -> it.getName();
            return IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)this.getGlobalObject(resource), TMember.class), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        };
        return (List)this.cache.get((Object)"globalObjectNames", resource, _function);
    }

    public List<TMember> findGlobalMembers(Resource resource) {
        Provider _function = () -> EcoreUtil2.getAllContentsOfType((EObject)this.getGlobalObject(resource), TMember.class);
        return (List)this.cache.get((Object)"globalObjectMembers", resource, _function);
    }

    public TClass getGlobalObject(Resource resource) {
        return GlobalObjectScope.get(resource.getResourceSet()).getGlobalObject();
    }

    private Iterable<EObject> getNameDeclarations(VariableEnvironmentElement scope) {
        Resource resource = scope.eResource();
        ArrayList namedEOs = CollectionLiterals.newArrayList();
        boolean _matched = false;
        if (scope instanceof Script) {
            _matched = true;
            List _list = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)((Script)scope).eAllContents(), ImportSpecifier.class));
            Iterables.addAll((Collection)namedEOs, (Iterable)_list);
        }
        if (!_matched && scope instanceof FunctionOrFieldAccessor) {
            _matched = true;
            LocalArgumentsVariable _localArgumentsVariable = ((FunctionOrFieldAccessor)scope).getLocalArgumentsVariable();
            namedEOs.add(_localArgumentsVariable);
        }
        Functions.Function1 _function = it -> this.backToAST((EObject)it, resource);
        List _map = ListExtensions.map(this.sourceElementExtensions.collectVisibleIdentifiableElements(scope), (Functions.Function1)_function);
        Iterables.addAll((Collection)namedEOs, (Iterable)_map);
        Functions.Function1 _function_1 = it -> {
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.getDeclaredName((EObject)it));
            return !_isNullOrEmpty;
        };
        return IterableExtensions.filter((Iterable)namedEOs, (Functions.Function1)_function_1);
    }

    private Iterable<EObject> getNameDeclarations(VariableEnvironmentElement scope, String name) {
        Functions.Function1 _function = it -> {
            String _declaredName = this.getDeclaredName((EObject)it);
            return Objects.equal((Object)_declaredName, (Object)name);
        };
        return IterableExtensions.filter(this.getNameDeclarations(scope), (Functions.Function1)_function);
    }

    private Iterable<String> getDeclaredNames(VariableEnvironmentElement scope) {
        Functions.Function1 _function = it -> this.getDeclaredName((EObject)it);
        return IterableExtensions.map(this.getNameDeclarations(scope), (Functions.Function1)_function);
    }

    private Iterable<String> getDeclaredNamesForGlobalScopeComparison(VariableEnvironmentElement scope) {
        Functions.Function1 _function = it -> this.getDeclaredNameForGlobalScopeComparision((EObject)it);
        return IterableExtensions.map(this.getNameDeclarations(scope), (Functions.Function1)_function);
    }

    private Iterator<VariableEnvironmentElement> getNestedScopes(VariableEnvironmentElement scope) {
        Predicate _function = it -> !this.createsScope(it.eContainer()) || it.eContainer() == scope;
        Functions.Function1 _function_1 = it -> this.createsScope((EObject)it);
        return Iterators.filter((Iterator)IteratorExtensions.filter((Iterator)EcoreUtilN4.getAllContentsFiltered((EObject)scope, (Predicate)_function), (Functions.Function1)_function_1), VariableEnvironmentElement.class);
    }

    private boolean createsScope(EObject eo) {
        return eo instanceof VariableEnvironmentElement;
    }

    private String getDeclaredName(EObject eo) {
        if (VersionUtils.isVersioned(eo) && eo instanceof NamedElement) {
            String _name = ((NamedElement)eo).getName();
            String _plus = String.valueOf(_name) + "#";
            BigDecimal _declaredVersion = ((VersionedElement)eo).getDeclaredVersion();
            return String.valueOf(_plus) + _declaredVersion;
        }
        if (eo instanceof FunctionDeclaration || eo instanceof FunctionExpression || eo instanceof N4TypeDefinition || eo instanceof Variable) {
            return this.findName(eo);
        }
        if (eo instanceof NamedImportSpecifier) {
            boolean _not;
            NamedImportSpecifier namedIS = (NamedImportSpecifier)eo;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)namedIS.getAlias());
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                return namedIS.getAlias();
            }
            TExportableElement importedElem = namedIS.getImportedElement();
            if (importedElem == null) {
                return null;
            }
            String n = this.findName((EObject)importedElem);
            return n;
        }
        if (eo instanceof NamespaceImportSpecifier) {
            return ((NamespaceImportSpecifier)eo).getAlias();
        }
        return null;
    }

    private String getDeclaredNameForGlobalScopeComparision(EObject eo) {
        String _switchResult = null;
        boolean _matched = false;
        if (eo instanceof N4ClassDeclaration) {
            _matched = true;
            _switchResult = ((N4ClassDeclaration)eo).getName();
        }
        if (!_matched && eo instanceof N4InterfaceDeclaration) {
            _matched = true;
            _switchResult = ((N4InterfaceDeclaration)eo).getName();
        }
        if (!_matched && eo instanceof N4EnumDeclaration) {
            _matched = true;
            _switchResult = ((N4EnumDeclaration)eo).getName();
        }
        if (!_matched) {
            _switchResult = this.getDeclaredName(eo);
        }
        return _switchResult;
    }

    private String _findName(NamedElement it) {
        return it.getName();
    }

    private String _findName(IdentifiableElement it) {
        return it.getName();
    }

    private EStructuralFeature findNameEAttribute(EObject eo) {
        if (eo instanceof N4TypeDeclaration) {
            return N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME;
        }
        if (eo instanceof N4ClassExpression) {
            return N4JSPackage.Literals.N4_CLASS_EXPRESSION__NAME;
        }
        if (eo instanceof FunctionExpression) {
            return N4JSPackage.Literals.FUNCTION_EXPRESSION__NAME;
        }
        if (eo instanceof FunctionDeclaration) {
            return N4JSPackage.Literals.FUNCTION_DECLARATION__NAME;
        }
        if (eo instanceof NamedImportSpecifier) {
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            String _alias = ((NamedImportSpecifier)eo).getAlias();
            boolean bl = _tripleNotEquals = _alias != null;
            if (_tripleNotEquals) {
                return N4JSPackage.Literals.NAMED_IMPORT_SPECIFIER__ALIAS;
            }
            String _name = ((NamedImportSpecifier)eo).getImportedElement().getName();
            boolean bl2 = _tripleNotEquals_1 = _name != null;
            if (_tripleNotEquals_1) {
                return TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME;
            }
        }
        if (eo instanceof NamespaceImportSpecifier) {
            boolean _tripleNotEquals_2;
            String _alias_1 = ((NamespaceImportSpecifier)eo).getAlias();
            boolean bl = _tripleNotEquals_2 = _alias_1 != null;
            if (_tripleNotEquals_2) {
                return N4JSPackage.Literals.NAMESPACE_IMPORT_SPECIFIER__ALIAS;
            }
        }
        if (eo instanceof IdentifiableElement) {
            return TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME;
        }
        if (eo instanceof PropertyAssignment) {
            return N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME;
        }
        throw new RuntimeException("cannot obtain name attribute for " + eo);
    }

    private EObject backToAST(EObject potentialTModuleElement, Resource resource) {
        if (potentialTModuleElement instanceof SyntaxRelatedTElement) {
            boolean _tripleEquals;
            Resource _eResource = ((SyntaxRelatedTElement)potentialTModuleElement).eResource();
            boolean bl = _tripleEquals = _eResource == resource;
            if (_tripleEquals) {
                return ((SyntaxRelatedTElement)potentialTModuleElement).getAstElement();
            }
        }
        return potentialTModuleElement;
    }

    private String findName(EObject it) {
        if (it instanceof IdentifiableElement) {
            return this._findName((IdentifiableElement)it);
        }
        if (it instanceof NamedElement) {
            return this._findName((NamedElement)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    private /* synthetic */ void lambda$19(List list, VariableDeclaration dupeEO) {
        String name = this.getDeclaredName((EObject)dupeEO);
        Functions.Function1 _function_4 = it -> {
            String _name = it.getName();
            return Objects.equal((Object)_name, (Object)name);
        };
        FormalParameter baseEO = (FormalParameter)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)list, (Functions.Function1)_function_4));
        this.addIssue(StringExtensions.toFirstUpper((String)IssueCodes.getMessageForAST_NAME_DUPLICATE_ERR(this.messageHelper.description((EObject)dupeEO, name), this.messageHelper.description((EObject)baseEO, name))), (EObject)dupeEO, this.findNameEAttribute((EObject)dupeEO), "AST_NAME_SHADOW_ERR", new String[0]);
    }
}

