/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.nodejs;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.runner.SystemLoaderInfo;
import org.eclipse.n4js.runner.nodejs.NodeBootScriptTemplate;
import org.eclipse.n4js.runner.nodejs.NodeRunOptions;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;

public class NodeEngineCommandBuilder {
    private static final String CJS_COMMAND = "cjs";
    @Inject
    private Provider<NodeJsBinary> nodeJsBinary;

    public String[] createCmds(NodeRunOptions nodeRunOptions, Path workDir) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(((NodeJsBinary)this.nodeJsBinary.get()).getBinaryAbsolutePath());
        String nodeOptions = nodeRunOptions.getEngineOptions();
        if (nodeOptions != null) {
            for (String nodeOption : Splitter.on((CharMatcher)CharMatcher.breakingWhitespace()).omitEmptyStrings().split((CharSequence)nodeOptions)) {
                commands.add(nodeOption);
            }
        }
        String bootScript = this.generateBootCode(nodeRunOptions, workDir);
        commands.add(bootScript);
        if (nodeRunOptions.getSystemLoader() == SystemLoaderInfo.COMMON_JS) {
            commands.add(CJS_COMMAND);
        }
        return commands.toArray(new String[0]);
    }

    private String generateBootCode(NodeRunOptions nodeRunOptions, Path workDir) throws IOException {
        Path projectRootPath = workDir;
        File node_modules = new File(projectRootPath.toFile(), "node_modules");
        node_modules.mkdirs();
        NodeEngineCommandBuilder.addNodeModulesDeleteHook(node_modules);
        File elf = Files.createTempFile(projectRootPath, "N4JSNodeELF", ".js", new FileAttribute[0]).toFile();
        elf.deleteOnExit();
        Map<Path, String> path2name = nodeRunOptions.getCoreProjectPaths();
        String execModule = nodeRunOptions.getExecModule();
        if (Strings.isNullOrEmpty((String)execModule)) {
            throw new RuntimeException("Execution module not provided.");
        }
        List<String> initModules = nodeRunOptions.getInitModules();
        initModules = Arrays.asList(new String[0]);
        String eflCode = this.getELFCode(nodeRunOptions, node_modules, path2name, execModule, initModules);
        NodeEngineCommandBuilder.writeContentToFile(eflCode, elf);
        return elf.getAbsolutePath();
    }

    protected String getELFCode(NodeRunOptions nodeRunOptions, File node_modules, Map<Path, String> path2name, String execModule, List<String> initModules) throws IOException {
        Set<String> scopeNames = path2name.values().stream().filter(name -> ProjectDescriptionUtils.isProjectNameWithScope((String)name)).map(name -> name.substring(0, name.indexOf(47))).collect(Collectors.toSet());
        return NodeBootScriptTemplate.getRunScriptCore(node_modules.getCanonicalPath(), nodeRunOptions.getExecutionData(), initModules, execModule, scopeNames, path2name);
    }

    private static void writeContentToFile(String content, File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void addNodeModulesDeleteHook(final File file) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                file.deleteOnExit();
                if (file.isDirectory()) {
                    File[] childFildes = file.listFiles();
                    int i = 0;
                    while (i < childFildes.length) {
                        childFildes[i].deleteOnExit();
                        ++i;
                    }
                }
            }
        });
    }
}

