/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.n4js.smith.CollectedDataAccess;
import org.eclipse.n4js.smith.ui.Activator;
import org.eclipse.n4js.smith.ui.graph.DashboardComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class PerformanceView
extends ViewPart {
    private final Map<String, DashboardComposite> visualisation = new HashMap<String, DashboardComposite>();
    private DashboardComposite visualisationComposite = null;
    private boolean paused = true;
    private Composite visualisationParent = null;
    private final StackLayout layout = new StackLayout();
    private IContributionItem[] defaultMenuItems = null;

    public void createPartControl(Composite parent) {
        this.visualisationParent = parent;
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)this.layout);
        this.createToolbarActions();
        this.createMenu();
    }

    private void createToolbarActions() {
        this.createAction("Pause", 2, "Suspend collecting all data", Activator.getInstance().ICON_PAUSE, this::onPause).setChecked(this.paused);
        this.createAction("Delete ALL data", 1, "Delete ALL collected data.", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"), this::onDelete);
    }

    private Action createDynamicAction(final String name, final Consumer<String> delegate) {
        return new Action(name){

            public void run() {
                delegate.accept(name);
            }
        };
    }

    private void createMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                PerformanceView.this.addDynamicVisualisationSelection(m);
            }
        });
    }

    private void addDynamicVisualisationSelection(IMenuManager menuManager) {
        if (this.defaultMenuItems == null) {
            this.defaultMenuItems = menuManager.getItems();
        } else {
            menuManager.removeAll();
            Stream.of(this.defaultMenuItems).forEach(item -> menuManager.add(item));
        }
        Set collectorsKeys = CollectedDataAccess.getCollectorsKeys();
        this.trashUnreachableVisualisations(collectorsKeys);
        menuManager.add((IContributionItem)new Separator());
        collectorsKeys.forEach(collectorName -> menuManager.add((IAction)this.createDynamicAction((String)collectorName, this::selectDataSource)));
    }

    private void trashUnreachableVisualisations(Set<String> collectorsKeys) {
        HashSet unreachableKeys = new HashSet();
        this.visualisation.keySet().forEach(key -> {
            if (!collectorsKeys.contains(key)) {
                unreachableKeys.add(key);
            }
        });
        if (!unreachableKeys.isEmpty()) {
            unreachableKeys.forEach(this.visualisation::remove);
        }
    }

    private void selectDataSource(String key) {
        if (!this.visualisation.containsKey(key)) {
            this.visualisation.put(key, new DashboardComposite(key, this.visualisationParent, 0));
        }
        this.visualisationComposite = this.visualisation.get(key);
        this.layout.topControl = this.visualisationComposite;
        this.visualisationParent.layout();
    }

    private Action createAction(String label, int style, String tooltip, ImageDescriptor image, final Consumer<Action> onRun) {
        Action result = new Action(label, style){

            public void run() {
                onRun.accept(this);
            }
        };
        result.setText(label);
        result.setToolTipText(tooltip);
        result.setImageDescriptor(image);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)result);
        return result;
    }

    protected void onPause(Action action) {
        this.paused = action.isChecked();
        CollectedDataAccess.setPaused((boolean)this.paused);
    }

    protected void onDelete(Action action) {
        this.visualisation.values().forEach(v -> v.removeAllGraphs());
        this.visualisation.clear();
        CollectedDataAccess.purgeAllData();
    }

    public void setFocus() {
    }
}

