/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.formatting2;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.formatting2.FixedMultilineCommentReplacer;
import org.eclipse.n4js.formatting2.IndentHandlingTextReplaceMerger;
import org.eclipse.n4js.formatting2.N4JSFormatterPreferenceKeys;
import org.eclipse.n4js.formatting2.N4JSGenericFormatter;
import org.eclipse.n4js.formatting2.N4MultilineCommentReplacer;
import org.eclipse.n4js.formatting2.OffMultilineCommentReplacer;
import org.eclipse.n4js.n4JS.AbstractAnnotationList;
import org.eclipse.n4js.n4JS.AbstractCaseClause;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.AnnotableExpression;
import org.eclipse.n4js.n4JS.AnnotableN4MemberDeclaration;
import org.eclipse.n4js.n4JS.AnnotablePropertyAssignment;
import org.eclipse.n4js.n4JS.AnnotableScriptElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.AnnotationList;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.BinaryBitwiseExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BindingPattern;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.CastExpression;
import org.eclipse.n4js.n4JS.CatchBlock;
import org.eclipse.n4js.n4JS.CatchVariable;
import org.eclipse.n4js.n4JS.CommaExpression;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FieldAccessor;
import org.eclipse.n4js.n4JS.FinallyBlock;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.GetterDeclaration;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.IntLiteral;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.MultiplicativeExpression;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PostfixExpression;
import org.eclipse.n4js.n4JS.PromisifyExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.RegularExpressionLiteral;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.n4JS.ShiftExpression;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.SwitchStatement;
import org.eclipse.n4js.n4JS.TaggedTemplateString;
import org.eclipse.n4js.n4JS.TemplateLiteral;
import org.eclipse.n4js.n4JS.TemplateSegment;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.ThrowStatement;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableDeclarationOrBinding;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ts.formatting2.TypeExpressionsFormatter;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.StaticBaseTypeRef;
import org.eclipse.n4js.ts.typeRefs.StructuralTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting2.IAutowrapFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.IMerger;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.internal.SinglelineCodeCommentReplacer;
import org.eclipse.xtext.formatting2.internal.SinglelineDocCommentReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure3;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.simpleExpressions.NumberLiteral;

@SuppressWarnings("all")
public class N4JSFormatter extends TypeExpressionsFormatter {
  /**
   * Simple tracker that only gives exactly one time the value {@code true}
   * when calling {@link StateTrack#shouldDoThenDone()}
   */
  private static final class StateTrack {
    private boolean done = false;
    
    /**
     * This method returns {@code true} exactly on it's first invocation. Proceeding calls always return {@code false}.
     * 
     * @return Returns {@code true} if not done, immediately switches {@link #done} to {@code true};
     * returns {@code false} if already done.
     */
    public boolean shouldDoThenDone() {
      final boolean ret = (!this.done);
      this.done = true;
      return ret;
    }
  }
  
  /**
   * Debug switch
   */
  private static boolean debug = false;
  
  @Inject
  @Extension
  private N4JSGrammarAccess _n4JSGrammarAccess;
  
  /**
   * PRIO_4 = -7 - still very low.
   * Standard priorities in the formatter are:
   * <ul>
   * <li>lowPriority = -1;  == PRIO_10
   * <li>normal priority = 0; == PRIO_11
   * <li>high priority = +1; == PRIO_12
   * </ul>
   */
  private static final int PRIO_4 = (N4JSGenericFormatter.PRIO_3 + 1);
  
  private static final int PRIO_13 = (IHiddenRegionFormatter.HIGH_PRIORITY + 1);
  
  private Integer maxConsecutiveNewLines() {
    return this.<Integer>getPreference(N4JSFormatterPreferenceKeys.FORMAT_MAX_CONSECUTIVE_NEWLINES);
  }
  
  protected void _format(final Script script, @Extension final IFormattableDocument document) {
    @Extension
    final N4JSGenericFormatter generic = new N4JSGenericFormatter(this._n4JSGrammarAccess, this.textRegionExtensions);
    Boolean _preference = this.<Boolean>getPreference(N4JSFormatterPreferenceKeys.FORMAT_PARENTHESIS);
    if ((_preference).booleanValue()) {
    }
    generic.formatSemicolons(script, document);
    generic.formatColon(script, document);
    this.formatScriptAnnotations(script, document);
    EList<ScriptElement> _scriptElements = script.getScriptElements();
    for (final ScriptElement element : _scriptElements) {
      {
        final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, (this.maxConsecutiveNewLines()).intValue());
          it.autowrap();
        };
        document.<ScriptElement>append(element, _function);
        document.<ScriptElement>format(element);
      }
    }
    ImportDeclaration _last = IterableExtensions.<ImportDeclaration>last(Iterables.<ImportDeclaration>filter(script.getScriptElements(), ImportDeclaration.class));
    if (_last!=null) {
      final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
        it.setNewLines(2, 2, 3);
        it.highPriority();
      };
      document.<ImportDeclaration>append(_last, _function);
    }
  }
  
  /**
   * put modifiers into a single line separated by one space, last modifier has one space to following element.
   */
  public void configureModifiers(final EObject semObject, @Extension final IFormattableDocument document) {
    final Consumer<ISemanticRegion> _function = (ISemanticRegion it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_1) -> {
        it_1.oneSpace();
      };
      document.append(it, _function_1);
    };
    this.textRegionExtensions.regionFor(semObject).ruleCallsTo(this._n4JSGrammarAccess.getN4ModifierRule()).forEach(_function);
  }
  
  public void configureTypingStrategy(final EObject semObject, @Extension final IFormattableDocument document) {
    final Consumer<ISemanticRegion> _function = (ISemanticRegion it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_1) -> {
        it_1.noSpace();
      };
      document.append(it, _function_1);
    };
    this.textRegionExtensions.regionFor(semObject).ruleCallsTo(this._n4JSGrammarAccess.getTypingStrategyDefSiteOperatorRule(), this._n4JSGrammarAccess.getTypingStrategyUseSiteOperatorRule()).forEach(_function);
  }
  
  public void formatTypeVariables(final GenericDeclaration semObject, @Extension final IFormattableDocument document) {
    boolean _isEmpty = semObject.getTypeVars().isEmpty();
    if (_isEmpty) {
      return;
    }
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.setNewLines(0);
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(semObject).keyword("<"), _function), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
    };
    document.prepend(this.textRegionExtensions.regionFor(semObject).keyword(">"), _function_2);
    EList<TypeVariable> _typeVars = semObject.getTypeVars();
    for (final TypeVariable typeVar : _typeVars) {
      {
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
          it.noSpace();
        };
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        document.append(this.textRegionExtensions.immediatelyFollowing(document.<TypeVariable>append(typeVar, _function_3)).keyword(","), _function_4);
        this.format(typeVar, document);
      }
    }
  }
  
  protected void _format(final N4ClassDeclaration clazz, @Extension final IFormattableDocument document) {
    abstract class __N4JSFormatter_1 implements IAutowrapFormatter {
      boolean didReconfigure;
    }
    
    this.configureAnnotations(clazz, document);
    this.insertSpaceInFrontOfCurlyBlockOpener(clazz, document);
    this.indentExcludingAnnotations(clazz, document);
    this.configureTypingStrategy(clazz, document);
    this.configureModifiers(clazz, document);
    this.formatTypeVariables(clazz, document);
    final Function1<Integer, N4MemberDeclaration> _function = (Integer prio) -> {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.setNewLines(2);
        it.setPriority(prio);
      };
      return document.<N4MemberDeclaration>prepend(IterableExtensions.<N4MemberDeclaration>head(clazz.getOwnedMembersRaw()), _function_1);
    };
    final Function1<Integer, N4MemberDeclaration> twolinesBeforeFirstMember = _function;
    final __N4JSFormatter_1 callBackOnAutoWrap = new __N4JSFormatter_1() {
      {
        didReconfigure = false;
      }
      @Override
      public void format(final ITextSegment region, final IHiddenRegionFormatting wrapped, final IFormattableDocument document) {
        if ((!this.didReconfigure)) {
          twolinesBeforeFirstMember.apply(Integer.valueOf(IHiddenRegionFormatter.HIGH_PRIORITY));
          this.didReconfigure = true;
        }
      }
    };
    final N4JSFormatter.StateTrack state2 = new N4JSFormatter.StateTrack();
    final IAutowrapFormatter _function_1 = (ITextSegment region, IHiddenRegionFormatting hrFormatting, IFormattableDocument document2) -> {
      boolean _shouldDoThenDone = state2.shouldDoThenDone();
      if (_shouldDoThenDone) {
        twolinesBeforeFirstMember.apply(Integer.valueOf(IHiddenRegionFormatter.HIGH_PRIORITY));
      }
    };
    final IAutowrapFormatter callBackOnAutoWrap2 = _function_1;
    this.suppressUnusedWarnings(callBackOnAutoWrap2);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.setNewLines(0, 0, 1);
      it.autowrap();
    };
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.autowrap();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(clazz).keyword("extends"), _function_2), _function_3);
    final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
      it.setNewLines(0, 0, 1);
      it.autowrap();
      it.setPriority(IHiddenRegionFormatter.LOW_PRIORITY);
      it.setOnAutowrap(callBackOnAutoWrap);
    };
    final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.autowrap();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(clazz).keyword("implements"), _function_4), _function_5);
    final Consumer<ParameterizedTypeRef> _function_6 = (ParameterizedTypeRef it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_7 = (IHiddenRegionFormatter it_1) -> {
        it_1.autowrap();
        it_1.setPriority(IHiddenRegionFormatter.LOW_PRIORITY);
        it_1.setOnAutowrap(callBackOnAutoWrap);
      };
      document.<ParameterizedTypeRef>prepend(it, _function_7);
    };
    IterableExtensions.<ParameterizedTypeRef>tail(clazz.getImplementedInterfaceRefs()).forEach(_function_6);
    final ISemanticRegion kwClass = this.textRegionExtensions.regionFor(clazz).keyword("class");
    final ISemanticRegion kwBrace = this.textRegionExtensions.regionFor(clazz).keyword("{");
    boolean _contains = IterableExtensions.<ILineRegion>head(kwClass.getLineRegions()).contains(kwBrace);
    boolean _not = (!_contains);
    if (_not) {
      twolinesBeforeFirstMember.apply(Integer.valueOf(IHiddenRegionFormatter.NORMAL_PRIORITY));
    } else {
      final Procedure1<IHiddenRegionFormatter> _function_7 = (IHiddenRegionFormatter it) -> {
        it.setNewLines(1, 1, (this.maxConsecutiveNewLines()).intValue());
        it.autowrap();
      };
      document.<N4MemberDeclaration>prepend(IterableExtensions.<N4MemberDeclaration>head(clazz.getOwnedMembersRaw()), _function_7);
    }
    final Procedure1<IHiddenRegionFormatter> _function_8 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(kwClass, _function_8);
    EList<N4MemberDeclaration> _ownedMembersRaw = clazz.getOwnedMembersRaw();
    for (final N4MemberDeclaration member : _ownedMembersRaw) {
      {
        final Procedure1<IHiddenRegionFormatter> _function_9 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, (this.maxConsecutiveNewLines()).intValue());
        };
        document.<N4MemberDeclaration>append(member, _function_9);
        document.<N4MemberDeclaration>format(member);
      }
    }
    boolean _isEmpty = clazz.getOwnedMembersRaw().isEmpty();
    if (_isEmpty) {
      final Procedure1<IHiddenRegionFormatter> _function_9 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
        it.setNewLines(0);
      };
      document.append(kwBrace, _function_9);
    }
  }
  
  protected void _format(final N4InterfaceDeclaration interf, @Extension final IFormattableDocument document) {
    this.configureAnnotations(interf, document);
    this.configureModifiers(interf, document);
    this.insertSpaceInFrontOfCurlyBlockOpener(interf, document);
    this.indentExcludingAnnotations(interf, document);
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(1, 1, (this.maxConsecutiveNewLines()).intValue());
    };
    document.<N4MemberDeclaration>prepend(IterableExtensions.<N4MemberDeclaration>head(interf.getOwnedMembersRaw()), _function);
    EList<N4MemberDeclaration> _ownedMembersRaw = interf.getOwnedMembersRaw();
    for (final N4MemberDeclaration member : _ownedMembersRaw) {
      {
        final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, (this.maxConsecutiveNewLines()).intValue());
        };
        document.<N4MemberDeclaration>append(member, _function_1);
        document.<N4MemberDeclaration>format(member);
      }
    }
  }
  
  protected void _format(final N4FieldDeclaration field, @Extension final IFormattableDocument document) {
    this.configureAnnotations(field, document);
    this.configureModifiers(field, document);
    this.indentExcludingAnnotations(field, document);
    this.configureOptionality(field, document);
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(field).keyword("="), _function), _function_1);
    document.<Expression>format(field.getExpression());
    document.<TypeRef>format(field.getDeclaredTypeRef());
    document.<TypeRef>format(field.getBogusTypeRef());
  }
  
  protected void _format(final FunctionExpression funE, @Extension final IFormattableDocument document) {
    this.configureAnnotations(funE, document);
    this.configureModifiers(funE, document);
    boolean _isArrowFunction = funE.isArrowFunction();
    if (_isArrowFunction) {
      throw new IllegalStateException("Arrow functions should be formated differently.");
    }
    final Procedure3<ITextSegment, IHiddenRegionFormatting, IFormattableDocument> _function = (ITextSegment $0, IHiddenRegionFormatting $1, IFormattableDocument $2) -> {
    };
    this.configureFormalParameters(funE.getFpars(), document, _function);
    final Pair<ISemanticRegion, ISemanticRegion> parenPair = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(funE).keywordPairs("(", ")"));
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    document.append(parenPair.getKey(), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    document.prepend(parenPair.getValue(), _function_2);
    document.<Block>format(funE.getBody());
  }
  
  protected void _format(final FunctionOrFieldAccessor fDecl, @Extension final IFormattableDocument document) {
    this.configureAnnotations(fDecl, document);
    this.configureModifiers(fDecl, document);
    final N4JSFormatter.StateTrack state = new N4JSFormatter.StateTrack();
    final Procedure3<ITextSegment, IHiddenRegionFormatting, IFormattableDocument> _function = (ITextSegment $0, IHiddenRegionFormatting $1, IFormattableDocument $2) -> {
      boolean _shouldDoThenDone = state.shouldDoThenDone();
      if (_shouldDoThenDone) {
        Block _body = fDecl.getBody();
        EList<Statement> _statements = null;
        if (_body!=null) {
          _statements=_body.getStatements();
        }
        Statement _head = null;
        if (_statements!=null) {
          _head=IterableExtensions.<Statement>head(_statements);
        }
        final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(2, 2, (this.maxConsecutiveNewLines()).intValue());
          it.highPriority();
        };
        document.<Statement>prepend(_head, _function_1);
      }
    };
    final Procedure3<? super ITextSegment, ? super IHiddenRegionFormatting, ? super IFormattableDocument> cbInsertEmptyLineInBody = _function;
    boolean _matched = false;
    if (fDecl instanceof FunctionDefinition) {
      _matched=true;
      this.configureFormalParameters(((FunctionDefinition)fDecl).getFpars(), document, cbInsertEmptyLineInBody);
    }
    if (!_matched) {
      if (fDecl instanceof N4SetterDeclaration) {
        _matched=true;
        final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
          it.noSpace();
        };
        final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
          it.noSpace();
        };
        document.<FormalParameter>append(document.<FormalParameter>prepend(((N4SetterDeclaration)fDecl).getFpar(), _function_1), _function_2);
      }
    }
    boolean _matched_1 = false;
    if (fDecl instanceof FunctionDeclaration) {
      _matched_1=true;
      this.formatTypeVariables(((GenericDeclaration)fDecl), document);
    }
    if ((fDecl instanceof FieldAccessor)) {
      this.configureGetSetKeyword(((FieldAccessor)fDecl), document);
      this.configureOptionality(((FieldAccessor)fDecl), document);
    }
    final Pair<ISemanticRegion, ISemanticRegion> parenPair = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(fDecl).keywordPairs("(", ")"));
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
    };
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    document.append(document.prepend(parenPair.getKey(), _function_1), _function_2);
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(parenPair, _function_3);
    if ((N4JSFormatter.isMultiLine(parenPair) && (!(fDecl instanceof FieldAccessor)))) {
    } else {
    }
    final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    document.prepend(parenPair.getValue(), _function_4);
    EList<EObject> _eContents = fDecl.eContents();
    for (final EObject child : _eContents) {
      document.<EObject>format(child);
    }
  }
  
  /**
   * to be used by FunctionDefintiions and SetterDeclarations
   */
  public void configureFormalParameters(final EList<FormalParameter> list, @Extension final IFormattableDocument document, final Procedure3<? super ITextSegment, ? super IHiddenRegionFormatting, ? super IFormattableDocument> x) {
    if (((list == null) || list.isEmpty())) {
      return;
    }
    final Procedure2<FormalParameter, Integer> _function = (FormalParameter it, Integer idx) -> {
      if (((idx).intValue() != 0)) {
        final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_1) -> {
          it_1.oneSpace();
          it_1.setNewLines(0, 0, 1);
          it_1.setOnAutowrap(new IAutowrapFormatter() {
              public void format(ITextSegment arg0, IHiddenRegionFormatting arg1, IFormattableDocument arg2) {
                x.apply(arg0, arg1, arg2);
              }
          });
        };
        document.<FormalParameter>prepend(it, _function_1);
      }
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it_1) -> {
        it_1.noSpace();
      };
      document.<FormalParameter>append(it, _function_2);
      this.configureAnnotationsInLine(it, document);
      this.format(it.getDeclaredTypeRef(), document);
      boolean _isVariadic = it.isVariadic();
      if (_isVariadic) {
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it_1) -> {
          it_1.setNewLines(0);
        };
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it_1) -> {
          it_1.setNewLines(0);
          it_1.noSpace();
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor(it).keyword("..."), _function_3), _function_4);
      }
      boolean _isHasInitializerAssignment = it.isHasInitializerAssignment();
      if (_isHasInitializerAssignment) {
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it_1) -> {
          it_1.setNewLines(0);
          it_1.noSpace();
        };
        final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it_1) -> {
          it_1.setNewLines(0);
          it_1.noSpace();
        };
        document.append(document.prepend(this.textRegionExtensions.regionFor(it).keyword("="), _function_5), _function_6);
        Expression _initializer = it.getInitializer();
        boolean _tripleNotEquals = (_initializer != null);
        if (_tripleNotEquals) {
          this.format(it.getInitializer(), document);
        }
      }
    };
    IterableExtensions.<FormalParameter>forEach(list, _function);
  }
  
  /**
   * Check if key and value are in different lines. Defined for non-overlapping Regions, e.g. Keyword-pairs.
   */
  public static boolean isMultiLine(final Pair<ISemanticRegion, ISemanticRegion> pair) {
    boolean _contains = IterableExtensions.<ILineRegion>last(pair.getKey().getLineRegions()).contains(pair.getValue());
    return (!_contains);
  }
  
  protected void _format(final N4EnumDeclaration enumDecl, @Extension final IFormattableDocument document) {
    this.configureAnnotations(enumDecl, document);
    this.configureModifiers(enumDecl, document);
    this.insertSpaceInFrontOfCurlyBlockOpener(enumDecl, document);
    this.indentExcludingAnnotations(enumDecl, document);
    this.configureCommas(enumDecl, document);
    final Pair<ISemanticRegion, ISemanticRegion> braces = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(enumDecl).keywordPairs("{", "}"));
    final boolean multiLine = this.textRegionExtensions.isMultiline(enumDecl);
    final Consumer<N4EnumLiteral> _function = (N4EnumLiteral it) -> {
      document.<N4EnumLiteral>format(it);
      if (multiLine) {
        boolean _containsComment = this.textRegionExtensions.regionForEObject(it).getPreviousHiddenRegion().containsComment();
        if (_containsComment) {
          final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_1) -> {
            it_1.setNewLines(2);
          };
          document.<N4EnumLiteral>prepend(it, _function_1);
        } else {
          final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it_1) -> {
            it_1.newLine();
          };
          document.<N4EnumLiteral>prepend(it, _function_2);
        }
      }
    };
    enumDecl.getLiterals().forEach(_function);
    if (multiLine) {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.newLine();
      };
      document.prepend(braces.getValue(), _function_1);
    }
  }
  
  protected void _format(final ParameterizedPropertyAccessExpression exp, @Extension final IFormattableDocument document) {
    final ISemanticRegion dotKW = this.textRegionExtensions.regionFor(exp).keyword(".");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.autowrap();
      it.setNewLines(0, 0, 1);
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    document.append(document.prepend(dotKW, _function), _function_1);
    EObject _eContainer = exp.eContainer();
    if ((_eContainer instanceof ExpressionStatement)) {
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
        it.indent();
      };
      this.interiorBUGFIX(exp, _function_2, document);
    }
    document.<Expression>format(exp.getTarget());
  }
  
  protected void _format(final ParameterizedCallExpression exp, @Extension final IFormattableDocument document) {
    final ISemanticRegion dotKW = this.textRegionExtensions.regionFor(exp).keyword(".");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.autowrap();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    document.append(document.prepend(dotKW, _function), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(exp).keyword("("), _function_2), _function_3);
    final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    document.prepend(this.textRegionExtensions.regionFor(exp).keyword(")"), _function_4);
    this.configureCommas(exp, document);
    final Consumer<Argument> _function_5 = (Argument it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it_1) -> {
        it_1.oneSpace();
        it_1.autowrap();
      };
      document.<Argument>prepend(it, _function_6);
    };
    IterableExtensions.<Argument>tail(exp.getArguments()).forEach(_function_5);
    final Consumer<Argument> _function_6 = (Argument it) -> {
      document.<Argument>format(it);
    };
    exp.getArguments().forEach(_function_6);
    EObject _eContainer = exp.eContainer();
    if ((_eContainer instanceof ExpressionStatement)) {
      final Procedure1<IHiddenRegionFormatter> _function_7 = (IHiddenRegionFormatter it) -> {
        it.indent();
      };
      this.interiorBUGFIX(exp, _function_7, document);
    }
    document.<Expression>format(exp.getTarget());
  }
  
  protected void _format(final ImportDeclaration decl, @Extension final IFormattableDocument document) {
    final Boolean extraSpace = this.<Boolean>getPreference(N4JSFormatterPreferenceKeys.FORMAT_SURROUND_IMPORT_LIST_WITH_SPACE);
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      if ((extraSpace).booleanValue()) {
        it.oneSpace();
      } else {
        it.noSpace();
      }
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(decl).keyword("{"), _function), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      if ((extraSpace).booleanValue()) {
        it.oneSpace();
      } else {
        it.noSpace();
      }
    };
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.setNewLines(0);
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(decl).keyword("}"), _function_2), _function_3);
    final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(this.textRegionExtensions.regionFor(decl).keyword("from"), _function_4);
    this.configureCommas(decl, document);
    final Consumer<EObject> _function_5 = (EObject it) -> {
      document.<EObject>format(it);
    };
    decl.eContents().forEach(_function_5);
  }
  
  protected void _format(final NamedImportSpecifier namedImp, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(namedImp).keyword("as"), _function), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(namedImp).feature(N4JSPackage.Literals.NAMESPACE_IMPORT_SPECIFIER__DECLARED_DYNAMIC), _function_2), _function_3);
  }
  
  protected void _format(final NamespaceImportSpecifier nsImp, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(this.textRegionExtensions.regionFor(nsImp).keyword("*"), _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(this.textRegionExtensions.regionFor(nsImp).keyword("as"), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(nsImp).feature(N4JSPackage.Literals.NAMESPACE_IMPORT_SPECIFIER__DECLARED_DYNAMIC), _function_2), _function_3);
  }
  
  protected void _format(final ExportDeclaration export, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.setNewLines(0);
      it.setPriority(N4JSFormatter.PRIO_13);
    };
    document.append(this.textRegionExtensions.regionFor(export).keyword("export"), _function);
    final Consumer<EObject> _function_1 = (EObject it) -> {
      document.<EObject>format(it);
    };
    export.eContents().forEach(_function_1);
    final ExportableElement exported = export.getExportedElement();
    if ((exported instanceof AnnotableScriptElement)) {
      final AnnotationList annoList = ((AnnotableScriptElement)exported).getAnnotationList();
      if (((annoList != null) && (!annoList.getAnnotations().isEmpty()))) {
        final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(0);
          it.oneSpace();
          it.setPriority(N4JSFormatter.PRIO_13);
        };
        document.<Annotation>append(IterableExtensions.<Annotation>last(annoList.getAnnotations()), _function_2);
      }
    }
  }
  
  protected void _format(final IfStatement stmt, @Extension final IFormattableDocument document) {
    final Pair<ISemanticRegion, ISemanticRegion> parenPair = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(stmt).keywordPairs("(", ")"));
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(parenPair, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.prepend(parenPair.getKey(), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(parenPair.getValue(), _function_2);
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.autowrap();
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(stmt).keyword("else"), _function_3), _function_4);
    final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.setNewLines(0);
    };
    document.<Statement>prepend(stmt.getElseStmt(), _function_5);
    document.<Expression>format(stmt.getExpression());
    document.<Statement>format(stmt.getIfStmt());
    document.<Statement>format(stmt.getElseStmt());
  }
  
  protected void _format(final SwitchStatement swStmt, @Extension final IFormattableDocument document) {
    this.insertSpaceInFrontOfCurlyBlockOpener(swStmt, document);
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    this.interiorBUGFIX(swStmt, _function, document);
    document.<Expression>format(swStmt.getExpression());
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.<AbstractCaseClause>prepend(IterableExtensions.<AbstractCaseClause>head(swStmt.getCases()), _function_1);
    final Consumer<AbstractCaseClause> _function_2 = (AbstractCaseClause it) -> {
      document.<AbstractCaseClause>format(it);
    };
    swStmt.getCases().forEach(_function_2);
  }
  
  /**
   * Formats DefaultCaseClause + CaseClause
   */
  protected void _format(final AbstractCaseClause caseClause, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    this.interiorBUGFIX(caseClause, _function, document);
    int _size = caseClause.getStatements().size();
    boolean _equals = (_size == 1);
    if (_equals) {
      Statement _head = IterableExtensions.<Statement>head(caseClause.getStatements());
      if ((_head instanceof Block)) {
        final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(0, 0, 0);
        };
        document.<Statement>prepend(IterableExtensions.<Statement>head(caseClause.getStatements()), _function_1);
      } else {
        final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(0, 1, 1);
        };
        document.<Statement>prepend(IterableExtensions.<Statement>head(caseClause.getStatements()), _function_2);
      }
    } else {
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
        it.setNewLines(1, 1, 1);
      };
      document.<Statement>prepend(IterableExtensions.<Statement>head(caseClause.getStatements()), _function_3);
    }
    final Consumer<Statement> _function_4 = (Statement it) -> {
      document.<Statement>format(it);
    };
    caseClause.getStatements().forEach(_function_4);
    final Consumer<Statement> _function_5 = (Statement it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it_1) -> {
        it_1.setNewLines(1, 1, (this.maxConsecutiveNewLines()).intValue());
      };
      document.<Statement>append(it, _function_6);
    };
    caseClause.getStatements().forEach(_function_5);
    final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
      it.setNewLines(1, 1, (this.maxConsecutiveNewLines()).intValue());
    };
    document.<AbstractCaseClause>append(caseClause, _function_6);
  }
  
  protected void _format(final CastExpression expr, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(0);
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.setNewLines(0);
      it.oneSpace();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(expr).keyword("as"), _function), _function_1);
    document.<Expression>format(expr.getExpression());
    document.<TypeRef>format(expr.getTargetTypeRef());
  }
  
  protected void _format(final Block block, @Extension final IFormattableDocument document) {
    if (N4JSFormatter.debug) {
      String _containmentStructure = N4JSFormatter.containmentStructure(block);
      String _plus = ("Formatting block " + _containmentStructure);
      InputOutput.<String>println(_plus);
    }
    boolean _not = (!((block.eContainer() instanceof Block) || (block.eContainer() instanceof Script)));
    if (_not) {
      final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
      };
      document.prepend(this.textRegionExtensions.regionFor(block).keyword("{"), _function);
    }
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    this.interiorBUGFIX(block, _function_1, document);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.setNewLines(1, 1, (this.maxConsecutiveNewLines()).intValue());
    };
    document.<Statement>prepend(IterableExtensions.<Statement>head(block.getStatements()), _function_2);
    final Consumer<Statement> _function_3 = (Statement it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it_1) -> {
        it_1.setNewLines(1, 1, (this.maxConsecutiveNewLines()).intValue());
      };
      document.<Statement>append(it, _function_4);
    };
    block.getStatements().forEach(_function_3);
    final Consumer<Statement> _function_4 = (Statement it) -> {
      document.<Statement>format(it);
    };
    block.getStatements().forEach(_function_4);
    final Pair<ISemanticRegion, ISemanticRegion> braces = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(block).keywordPairs("{", "}"));
    if (((braces != null) && Objects.equal(braces.getKey().getNextSemanticRegion(), braces.getValue()))) {
      boolean _containsComment = braces.getKey().getNextHiddenRegion().containsComment();
      if (_containsComment) {
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, (this.maxConsecutiveNewLines()).intValue());
        };
        document.append(braces.getKey(), _function_5);
      } else {
        final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(0);
          it.noSpace();
        };
        document.append(braces.getKey(), _function_6);
      }
    }
  }
  
  protected void _format(final ReturnStatement ret, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    this.interiorBUGFIX(ret, _function, document);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.setNewLines(0);
    };
    document.<Expression>prepend(ret.getExpression(), _function_1);
    document.<Expression>format(ret.getExpression());
  }
  
  protected void _format(final AdditiveExpression add, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.autowrap();
    };
    document.append(document.surround(this.textRegionExtensions.regionFor(add).feature(N4JSPackage.Literals.ADDITIVE_EXPRESSION__OP), _function), _function_1);
    document.<Expression>format(add.getLhs());
    document.<Expression>format(add.getRhs());
  }
  
  protected void _format(final MultiplicativeExpression mul, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.autowrap();
    };
    document.append(document.surround(this.textRegionExtensions.regionFor(mul).feature(N4JSPackage.Literals.MULTIPLICATIVE_EXPRESSION__OP), _function), _function_1);
    document.<Expression>format(mul.getLhs());
    document.<Expression>format(mul.getRhs());
  }
  
  protected void _format(final BinaryBitwiseExpression binbit, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(this.textRegionExtensions.regionFor(binbit).feature(N4JSPackage.Literals.BINARY_BITWISE_EXPRESSION__OP), _function);
    document.<Expression>format(binbit.getLhs());
    document.<Expression>format(binbit.getRhs());
  }
  
  protected void _format(final BinaryLogicalExpression binLog, @Extension final IFormattableDocument document) {
    final ISemanticRegion opReg = this.textRegionExtensions.regionFor(binLog).feature(N4JSPackage.Literals.BINARY_LOGICAL_EXPRESSION__OP);
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(opReg, _function);
    document.<Expression>format(binLog.getLhs());
    document.<Expression>format(binLog.getRhs());
    final Boolean autoWrapInFront = this.<Boolean>getPreference(N4JSFormatterPreferenceKeys.FORMAT_AUTO_WRAP_IN_FRONT_OF_LOGICAL_OPERATOR);
    if ((autoWrapInFront).booleanValue()) {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.autowrap();
        it.lowPriority();
        it.setNewLines(0, 0, 1);
      };
      document.prepend(opReg, _function_1);
    } else {
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
        it.autowrap();
        it.lowPriority();
        it.setNewLines(0, 0, 1);
      };
      document.append(opReg, _function_2);
    }
  }
  
  protected void _format(final EqualityExpression eqExpr, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.autowrap();
    };
    document.append(document.surround(this.textRegionExtensions.regionFor(eqExpr).feature(N4JSPackage.Literals.EQUALITY_EXPRESSION__OP), _function), _function_1);
    document.<Expression>format(eqExpr.getLhs());
    document.<Expression>format(eqExpr.getRhs());
  }
  
  protected void _format(final RelationalExpression relExpr, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.autowrap();
    };
    document.append(document.surround(this.textRegionExtensions.regionFor(relExpr).feature(N4JSPackage.Literals.RELATIONAL_EXPRESSION__OP), _function), _function_1);
    document.<Expression>format(relExpr.getLhs());
    document.<Expression>format(relExpr.getRhs());
  }
  
  protected void _format(final ShiftExpression shiftExpr, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.autowrap();
    };
    document.append(document.surround(this.textRegionExtensions.regionFor(shiftExpr).feature(N4JSPackage.Literals.SHIFT_EXPRESSION__OP), _function), _function_1);
    document.<Expression>format(shiftExpr.getLhs());
    document.<Expression>format(shiftExpr.getRhs());
  }
  
  protected void _format(final CommaExpression comma, @Extension final IFormattableDocument document) {
    this.configureCommas(comma, document);
    final Consumer<EObject> _function = (EObject it) -> {
      document.<EObject>format(it);
    };
    comma.eContents().forEach(_function);
  }
  
  protected void _format(final ConditionalExpression cond, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.autowrap();
      it.lowPriority();
      it.setNewLines(0, 0, 1);
    };
    document.append(document.surround(this.textRegionExtensions.regionFor(cond).keyword("?"), _function), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.autowrap();
      it.lowPriority();
      it.setNewLines(0, 0, 1);
    };
    document.append(document.surround(this.textRegionExtensions.regionFor(cond).keyword(":"), _function_2), _function_3);
    document.<Expression>format(cond.getExpression());
    document.<Expression>format(cond.getTrueExpression());
    document.<Expression>format(cond.getFalseExpression());
  }
  
  protected void _format(final AwaitExpression await, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.setNewLines(0);
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(await).keyword("await"), _function), _function_1);
    document.<Expression>format(await.getExpression());
  }
  
  protected void _format(final PromisifyExpression promify, @Extension final IFormattableDocument document) {
    this.noSpaceAfterAT(promify, document);
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(this.textRegionExtensions.regionFor(promify).keyword("Promisify"), _function);
    document.<Expression>format(promify.getExpression());
  }
  
  protected void _format(final IndexedAccessExpression idxAcc, @Extension final IFormattableDocument document) {
    final IEObjectRegion indexRegion = this.textRegionExtensions.regionForEObject(idxAcc.getIndex());
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
    };
    document.append(document.prepend(indexRegion.getPreviousSemanticRegion(), _function), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    document.prepend(indexRegion.getNextSemanticRegion(), _function_2);
    document.<Expression>format(idxAcc.getIndex());
    document.<Expression>format(idxAcc.getTarget());
  }
  
  protected void _format(final NewExpression newExp, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.setNewLines(0);
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(newExp).keyword("new"), _function), _function_1);
    document.<Expression>format(newExp.getCallee());
    final ISemanticRegion commas = this.textRegionExtensions.regionFor(newExp).keyword(",");
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(document.prepend(commas, _function_2), _function_3);
    final Pair<ISemanticRegion, ISemanticRegion> typeArgsAngle = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(newExp).keywordPairs("<", ">"));
    if ((typeArgsAngle != null)) {
      final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
        it.setNewLines(0);
      };
      final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
        it.setNewLines(0);
      };
      document.prepend(document.append(typeArgsAngle.getKey(), _function_4), _function_5);
      final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
        it.setNewLines(0);
      };
      document.prepend(typeArgsAngle.getValue(), _function_6);
    }
    final Consumer<TypeRef> _function_7 = (TypeRef it) -> {
      document.<TypeRef>format(it);
    };
    newExp.getTypeArgs().forEach(_function_7);
    boolean _isWithArgs = newExp.isWithArgs();
    if (_isWithArgs) {
      final Pair<ISemanticRegion, ISemanticRegion> argParen = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(newExp).keywordPairs("(", ")"));
      final Procedure1<IHiddenRegionFormatter> _function_8 = (IHiddenRegionFormatter it) -> {
        it.setNewLines(0);
        it.noSpace();
      };
      final Procedure1<IHiddenRegionFormatter> _function_9 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
      };
      document.append(document.prepend(argParen.getKey(), _function_8), _function_9);
      final Procedure1<IHiddenRegionFormatter> _function_10 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
      };
      document.prepend(argParen.getValue(), _function_10);
      final Consumer<Argument> _function_11 = (Argument it) -> {
        document.<Argument>format(it);
      };
      newExp.getArguments().forEach(_function_11);
    }
  }
  
  protected void _format(final PostfixExpression postFix, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(0);
      it.noSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.lowPriority();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(postFix).feature(N4JSPackage.Literals.POSTFIX_EXPRESSION__OP), _function), _function_1);
    document.<Expression>format(postFix.getExpression());
  }
  
  protected void _format(final TaggedTemplateString taggedTemplate, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(0);
      it.oneSpace();
    };
    document.append(this.textRegionExtensions.regionFor(taggedTemplate).feature(N4JSPackage.Literals.TAGGED_TEMPLATE_STRING__TARGET), _function);
    document.<Expression>format(taggedTemplate.getTarget());
    document.<TemplateLiteral>format(taggedTemplate.getTemplate());
  }
  
  protected void _format(final UnaryExpression unaryExpr, @Extension final IFormattableDocument document) {
    int _ordinal = unaryExpr.getOp().ordinal();
    final boolean requireSpace = (_ordinal <= UnaryOperator.TYPEOF_VALUE);
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      if (requireSpace) {
        it.oneSpace();
      } else {
        it.noSpace();
      }
      it.setNewLines(0);
    };
    document.append(this.textRegionExtensions.regionFor(unaryExpr).feature(N4JSPackage.Literals.UNARY_EXPRESSION__OP), _function);
    document.<Expression>format(unaryExpr.getExpression());
  }
  
  protected void _format(final YieldExpression yieldExpr, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      boolean _isMany = yieldExpr.isMany();
      if (_isMany) {
        it.noSpace();
      } else {
        it.oneSpace();
      }
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(yieldExpr).keyword("yield"), _function), _function_1);
    boolean _isMany = yieldExpr.isMany();
    if (_isMany) {
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
        it.setNewLines(0);
      };
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
      };
      document.append(document.prepend(this.textRegionExtensions.regionFor(yieldExpr).keyword("*"), _function_2), _function_3);
    }
    document.<Expression>format(yieldExpr.getExpression());
  }
  
  protected void _format(final ParenExpression parenE, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
      it.autowrap();
    };
    document.append(IterableExtensions.<ISemanticRegion>head(this.textRegionExtensions.semanticRegions(parenE)), _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
      it.autowrap();
    };
    document.prepend(IterableExtensions.<ISemanticRegion>last(this.textRegionExtensions.semanticRegions(parenE)), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    this.interiorBUGFIX(parenE, _function_2, document);
    document.<Expression>format(parenE.getExpression());
  }
  
  protected void _format(final ArrowFunction arrowF, @Extension final IFormattableDocument document) {
    this.configureCommas(arrowF, document);
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(this.textRegionExtensions.regionFor(arrowF).keyword("=>"), _function);
    Pair<ISemanticRegion, ISemanticRegion> _head = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(arrowF).keywordPairs("(", ")"));
    if (_head!=null) {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
      };
      document.<ISemanticRegion, ISemanticRegion>interior(_head, _function_1);
    }
    boolean _isHasBracesAroundBody = arrowF.isHasBracesAroundBody();
    if (_isHasBracesAroundBody) {
      final Pair<ISemanticRegion, ISemanticRegion> bracesPair = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(arrowF).keywordPairs("{", "}"));
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
        it.indent();
      };
      document.<ISemanticRegion, ISemanticRegion>interior(bracesPair, _function_2);
      if ((IterableExtensions.<ILineRegion>last(bracesPair.getKey().getLineRegions()).contains(bracesPair.getValue()) || IterableExtensions.<ILineRegion>last(bracesPair.getKey().getLineRegions()).contains(bracesPair.getKey().getNextSemanticRegion()))) {
        Block _body = arrowF.getBody();
        EList<Statement> _statements = null;
        if (_body!=null) {
          _statements=_body.getStatements();
        }
        final Procedure2<Statement, Integer> _function_3 = (Statement it, Integer idx) -> {
          document.<Statement>format(it);
          if (((idx).intValue() != 0)) {
            final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it_1) -> {
              it_1.oneSpace();
              it_1.autowrap();
              it_1.setNewLines(0);
            };
            document.<Statement>prepend(it, _function_4);
          }
        };
        IterableExtensions.<Statement>forEach(_statements, _function_3);
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        document.append(bracesPair.getKey(), _function_4);
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        document.prepend(bracesPair.getValue(), _function_5);
      } else {
        if (((arrowF.getBody() != null) && (!arrowF.getBody().getStatements().isEmpty()))) {
          Block _body_1 = arrowF.getBody();
          EList<Statement> _statements_1 = null;
          if (_body_1!=null) {
            _statements_1=_body_1.getStatements();
          }
          final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
            it.setNewLines(1);
          };
          document.<Statement>prepend(IterableExtensions.<Statement>head(_statements_1), _function_6);
          Block _body_2 = arrowF.getBody();
          EList<Statement> _statements_2 = null;
          if (_body_2!=null) {
            _statements_2=_body_2.getStatements();
          }
          final Consumer<Statement> _function_7 = (Statement it) -> {
            document.<Statement>format(it);
            final Procedure1<IHiddenRegionFormatter> _function_8 = (IHiddenRegionFormatter it_1) -> {
              it_1.setNewLines(1);
            };
            document.<Statement>append(it, _function_8);
          };
          _statements_2.forEach(_function_7);
        } else {
          final Procedure1<IHiddenRegionFormatter> _function_8 = (IHiddenRegionFormatter it) -> {
            it.noSpace();
            it.setNewLines(1);
          };
          document.append(bracesPair.getKey(), _function_8);
          final Procedure1<IHiddenRegionFormatter> _function_9 = (IHiddenRegionFormatter it) -> {
            it.noSpace();
            it.setNewLines(1);
          };
          document.prepend(bracesPair.getValue(), _function_9);
        }
      }
    } else {
      Block _body_3 = arrowF.getBody();
      EList<Statement> _statements_3 = null;
      if (_body_3!=null) {
        _statements_3=_body_3.getStatements();
      }
      document.<Statement>format(IterableExtensions.<Statement>head(_statements_3));
    }
  }
  
  protected void _format(final ArrayLiteral al, @Extension final IFormattableDocument document) {
    final Pair<ISemanticRegion, ISemanticRegion> bracketPair = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(al).keywordPairs("[", "]"));
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(bracketPair, _function);
    final boolean sameLine = IterableExtensions.<ILineRegion>head(bracketPair.getKey().getLineRegions()).contains(bracketPair.getValue());
    if ((!sameLine)) {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.autowrap();
      };
      document.<ArrayElement>append(IterableExtensions.<ArrayElement>last(al.getElements()), _function_1);
      final Procedure2<ArrayElement, Integer> _function_2 = (ArrayElement it, Integer num) -> {
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it_1) -> {
          it_1.autowrap();
          it_1.setNewLines(0, 0, 1);
          if (((num).intValue() != 0)) {
            it_1.oneSpace();
          }
        };
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it_1) -> {
          it_1.noSpace();
        };
        document.<ArrayElement>append(document.<ArrayElement>prepend(it, _function_3), _function_4);
      };
      IterableExtensions.<ArrayElement>forEach(al.getElements(), _function_2);
      boolean _contains = IterableExtensions.<ILineRegion>last(bracketPair.getValue().getPreviousSemanticRegion().getLineRegions()).contains(bracketPair.getValue());
      boolean _not = (!_contains);
      if (_not) {
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        document.prepend(bracketPair.getValue(), _function_3);
      }
    } else {
      final Procedure2<ArrayElement, Integer> _function_4 = (ArrayElement it, Integer num) -> {
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it_1) -> {
          it_1.autowrap();
          if (((num).intValue() != 0)) {
            it_1.oneSpace();
          }
        };
        document.<ArrayElement>prepend(it, _function_5);
      };
      IterableExtensions.<ArrayElement>forEach(al.getElements(), _function_4);
    }
  }
  
  protected void _format(final ObjectLiteral ol, @Extension final IFormattableDocument document) {
    this.configureCommas(ol, document);
    final Pair<ISemanticRegion, ISemanticRegion> bracePair = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(ol).keywordPairs("{", "}"));
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(bracePair, _function);
    final boolean sameLine = IterableExtensions.<ILineRegion>head(bracePair.getKey().getLineRegions()).contains(IterableExtensions.<ILineRegion>head(bracePair.getKey().getNextSemanticRegion().getLineRegions()));
    if ((!sameLine)) {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.newLine();
      };
      document.prepend(bracePair.getValue(), _function_1);
      final Procedure2<PropertyAssignment, Integer> _function_2 = (PropertyAssignment it, Integer num) -> {
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it_1) -> {
          it_1.newLine();
        };
        document.<PropertyAssignment>prepend(it, _function_3);
      };
      IterableExtensions.<PropertyAssignment>forEach(ol.getPropertyAssignments(), _function_2);
      ISemanticRegion _nextSemanticRegion = bracePair.getKey().getNextSemanticRegion();
      ISemanticRegion _value = bracePair.getValue();
      boolean _equals = Objects.equal(_nextSemanticRegion, _value);
      if (_equals) {
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        document.append(bracePair.getKey(), _function_3);
      }
    } else {
      final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
        it.setNewLines(0);
      };
      document.append(bracePair.getKey(), _function_4);
      final Procedure2<PropertyAssignment, Integer> _function_5 = (PropertyAssignment it, Integer num) -> {
        final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it_1) -> {
          it_1.setNewLines(0);
          if (((num).intValue() != 0)) {
            it_1.autowrap();
            it_1.oneSpace();
          } else {
            it_1.noSpace();
          }
        };
        document.<PropertyAssignment>prepend(it, _function_6);
      };
      IterableExtensions.<PropertyAssignment>forEach(ol.getPropertyAssignments(), _function_5);
      final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
        it.setNewLines(0);
        it.noSpace();
        it.lowPriority();
      };
      document.prepend(bracePair.getValue(), _function_6);
    }
    final Consumer<EObject> _function_7 = (EObject it) -> {
      document.<EObject>format(it);
    };
    ol.eContents().forEach(_function_7);
  }
  
  protected void _format(final ForStatement fst, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.setNewLines(0);
      it.autowrap();
    };
    document.append(this.textRegionExtensions.regionFor(fst).keyword("for"), _function);
    final Pair<ISemanticRegion, ISemanticRegion> parenPair = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(fst).keywordPairs("(", ")"));
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.autowrap();
      it.setNewLines(0);
    };
    document.append(parenPair.getKey(), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
    };
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.setNewLines(0);
      it.autowrap();
    };
    document.append(document.prepend(parenPair.getValue(), _function_2), _function_3);
    final Consumer<ISemanticRegion> _function_4 = (ISemanticRegion it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it_1) -> {
        it_1.oneSpace();
        it_1.setNewLines(0);
        it_1.autowrap();
      };
      document.surround(it, _function_5);
    };
    this.textRegionExtensions.regionFor(fst).keywords("in", "of").forEach(_function_4);
    final Consumer<ISemanticRegion> _function_5 = (ISemanticRegion it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it_1) -> {
        it_1.noSpace();
        it_1.setNewLines(0);
      };
      final Procedure1<IHiddenRegionFormatter> _function_7 = (IHiddenRegionFormatter it_1) -> {
        it_1.oneSpace();
        it_1.setNewLines(0);
        it_1.autowrap();
      };
      document.append(document.prepend(it, _function_6), _function_7);
    };
    this.textRegionExtensions.regionFor(fst).keywords(";").forEach(_function_5);
    final Consumer<EObject> _function_6 = (EObject it) -> {
      document.<EObject>format(it);
    };
    fst.eContents().forEach(_function_6);
  }
  
  protected void _format(final TemplateLiteral tl, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    this.interiorBUGFIX(tl, _function, document);
    final Consumer<Expression> _function_1 = (Expression it) -> {
      boolean _matched = false;
      if (it instanceof TemplateSegment) {
        _matched=true;
        this.noOp();
      }
      if (!_matched) {
        final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it_1) -> {
          it_1.oneSpace();
          it_1.autowrap();
        };
        document.<Expression>surround(it, _function_2);
      }
      document.<Expression>format(it);
    };
    tl.getSegments().forEach(_function_1);
  }
  
  private Object noOp() {
    return null;
  }
  
  protected void _format(final TemplateSegment tl, @Extension final IFormattableDocument document) {
  }
  
  protected void _format(final TypeVariable tv, @Extension final IFormattableDocument document) {
    boolean _isDeclaredCovariant = tv.isDeclaredCovariant();
    if (_isDeclaredCovariant) {
      final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
      };
      document.append(this.textRegionExtensions.regionFor(tv).feature(TypesPackage.Literals.TYPE_VARIABLE__DECLARED_COVARIANT), _function);
    }
    boolean _isDeclaredContravariant = tv.isDeclaredContravariant();
    if (_isDeclaredContravariant) {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
      };
      document.append(this.textRegionExtensions.regionFor(tv).feature(TypesPackage.Literals.TYPE_VARIABLE__DECLARED_CONTRAVARIANT), _function_1);
    }
    TypeRef _declaredUpperBound = tv.getDeclaredUpperBound();
    boolean _tripleNotEquals = (_declaredUpperBound != null);
    if (_tripleNotEquals) {
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
      };
      document.surround(this.textRegionExtensions.regionFor(tv).keyword("extends"), _function_2);
      final TypeRef upperBound = tv.getDeclaredUpperBound();
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
      };
      document.surround(this.textRegionExtensions.immediatelyFollowing(upperBound).keyword("&"), _function_3);
      this.format(upperBound, document);
    }
  }
  
  protected void _format(final Expression exp, @Extension final IFormattableDocument document) {
    boolean _matched = false;
    if (exp instanceof BooleanLiteral) {
      _matched=true;
    }
    if (!_matched) {
      if (exp instanceof IdentifierRef) {
        _matched=true;
      }
    }
    if (!_matched) {
      if (exp instanceof IntLiteral) {
        _matched=true;
      }
    }
    if (!_matched) {
      if (exp instanceof NullLiteral) {
        _matched=true;
      }
    }
    if (!_matched) {
      if (exp instanceof NumberLiteral) {
        _matched=true;
      }
    }
    if (!_matched) {
      if (exp instanceof RegularExpressionLiteral) {
        _matched=true;
      }
    }
    if (!_matched) {
      if (exp instanceof StringLiteral) {
        _matched=true;
      }
    }
    if (!_matched) {
      if (exp instanceof ThisLiteral) {
        _matched=true;
      }
    }
    if (!_matched) {
      if (exp instanceof SuperLiteral) {
        _matched=true;
      }
    }
    if (!_matched) {
      if (exp instanceof JSXElement) {
        _matched=true;
      }
    }
    if (_matched) {
      return;
    }
    String _simpleName = exp.getClass().getSimpleName();
    String _plus = ("expression " + _simpleName);
    String _plus_1 = (_plus + " not yet implemented.");
    throw new UnsupportedOperationException(_plus_1);
  }
  
  /**
   * simply formats all content
   */
  public void genericFormat(final Expression exp, @Extension final IFormattableDocument document) {
    final Consumer<EObject> _function = (EObject it) -> {
      document.<EObject>format(it);
    };
    exp.eContents().forEach(_function);
  }
  
  protected void _format(final AssignmentExpression ass, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.<Expression>append(ass.getLhs(), _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.<Expression>prepend(ass.getRhs(), _function_1);
    document.<Expression>format(ass.getLhs());
    document.<Expression>format(ass.getRhs());
  }
  
  protected void _format(final ExpressionStatement eStmt, @Extension final IFormattableDocument docuemt) {
    docuemt.<Expression>format(eStmt.getExpression());
  }
  
  /**
   * var,let,const
   */
  protected void _format(final VariableStatement vStmt, @Extension final IFormattableDocument document) {
    if ((vStmt instanceof ModifiableElement)) {
      this.configureModifiers(vStmt, document);
    }
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.append(this.textRegionExtensions.regionFor(vStmt).feature(
      N4JSPackage.Literals.VARIABLE_DECLARATION_CONTAINER__VAR_STMT_KEYWORD), _function);
    this.configureCommas(vStmt, document);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    this.interiorBUGFIX(vStmt, _function_1, document);
    int _size = vStmt.getVarDeclsOrBindings().size();
    final int lastIdx = (_size - 1);
    final Procedure2<VariableDeclarationOrBinding, Integer> _function_2 = (VariableDeclarationOrBinding e, Integer i) -> {
      document.<VariableDeclarationOrBinding>format(e);
      if ((i > 0)) {
        if ((e instanceof VariableDeclaration)) {
          Expression _expression = ((VariableDeclaration)e).getExpression();
          boolean _tripleNotEquals = (_expression != null);
          if (_tripleNotEquals) {
            final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
              it.newLine();
            };
            document.<VariableDeclaration>prepend(((VariableDeclaration)e), _function_3);
          } else {
            final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
              it.setNewLines(0, 1, 1);
              it.lowPriority();
            };
            document.<VariableDeclaration>prepend(((VariableDeclaration)e), _function_4);
          }
        } else {
          if ((e instanceof VariableBinding)) {
            Expression _expression_1 = ((VariableBinding)e).getExpression();
            boolean _tripleNotEquals_1 = (_expression_1 != null);
            if (_tripleNotEquals_1) {
              final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
                it.newLine();
              };
              document.<VariableBinding>prepend(((VariableBinding)e), _function_5);
            } else {
              final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
                it.setNewLines(0, 1, 1);
                it.lowPriority();
              };
              document.<VariableBinding>prepend(((VariableBinding)e), _function_6);
            }
          }
        }
      }
      if ((i < lastIdx)) {
        if ((e instanceof VariableDeclaration)) {
          Expression _expression_2 = ((VariableDeclaration)e).getExpression();
          boolean _tripleNotEquals_2 = (_expression_2 != null);
          if (_tripleNotEquals_2) {
            final Procedure1<IHiddenRegionFormatter> _function_7 = (IHiddenRegionFormatter it) -> {
              it.newLine();
            };
            document.append(this.textRegionExtensions.immediatelyFollowing(e).keyword(","), _function_7);
          } else {
            final Procedure1<IHiddenRegionFormatter> _function_8 = (IHiddenRegionFormatter it) -> {
              it.setNewLines(0, 1, 1);
              it.lowPriority();
            };
            document.<VariableDeclaration>prepend(((VariableDeclaration)e), _function_8);
          }
        } else {
          if ((e instanceof VariableBinding)) {
            Expression _expression_3 = ((VariableBinding)e).getExpression();
            boolean _tripleNotEquals_3 = (_expression_3 != null);
            if (_tripleNotEquals_3) {
              final Procedure1<IHiddenRegionFormatter> _function_9 = (IHiddenRegionFormatter it) -> {
                it.newLine();
              };
              document.append(this.textRegionExtensions.immediatelyFollowing(e).keyword(","), _function_9);
            } else {
              final Procedure1<IHiddenRegionFormatter> _function_10 = (IHiddenRegionFormatter it) -> {
                it.setNewLines(0, 1, 1);
                it.lowPriority();
              };
              document.<VariableBinding>prepend(((VariableBinding)e), _function_10);
            }
          }
        }
      }
    };
    IterableExtensions.<VariableDeclarationOrBinding>forEach(vStmt.getVarDeclsOrBindings(), _function_2);
  }
  
  protected void _format(final VariableDeclaration vDecl, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.set(this.textRegionExtensions.previousHiddenRegion(vDecl), _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(this.textRegionExtensions.regionFor(vDecl).keyword("="), _function_1);
    document.<Expression>format(vDecl.getExpression());
    document.<TypeRef>format(vDecl.getDeclaredTypeRef());
  }
  
  protected void _format(final VariableBinding vBind, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.set(this.textRegionExtensions.previousHiddenRegion(vBind), _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.surround(this.textRegionExtensions.regionFor(vBind).keyword("="), _function_1);
    document.<BindingPattern>format(vBind.getPattern());
    document.<Expression>format(vBind.getExpression());
    document.<BindingPattern>format(vBind.getPattern());
  }
  
  protected void _format(final BindingPattern bp, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
      it.autowrap();
    };
    document.append(IterableExtensions.<ISemanticRegion>head(this.textRegionExtensions.semanticRegions(bp)), _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
      it.autowrap();
    };
    document.prepend(IterableExtensions.<ISemanticRegion>last(this.textRegionExtensions.semanticRegions(bp)), _function_1);
    this.configureCommas(bp, document);
    final Consumer<EObject> _function_2 = (EObject it) -> {
      document.<EObject>format(it);
    };
    bp.eContents().forEach(_function_2);
  }
  
  protected void _format(final ThrowStatement thrStmt, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(0, 0, 0);
      it.oneSpace();
    };
    document.<Expression>prepend(thrStmt.getExpression(), _function);
    document.<Expression>format(thrStmt.getExpression());
  }
  
  protected void _format(final CatchBlock ctch, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(0, 0, 0);
      it.oneSpace();
    };
    document.<CatchBlock>prepend(ctch, _function);
    document.<CatchVariable>format(ctch.getCatchVariable());
    document.<Block>format(ctch.getBlock());
  }
  
  protected void _format(final FinallyBlock finlly, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(0);
      it.oneSpace();
    };
    document.set(this.textRegionExtensions.previousHiddenRegion(finlly), _function);
    document.<Block>format(finlly.getBlock());
  }
  
  /**
   * Insert one space in front of first '{' in the direct content of the element.
   * semEObject is a semanticObject, e.g. N4EnumDecl, N4Classifier ...
   */
  private void insertSpaceInFrontOfCurlyBlockOpener(final EObject semEObject, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.prepend(this.textRegionExtensions.regionFor(semEObject).keyword("{"), _function);
  }
  
  /**
   * force: " @" and no newLine after '@'
   */
  private void noSpaceAfterAT(final EObject semEObject, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    document.prepend(document.append(this.textRegionExtensions.regionFor(semEObject).keyword("@"), _function), _function_1);
  }
  
  /**
   * On the direct level of an semantic Object enforce commas to ", " with autoWrap option.
   */
  private void configureCommas(final EObject semEObject, @Extension final IFormattableDocument document) {
    final Consumer<ISemanticRegion> _function = (ISemanticRegion it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_1) -> {
        it_1.noSpace();
      };
      document.prepend(it, _function_1);
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it_1) -> {
        it_1.oneSpace();
        it_1.autowrap();
      };
      document.append(it, _function_2);
    };
    this.textRegionExtensions.regionFor(semEObject).keywords(",").forEach(_function);
  }
  
  public void indentExcludingAnnotations(final EObject semObject, @Extension final IFormattableDocument document) {
    final Function1<ISemanticRegion, Boolean> _function = (ISemanticRegion it) -> {
      EObject _semanticElement = it.getSemanticElement();
      return Boolean.valueOf((!(_semanticElement instanceof Annotation)));
    };
    final ISemanticRegion begin = IterableExtensions.<ISemanticRegion>findFirst(this.textRegionExtensions.semanticRegions(semObject), _function);
    final ISemanticRegion end = IterableExtensions.<ISemanticRegion>last(this.textRegionExtensions.semanticRegions(semObject));
    if ((begin != end)) {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.indent();
      };
      document.<ISemanticRegion, ISemanticRegion>interior(begin, end, _function_1);
    }
  }
  
  private void _configureAnnotations(final AnnotableN4MemberDeclaration semEObject, @Extension final IFormattableDocument document) {
    this.configureAnnotations(semEObject.getAnnotationList(), document);
  }
  
  private void _configureAnnotations(final AnnotablePropertyAssignment semEObject, @Extension final IFormattableDocument document) {
    this.configureAnnotations(semEObject.getAnnotationList(), document);
  }
  
  private void _configureAnnotations(final AnnotableScriptElement semEObject, @Extension final IFormattableDocument document) {
    this.configureAnnotations(semEObject.getAnnotationList(), document);
  }
  
  private void _configureAnnotations(final AnnotableExpression semEObject, @Extension final IFormattableDocument document) {
    this.configureAnnotations(semEObject.getAnnotationList(), document);
  }
  
  private void _configureAnnotations(final AbstractAnnotationList aList, @Extension final IFormattableDocument document) {
    if (((aList == null) || aList.getAnnotations().isEmpty())) {
      return;
    }
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.setNewLines(2, 2, 2);
      it.highPriority();
    };
    document.<AbstractAnnotationList>prepend(aList, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.<AbstractAnnotationList>append(aList, _function_1);
    final Procedure2<Annotation, Integer> _function_2 = (Annotation it, Integer idx) -> {
      this.configureAnnotation(it, document, true, ((idx).intValue() == 0));
    };
    IterableExtensions.<Annotation>forEach(aList.getAnnotations(), _function_2);
  }
  
  /**
   * @param withLineWraps  <code>true</code> do line-wrapping
   * @param isFirstenAnnotation if this is the first annotation in a sequence ( used with line-wrapping in front of '@')
   */
  private ISemanticRegion configureAnnotation(final Annotation it, @Extension final IFormattableDocument document, final boolean withLineWraps, final boolean isFirstAnnotation) {
    ISemanticRegion _xblockexpression = null;
    {
      final Pair<ISemanticRegion, ISemanticRegion> parens = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(it).keywordPairs("(", ")"));
      if ((parens != null)) {
        final Procedure1<Pair<ISemanticRegion, ISemanticRegion>> _function = (Pair<ISemanticRegion, ISemanticRegion> it_1) -> {
          final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_2) -> {
            it_2.noSpace();
          };
          final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it_2) -> {
            it_2.noSpace();
          };
          document.append(document.prepend(it_1.getKey(), _function_1), _function_2);
          final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it_2) -> {
            it_2.noSpace();
          };
          final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it_2) -> {
            if (withLineWraps) {
              it_2.noSpace();
              it_2.setNewLines(1);
            } else {
              it_2.oneSpace();
              it_2.setNewLines(0);
            }
          };
          document.append(document.prepend(it_1.getValue(), _function_3), _function_4);
          final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it_2) -> {
            it_2.indent();
          };
          document.<ISemanticRegion, ISemanticRegion>interior(it_1, _function_5);
          if ((withLineWraps && (!isFirstAnnotation))) {
            final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it_2) -> {
              it_2.setNewLines(1);
            };
            document.prepend(it_1.getKey().getPreviousSemanticRegion().getPreviousSemanticRegion(), _function_6);
          }
        };
        ObjectExtensions.<Pair<ISemanticRegion, ISemanticRegion>>operator_doubleArrow(parens, _function);
        this.configureCommas(it, document);
      }
      ISemanticRegion _head = IterableExtensions.<ISemanticRegion>head(this.textRegionExtensions.semanticRegions(it));
      final Procedure1<ISemanticRegion> _function_1 = (ISemanticRegion it_1) -> {
        EObject _grammarElement = it_1.getGrammarElement();
        if ((_grammarElement instanceof Keyword)) {
          final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it_2) -> {
            it_2.noSpace();
            it_2.setNewLines(0);
          };
          document.append(it_1, _function_2);
        } else {
          final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it_2) -> {
            it_2.noSpace();
            it_2.setNewLines(0);
          };
          document.prepend(it_1, _function_3);
        }
      };
      _xblockexpression = ObjectExtensions.<ISemanticRegion>operator_doubleArrow(_head, _function_1);
    }
    return _xblockexpression;
  }
  
  private void _configureAnnotations(final Object semEObject, @Extension final IFormattableDocument document) {
  }
  
  private void _configureAnnotations(final Void x, @Extension final IFormattableDocument document) {
  }
  
  private void configureAnnotationsInLine(final FormalParameter fpar, @Extension final IFormattableDocument document) {
    boolean _isEmpty = fpar.getAnnotations().isEmpty();
    if (_isEmpty) {
      return;
    }
    Annotation _head = IterableExtensions.<Annotation>head(fpar.getAnnotations());
    final Procedure1<Annotation> _function = (Annotation it) -> {
      this.configureAnnotation(it, document, false, true);
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_1) -> {
        it_1.noSpace();
        it_1.setNewLines(0);
        it_1.autowrap();
      };
      document.<Annotation>prepend(it, _function_1);
    };
    ObjectExtensions.<Annotation>operator_doubleArrow(_head, _function);
    final Consumer<Annotation> _function_1 = (Annotation it) -> {
      this.configureAnnotation(it, document, false, false);
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it_1) -> {
        it_1.oneSpace();
        it_1.setNewLines(0);
        it_1.autowrap();
      };
      document.<Annotation>prepend(it, _function_2);
    };
    IterableExtensions.<Annotation>tail(fpar.getAnnotations()).forEach(_function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.setNewLines(0);
      it.autowrap();
    };
    document.<Annotation>append(IterableExtensions.<Annotation>last(fpar.getAnnotations()), _function_2);
  }
  
  /**
   * only script-level annotations '@@'
   */
  private void formatScriptAnnotations(final Script script, @Extension final IFormattableDocument document) {
    boolean _isEmpty = script.getAnnotations().isEmpty();
    if (_isEmpty) {
      return;
    }
    boolean _containsComment = this.textRegionExtensions.previousHiddenRegion(IterableExtensions.<Annotation>head(script.getAnnotations())).containsComment();
    if (_containsComment) {
      final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
        it.noSpace();
      };
      document.<Annotation>prepend(IterableExtensions.<Annotation>head(script.getAnnotations()), _function);
    } else {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
        it.setNewLines(0);
      };
      document.<Annotation>prepend(IterableExtensions.<Annotation>head(script.getAnnotations()), _function_1);
    }
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.setNewLines(2, 2, 2);
    };
    document.<Annotation>append(IterableExtensions.<Annotation>last(script.getAnnotations()), _function_2);
    final Procedure2<Annotation, Integer> _function_3 = (Annotation it, Integer idx) -> {
      if (((idx).intValue() != 0)) {
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it_1) -> {
          it_1.setNewLines(1);
          it_1.noSpace();
        };
        document.<Annotation>prepend(it, _function_4);
      }
      ISemanticRegion _head = IterableExtensions.<ISemanticRegion>head(this.textRegionExtensions.semanticRegions(it));
      final Procedure1<ISemanticRegion> _function_5 = (ISemanticRegion it_1) -> {
        final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it_2) -> {
          it_2.noSpace();
          it_2.setNewLines(0);
        };
        document.append(it_1, _function_6);
      };
      ObjectExtensions.<ISemanticRegion>operator_doubleArrow(_head, _function_5);
    };
    IterableExtensions.<Annotation>forEach(script.getAnnotations(), _function_3);
  }
  
  @Override
  public ITextReplacer createCommentReplacer(final IComment comment) {
    ITextReplacer _xblockexpression = null;
    {
      final EObject grammarElement = comment.getGrammarElement();
      if ((grammarElement instanceof AbstractRule)) {
        final String ruleName = ((AbstractRule)grammarElement).getName();
        boolean _startsWith = ruleName.startsWith("ML");
        if (_startsWith) {
          final String cText = comment.getText();
          if ((cText.startsWith("/**") && (!cText.startsWith("/***")))) {
            return new N4MultilineCommentReplacer(comment, '*');
          } else {
            boolean _startsWith_1 = cText.startsWith("/*-");
            if (_startsWith_1) {
              boolean _isNotFirstInLine = N4JSFormatter.isNotFirstInLine(comment);
              boolean _not = (!_isNotFirstInLine);
              return new OffMultilineCommentReplacer(comment, _not);
            } else {
              return new FixedMultilineCommentReplacer(comment);
            }
          }
        }
        boolean _startsWith_2 = ruleName.startsWith("SL");
        if (_startsWith_2) {
          boolean _isNotFirstInLine_1 = N4JSFormatter.isNotFirstInLine(comment);
          if (_isNotFirstInLine_1) {
            return new SinglelineDocCommentReplacer(comment, "//");
          } else {
            return new SinglelineCodeCommentReplacer(comment, "//");
          }
        }
      }
      _xblockexpression = super.createCommentReplacer(comment);
    }
    return _xblockexpression;
  }
  
  private static boolean isNotFirstInLine(final IComment comment) {
    final ILineRegion lineRegion = comment.getLineRegions().get(0);
    boolean _contains = comment.contains(lineRegion.getOffset());
    return (!_contains);
  }
  
  @Override
  public IMerger<ITextReplacer> createTextReplacerMerger() {
    return new IndentHandlingTextReplaceMerger(this);
  }
  
  /**
   * DEBUG-helper
   */
  private static String containmentStructure(final EObject eo) {
    final String name = eo.getClass().getSimpleName();
    EObject _eContainer = eo.eContainer();
    boolean _tripleNotEquals = (_eContainer != null);
    if (_tripleNotEquals) {
      StringConcatenation _builder = new StringConcatenation();
      String _containmentStructure = N4JSFormatter.containmentStructure(eo.eContainer());
      _builder.append(_containmentStructure);
      _builder.append(".");
      String _name = eo.eContainingFeature().getName();
      _builder.append(_name);
      _builder.append("-> ");
      _builder.append(name);
      return _builder.toString();
    }
    return name;
  }
  
  /**
   * HELPER to avoid Warnings in code, since @SuppressWarnings("unused") is not active in xtend code.
   */
  public int suppressUnusedWarnings(final Object... e) {
    return N4JSFormatter.PRIO_4;
  }
  
  /**
   * Type Expression
   */
  protected void _format(final UnionTypeExpression ute, @Extension final IFormattableDocument document) {
    final Consumer<ISemanticRegion> _function = (ISemanticRegion it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_1) -> {
        it_1.oneSpace();
        it_1.setNewLines(0);
      };
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it_1) -> {
        it_1.autowrap();
        it_1.highPriority();
      };
      document.prepend(document.surround(it, _function_1), _function_2);
    };
    this.textRegionExtensions.regionFor(ute).keywords("|").forEach(_function);
    final Consumer<TypeRef> _function_1 = (TypeRef it) -> {
      document.<TypeRef>format(it);
    };
    ute.getTypeRefs().forEach(_function_1);
    final ISemanticRegion kwUnion = this.textRegionExtensions.regionFor(ute).keyword("union");
    if ((kwUnion != null)) {
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
      };
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
        it.setNewLines(0);
      };
      final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
        it.setNewLines(0);
      };
      document.append(document.append(document.prepend(kwUnion, _function_2), _function_3).getNextSemanticRegion(), _function_4);
      final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
        it.setNewLines(0);
      };
      document.prepend(IterableExtensions.<ISemanticRegion>last(this.textRegionExtensions.semanticRegions(ute)), _function_5);
    }
  }
  
  protected void _format(final IntersectionTypeExpression ite, @Extension final IFormattableDocument document) {
    final Consumer<ISemanticRegion> _function = (ISemanticRegion it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it_1) -> {
        it_1.oneSpace();
        it_1.setNewLines(0);
      };
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it_1) -> {
        it_1.autowrap();
        it_1.highPriority();
      };
      document.prepend(document.surround(it, _function_1), _function_2);
    };
    this.textRegionExtensions.regionFor(ite).keywords("&").forEach(_function);
    final Consumer<TypeRef> _function_1 = (TypeRef it) -> {
      document.<TypeRef>format(it);
    };
    ite.getTypeRefs().forEach(_function_1);
    final ISemanticRegion kwInersection = this.textRegionExtensions.regionFor(ite).keyword("intersection");
    if ((kwInersection != null)) {
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
      };
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
        it.setNewLines(0);
      };
      final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
        it.setNewLines(0);
      };
      document.append(document.append(document.prepend(kwInersection, _function_2), _function_3).getNextSemanticRegion(), _function_4);
      final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
        it.setNewLines(0);
      };
      document.prepend(IterableExtensions.<ISemanticRegion>last(this.textRegionExtensions.semanticRegions(ite)), _function_5);
    }
  }
  
  protected void _format(final TStructMember tsm, @Extension final IFormattableDocument document) {
    if ((tsm instanceof TField)) {
      this.configureOptionality(((TField)tsm), document);
    } else {
      if ((tsm instanceof org.eclipse.n4js.ts.types.FieldAccessor)) {
        this.configureGetSetKeyword(((org.eclipse.n4js.ts.types.FieldAccessor)tsm), document);
        this.configureOptionality(((org.eclipse.n4js.ts.types.FieldAccessor)tsm), document);
        final Pair<ISemanticRegion, ISemanticRegion> parenPair = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(tsm).keywordPairs("(", ")"));
        final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
          it.noSpace();
          it.setNewLines(0);
        };
        final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
          it.noSpace();
        };
        document.append(document.prepend(parenPair.getKey(), _function), _function_1);
      }
    }
    final Consumer<EObject> _function_2 = (EObject it) -> {
      document.<EObject>format(it);
    };
    tsm.eContents().forEach(_function_2);
  }
  
  private void configureUndefModifier(final StaticBaseTypeRef sbtr, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
    };
    document.prepend(this.textRegionExtensions.regionFor(sbtr).feature(TypeRefsPackage.Literals.TYPE_REF__FOLLOWED_BY_QUESTION_MARK), _function);
  }
  
  protected void _format(final ThisTypeRef ttr, @Extension final IFormattableDocument document) {
    this.configureUndefModifier(ttr, document);
    if ((ttr instanceof ThisTypeRefStructural)) {
      final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
        it.indent();
      };
      this.interiorBUGFIX(ttr, _function, document);
      this.configureStructuralAdditions(ttr, document);
      final Consumer<EObject> _function_1 = (EObject it) -> {
        document.<EObject>format(it);
      };
      ((ThisTypeRefStructural)ttr).eContents().forEach(_function_1);
    }
  }
  
  protected void _format(final ParameterizedTypeRef ptr, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    this.interiorBUGFIX(ptr, _function, document);
    this.configureUndefModifier(ptr, document);
    final Consumer<ISemanticRegion> _function_1 = (ISemanticRegion it) -> {
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it_1) -> {
        it_1.oneSpace();
        it_1.setNewLines(0);
      };
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it_1) -> {
        it_1.autowrap();
        it_1.highPriority();
      };
      document.append(document.surround(it, _function_2), _function_3);
    };
    this.textRegionExtensions.regionFor(ptr).keywords("&", "|").forEach(_function_1);
    boolean _isArrayTypeLiteral = ptr.isArrayTypeLiteral();
    if (_isArrayTypeLiteral) {
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
      };
      document.append(this.textRegionExtensions.regionFor(ptr).keyword("["), _function_2);
      final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
      };
      document.append(this.textRegionExtensions.regionFor(ptr).keyword("]"), _function_3);
    }
    this.formatTypeArguments(ptr, document);
    this.configureStructuralAdditions(ptr, document);
    final Consumer<EObject> _function_4 = (EObject it) -> {
      document.<EObject>format(it);
    };
    ptr.eContents().forEach(_function_4);
  }
  
  /**
   * used for "~X with {}" except for the 'X' part.
   */
  public void configureStructuralAdditions(final TypeRef ptr, @Extension final IFormattableDocument document) {
    final ISemanticRegion semRegTypingStrategy = this.textRegionExtensions.regionFor(ptr).ruleCallTo(this._n4JSGrammarAccess.getTypingStrategyUseSiteOperatorRule());
    if ((semRegTypingStrategy != null)) {
      final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
        it.oneSpace();
      };
      final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
        it.noSpace();
        it.setNewLines(0);
      };
      document.append(document.prepend(semRegTypingStrategy, _function), _function_1);
      final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      };
      document.append(semRegTypingStrategy.getNextSemanticRegion(), _function_2);
      final ISemanticRegion kwWith = this.textRegionExtensions.regionFor(ptr).keyword("with");
      if ((kwWith != null)) {
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
          it.setNewLines(0);
          it.autowrap();
        };
        document.surround(kwWith, _function_3);
        final Pair<ISemanticRegion, ISemanticRegion> bracesPair = IterableExtensions.<Pair<ISemanticRegion, ISemanticRegion>>head(this.textRegionExtensions.regionFor(ptr).keywordPairs("{", "}"));
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.noSpace();
          it.setNewLines(0);
          it.autowrap();
        };
        document.append(bracesPair.getKey(), _function_4);
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
          it.noSpace();
          it.setNewLines(0);
          it.autowrap();
        };
        document.prepend(bracesPair.getValue(), _function_5);
        final Consumer<ISemanticRegion> _function_6 = (ISemanticRegion it) -> {
          final Procedure1<IHiddenRegionFormatter> _function_7 = (IHiddenRegionFormatter it_1) -> {
            it_1.noSpace();
            it_1.setNewLines(0);
          };
          final Procedure1<IHiddenRegionFormatter> _function_8 = (IHiddenRegionFormatter it_1) -> {
            it_1.oneSpace();
            it_1.setNewLines(0);
            it_1.autowrap();
            it_1.lowPriority();
          };
          document.append(document.prepend(it, _function_7), _function_8);
        };
        this.textRegionExtensions.regionFor(ptr).keywords(";").forEach(_function_6);
        final Consumer<TStructMember> _function_7 = (TStructMember it) -> {
          final Procedure1<IHiddenRegionFormatter> _function_8 = (IHiddenRegionFormatter it_1) -> {
            it_1.oneSpace();
            it_1.setNewLines(0);
            it_1.autowrap();
          };
          document.set(this.textRegionExtensions.regionForEObject(it).getPreviousHiddenRegion(), _function_8);
        };
        IterableExtensions.<TStructMember>tail(((StructuralTypeRef) ptr).getAstStructuralMembers()).forEach(_function_7);
      }
    }
  }
  
  /**
   * formats type argument section including outside border.
   */
  public void formatTypeArguments(final ParameterizedTypeRef semObject, @Extension final IFormattableDocument document) {
    boolean _isEmpty = semObject.getTypeArgs().isEmpty();
    if (_isEmpty) {
      return;
    }
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
      it.lowPriority();
    };
    document.prepend(document.append(this.textRegionExtensions.regionFor(semObject).keyword("<"), _function), _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
      it.lowPriority();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(semObject).keyword(">"), _function_2), _function_3);
    EList<TypeArgument> _typeArgs = semObject.getTypeArgs();
    for (final TypeArgument typeArg : _typeArgs) {
      {
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.noSpace();
        };
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        document.append(this.textRegionExtensions.immediatelyFollowing(document.<TypeArgument>append(typeArg, _function_4)).keyword(","), _function_5);
        this.format(typeArg, document);
      }
    }
  }
  
  private void configureGetSetKeyword(final FieldAccessor fieldAccessor, @Extension final IFormattableDocument document) {
    String _xifexpression = null;
    if ((fieldAccessor instanceof GetterDeclaration)) {
      _xifexpression = "get";
    } else {
      _xifexpression = "set";
    }
    final String kw = _xifexpression;
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.setNewLines(0);
      it.autowrap();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(fieldAccessor).keyword(kw), _function), _function_1);
  }
  
  private void configureGetSetKeyword(final org.eclipse.n4js.ts.types.FieldAccessor tFieldAccessor, @Extension final IFormattableDocument document) {
    String _xifexpression = null;
    if ((tFieldAccessor instanceof TGetter)) {
      _xifexpression = "get";
    } else {
      _xifexpression = "set";
    }
    final String kw = _xifexpression;
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
    };
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.oneSpace();
      it.setNewLines(0);
      it.autowrap();
    };
    document.append(document.prepend(this.textRegionExtensions.regionFor(tFieldAccessor).keyword(kw), _function), _function_1);
  }
  
  private void configureOptionality(final N4FieldDeclaration fieldDecl, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
    };
    document.prepend(this.textRegionExtensions.regionFor(fieldDecl).feature(N4JSPackage.Literals.N4_FIELD_DECLARATION__DECLARED_OPTIONAL), _function);
  }
  
  private void configureOptionality(final FieldAccessor fieldAccessor, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
    };
    document.prepend(this.textRegionExtensions.regionFor(fieldAccessor).feature(N4JSPackage.Literals.FIELD_ACCESSOR__DECLARED_OPTIONAL), _function);
  }
  
  private void configureOptionality(final TField tField, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
    };
    document.prepend(this.textRegionExtensions.regionFor(tField).feature(TypesPackage.Literals.TFIELD__OPTIONAL), _function);
  }
  
  private void configureOptionality(final org.eclipse.n4js.ts.types.FieldAccessor tFieldAccessor, @Extension final IFormattableDocument document) {
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.noSpace();
      it.setNewLines(0);
    };
    document.prepend(this.textRegionExtensions.regionFor(tFieldAccessor).feature(TypesPackage.Literals.FIELD_ACCESSOR__OPTIONAL), _function);
  }
  
  /**
   * Temporarily used method to replace document.interior(EObject, Procedure1) to prevent wrong indentations.
   * 
   * Main pattern replace document-extension method call:
   * <pre>
   * object.interior[indent]
   * </pre>
   * by
   * <pre>
   * object.interiorBUGFIX([indent],document);
   * <pre>
   */
  public void interiorBUGFIX(final EObject object, final Procedure1<? super IHiddenRegionFormatter> init, final IFormattableDocument document) {
    final IEObjectRegion objRegion = this.getTextRegionAccess().regionForEObject(object);
    if ((objRegion != null)) {
      final IHiddenRegion previous = objRegion.getPreviousHiddenRegion();
      final IHiddenRegion next = objRegion.getNextHiddenRegion();
      if ((((previous != null) && (next != null)) && (!Objects.equal(previous, next)))) {
        final ISemanticRegion nsr = previous.getNextSemanticRegion();
        final ISemanticRegion psr = next.getPreviousSemanticRegion();
        boolean _notEquals = (!Objects.equal(nsr, psr));
        if (_notEquals) {
          document.<ISemanticRegion, ISemanticRegion>interior(nsr, psr, init);
        } else {
        }
      }
    }
  }
  
  /**
   * Dummy method to prevent accidentally calling interior - extension method form document. You should call interiorBUGFIX instead !
   */
  public Procedure1<? super IFormattableDocument> interior(final EObject eo, final Procedure1<? super IHiddenRegionFormatter> init) {
    throw new IllegalStateException("Method should not be called.");
  }
  
  public void format(final Object clazz, final IFormattableDocument document) {
    if (clazz instanceof N4ClassDeclaration) {
      _format((N4ClassDeclaration)clazz, document);
      return;
    } else if (clazz instanceof N4InterfaceDeclaration) {
      _format((N4InterfaceDeclaration)clazz, document);
      return;
    } else if (clazz instanceof ArrowFunction) {
      _format((ArrowFunction)clazz, document);
      return;
    } else if (clazz instanceof N4EnumDeclaration) {
      _format((N4EnumDeclaration)clazz, document);
      return;
    } else if (clazz instanceof TemplateSegment) {
      _format((TemplateSegment)clazz, document);
      return;
    } else if (clazz instanceof IntersectionTypeExpression) {
      _format((IntersectionTypeExpression)clazz, document);
      return;
    } else if (clazz instanceof ParameterizedTypeRef) {
      _format((ParameterizedTypeRef)clazz, document);
      return;
    } else if (clazz instanceof ThisTypeRef) {
      _format((ThisTypeRef)clazz, document);
      return;
    } else if (clazz instanceof UnionTypeExpression) {
      _format((UnionTypeExpression)clazz, document);
      return;
    } else if (clazz instanceof TypeVariable) {
      _format((TypeVariable)clazz, document);
      return;
    } else if (clazz instanceof ArrayLiteral) {
      _format((ArrayLiteral)clazz, document);
      return;
    } else if (clazz instanceof ForStatement) {
      _format((ForStatement)clazz, document);
      return;
    } else if (clazz instanceof FunctionExpression) {
      _format((FunctionExpression)clazz, document);
      return;
    } else if (clazz instanceof N4FieldDeclaration) {
      _format((N4FieldDeclaration)clazz, document);
      return;
    } else if (clazz instanceof ObjectLiteral) {
      _format((ObjectLiteral)clazz, document);
      return;
    } else if (clazz instanceof ParenExpression) {
      _format((ParenExpression)clazz, document);
      return;
    } else if (clazz instanceof TemplateLiteral) {
      _format((TemplateLiteral)clazz, document);
      return;
    } else if (clazz instanceof VariableDeclaration) {
      _format((VariableDeclaration)clazz, document);
      return;
    } else if (clazz instanceof TStructMember) {
      _format((TStructMember)clazz, document);
      return;
    } else if (clazz instanceof AdditiveExpression) {
      _format((AdditiveExpression)clazz, document);
      return;
    } else if (clazz instanceof AssignmentExpression) {
      _format((AssignmentExpression)clazz, document);
      return;
    } else if (clazz instanceof AwaitExpression) {
      _format((AwaitExpression)clazz, document);
      return;
    } else if (clazz instanceof BinaryBitwiseExpression) {
      _format((BinaryBitwiseExpression)clazz, document);
      return;
    } else if (clazz instanceof BinaryLogicalExpression) {
      _format((BinaryLogicalExpression)clazz, document);
      return;
    } else if (clazz instanceof Block) {
      _format((Block)clazz, document);
      return;
    } else if (clazz instanceof CastExpression) {
      _format((CastExpression)clazz, document);
      return;
    } else if (clazz instanceof CommaExpression) {
      _format((CommaExpression)clazz, document);
      return;
    } else if (clazz instanceof ConditionalExpression) {
      _format((ConditionalExpression)clazz, document);
      return;
    } else if (clazz instanceof EqualityExpression) {
      _format((EqualityExpression)clazz, document);
      return;
    } else if (clazz instanceof ExportDeclaration) {
      _format((ExportDeclaration)clazz, document);
      return;
    } else if (clazz instanceof ExpressionStatement) {
      _format((ExpressionStatement)clazz, document);
      return;
    } else if (clazz instanceof IfStatement) {
      _format((IfStatement)clazz, document);
      return;
    } else if (clazz instanceof ImportDeclaration) {
      _format((ImportDeclaration)clazz, document);
      return;
    } else if (clazz instanceof IndexedAccessExpression) {
      _format((IndexedAccessExpression)clazz, document);
      return;
    } else if (clazz instanceof MultiplicativeExpression) {
      _format((MultiplicativeExpression)clazz, document);
      return;
    } else if (clazz instanceof NamespaceImportSpecifier) {
      _format((NamespaceImportSpecifier)clazz, document);
      return;
    } else if (clazz instanceof NewExpression) {
      _format((NewExpression)clazz, document);
      return;
    } else if (clazz instanceof ParameterizedCallExpression) {
      _format((ParameterizedCallExpression)clazz, document);
      return;
    } else if (clazz instanceof ParameterizedPropertyAccessExpression) {
      _format((ParameterizedPropertyAccessExpression)clazz, document);
      return;
    } else if (clazz instanceof PostfixExpression) {
      _format((PostfixExpression)clazz, document);
      return;
    } else if (clazz instanceof PromisifyExpression) {
      _format((PromisifyExpression)clazz, document);
      return;
    } else if (clazz instanceof RelationalExpression) {
      _format((RelationalExpression)clazz, document);
      return;
    } else if (clazz instanceof ReturnStatement) {
      _format((ReturnStatement)clazz, document);
      return;
    } else if (clazz instanceof ShiftExpression) {
      _format((ShiftExpression)clazz, document);
      return;
    } else if (clazz instanceof SwitchStatement) {
      _format((SwitchStatement)clazz, document);
      return;
    } else if (clazz instanceof TaggedTemplateString) {
      _format((TaggedTemplateString)clazz, document);
      return;
    } else if (clazz instanceof ThrowStatement) {
      _format((ThrowStatement)clazz, document);
      return;
    } else if (clazz instanceof UnaryExpression) {
      _format((UnaryExpression)clazz, document);
      return;
    } else if (clazz instanceof VariableBinding) {
      _format((VariableBinding)clazz, document);
      return;
    } else if (clazz instanceof VariableStatement) {
      _format((VariableStatement)clazz, document);
      return;
    } else if (clazz instanceof YieldExpression) {
      _format((YieldExpression)clazz, document);
      return;
    } else if (clazz instanceof XtextResource) {
      _format((XtextResource)clazz, document);
      return;
    } else if (clazz instanceof AbstractCaseClause) {
      _format((AbstractCaseClause)clazz, document);
      return;
    } else if (clazz instanceof BindingPattern) {
      _format((BindingPattern)clazz, document);
      return;
    } else if (clazz instanceof CatchBlock) {
      _format((CatchBlock)clazz, document);
      return;
    } else if (clazz instanceof Expression) {
      _format((Expression)clazz, document);
      return;
    } else if (clazz instanceof FinallyBlock) {
      _format((FinallyBlock)clazz, document);
      return;
    } else if (clazz instanceof FunctionOrFieldAccessor) {
      _format((FunctionOrFieldAccessor)clazz, document);
      return;
    } else if (clazz instanceof NamedImportSpecifier) {
      _format((NamedImportSpecifier)clazz, document);
      return;
    } else if (clazz instanceof Script) {
      _format((Script)clazz, document);
      return;
    } else if (clazz instanceof EObject) {
      _format((EObject)clazz, document);
      return;
    } else if (clazz == null) {
      _format((Void)null, document);
      return;
    } else if (clazz != null) {
      _format(clazz, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(clazz, document).toString());
    }
  }
  
  private void configureAnnotations(final Object semEObject, final IFormattableDocument document) {
    if (semEObject instanceof AnnotablePropertyAssignment) {
      _configureAnnotations((AnnotablePropertyAssignment)semEObject, document);
      return;
    } else if (semEObject instanceof AnnotableExpression) {
      _configureAnnotations((AnnotableExpression)semEObject, document);
      return;
    } else if (semEObject instanceof AnnotableN4MemberDeclaration) {
      _configureAnnotations((AnnotableN4MemberDeclaration)semEObject, document);
      return;
    } else if (semEObject instanceof AnnotableScriptElement) {
      _configureAnnotations((AnnotableScriptElement)semEObject, document);
      return;
    } else if (semEObject instanceof AbstractAnnotationList) {
      _configureAnnotations((AbstractAnnotationList)semEObject, document);
      return;
    } else if (semEObject == null) {
      _configureAnnotations((Void)null, document);
      return;
    } else if (semEObject != null) {
      _configureAnnotations(semEObject, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(semEObject, document).toString());
    }
  }
}
