/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.tests.codegen;

import org.eclipse.n4js.tests.codegen.Member;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Generates code for a field of a {@link Classifier}.
 */
@SuppressWarnings("all")
public class Field extends Member<Field> {
  private String fieldType;
  
  private String defaultValue;
  
  /**
   * Creates a new field with the given values.
   * 
   * @param name the name of this field
   */
  public Field(final String name) {
    super(name);
  }
  
  /**
   * Sets the field type.
   * 
   * @param fieldType the field type
   */
  public Field setFieldType(final String fieldType) {
    this.fieldType = fieldType;
    return this;
  }
  
  /**
   * Sets the default value or expression.
   * 
   * @param defaultValue the default value
   */
  public Field setDefaultValue(final String defaultValue) {
    this.defaultValue = defaultValue;
    return this;
  }
  
  @java.lang.Override
  protected CharSequence generateMember() {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(this.fieldType);
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        _builder.append(this.fieldType);
        _builder.append(" ");
      }
    }
    _builder.append(this.name);
    {
      boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty(this.defaultValue);
      boolean _not_1 = (!_isNullOrEmpty_1);
      if (_not_1) {
        _builder.append(" = ");
        _builder.append(this.defaultValue);
      }
    }
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
