/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.utils.process;

import com.google.common.base.Strings;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

/**
 * Representation of the result of a terminated process.
 */
@Accessors(AccessorType.PUBLIC_GETTER)
@SuppressWarnings("all")
public class ProcessResult {
  private static final String LN = System.lineSeparator();
  
  private final int exitCode;
  
  private final String stdOut;
  
  private final String stdErr;
  
  ProcessResult(final int exitCode, final String stdOut, final String stdErr) {
    this.exitCode = exitCode;
    this.stdOut = Strings.nullToEmpty(stdOut);
    this.stdErr = Strings.nullToEmpty(stdErr);
  }
  
  /**
   * Returns with {@code true} if the exit code is {@code 0}, otherwise {@code false}.
   */
  public boolean isOK() {
    return (0 == this.exitCode);
  }
  
  @Override
  public String toString() {
    return ((((((((("Exit code:" + Integer.valueOf(this.exitCode)) + ProcessResult.LN) + "Standard out:") + ProcessResult.LN) + this.stdOut) + ProcessResult.LN) + "Standard error:") + ProcessResult.LN) + this.stdErr);
  }
  
  /**
   * Creates {@link Throwable} instance with provided custom message and {@link #getStdErr error output} of this result.
   */
  public Throwable toThrowable(final String message) {
    final Exception exc = new Exception((((message + ProcessResult.LN) + ProcessResult.LN) + this.stdErr));
    exc.setStackTrace(new StackTraceElement[] {});
    return exc;
  }
  
  @Pure
  public int getExitCode() {
    return this.exitCode;
  }
  
  @Pure
  public String getStdOut() {
    return this.stdOut;
  }
  
  @Pure
  public String getStdErr() {
    return this.stdErr;
  }
}
