/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.migrations;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4idl.migrations.MigrationMatcher;
import org.eclipse.n4js.n4idl.migrations.TypeDistanceComputer;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TMigratable;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.versions.VersionableUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;

public class MigrationLocator {
    @Inject
    private N4JSTypeSystem typeSystem;
    @Inject
    private TypeDistanceComputer typeDistanceComputer;

    public List<TMigration> findMigration(List<Argument> arguments, TMigration contextMigration) {
        if (arguments.isEmpty()) {
            return Collections.emptyList();
        }
        List<TypeRef> argumentTypeRefs = this.getTypeRefsFromArguments(arguments);
        Iterable<TMigration> allMigrationCandidates = this.getAllMigrationCandidates(argumentTypeRefs);
        return this.selectMigrationCandidate(argumentTypeRefs, allMigrationCandidates, contextMigration);
    }

    public List<TypeRef> getTypeRefsFromArguments(List<Argument> arguments) {
        return arguments.stream().map(a -> this.typeSystem.tau((TypableElement)a.getExpression())).filter(a -> a != null).collect(Collectors.toList());
    }

    private Iterable<TMigration> getAllMigrationCandidates(List<TypeRef> argumentTypeRefs) {
        return () -> argumentTypeRefs.stream().flatMap(ref -> VersionableUtils.streamVersionedSubReferences((TypeRef)ref)).map(ref -> ref.getDeclaredType()).filter(type -> type != null).filter(type -> type instanceof TMigratable).flatMap(migratable -> this.getAllMigrations((TMigratable)migratable)).iterator();
    }

    private Stream<TMigration> getAllMigrations(TMigratable migratable) {
        if (migratable instanceof TClassifier) {
            return Stream.concat(migratable.getMigrations().stream(), StreamSupport.stream(((TClassifier)migratable).getSuperClassifiers().spliterator(), false).filter(classifier -> classifier instanceof TMigratable).flatMap(superClassifier -> this.getAllMigrations((TMigratable)superClassifier)));
        }
        return migratable.getMigrations().stream();
    }

    public Iterable<TMigration> getMigrationCandidates(List<Argument> arguments) {
        if (arguments.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getAllMigrationCandidates(this.getTypeRefsFromArguments(arguments));
    }

    private List<TMigration> selectMigrationCandidate(List<TypeRef> arguments, Iterable<TMigration> candidates, TMigration contextMigration) {
        MigrationMatcher matcher = MigrationMatcher.emptyMatcher();
        for (TMigration migration : candidates) {
            try {
                double distance = this.typeDistanceComputer.computeDistance(arguments, (List<TypeRef>)migration.getSourceTypeRefs());
                if (distance == Double.POSITIVE_INFINITY) continue;
                matcher.match(migration, distance);
                if (!matcher.hasPerfectMatch() || matcher.getAllMatches().size() != 1) continue;
                return Collections.singletonList(migration);
            }
            catch (TypeDistanceComputer.UnsupportedTypeDistanceOperandsException unsupportedTypeDistanceOperandsException) {
                // empty catch block
            }
        }
        return matcher.getAllMatches();
    }
}

