/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.preferences;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.n4js.external.ExternalLibraryHelper;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceModel;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.utils.NodeModulesDiscoveryHelper;
import org.eclipse.n4js.utils.collections.Arrays2;

abstract class ExternalLibraryPreferenceStoreImpl
implements ExternalLibraryPreferenceStore {
    private static final Logger LOGGER = Logger.getLogger(ExternalLibraryPreferenceStoreImpl.class);
    @Inject
    private ExternalLibraryHelper externalLibraryHelper;
    @Inject
    private NodeModulesDiscoveryHelper nodeModulesDiscoveryHelper;
    private final Collection<ExternalLibraryPreferenceStore.StoreUpdatedListener> listeners = Sets.newHashSet();
    private ExternalLibraryPreferenceModel model = this.getOrCreateModel();
    private ExternalLibraryPreferenceModel lastSavedModel;

    protected ExternalLibraryPreferenceStoreImpl() {
    }

    @Override
    public Collection<URI> getLocations() {
        ArrayList<URI> result = new ArrayList<URI>(this.getOrCreateModel().getExternalLibraryLocationsAsUris());
        return result;
    }

    @Override
    public Collection<URI> getNodeModulesLocations() {
        return this.getOrCreateModel().getNodeModulesLocationsAsUris();
    }

    @Override
    public void add(URI location) {
        this.getOrCreateModel().add(location);
    }

    @Override
    public void remove(URI location) {
        this.getOrCreateModel().remove(location);
    }

    @Override
    public void moveUp(URI location) {
        this.getOrCreateModel().moveUp(location);
    }

    @Override
    public void moveDown(URI location) {
        this.getOrCreateModel().moveDown(location);
    }

    @Override
    public void resetDefaults() {
        this.model = this.getDefaults();
    }

    @Override
    public void invalidate() {
        this.model = this.doLoad();
    }

    @Override
    public final IStatus save(IProgressMonitor monitor) {
        if (this.lastSavedModel != null && this.getOrCreateModel().equals(this.lastSavedModel)) {
            return new Status(0, "unknown", 2, "", null);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IStatus status = this.doSave(this.getOrCreateModel());
        this.lastSavedModel = this.doLoad();
        if (status != null && status.isOK()) {
            this.notifyListeners(monitor);
        }
        return new Status(0, "unknown", 1, "", null);
    }

    @Override
    public void addListener(ExternalLibraryPreferenceStore.StoreUpdatedListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(ExternalLibraryPreferenceStore.StoreUpdatedListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public IStatus synchronizeNodeModulesFolders() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        LinkedList<Path> projectRoots = new LinkedList<Path>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                Path path = project.getLocation().toFile().toPath();
                projectRoots.add(path);
            }
            ++n2;
        }
        this.resetDefaults();
        List<Path> locations = this.nodeModulesDiscoveryHelper.findNodeModulesFolders(projectRoots);
        for (Path location : locations) {
            this.add(location.toUri());
        }
        return this.save((IProgressMonitor)new NullProgressMonitor());
    }

    protected abstract IStatus doSave(ExternalLibraryPreferenceModel var1);

    protected abstract ExternalLibraryPreferenceModel doLoad();

    protected ExternalLibraryPreferenceModel getDefaults() {
        return ExternalLibraryPreferenceModel.createDefault();
    }

    protected void notifyListeners(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.listeners.size());
        for (ExternalLibraryPreferenceStore.StoreUpdatedListener listener : this.listeners) {
            listener.storeUpdated(this, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final ExternalLibraryPreferenceModel getOrCreateModel() {
        if (this.model != null) return this.model;
        Class<ExternalLibraryPreferenceStoreImpl> clazz = ExternalLibraryPreferenceStoreImpl.class;
        synchronized (ExternalLibraryPreferenceStoreImpl.class) {
            if (this.model != null) return this.model;
            this.model = this.doLoad();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.model;
        }
    }

    @Override
    public Iterable<URI> convertToProjectRootLocations(Iterable<URI> externalRootLocations) {
        return FluentIterable.from(externalRootLocations).transformAndConcat(this::getProjectsInLocation);
    }

    private final Iterable<URI> getProjectsInLocation(URI location) {
        File rootFolder = new File(location);
        if (this.isExistingFolder(rootFolder)) {
            Iterable<URI> directContents = this.getDirectProjectsInLocation(rootFolder.toURI());
            FluentIterable scopedContents = FluentIterable.from(this.getDirectoryContents(rootFolder)).filter(f1 -> this.isExistingFolder((File)f1)).filter(f2 -> this.externalLibraryHelper.isScopeDirectory((File)f2)).transformAndConcat(file -> this.getDirectProjectsInLocation(file.toURI()));
            return Iterables.concat((Iterable)scopedContents, directContents);
        }
        return Collections.emptyList();
    }

    private final Iterable<URI> getDirectProjectsInLocation(URI location) {
        File rootFolder = new File(location);
        if (this.isExistingFolder(rootFolder)) {
            return FluentIterable.from(this.getDirectoryContents(rootFolder)).filter(f -> this.isExistingFolder((File)f)).filter(f -> !Files.isSymbolicLink(f.toPath())).filter(f -> this.externalLibraryHelper.isExternalProjectDirectory((File)f)).transform(file -> file.toURI());
        }
        return Collections.emptyList();
    }

    private final boolean isExistingFolder(File file) {
        return file != null && file.isDirectory();
    }

    private final Iterable<File> getDirectoryContents(File folder) {
        if (folder == null || !folder.isDirectory()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Not a directory: " + folder + "."));
            }
            return Collections.emptyList();
        }
        Object[] files = folder.listFiles();
        if (Arrays2.isEmpty((Object[])files)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("No resources were found under: " + folder + "."));
            }
            return Collections.emptyList();
        }
        List<Object> fileList = Arrays.asList(files);
        Collections.sort(fileList);
        return fileList;
    }
}

