/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.n4js.jsdoc.N4JSDocHelper;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.jsdoc2spec.adoc.ADocSerializer;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecIdentifiableElementSection;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecRequirementSection;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecSection;

/**
 * Creates AsciiDoc spec fragments for spec region entries.
 */
@SuppressWarnings("all")
public class ADocFactory {
  @Inject
  private N4JSDocHelper n4jsDocHelper;
  
  @Inject
  private ADocSerializer ADocSerializer;
  
  /**
   * Creates the spec of the given entry for the AsciiDoc document.
   */
  public CharSequence createSpecRegionString(final SpecRequirementSection spec, final Map<String, SpecSection> specsByKey) {
    return this.ADocSerializer.process(spec, specsByKey);
  }
  
  /**
   * Creates the spec of the given entry for the AsciiDoc document.
   */
  public CharSequence createSpecRegionString(final SpecIdentifiableElementSection spec, final Map<String, SpecSection> specsByKey) {
    Doclet _doclet = spec.getDoclet();
    boolean _tripleEquals = (_doclet == null);
    if (_tripleEquals) {
      spec.setDoclet(this.n4jsDocHelper.getDoclet(spec.getIdentifiableElement()));
    }
    return this.ADocSerializer.process(spec, specsByKey);
  }
}
