/**
 * Copyright (c) 2018 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.n4js.utils.NLSMessages;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

/**
 * Provides messages and helper methods for creating NLS messages. This class uses an active annotation
 * {@code @NLSMessages} to derive constants and methods out of the entries of the {@code messages.properties}. See
 * {@link org.eclipse.n4js.utils.NLSMessagesProcessor} for details about the message format.
 */
@NLSMessages(propertyFileName = "N4JSUiMessages")
@SuppressWarnings("all")
public class N4JSUiMessages {
  private static final String BUNDLE_NAME = N4JSUiMessages.class.getPackage().getName() + ".N4JSUiMessages";
  
  private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
  
  private static final String INITIALIZER = new Function0<String>() {
        public String apply() {
          org.eclipse.osgi.util.NLS.initializeMessages(BUNDLE_NAME, N4JSUiMessages.class);
          return "";
        }
      }.apply();;
  
  private static String getString(final String key) {
    try {
    	String value = RESOURCE_BUNDLE.getString(key);
    	return value;
    } catch (MissingResourceException e) {
    	return '!' + key + '!';
    }
  }
  
  public static final String N4JSUI_ERROR_TITLE = "N4JSUI_ERROR_TITLE";
  
  /**
   * N4JS Error
   */
  public static String msgN4JSUI_ERROR_TITLE() {
    return org.eclipse.osgi.util.NLS.bind(getString(N4JSUI_ERROR_TITLE), new Object [] {  });
  }
  
  public static final String N4JSUI_INFO_TITLE = "N4JSUI_INFO_TITLE";
  
  /**
   * N4JS Info
   */
  public static String msgN4JSUI_INFO_TITLE() {
    return org.eclipse.osgi.util.NLS.bind(getString(N4JSUI_INFO_TITLE), new Object [] {  });
  }
  
  public static final String N4JSUI_WARNING_TITLE = "N4JSUI_WARNING_TITLE";
  
  /**
   * N4JS Warning
   */
  public static String msgN4JSUI_WARNING_TITLE() {
    return org.eclipse.osgi.util.NLS.bind(getString(N4JSUI_WARNING_TITLE), new Object [] {  });
  }
}
