package org.eclipse.n4js.ui.contentassist.antlr.internal;
import java.util.Map;
import java.util.HashMap;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.n4js.services.N4JSGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
@SuppressWarnings("all")
public class InternalN4JSParser extends AbstractInternalContentAssistParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "Intersection", "Constructor", "Implements", "Instanceof", "Promisify", "Interface", "Protected", "Abstract", "Continue", "Debugger", "External", "Function", "Default", "Extends", "Finally", "Private", "Project", "Delete", "Export", "Import", "Public", "Return", "Static", "Switch", "Target", "Typeof", "Async", "Await", "Break", "Catch", "Class", "Const", "False", "Super", "Throw", "Union", "While", "Yield", "This", "Case", "Else", "Enum", "From", "Null", "This_1", "True", "Type", "Void", "With", "ExclamationMarkEqualsSignEqualsSign", "FullStopFullStopFullStop", "LessThanSignLessThanSignEqualsSign", "EqualsSignEqualsSignEqualsSign", "For", "Get", "Let", "New", "Out", "Set", "Try", "Var", "ExclamationMarkEqualsSign", "PercentSignEqualsSign", "AmpersandAmpersand", "AmpersandEqualsSign", "AsteriskEqualsSign", "PlusSignPlusSign", "PlusSignEqualsSign", "HyphenMinusHyphenMinus", "HyphenMinusEqualsSign", "SolidusEqualsSign", "LessThanSignLessThanSign", "LessThanSignEqualsSign", "EqualsSignEqualsSign", "EqualsSignGreaterThanSign", "CommercialAtCommercialAt", "CircumflexAccentEqualsSign", "As", "Do", "If", "In", "Of", "VerticalLineEqualsSign", "VerticalLineVerticalLine", "ExclamationMark", "PercentSign", "Ampersand", "LeftParenthesis", "RightParenthesis", "Asterisk", "PlusSign", "Comma", "HyphenMinus", "FullStop", "Solidus", "Colon", "Semicolon", "LessThanSign", "EqualsSign", "GreaterThanSign", "QuestionMark", "CommercialAt", "LeftSquareBracket", "RightSquareBracket", "CircumflexAccent", "LeftCurlyBracket", "VerticalLine", "RightCurlyBracket", "Tilde", "RULE_DECIMAL_DIGIT_FRAGMENT", "RULE_EXPONENT_PART", "RULE_DECIMAL_INTEGER_LITERAL_FRAGMENT", "RULE_DOUBLE", "RULE_INT_SUFFIX", "RULE_HEX_INT", "RULE_BINARY_INT", "RULE_OCTAL_INT", "RULE_LEGACY_OCTAL_INT", "RULE_IDENTIFIER_PART", "RULE_SCIENTIFIC_INT", "RULE_SIGNED_INT", "RULE_IDENTIFIER", "RULE_DOUBLE_STRING_CHAR", "RULE_SINGLE_STRING_CHAR", "RULE_STRING", "RULE_LINE_TERMINATOR_FRAGMENT", "RULE_LINE_TERMINATOR_SEQUENCE_FRAGMENT", "RULE_BACKSLASH_SEQUENCE", "RULE_REGEX_CHAR_OR_BRACKET", "RULE_REGEX_CHAR", "RULE_ACTUAL_REGEX_TAIL", "RULE_REGEX_START", "RULE_REGEX_TAIL", "RULE_TEMPLATE_LITERAL_CHAR", "RULE_TEMPLATE_HEAD", "RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL", "RULE_ACTUAL_TEMPLATE_END", "RULE_TEMPLATE_MIDDLE", "RULE_TEMPLATE_END", "RULE_TEMPLATE_CONTINUATION", "RULE_NO_LINE_TERMINATOR", "RULE_INCOMPLETE_ASYNC_ARROW", "RULE_STRUCTMODSUFFIX", "RULE_IDENTIFIER_START", "RULE_INT", "RULE_ML_COMMENT_FRAGMENT", "RULE_ML_COMMENT", "RULE_SL_COMMENT", "RULE_EOL", "RULE_WHITESPACE_FRAGMENT", "RULE_WS", "RULE_HEX_DIGIT", "RULE_UNICODE_ESCAPE_FRAGMENT", "RULE_UNICODE_LETTER_FRAGMENT", "RULE_UNICODE_COMBINING_MARK_FRAGMENT", "RULE_UNICODE_DIGIT_FRAGMENT", "RULE_UNICODE_CONNECTOR_PUNCTUATION_FRAGMENT", "RULE_ZWNJ", "RULE_ZWJ", "RULE_DOT_DOT", "RULE_VERSION", "RULE_BOM", "RULE_UNICODE_SPACE_SEPARATOR_FRAGMENT", "RULE_SL_COMMENT_FRAGMENT", "RULE_ANY_OTHER"
    };
    public static final int Delete=21;
    public static final int Enum=45;
    public static final int RULE_REGEX_CHAR=133;
    public static final int Import=23;
    public static final int EqualsSignGreaterThanSign=78;
    public static final int Var=64;
    public static final int RULE_ACTUAL_TEMPLATE_END=140;
    public static final int Break=32;
    public static final int False=36;
    public static final int LessThanSign=101;
    public static final int LeftParenthesis=91;
    public static final int RULE_VERSION=164;
    public static final int RULE_TEMPLATE_LITERAL_CHAR=137;
    public static final int Throw=38;
    public static final int Private=19;
    public static final int Extends=17;
    public static final int RULE_REGEX_TAIL=136;
    public static final int ExclamationMark=88;
    public static final int ExclamationMarkEqualsSignEqualsSign=53;
    public static final int GreaterThanSign=103;
    public static final int RULE_LINE_TERMINATOR_SEQUENCE_FRAGMENT=130;
    public static final int RULE_TEMPLATE_HEAD=138;
    public static final int RULE_STRUCTMODSUFFIX=146;
    public static final int RULE_EOL=152;
    public static final int RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL=139;
    public static final int Out=61;
    public static final int RULE_ZWNJ=161;
    public static final int Project=20;
    public static final int EqualsSignEqualsSign=77;
    public static final int Switch=27;
    public static final int RULE_OCTAL_INT=120;
    public static final int VerticalLine=110;
    public static final int PlusSign=94;
    public static final int RULE_INT=148;
    public static final int Get=58;
    public static final int RULE_ML_COMMENT=150;
    public static final int LeftSquareBracket=106;
    public static final int LessThanSignLessThanSign=75;
    public static final int If=83;
    public static final int RULE_REGEX_START=135;
    public static final int Finally=18;
    public static final int Intersection=4;
    public static final int Set=62;
    public static final int RULE_UNICODE_ESCAPE_FRAGMENT=156;
    public static final int In=84;
    public static final int Catch=33;
    public static final int VerticalLineVerticalLine=87;
    public static final int RULE_SCIENTIFIC_INT=123;
    public static final int RULE_TEMPLATE_MIDDLE=141;
    public static final int RULE_INCOMPLETE_ASYNC_ARROW=145;
    public static final int RULE_EXPONENT_PART=114;
    public static final int Union=39;
    public static final int Case=43;
    public static final int RULE_REGEX_CHAR_OR_BRACKET=132;
    public static final int Comma=95;
    public static final int RULE_SL_COMMENT_FRAGMENT=167;
    public static final int Target=28;
    public static final int As=81;
    public static final int HyphenMinus=96;
    public static final int RULE_IDENTIFIER_PART=122;
    public static final int RULE_UNICODE_SPACE_SEPARATOR_FRAGMENT=166;
    public static final int Export=22;
    public static final int LessThanSignEqualsSign=76;
    public static final int CommercialAtCommercialAt=79;
    public static final int Solidus=98;
    public static final int RightCurlyBracket=111;
    public static final int PercentSignEqualsSign=66;
    public static final int RULE_HEX_INT=118;
    public static final int FullStop=97;
    public static final int Constructor=5;
    public static final int Abstract=11;
    public static final int Promisify=8;
    public static final int RULE_SIGNED_INT=124;
    public static final int Default=16;
    public static final int CommercialAt=105;
    public static final int Semicolon=100;
    public static final int RULE_LINE_TERMINATOR_FRAGMENT=129;
    public static final int Type=50;
    public static final int PlusSignPlusSign=70;
    public static final int QuestionMark=104;
    public static final int Else=44;
    public static final int RULE_HEX_DIGIT=155;
    public static final int RULE_UNICODE_CONNECTOR_PUNCTUATION_FRAGMENT=160;
    public static final int Yield=41;
    public static final int ExclamationMarkEqualsSign=65;
    public static final int Interface=9;
    public static final int RULE_TEMPLATE_CONTINUATION=143;
    public static final int HyphenMinusHyphenMinus=72;
    public static final int New=60;
    public static final int Null=47;
    public static final int AmpersandEqualsSign=68;
    public static final int Typeof=29;
    public static final int SolidusEqualsSign=74;
    public static final int True=49;
    public static final int FullStopFullStopFullStop=54;
    public static final int PercentSign=89;
    public static final int RULE_IDENTIFIER_START=147;
    public static final int Implements=6;
    public static final int RULE_WHITESPACE_FRAGMENT=153;
    public static final int Super=37;
    public static final int Async=30;
    public static final int This=42;
    public static final int Try=63;
    public static final int Ampersand=90;
    public static final int AsteriskEqualsSign=69;
    public static final int Void=51;
    public static final int VerticalLineEqualsSign=86;
    public static final int RightSquareBracket=107;
    public static final int RULE_BINARY_INT=119;
    public static final int Protected=10;
    public static final int Const=35;
    public static final int RULE_ACTUAL_REGEX_TAIL=134;
    public static final int For=57;
    public static final int RightParenthesis=92;
    public static final int RULE_UNICODE_COMBINING_MARK_FRAGMENT=158;
    public static final int Public=24;
    public static final int Do=82;
    public static final int RULE_LEGACY_OCTAL_INT=121;
    public static final int RULE_DOUBLE_STRING_CHAR=126;
    public static final int EqualsSignEqualsSignEqualsSign=56;
    public static final int RULE_TEMPLATE_END=142;
    public static final int This_1=48;
    public static final int RULE_NO_LINE_TERMINATOR=144;
    public static final int RULE_DOT_DOT=163;
    public static final int External=14;
    public static final int CircumflexAccentEqualsSign=80;
    public static final int Class=34;
    public static final int Static=26;
    public static final int Debugger=13;
    public static final int RULE_SINGLE_STRING_CHAR=127;
    public static final int LessThanSignLessThanSignEqualsSign=55;
    public static final int RULE_INT_SUFFIX=117;
    public static final int RULE_IDENTIFIER=125;
    public static final int RULE_ML_COMMENT_FRAGMENT=149;
    public static final int RULE_STRING=128;
    public static final int Continue=12;
    public static final int With=52;
    public static final int RULE_SL_COMMENT=151;
    public static final int Function=15;
    public static final int EqualsSign=102;
    public static final int RULE_ZWJ=162;
    public static final int RULE_UNICODE_DIGIT_FRAGMENT=159;
    public static final int AmpersandAmpersand=67;
    public static final int RULE_DOUBLE=116;
    public static final int Instanceof=7;
    public static final int HyphenMinusEqualsSign=73;
    public static final int Colon=99;
    public static final int RULE_BACKSLASH_SEQUENCE=131;
    public static final int EOF=-1;
    public static final int Asterisk=93;
    public static final int PlusSignEqualsSign=71;
    public static final int Return=25;
    public static final int RULE_WS=154;
    public static final int RULE_BOM=165;
    public static final int LeftCurlyBracket=109;
    public static final int Tilde=112;
    public static final int While=40;
    public static final int From=46;
    public static final int RULE_ANY_OTHER=168;
    public static final int CircumflexAccent=108;
    public static final int RULE_UNICODE_LETTER_FRAGMENT=157;
    public static final int RULE_DECIMAL_DIGIT_FRAGMENT=113;
    public static final int Of=85;
    public static final int RULE_DECIMAL_INTEGER_LITERAL_FRAGMENT=115;
    public static final int Let=59;
    public static final int Await=31;


        public InternalN4JSParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalN4JSParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalN4JSParser.tokenNames; }
    public String getGrammarFileName() { return "InternalN4JSParser.g"; }


    	private N4JSGrammarAccess grammarAccess;
    	private final Map<String, String> tokenNameToValue = new HashMap<String, String>();
    	
    	{
    		tokenNameToValue.put("ExclamationMark", "'!'");
    		tokenNameToValue.put("PercentSign", "'%'");
    		tokenNameToValue.put("Ampersand", "'&'");
    		tokenNameToValue.put("LeftParenthesis", "'('");
    		tokenNameToValue.put("RightParenthesis", "')'");
    		tokenNameToValue.put("Asterisk", "'*'");
    		tokenNameToValue.put("PlusSign", "'+'");
    		tokenNameToValue.put("Comma", "','");
    		tokenNameToValue.put("HyphenMinus", "'-'");
    		tokenNameToValue.put("FullStop", "'.'");
    		tokenNameToValue.put("Solidus", "'/'");
    		tokenNameToValue.put("Colon", "':'");
    		tokenNameToValue.put("Semicolon", "';'");
    		tokenNameToValue.put("LessThanSign", "'<'");
    		tokenNameToValue.put("EqualsSign", "'='");
    		tokenNameToValue.put("GreaterThanSign", "'>'");
    		tokenNameToValue.put("QuestionMark", "'?'");
    		tokenNameToValue.put("CommercialAt", "'@'");
    		tokenNameToValue.put("LeftSquareBracket", "'['");
    		tokenNameToValue.put("RightSquareBracket", "']'");
    		tokenNameToValue.put("CircumflexAccent", "'^'");
    		tokenNameToValue.put("LeftCurlyBracket", "'{'");
    		tokenNameToValue.put("VerticalLine", "'|'");
    		tokenNameToValue.put("RightCurlyBracket", "'}'");
    		tokenNameToValue.put("Tilde", "'~'");
    		tokenNameToValue.put("ExclamationMarkEqualsSign", "'!='");
    		tokenNameToValue.put("PercentSignEqualsSign", "'%='");
    		tokenNameToValue.put("AmpersandAmpersand", "'&&'");
    		tokenNameToValue.put("AmpersandEqualsSign", "'&='");
    		tokenNameToValue.put("AsteriskEqualsSign", "'*='");
    		tokenNameToValue.put("PlusSignPlusSign", "'++'");
    		tokenNameToValue.put("PlusSignEqualsSign", "'+='");
    		tokenNameToValue.put("HyphenMinusHyphenMinus", "'--'");
    		tokenNameToValue.put("HyphenMinusEqualsSign", "'-='");
    		tokenNameToValue.put("SolidusEqualsSign", "'/='");
    		tokenNameToValue.put("LessThanSignLessThanSign", "'<<'");
    		tokenNameToValue.put("LessThanSignEqualsSign", "'<='");
    		tokenNameToValue.put("EqualsSignEqualsSign", "'=='");
    		tokenNameToValue.put("EqualsSignGreaterThanSign", "'=>'");
    		tokenNameToValue.put("CommercialAtCommercialAt", "'@@'");
    		tokenNameToValue.put("CircumflexAccentEqualsSign", "'^='");
    		tokenNameToValue.put("As", "'as'");
    		tokenNameToValue.put("Do", "'do'");
    		tokenNameToValue.put("If", "'if'");
    		tokenNameToValue.put("In", "'in'");
    		tokenNameToValue.put("Of", "'of'");
    		tokenNameToValue.put("VerticalLineEqualsSign", "'|='");
    		tokenNameToValue.put("VerticalLineVerticalLine", "'||'");
    		tokenNameToValue.put("ExclamationMarkEqualsSignEqualsSign", "'!=='");
    		tokenNameToValue.put("FullStopFullStopFullStop", "'...'");
    		tokenNameToValue.put("LessThanSignLessThanSignEqualsSign", "'<<='");
    		tokenNameToValue.put("EqualsSignEqualsSignEqualsSign", "'==='");
    		tokenNameToValue.put("For", "'for'");
    		tokenNameToValue.put("Get", "'get'");
    		tokenNameToValue.put("Let", "'let'");
    		tokenNameToValue.put("New", "'new'");
    		tokenNameToValue.put("Out", "'out'");
    		tokenNameToValue.put("Set", "'set'");
    		tokenNameToValue.put("Try", "'try'");
    		tokenNameToValue.put("Var", "'var'");
    		tokenNameToValue.put("This", "'This'");
    		tokenNameToValue.put("Case", "'case'");
    		tokenNameToValue.put("Else", "'else'");
    		tokenNameToValue.put("Enum", "'enum'");
    		tokenNameToValue.put("From", "'from'");
    		tokenNameToValue.put("Null", "'null'");
    		tokenNameToValue.put("This_1", "'this'");
    		tokenNameToValue.put("True", "'true'");
    		tokenNameToValue.put("Type", "'type'");
    		tokenNameToValue.put("Void", "'void'");
    		tokenNameToValue.put("With", "'with'");
    		tokenNameToValue.put("Async", "'async'");
    		tokenNameToValue.put("Await", "'await'");
    		tokenNameToValue.put("Break", "'break'");
    		tokenNameToValue.put("Catch", "'catch'");
    		tokenNameToValue.put("Class", "'class'");
    		tokenNameToValue.put("Const", "'const'");
    		tokenNameToValue.put("False", "'false'");
    		tokenNameToValue.put("Super", "'super'");
    		tokenNameToValue.put("Throw", "'throw'");
    		tokenNameToValue.put("Union", "'union'");
    		tokenNameToValue.put("While", "'while'");
    		tokenNameToValue.put("Yield", "'yield'");
    		tokenNameToValue.put("Delete", "'delete'");
    		tokenNameToValue.put("Export", "'export'");
    		tokenNameToValue.put("Import", "'import'");
    		tokenNameToValue.put("Public", "'public'");
    		tokenNameToValue.put("Return", "'return'");
    		tokenNameToValue.put("Static", "'static'");
    		tokenNameToValue.put("Switch", "'switch'");
    		tokenNameToValue.put("Target", "'target'");
    		tokenNameToValue.put("Typeof", "'typeof'");
    		tokenNameToValue.put("Default", "'default'");
    		tokenNameToValue.put("Extends", "'extends'");
    		tokenNameToValue.put("Finally", "'finally'");
    		tokenNameToValue.put("Private", "'private'");
    		tokenNameToValue.put("Project", "'project'");
    		tokenNameToValue.put("Abstract", "'abstract'");
    		tokenNameToValue.put("Continue", "'continue'");
    		tokenNameToValue.put("Debugger", "'debugger'");
    		tokenNameToValue.put("External", "'external'");
    		tokenNameToValue.put("Function", "'function'");
    		tokenNameToValue.put("Promisify", "'Promisify'");
    		tokenNameToValue.put("Interface", "'interface'");
    		tokenNameToValue.put("Protected", "'protected'");
    		tokenNameToValue.put("Implements", "'implements'");
    		tokenNameToValue.put("Instanceof", "'instanceof'");
    		tokenNameToValue.put("Constructor", "'constructor'");
    		tokenNameToValue.put("Intersection", "'intersection'");
    	}

    	public void setGrammarAccess(N4JSGrammarAccess grammarAccess) {
    		this.grammarAccess = grammarAccess;
    	}

    	@Override
    	protected Grammar getGrammar() {
    		return grammarAccess.getGrammar();
    	}

    	@Override
    	protected String getValueForTokenName(String tokenName) {
    		String result = tokenNameToValue.get(tokenName);
    		if (result == null)
    			result = tokenName;
    		return result;
    	}
    public final void entryRuleScript() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getScriptRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleScript();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getScriptRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleScript() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getScriptAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__Script__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getScriptAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleScriptElement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getScriptElementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleScriptElement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getScriptElementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleScriptElement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getScriptElementAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ScriptElement__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getScriptElementAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAnnotatedScriptElement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedScriptElementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAnnotatedScriptElement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedScriptElementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAnnotatedScriptElement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedScriptElementAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AnnotatedScriptElement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedScriptElementAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleExportDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleExportDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleExportDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportDeclarationAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExportDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportDeclarationAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleExportDeclarationImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportDeclarationImplAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExportDeclarationImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportDeclarationImplAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleExportFromClause() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportFromClauseAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExportFromClause__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportFromClauseAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleExportClause() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportClauseAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExportClause__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportClauseAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleExportSpecifier() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportSpecifierRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleExportSpecifier();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportSpecifierRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleExportSpecifier() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportSpecifierAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExportSpecifier__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportSpecifierAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleExportableElement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportableElementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleExportableElement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportableElementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleExportableElement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportableElementAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExportableElement__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportableElementAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAnnotatedExportableElement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedExportableElementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAnnotatedExportableElement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedExportableElementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAnnotatedExportableElement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedExportableElementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AnnotatedExportableElement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedExportableElementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleImportDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getImportDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleImportDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getImportDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleImportDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getImportDeclarationAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ImportDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getImportDeclarationAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleImportDeclarationImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getImportDeclarationImplAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ImportDeclarationImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getImportDeclarationImplAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleImportClause() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getImportClauseAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ImportClause__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getImportClauseAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleImportSpecifiersExceptDefault() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ImportSpecifiersExceptDefault__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleNamedImportSpecifier() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNamedImportSpecifierRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleNamedImportSpecifier();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getNamedImportSpecifierRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleNamedImportSpecifier() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNamedImportSpecifierAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__NamedImportSpecifier__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNamedImportSpecifierAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleDefaultImportSpecifier() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDefaultImportSpecifierRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleDefaultImportSpecifier();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDefaultImportSpecifierRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleDefaultImportSpecifier() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDefaultImportSpecifierAccess().getImportedElementAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__DefaultImportSpecifier__ImportedElementAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDefaultImportSpecifierAccess().getImportedElementAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleNamespaceImportSpecifier() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNamespaceImportSpecifierRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleNamespaceImportSpecifier();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getNamespaceImportSpecifierRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleNamespaceImportSpecifier() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNamespaceImportSpecifierAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__NamespaceImportSpecifier__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNamespaceImportSpecifierAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleModuleSpecifier() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getModuleSpecifierRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleModuleSpecifier();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getModuleSpecifierRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleModuleSpecifier() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getModuleSpecifierAccess().getSTRINGTerminalRuleCall()); 
            }
            match(input,RULE_STRING,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getModuleSpecifierAccess().getSTRINGTerminalRuleCall()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleFunctionDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleFunctionDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleFunctionDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__FunctionDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_FunctionDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_FunctionDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleAsyncNoTrailingLineBreak() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAsyncNoTrailingLineBreakAccess().getGroup()); 
            }
            int alt1=2;
            int LA1_0 = input.LA(1);

            if ( (LA1_0==Async) ) {
                int LA1_1 = input.LA(2);

                if ( ((LA1_1>=Intersection && LA1_1<=With)||(LA1_1>=For && LA1_1<=Var)||(LA1_1>=As && LA1_1<=Of)||LA1_1==LeftSquareBracket||LA1_1==RULE_DOUBLE||LA1_1==RULE_HEX_INT||LA1_1==RULE_OCTAL_INT||LA1_1==RULE_SCIENTIFIC_INT||LA1_1==RULE_IDENTIFIER||LA1_1==RULE_STRING||LA1_1==RULE_NO_LINE_TERMINATOR||LA1_1==RULE_INT) ) {
                    alt1=1;
                }
            }
            switch (alt1) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    rule__AsyncNoTrailingLineBreak__Group__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAsyncNoTrailingLineBreakAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleFunctionImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionImplAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__FunctionImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionImplAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_FunctionImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionImplAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_FunctionImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionImplAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm6_FunctionImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionImplAccess().getGroup(), 6
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm6_FunctionImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionImplAccess().getGroup(), 6
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleFunctionHeader() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionHeaderAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__FunctionHeader__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionHeaderAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_FunctionHeader() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionHeaderAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_FunctionHeader__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionHeaderAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_FunctionHeader() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionHeaderAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_FunctionHeader__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionHeaderAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_FunctionHeader() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionHeaderAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_FunctionHeader__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionHeaderAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleFunctionBody() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionBodyAccess().getBodyAssignment_1_0(), 0
              		); 
            }
            int alt2=2;
            alt2 = dfa2.predict(input);
            switch (alt2) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    rule__FunctionBody__BodyAssignment_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionBodyAccess().getBodyAssignment_1_0(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_FunctionBody() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionBodyAccess().getBodyAssignment_1_0(), 1
              		); 
            }
            int alt3=2;
            alt3 = dfa3.predict(input);
            switch (alt3) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    norm1_FunctionBody__BodyAssignment_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionBodyAccess().getBodyAssignment_1_0(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_FunctionBody() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionBodyAccess().getBodyAssignment_0_0(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_FunctionBody__BodyAssignment_0_0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionBodyAccess().getBodyAssignment_0_0(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_FunctionBody() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionBodyAccess().getBodyAssignment_0_0(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_FunctionBody__BodyAssignment_0_0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionBodyAccess().getBodyAssignment_0_0(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAnnotatedFunctionDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedFunctionDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAnnotatedFunctionDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedFunctionDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAnnotatedFunctionDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedFunctionDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AnnotatedFunctionDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedFunctionDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AnnotatedFunctionDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedFunctionDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_AnnotatedFunctionDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedFunctionDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleFunctionExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleFunctionExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleFunctionExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionExpressionAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__FunctionExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionExpressionAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAsyncFunctionExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAsyncFunctionExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAsyncFunctionExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAsyncFunctionExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAsyncFunctionExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAsyncFunctionExpressionAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AsyncFunctionExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAsyncFunctionExpressionAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleArrowExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrowExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleArrowExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrowExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleArrowExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrowExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ArrowExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrowExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ArrowExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrowExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ArrowExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrowExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_ArrowExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrowExpressionAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_ArrowExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrowExpressionAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_ArrowExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrowExpressionAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_ArrowExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrowExpressionAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleStrictFormalParameters() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getStrictFormalParametersAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__StrictFormalParameters__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getStrictFormalParametersAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_StrictFormalParameters() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getStrictFormalParametersAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_StrictFormalParameters__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getStrictFormalParametersAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBindingIdentifierAsFormalParameter() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingIdentifierAsFormalParameterRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBindingIdentifierAsFormalParameter();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingIdentifierAsFormalParameterRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBindingIdentifierAsFormalParameter() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameAssignment(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BindingIdentifierAsFormalParameter__NameAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameAssignment(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BindingIdentifierAsFormalParameter() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameAssignment(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_BindingIdentifierAsFormalParameter__NameAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameAssignment(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBlockMinusBraces() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBlockMinusBracesRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBlockMinusBraces();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBlockMinusBracesRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBlockMinusBraces() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBlockMinusBracesAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BlockMinusBraces__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBlockMinusBracesAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BlockMinusBraces() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBlockMinusBracesAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_BlockMinusBraces__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBlockMinusBracesAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleExpressionDisguisedAsBlock() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionDisguisedAsBlockRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleExpressionDisguisedAsBlock();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionDisguisedAsBlockRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleExpressionDisguisedAsBlock() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionDisguisedAsBlockAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExpressionDisguisedAsBlock__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionDisguisedAsBlockAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ExpressionDisguisedAsBlock() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionDisguisedAsBlockAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ExpressionDisguisedAsBlock__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionDisguisedAsBlockAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAssignmentExpressionStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAssignmentExpressionStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAssignmentExpressionStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAssignmentExpressionStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAssignmentExpressionStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignment(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AssignmentExpressionStatement__ExpressionAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignment(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AssignmentExpressionStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignment(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_AssignmentExpressionStatement__ExpressionAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignment(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAnnotatedExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAnnotatedExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAnnotatedExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AnnotatedExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AnnotatedExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_AnnotatedExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypeVariable() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeVariableRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypeVariable();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeVariableRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypeVariable() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeVariableAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeVariable__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeVariableAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleFormalParameter() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFormalParameterRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleFormalParameter();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getFormalParameterRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleFormalParameter() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFormalParameterAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__FormalParameter__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFormalParameterAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_FormalParameter() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFormalParameterAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_FormalParameter__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFormalParameterAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleBindingElementFragment() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingElementFragmentAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BindingElementFragment__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingElementFragmentAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BindingElementFragment() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingElementFragmentAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_BindingElementFragment__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingElementFragmentAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleBogusTypeRefFragment() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBogusTypeRefFragmentAccess().getBogusTypeRefAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BogusTypeRefFragment__BogusTypeRefAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBogusTypeRefFragmentAccess().getBogusTypeRefAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBlock() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBlockRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBlock();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBlockRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBlock() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBlockAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__Block__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBlockAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_Block() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBlockAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_Block__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBlockAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleRootStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRootStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleRootStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getRootStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleRootStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRootStatementAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__RootStatement__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getRootStatementAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_RootStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRootStatementAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_RootStatement__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getRootStatementAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getStatementAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__Statement__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getStatementAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_Statement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getStatementAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_Statement__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getStatementAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_VariableStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_VariableStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_VariableStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableStatementAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_VariableStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableStatementAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleExportedVariableStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportedVariableStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleExportedVariableStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportedVariableStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleExportedVariableStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportedVariableStatementAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExportedVariableStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportedVariableStatementAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleVariableDeclarationOrBinding() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationOrBindingRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleVariableDeclarationOrBinding();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationOrBindingRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleVariableDeclarationOrBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__VariableDeclarationOrBinding__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_VariableDeclarationOrBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_VariableDeclarationOrBinding__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_VariableDeclarationOrBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_VariableDeclarationOrBinding__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_VariableDeclarationOrBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_VariableDeclarationOrBinding__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm4_VariableDeclarationOrBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 4
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm4_VariableDeclarationOrBinding__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 4
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm6_VariableDeclarationOrBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 6
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm6_VariableDeclarationOrBinding__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), 6
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleVariableBinding() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableBindingRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleVariableBinding();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableBindingRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleVariableBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableBindingAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__VariableBinding__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableBindingAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_VariableBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableBindingAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_VariableBinding__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableBindingAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_VariableBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableBindingAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_VariableBinding__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableBindingAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_VariableBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableBindingAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_VariableBinding__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableBindingAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm4_VariableBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableBindingAccess().getGroup(), 4
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm4_VariableBinding__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableBindingAccess().getGroup(), 4
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm5_VariableBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableBindingAccess().getGroup(), 5
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm5_VariableBinding__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableBindingAccess().getGroup(), 5
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm6_VariableBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableBindingAccess().getGroup(), 6
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm6_VariableBinding__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableBindingAccess().getGroup(), 6
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm7_VariableBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableBindingAccess().getGroup(), 7
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm7_VariableBinding__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableBindingAccess().getGroup(), 7
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_VariableDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_VariableDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_VariableDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_VariableDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm4_VariableDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationAccess().getGroup(), 4
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm4_VariableDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationAccess().getGroup(), 4
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm5_VariableDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationAccess().getGroup(), 5
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm5_VariableDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationAccess().getGroup(), 5
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm6_VariableDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationAccess().getGroup(), 6
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm6_VariableDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationAccess().getGroup(), 6
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm7_VariableDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationAccess().getGroup(), 7
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm7_VariableDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationAccess().getGroup(), 7
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleVariableDeclarationImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__VariableDeclarationImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_VariableDeclarationImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_VariableDeclarationImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_VariableDeclarationImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_VariableDeclarationImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_VariableDeclarationImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_VariableDeclarationImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm4_VariableDeclarationImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 4
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm4_VariableDeclarationImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 4
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm5_VariableDeclarationImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 5
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm5_VariableDeclarationImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 5
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm6_VariableDeclarationImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 6
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm6_VariableDeclarationImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 6
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm7_VariableDeclarationImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 7
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm7_VariableDeclarationImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableDeclarationImplAccess().getGroup(), 7
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleExportedVariableDeclarationOrBinding() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportedVariableDeclarationOrBindingRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleExportedVariableDeclarationOrBinding();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportedVariableDeclarationOrBindingRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleExportedVariableDeclarationOrBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExportedVariableDeclarationOrBinding__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ExportedVariableDeclarationOrBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ExportedVariableDeclarationOrBinding__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleExportedVariableBinding() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportedVariableBindingRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleExportedVariableBinding();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportedVariableBindingRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleExportedVariableBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportedVariableBindingAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExportedVariableBinding__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportedVariableBindingAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ExportedVariableBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportedVariableBindingAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ExportedVariableBinding__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportedVariableBindingAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleExportedVariableDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportedVariableDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleExportedVariableDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportedVariableDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleExportedVariableDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportedVariableDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExportedVariableDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportedVariableDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ExportedVariableDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExportedVariableDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ExportedVariableDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExportedVariableDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleEmptyStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEmptyStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleEmptyStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEmptyStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleEmptyStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEmptyStatementAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__EmptyStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEmptyStatementAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleExpressionStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleExpressionStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleExpressionStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExpressionStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ExpressionStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ExpressionStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleIfStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIfStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleIfStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getIfStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleIfStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIfStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__IfStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIfStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_IfStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIfStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_IfStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIfStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleIterationStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIterationStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleIterationStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getIterationStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleIterationStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIterationStatementAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__IterationStatement__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIterationStatementAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_IterationStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIterationStatementAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_IterationStatement__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIterationStatementAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleDoStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDoStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleDoStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDoStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleDoStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDoStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__DoStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDoStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_DoStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDoStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_DoStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDoStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleWhileStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getWhileStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleWhileStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getWhileStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleWhileStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getWhileStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__WhileStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getWhileStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_WhileStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getWhileStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_WhileStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getWhileStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleForStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getForStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleForStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getForStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleForStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getForStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ForStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getForStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ForStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getForStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ForStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getForStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleLetIdentifierRef() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLetIdentifierRefRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleLetIdentifierRef();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLetIdentifierRefRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleLetIdentifierRef() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLetIdentifierRefAccess().getIdAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__LetIdentifierRef__IdAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLetIdentifierRefAccess().getIdAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleLetAsIdentifier() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLetAsIdentifierRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleLetAsIdentifier();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLetAsIdentifierRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleLetAsIdentifier() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLetAsIdentifierAccess().getLetKeyword()); 
            }
            match(input,Let,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLetAsIdentifierAccess().getLetKeyword()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBindingIdentifierAsVariableDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingIdentifierAsVariableDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBindingIdentifierAsVariableDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingIdentifierAsVariableDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBindingIdentifierAsVariableDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameAssignment(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BindingIdentifierAsVariableDeclaration__NameAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameAssignment(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_BindingIdentifierAsVariableDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameAssignment(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_BindingIdentifierAsVariableDeclaration__NameAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameAssignment(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleContinueStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getContinueStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleContinueStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getContinueStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleContinueStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getContinueStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ContinueStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getContinueStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ContinueStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getContinueStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ContinueStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getContinueStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBreakStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBreakStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBreakStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBreakStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBreakStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBreakStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BreakStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBreakStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BreakStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBreakStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_BreakStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBreakStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleReturnStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getReturnStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleReturnStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getReturnStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleReturnStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getReturnStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ReturnStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getReturnStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ReturnStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getReturnStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ReturnStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getReturnStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleWithStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getWithStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleWithStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getWithStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleWithStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getWithStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__WithStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getWithStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_WithStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getWithStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_WithStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getWithStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleSwitchStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSwitchStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleSwitchStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSwitchStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleSwitchStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSwitchStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__SwitchStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSwitchStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_SwitchStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSwitchStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_SwitchStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSwitchStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleCaseClause() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getCaseClauseRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleCaseClause();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getCaseClauseRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleCaseClause() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getCaseClauseAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__CaseClause__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getCaseClauseAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_CaseClause() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getCaseClauseAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_CaseClause__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getCaseClauseAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleDefaultClause() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDefaultClauseRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleDefaultClause();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDefaultClauseRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleDefaultClause() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDefaultClauseAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__DefaultClause__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDefaultClauseAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_DefaultClause() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDefaultClauseAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_DefaultClause__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDefaultClauseAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleLabelledStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLabelledStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleLabelledStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLabelledStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleLabelledStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLabelledStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__LabelledStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLabelledStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_LabelledStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLabelledStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_LabelledStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLabelledStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleThrowStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getThrowStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleThrowStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getThrowStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleThrowStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getThrowStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ThrowStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getThrowStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ThrowStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getThrowStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ThrowStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getThrowStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTryStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTryStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTryStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTryStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTryStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTryStatementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TryStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTryStatementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_TryStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTryStatementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_TryStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTryStatementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleCatchBlock() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getCatchBlockRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleCatchBlock();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getCatchBlockRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleCatchBlock() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getCatchBlockAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__CatchBlock__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getCatchBlockAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_CatchBlock() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getCatchBlockAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_CatchBlock__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getCatchBlockAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleCatchVariable() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getCatchVariableRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleCatchVariable();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getCatchVariableRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleCatchVariable() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getCatchVariableAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__CatchVariable__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getCatchVariableAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_CatchVariable() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getCatchVariableAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_CatchVariable__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getCatchVariableAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleFinallyBlock() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFinallyBlockRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleFinallyBlock();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getFinallyBlockRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleFinallyBlock() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFinallyBlockAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__FinallyBlock__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFinallyBlockAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_FinallyBlock() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFinallyBlockAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_FinallyBlock__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFinallyBlockAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleDebuggerStatement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDebuggerStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleDebuggerStatement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDebuggerStatementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleDebuggerStatement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDebuggerStatementAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__DebuggerStatement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDebuggerStatementAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRulePrimaryExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPrimaryExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            rulePrimaryExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPrimaryExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void rulePrimaryExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPrimaryExpressionAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__PrimaryExpression__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPrimaryExpressionAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_PrimaryExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPrimaryExpressionAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_PrimaryExpression__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPrimaryExpressionAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleParenExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParenExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleParenExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getParenExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleParenExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParenExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ParenExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getParenExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ParenExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParenExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ParenExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getParenExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleIdentifierRef() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIdentifierRefRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleIdentifierRef();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getIdentifierRefRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleIdentifierRef() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIdentifierRefAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__IdentifierRef__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIdentifierRefAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_IdentifierRef() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIdentifierRefAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_IdentifierRef__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIdentifierRefAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleSuperLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSuperLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleSuperLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSuperLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleSuperLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSuperLiteralAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__SuperLiteral__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSuperLiteralAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleThisLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getThisLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleThisLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getThisLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleThisLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getThisLiteralAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ThisLiteral__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getThisLiteralAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleArrayLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleArrayLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleArrayLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayLiteralAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ArrayLiteral__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayLiteralAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ArrayLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayLiteralAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ArrayLiteral__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayLiteralAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleArrayPadding() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayPaddingRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleArrayPadding();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayPaddingRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleArrayPadding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayPaddingAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ArrayPadding__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayPaddingAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleArrayElement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayElementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleArrayElement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayElementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleArrayElement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayElementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ArrayElement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayElementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ArrayElement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayElementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ArrayElement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayElementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleObjectLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getObjectLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleObjectLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getObjectLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleObjectLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getObjectLiteralAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ObjectLiteral__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getObjectLiteralAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ObjectLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getObjectLiteralAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ObjectLiteral__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getObjectLiteralAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRulePropertyAssignment() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyAssignmentRule()); 
            }
            pushFollow(FOLLOW_1);
            rulePropertyAssignment();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyAssignmentRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void rulePropertyAssignment() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyAssignmentAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__PropertyAssignment__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyAssignmentAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_PropertyAssignment() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyAssignmentAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_PropertyAssignment__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyAssignmentAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAnnotatedPropertyAssignment() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedPropertyAssignmentRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAnnotatedPropertyAssignment();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedPropertyAssignmentRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAnnotatedPropertyAssignment() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AnnotatedPropertyAssignment__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AnnotatedPropertyAssignment() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_AnnotatedPropertyAssignment__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRulePropertyMethodDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyMethodDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            rulePropertyMethodDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyMethodDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void rulePropertyMethodDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__PropertyMethodDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_PropertyMethodDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_PropertyMethodDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRulePropertyNameValuePair() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyNameValuePairRule()); 
            }
            pushFollow(FOLLOW_1);
            rulePropertyNameValuePair();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyNameValuePairRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void rulePropertyNameValuePair() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyNameValuePairAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__PropertyNameValuePair__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyNameValuePairAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_PropertyNameValuePair() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyNameValuePairAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_PropertyNameValuePair__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyNameValuePairAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRulePropertyNameValuePairSingleName() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyNameValuePairSingleNameRule()); 
            }
            pushFollow(FOLLOW_1);
            rulePropertyNameValuePairSingleName();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyNameValuePairSingleNameRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void rulePropertyNameValuePairSingleName() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__PropertyNameValuePairSingleName__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_PropertyNameValuePairSingleName() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_PropertyNameValuePairSingleName__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRulePropertyGetterDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyGetterDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            rulePropertyGetterDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyGetterDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void rulePropertyGetterDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyGetterDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__PropertyGetterDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyGetterDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_PropertyGetterDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyGetterDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_PropertyGetterDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyGetterDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRulePropertySetterDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertySetterDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            rulePropertySetterDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertySetterDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void rulePropertySetterDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertySetterDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__PropertySetterDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertySetterDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_PropertySetterDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertySetterDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_PropertySetterDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertySetterDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleParameterizedCallExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParameterizedCallExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleParameterizedCallExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getParameterizedCallExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleParameterizedCallExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParameterizedCallExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ParameterizedCallExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getParameterizedCallExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ParameterizedCallExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParameterizedCallExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ParameterizedCallExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getParameterizedCallExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleConcreteTypeArguments() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getConcreteTypeArgumentsAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ConcreteTypeArguments__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getConcreteTypeArgumentsAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleLeftHandSideExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLeftHandSideExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleLeftHandSideExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLeftHandSideExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleLeftHandSideExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLeftHandSideExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__LeftHandSideExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLeftHandSideExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_LeftHandSideExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLeftHandSideExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_LeftHandSideExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLeftHandSideExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleArgumentsWithParentheses() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArgumentsWithParenthesesAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ArgumentsWithParentheses__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArgumentsWithParenthesesAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ArgumentsWithParentheses() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArgumentsWithParenthesesAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ArgumentsWithParentheses__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArgumentsWithParenthesesAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleArguments() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArgumentsAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__Arguments__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArgumentsAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_Arguments() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArgumentsAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_Arguments__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArgumentsAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleArgument() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArgumentRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleArgument();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getArgumentRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleArgument() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArgumentAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__Argument__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArgumentAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_Argument() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArgumentAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_Argument__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArgumentAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleMemberExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMemberExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleMemberExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getMemberExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleMemberExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMemberExpressionAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__MemberExpression__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getMemberExpressionAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_MemberExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMemberExpressionAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_MemberExpression__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getMemberExpressionAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleIndexedAccessExpressionTail() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIndexedAccessExpressionTailAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__IndexedAccessExpressionTail__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIndexedAccessExpressionTailAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_IndexedAccessExpressionTail() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIndexedAccessExpressionTailAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_IndexedAccessExpressionTail__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIndexedAccessExpressionTailAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleParameterizedPropertyAccessExpressionTail() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ParameterizedPropertyAccessExpressionTail__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ParameterizedPropertyAccessExpressionTail() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ParameterizedPropertyAccessExpressionTail__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRulePostfixExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPostfixExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            rulePostfixExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPostfixExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void rulePostfixExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPostfixExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__PostfixExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPostfixExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_PostfixExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPostfixExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_PostfixExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPostfixExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleCastExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getCastExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleCastExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getCastExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleCastExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getCastExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__CastExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getCastExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_CastExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getCastExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_CastExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getCastExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleUnaryExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getUnaryExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleUnaryExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getUnaryExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleUnaryExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getUnaryExpressionAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__UnaryExpression__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getUnaryExpressionAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_UnaryExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getUnaryExpressionAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_UnaryExpression__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getUnaryExpressionAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleMultiplicativeExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMultiplicativeExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleMultiplicativeExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getMultiplicativeExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleMultiplicativeExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMultiplicativeExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__MultiplicativeExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getMultiplicativeExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_MultiplicativeExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMultiplicativeExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_MultiplicativeExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getMultiplicativeExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAdditiveExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAdditiveExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAdditiveExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAdditiveExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAdditiveExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAdditiveExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AdditiveExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAdditiveExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AdditiveExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAdditiveExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_AdditiveExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAdditiveExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleShiftExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getShiftExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleShiftExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getShiftExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleShiftExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getShiftExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ShiftExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getShiftExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ShiftExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getShiftExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ShiftExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getShiftExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleShiftOperator() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getShiftOperatorRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleShiftOperator();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getShiftOperatorRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleShiftOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getShiftOperatorAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ShiftOperator__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getShiftOperatorAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleRelationalExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRelationalExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleRelationalExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getRelationalExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleRelationalExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRelationalExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__RelationalExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getRelationalExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_RelationalExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRelationalExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_RelationalExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getRelationalExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_RelationalExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRelationalExpressionAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_RelationalExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getRelationalExpressionAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_RelationalExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRelationalExpressionAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_RelationalExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getRelationalExpressionAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleRelationalOperator() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRelationalOperatorRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleRelationalOperator();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getRelationalOperatorRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleRelationalOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRelationalOperatorAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__RelationalOperator__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getRelationalOperatorAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_RelationalOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRelationalOperatorAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_RelationalOperator__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getRelationalOperatorAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleEqualityExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEqualityExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleEqualityExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getEqualityExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleEqualityExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEqualityExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__EqualityExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEqualityExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_EqualityExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEqualityExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_EqualityExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEqualityExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_EqualityExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEqualityExpressionAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_EqualityExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEqualityExpressionAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_EqualityExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEqualityExpressionAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_EqualityExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEqualityExpressionAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBitwiseANDExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseANDExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBitwiseANDExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseANDExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBitwiseANDExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BitwiseANDExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BitwiseANDExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_BitwiseANDExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_BitwiseANDExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_BitwiseANDExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_BitwiseANDExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_BitwiseANDExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBitwiseANDOperator() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseANDOperatorRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBitwiseANDOperator();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseANDOperatorRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBitwiseANDOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseANDOperatorAccess().getAmpersandKeyword()); 
            }
            match(input,Ampersand,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseANDOperatorAccess().getAmpersandKeyword()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBitwiseXORExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseXORExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBitwiseXORExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseXORExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBitwiseXORExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BitwiseXORExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BitwiseXORExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_BitwiseXORExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_BitwiseXORExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_BitwiseXORExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_BitwiseXORExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_BitwiseXORExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBitwiseXOROperator() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseXOROperatorRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBitwiseXOROperator();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseXOROperatorRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBitwiseXOROperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseXOROperatorAccess().getCircumflexAccentKeyword()); 
            }
            match(input,CircumflexAccent,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseXOROperatorAccess().getCircumflexAccentKeyword()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBitwiseORExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseORExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBitwiseORExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseORExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBitwiseORExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BitwiseORExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BitwiseORExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_BitwiseORExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_BitwiseORExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_BitwiseORExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_BitwiseORExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_BitwiseORExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseORExpressionAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBitwiseOROperator() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseOROperatorRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBitwiseOROperator();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseOROperatorRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBitwiseOROperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBitwiseOROperatorAccess().getVerticalLineKeyword()); 
            }
            match(input,VerticalLine,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBitwiseOROperatorAccess().getVerticalLineKeyword()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleLogicalANDExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalANDExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleLogicalANDExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalANDExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleLogicalANDExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__LogicalANDExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_LogicalANDExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_LogicalANDExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_LogicalANDExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_LogicalANDExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_LogicalANDExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_LogicalANDExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalANDExpressionAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleLogicalANDOperator() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalANDOperatorRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleLogicalANDOperator();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalANDOperatorRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleLogicalANDOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalANDOperatorAccess().getAmpersandAmpersandKeyword()); 
            }
            match(input,AmpersandAmpersand,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalANDOperatorAccess().getAmpersandAmpersandKeyword()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleLogicalORExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalORExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleLogicalORExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalORExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleLogicalORExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalORExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__LogicalORExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalORExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_LogicalORExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalORExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_LogicalORExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalORExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_LogicalORExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalORExpressionAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_LogicalORExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalORExpressionAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_LogicalORExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalORExpressionAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_LogicalORExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalORExpressionAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleLogicalOROperator() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalOROperatorRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleLogicalOROperator();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalOROperatorRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleLogicalOROperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLogicalOROperatorAccess().getVerticalLineVerticalLineKeyword()); 
            }
            match(input,VerticalLineVerticalLine,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLogicalOROperatorAccess().getVerticalLineVerticalLineKeyword()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleConditionalExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getConditionalExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleConditionalExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getConditionalExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleConditionalExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getConditionalExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ConditionalExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getConditionalExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ConditionalExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getConditionalExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ConditionalExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getConditionalExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_ConditionalExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getConditionalExpressionAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_ConditionalExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getConditionalExpressionAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_ConditionalExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getConditionalExpressionAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_ConditionalExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getConditionalExpressionAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAssignmentExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAssignmentExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAssignmentExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAssignmentExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAssignmentExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AssignmentExpression__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AssignmentExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_AssignmentExpression__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_AssignmentExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_AssignmentExpression__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_AssignmentExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_AssignmentExpression__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleYieldExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getYieldExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleYieldExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getYieldExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleYieldExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getYieldExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__YieldExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getYieldExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_YieldExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getYieldExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_YieldExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getYieldExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAssignmentOperator() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAssignmentOperatorRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAssignmentOperator();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAssignmentOperatorRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAssignmentOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAssignmentOperatorAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AssignmentOperator__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAssignmentOperatorAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAwaitExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAwaitExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAwaitExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAwaitExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAwaitExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAwaitExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AwaitExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAwaitExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AwaitExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAwaitExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_AwaitExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAwaitExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_AwaitExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAwaitExpressionAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_AwaitExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAwaitExpressionAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_AwaitExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAwaitExpressionAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_AwaitExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAwaitExpressionAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRulePromisifyExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPromisifyExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            rulePromisifyExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPromisifyExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void rulePromisifyExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPromisifyExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__PromisifyExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPromisifyExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_PromisifyExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPromisifyExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_PromisifyExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPromisifyExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_PromisifyExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPromisifyExpressionAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_PromisifyExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPromisifyExpressionAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_PromisifyExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPromisifyExpressionAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_PromisifyExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPromisifyExpressionAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__Expression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_Expression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_Expression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_Expression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionAccess().getGroup(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_Expression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionAccess().getGroup(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_Expression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionAccess().getGroup(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_Expression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionAccess().getGroup(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTemplateLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTemplateLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTemplateLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateLiteralAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TemplateLiteral__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateLiteralAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_TemplateLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateLiteralAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_TemplateLiteral__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateLiteralAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTemplateExpressionEnd() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateExpressionEndRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTemplateExpressionEnd();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateExpressionEndRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTemplateExpressionEnd() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateExpressionEndAccess().getRightCurlyBracketKeyword()); 
            }
            match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateExpressionEndAccess().getRightCurlyBracketKeyword()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleNoSubstitutionTemplate() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNoSubstitutionTemplateRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleNoSubstitutionTemplate();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getNoSubstitutionTemplateRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleNoSubstitutionTemplate() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNoSubstitutionTemplateAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__NoSubstitutionTemplate__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNoSubstitutionTemplateAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTemplateHead() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateHeadRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTemplateHead();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateHeadRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTemplateHead() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateHeadAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TemplateHead__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateHeadAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTemplateTail() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateTailRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTemplateTail();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateTailRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTemplateTail() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateTailAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TemplateTail__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateTailAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTemplateMiddle() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateMiddleRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTemplateMiddle();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateMiddleRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTemplateMiddle() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateMiddleAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TemplateMiddle__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateMiddleAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLiteralAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__Literal__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLiteralAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleNullLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNullLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleNullLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getNullLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleNullLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNullLiteralAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__NullLiteral__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNullLiteralAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBooleanLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBooleanLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBooleanLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBooleanLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBooleanLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBooleanLiteralAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BooleanLiteral__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBooleanLiteralAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleStringLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getStringLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleStringLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getStringLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleStringLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getStringLiteralAccess().getValueAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__StringLiteral__ValueAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getStringLiteralAccess().getValueAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleNumericLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNumericLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleNumericLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getNumericLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleNumericLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNumericLiteralAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__NumericLiteral__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNumericLiteralAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleDoubleLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDoubleLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleDoubleLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getDoubleLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleDoubleLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDoubleLiteralAccess().getValueAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__DoubleLiteral__ValueAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDoubleLiteralAccess().getValueAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleIntLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIntLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleIntLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getIntLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleIntLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIntLiteralAccess().getValueAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__IntLiteral__ValueAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIntLiteralAccess().getValueAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleOctalIntLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getOctalIntLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleOctalIntLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getOctalIntLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleOctalIntLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getOctalIntLiteralAccess().getValueAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__OctalIntLiteral__ValueAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getOctalIntLiteralAccess().getValueAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleLegacyOctalIntLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLegacyOctalIntLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleLegacyOctalIntLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLegacyOctalIntLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleLegacyOctalIntLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLegacyOctalIntLiteralAccess().getValueAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__LegacyOctalIntLiteral__ValueAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLegacyOctalIntLiteralAccess().getValueAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleHexIntLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getHexIntLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleHexIntLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getHexIntLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleHexIntLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getHexIntLiteralAccess().getValueAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__HexIntLiteral__ValueAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getHexIntLiteralAccess().getValueAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBinaryIntLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBinaryIntLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBinaryIntLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBinaryIntLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBinaryIntLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBinaryIntLiteralAccess().getValueAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BinaryIntLiteral__ValueAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBinaryIntLiteralAccess().getValueAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleScientificIntLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getScientificIntLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleScientificIntLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getScientificIntLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleScientificIntLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getScientificIntLiteralAccess().getValueAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ScientificIntLiteral__ValueAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getScientificIntLiteralAccess().getValueAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleRegularExpressionLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRegularExpressionLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleRegularExpressionLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getRegularExpressionLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleRegularExpressionLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getRegularExpressionLiteralAccess().getValueAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__RegularExpressionLiteral__ValueAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getRegularExpressionLiteralAccess().getValueAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleNumericLiteralAsString() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNumericLiteralAsStringRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleNumericLiteralAsString();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getNumericLiteralAsStringRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleNumericLiteralAsString() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNumericLiteralAsStringAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__NumericLiteralAsString__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNumericLiteralAsStringAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleIdentifierOrThis() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIdentifierOrThisRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleIdentifierOrThis();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getIdentifierOrThisRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleIdentifierOrThis() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIdentifierOrThisAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__IdentifierOrThis__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIdentifierOrThisAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAnnotationName() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotationNameRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAnnotationName();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotationNameRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAnnotationName() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotationNameAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AnnotationName__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotationNameAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleREGEX_LITERAL() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getREGEX_LITERALRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleREGEX_LITERAL();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getREGEX_LITERALRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleREGEX_LITERAL() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getREGEX_LITERALAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__REGEX_LITERAL__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getREGEX_LITERALAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTemplateTailLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateTailLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTemplateTailLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateTailLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTemplateTailLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateTailLiteralAccess().getTEMPLATE_ENDTerminalRuleCall()); 
            }
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0==RULE_TEMPLATE_END) ) {
                alt4=1;
            }
            switch (alt4) {
                case 1 :
                    {
                    match(input,RULE_TEMPLATE_END,FOLLOW_2); if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateTailLiteralAccess().getTEMPLATE_ENDTerminalRuleCall()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTemplateMiddleLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateMiddleLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTemplateMiddleLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateMiddleLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTemplateMiddleLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTemplateMiddleLiteralAccess().getTEMPLATE_MIDDLETerminalRuleCall()); 
            }
            match(input,RULE_TEMPLATE_MIDDLE,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTemplateMiddleLiteralAccess().getTEMPLATE_MIDDLETerminalRuleCall()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleSemi() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSemiRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleSemi();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSemiRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleSemi() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSemiAccess().getSemicolonKeyword()); 
            }
            match(input,Semicolon,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSemiAccess().getSemicolonKeyword()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleNoLineTerminator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getNoLineTerminatorAccess().getNO_LINE_TERMINATORTerminalRuleCall()); 
            }
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==RULE_NO_LINE_TERMINATOR) ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    {
                    match(input,RULE_NO_LINE_TERMINATOR,FOLLOW_2); if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getNoLineTerminatorAccess().getNO_LINE_TERMINATORTerminalRuleCall()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAnnotation() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAnnotation();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAnnotation() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotationAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__Annotation__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotationAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleScriptAnnotation() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getScriptAnnotationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleScriptAnnotation();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getScriptAnnotationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleScriptAnnotation() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getScriptAnnotationAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ScriptAnnotation__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getScriptAnnotationAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAnnotationNoAtSign() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotationNoAtSignRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAnnotationNoAtSign();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotationNoAtSignRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAnnotationNoAtSign() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotationNoAtSignAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AnnotationNoAtSign__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotationNoAtSignAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAnnotationArgument() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotationArgumentRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAnnotationArgument();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotationArgumentRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAnnotationArgument() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotationArgumentAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AnnotationArgument__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotationArgumentAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleLiteralAnnotationArgument() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLiteralAnnotationArgumentRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleLiteralAnnotationArgument();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLiteralAnnotationArgumentRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleLiteralAnnotationArgument() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLiteralAnnotationArgumentAccess().getLiteralAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__LiteralAnnotationArgument__LiteralAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLiteralAnnotationArgumentAccess().getLiteralAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypeRefAnnotationArgument() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeRefAnnotationArgumentRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypeRefAnnotationArgument();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeRefAnnotationArgumentRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypeRefAnnotationArgument() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeRefAnnotationArgumentAccess().getTypeRefAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeRefAnnotationArgument__TypeRefAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeRefAnnotationArgumentAccess().getTypeRefAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypeRefForCast() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeRefForCastRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypeRefForCast();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeRefForCastRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypeRefForCast() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeRefForCastAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeRefForCast__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeRefForCastAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAnnotationList() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotationListRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAnnotationList();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotationListRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAnnotationList() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotationListAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AnnotationList__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotationListAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleExpressionAnnotationList() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionAnnotationListRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleExpressionAnnotationList();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionAnnotationListRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleExpressionAnnotationList() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getExpressionAnnotationListAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ExpressionAnnotationList__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getExpressionAnnotationListAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRulePropertyAssignmentAnnotationList() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyAssignmentAnnotationListRule()); 
            }
            pushFollow(FOLLOW_1);
            rulePropertyAssignmentAnnotationList();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyAssignmentAnnotationListRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void rulePropertyAssignmentAnnotationList() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPropertyAssignmentAnnotationListAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__PropertyAssignmentAnnotationList__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPropertyAssignmentAnnotationListAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4MemberAnnotationList() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4MemberAnnotationListRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4MemberAnnotationList();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4MemberAnnotationListRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4MemberAnnotationList() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4MemberAnnotationListAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4MemberAnnotationList__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4MemberAnnotationListAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleTypeReference() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeReferenceAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeReference__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeReferenceAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypeReferenceName() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeReferenceNameRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypeReferenceName();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeReferenceNameRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypeReferenceName() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeReferenceNameAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeReferenceName__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeReferenceNameAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4ClassDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4ClassDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4ClassDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4ClassDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4ClassDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4ClassDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4ClassDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4ClassDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleMembers() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMembersAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__Members__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getMembersAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_Members() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMembersAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_Members__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getMembersAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleClassExtendsImplements() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getClassExtendsImplementsAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ClassExtendsImplements__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getClassExtendsImplementsAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ClassExtendsImplements() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getClassExtendsImplementsAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ClassExtendsImplements__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getClassExtendsImplementsAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleClassExtendsClause() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getClassExtendsClauseAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ClassExtendsClause__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getClassExtendsClauseAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ClassExtendsClause() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getClassExtendsClauseAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ClassExtendsClause__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getClassExtendsClauseAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleClassImplementsList() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getClassImplementsListAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ClassImplementsList__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getClassImplementsListAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4ClassExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4ClassExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4ClassExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4ClassExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4ClassExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4ClassExpressionAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4ClassExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4ClassExpressionAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_N4ClassExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4ClassExpressionAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_N4ClassExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4ClassExpressionAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4InterfaceDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4InterfaceDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4InterfaceDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4InterfaceDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4InterfaceDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4InterfaceDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4InterfaceDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4InterfaceDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleInterfaceExtendsList() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getInterfaceExtendsListAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__InterfaceExtendsList__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getInterfaceExtendsListAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4EnumDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4EnumDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4EnumDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4EnumDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4EnumDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4EnumDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4EnumDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4EnumDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4EnumLiteral() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4EnumLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4EnumLiteral();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4EnumLiteralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4EnumLiteral() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4EnumLiteralAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4EnumLiteral__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4EnumLiteralAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4MemberDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4MemberDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4MemberDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4MemberDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4MemberDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4MemberDeclarationAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4MemberDeclaration__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4MemberDeclarationAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_N4MemberDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4MemberDeclarationAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_N4MemberDeclaration__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4MemberDeclarationAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleAnnotatedN4MemberDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedN4MemberDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleAnnotatedN4MemberDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedN4MemberDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleAnnotatedN4MemberDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AnnotatedN4MemberDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AnnotatedN4MemberDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_AnnotatedN4MemberDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleFieldDeclarationImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFieldDeclarationImplAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__FieldDeclarationImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFieldDeclarationImplAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_FieldDeclarationImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFieldDeclarationImplAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_FieldDeclarationImpl__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFieldDeclarationImplAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4FieldDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4FieldDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4FieldDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4FieldDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4FieldDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4FieldDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4FieldDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4FieldDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_N4FieldDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4FieldDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_N4FieldDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4FieldDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4MethodDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4MethodDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4MethodDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4MethodDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4MethodDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4MethodDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4MethodDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4MethodDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_N4MethodDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4MethodDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_N4MethodDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4MethodDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4CallableConstructorDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4CallableConstructorDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4CallableConstructorDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4CallableConstructorDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4CallableConstructorDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4CallableConstructorDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4CallableConstructorDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4CallableConstructorDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_N4CallableConstructorDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4CallableConstructorDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_N4CallableConstructorDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4CallableConstructorDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleMethodParamsAndBody() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMethodParamsAndBodyAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__MethodParamsAndBody__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getMethodParamsAndBodyAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_MethodParamsAndBody() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMethodParamsAndBodyAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_MethodParamsAndBody__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getMethodParamsAndBodyAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleMethodParamsReturnAndBody() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMethodParamsReturnAndBodyAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__MethodParamsReturnAndBody__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getMethodParamsReturnAndBodyAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_MethodParamsReturnAndBody() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMethodParamsReturnAndBodyAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_MethodParamsReturnAndBody__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getMethodParamsReturnAndBodyAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4GetterDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4GetterDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4GetterDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4GetterDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4GetterDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4GetterDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4GetterDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4GetterDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_N4GetterDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4GetterDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_N4GetterDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4GetterDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleGetterHeader() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getGetterHeaderAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__GetterHeader__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getGetterHeaderAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_GetterHeader() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getGetterHeaderAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_GetterHeader__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getGetterHeaderAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4SetterDeclaration() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4SetterDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4SetterDeclaration();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4SetterDeclarationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4SetterDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4SetterDeclarationAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4SetterDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4SetterDeclarationAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_N4SetterDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4SetterDeclarationAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_N4SetterDeclaration__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4SetterDeclarationAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBindingPattern() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingPatternRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBindingPattern();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingPatternRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBindingPattern() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingPatternAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BindingPattern__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingPatternAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BindingPattern() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingPatternAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_BindingPattern__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingPatternAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleObjectBindingPattern() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getObjectBindingPatternRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleObjectBindingPattern();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getObjectBindingPatternRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleObjectBindingPattern() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getObjectBindingPatternAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ObjectBindingPattern__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getObjectBindingPatternAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ObjectBindingPattern() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getObjectBindingPatternAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ObjectBindingPattern__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getObjectBindingPatternAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleArrayBindingPattern() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayBindingPatternRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleArrayBindingPattern();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayBindingPatternRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleArrayBindingPattern() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayBindingPatternAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ArrayBindingPattern__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayBindingPatternAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ArrayBindingPattern() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayBindingPatternAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_ArrayBindingPattern__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayBindingPatternAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBindingProperty() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingPropertyRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBindingProperty();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingPropertyRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBindingProperty() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingPropertyAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BindingProperty__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingPropertyAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BindingProperty() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingPropertyAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_BindingProperty__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingPropertyAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleSingleNameBinding() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSingleNameBindingRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleSingleNameBinding();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getSingleNameBindingRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleSingleNameBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__SingleNameBinding__VarDeclAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_SingleNameBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_SingleNameBinding__VarDeclAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_SingleNameBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 2
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm2_SingleNameBinding__VarDeclAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 2
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_SingleNameBinding() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 3
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm3_SingleNameBinding__VarDeclAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), 3
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBindingElement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingElementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBindingElement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingElementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBindingElement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingElementAccess().getBindingElementImplParserRuleCall(), 0
              		); 
            }
            pushFollow(FOLLOW_2);
            ruleBindingElementImpl();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingElementAccess().getBindingElementImplParserRuleCall(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BindingElement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingElementAccess().getBindingElementImplParserRuleCall(), 1
              		); 
            }
            pushFollow(FOLLOW_2);
            norm1_BindingElementImpl();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingElementAccess().getBindingElementImplParserRuleCall(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBindingRestElement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingRestElementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBindingRestElement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingRestElementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBindingRestElement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingRestElementAccess().getGroup(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BindingRestElement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingRestElementAccess().getGroup(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BindingRestElement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingRestElementAccess().getGroup(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_BindingRestElement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingRestElementAccess().getGroup(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleBindingElementImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingElementImplAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BindingElementImpl__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingElementImplAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BindingElementImpl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingElementImplAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_BindingElementImpl__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingElementImplAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleElision() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getElisionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleElision();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getElisionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleElision() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getElisionAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__Elision__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getElisionAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleLiteralOrComputedPropertyName() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLiteralOrComputedPropertyNameRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleLiteralOrComputedPropertyName();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getLiteralOrComputedPropertyNameRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleLiteralOrComputedPropertyName() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__LiteralOrComputedPropertyName__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_LiteralOrComputedPropertyName() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_LiteralOrComputedPropertyName__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleJSXElement() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXElementRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleJSXElement();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXElementRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleJSXElement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXElementAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__JSXElement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXElementAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleJSXFragment() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXFragmentRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleJSXFragment();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXFragmentRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleJSXFragment() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXFragmentAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__JSXFragment__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXFragmentAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleJSXClosingElement() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXClosingElementAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__JSXClosingElement__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXClosingElementAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleJSXChild() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXChildRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleJSXChild();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXChildRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleJSXChild() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXChildAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__JSXChild__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXChildAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleJSXExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleJSXExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleJSXExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXExpressionAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__JSXExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXExpressionAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleJSXElementName() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXElementNameRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleJSXElementName();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXElementNameRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleJSXElementName() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXElementNameAccess().getExpressionAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__JSXElementName__ExpressionAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXElementNameAccess().getExpressionAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleJSXElementNameExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXElementNameExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleJSXElementNameExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXElementNameExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleJSXElementNameExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXElementNameExpressionAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__JSXElementNameExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXElementNameExpressionAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleJSXAttributes() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXAttributesAccess().getJsxAttributesAssignment()); 
            }
            loop6:
            do {
                int alt6=2;
                int LA6_0 = input.LA(1);

                if ( ((LA6_0>=Intersection && LA6_0<=With)||(LA6_0>=For && LA6_0<=Var)||(LA6_0>=As && LA6_0<=Of)||LA6_0==LeftCurlyBracket||LA6_0==RULE_IDENTIFIER) ) {
                    alt6=1;
                }


                switch (alt6) {
            	case 1 :
            	    {
            	    pushFollow(FOLLOW_3);
            	    rule__JSXAttributes__JsxAttributesAssignment();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop6;
                }
            } while (true);

            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXAttributesAccess().getJsxAttributesAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleJSXAttribute() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXAttributeRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleJSXAttribute();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXAttributeRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleJSXAttribute() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXAttributeAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__JSXAttribute__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXAttributeAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleJSXSpreadAttribute() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXSpreadAttributeRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleJSXSpreadAttribute();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXSpreadAttributeRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleJSXSpreadAttribute() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXSpreadAttributeAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__JSXSpreadAttribute__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXSpreadAttributeAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleJSXPropertyAttribute() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXPropertyAttributeRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleJSXPropertyAttribute();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXPropertyAttributeRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleJSXPropertyAttribute() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getJSXPropertyAttributeAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__JSXPropertyAttribute__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getJSXPropertyAttributeAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleVersionDeclaration() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVersionDeclarationAccess().getDeclaredVersionAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__VersionDeclaration__DeclaredVersionAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVersionDeclarationAccess().getDeclaredVersionAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypeRef() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeRefRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypeRef();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeRefRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypeRef() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeRefAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeRef__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeRefAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleIntersectionTypeExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIntersectionTypeExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleIntersectionTypeExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getIntersectionTypeExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleIntersectionTypeExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIntersectionTypeExpressionAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__IntersectionTypeExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIntersectionTypeExpressionAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRulePrimaryTypeExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPrimaryTypeExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            rulePrimaryTypeExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getPrimaryTypeExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void rulePrimaryTypeExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPrimaryTypeExpressionAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__PrimaryTypeExpression__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPrimaryTypeExpressionAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypeRefWithModifiers() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeRefWithModifiersRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypeRefWithModifiers();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeRefWithModifiersRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypeRefWithModifiers() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeRefWithModifiersAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeRefWithModifiers__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeRefWithModifiersAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypeRefWithoutModifiers() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeRefWithoutModifiersRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypeRefWithoutModifiers();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeRefWithoutModifiersRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypeRefWithoutModifiers() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeRefWithoutModifiersAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeRefWithoutModifiers__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeRefWithoutModifiersAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypeRefFunctionTypeExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeRefFunctionTypeExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypeRefFunctionTypeExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeRefFunctionTypeExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypeRefFunctionTypeExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeRefFunctionTypeExpression__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypeArgInTypeTypeRef() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeArgInTypeTypeRefRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypeArgInTypeTypeRef();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeArgInTypeTypeRefRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypeArgInTypeTypeRef() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeArgInTypeTypeRefAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeArgInTypeTypeRef__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeArgInTypeTypeRefAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleThisTypeRef() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getThisTypeRefRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleThisTypeRef();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getThisTypeRefRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleThisTypeRef() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getThisTypeRefAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ThisTypeRef__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getThisTypeRefAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleThisTypeRefNominal() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getThisTypeRefNominalRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleThisTypeRefNominal();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getThisTypeRefNominalRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleThisTypeRefNominal() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getThisTypeRefNominalAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ThisTypeRefNominal__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getThisTypeRefNominalAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleThisTypeRefStructural() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getThisTypeRefStructuralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleThisTypeRefStructural();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getThisTypeRefStructuralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleThisTypeRefStructural() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getThisTypeRefStructuralAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ThisTypeRefStructural__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getThisTypeRefStructuralAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleFunctionTypeExpressionOLD() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionTypeExpressionOLDRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleFunctionTypeExpressionOLD();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionTypeExpressionOLDRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleFunctionTypeExpressionOLD() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getFunctionTypeExpressionOLDAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__FunctionTypeExpressionOLD__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getFunctionTypeExpressionOLDAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleArrowFunctionTypeExpression() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrowFunctionTypeExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleArrowFunctionTypeExpression();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrowFunctionTypeExpressionRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleArrowFunctionTypeExpression() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrowFunctionTypeExpressionAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ArrowFunctionTypeExpression__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrowFunctionTypeExpressionAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleTAnonymousFormalParameterList() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTAnonymousFormalParameterListAccess().getGroup()); 
            }
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( ((LA7_0>=Intersection && LA7_0<=Implements)||(LA7_0>=Promisify && LA7_0<=Abstract)||LA7_0==External||LA7_0==Default||(LA7_0>=Private && LA7_0<=Project)||LA7_0==Public||LA7_0==Static||LA7_0==Target||(LA7_0>=Async && LA7_0<=Await)||LA7_0==Union||(LA7_0>=Yield && LA7_0<=This)||LA7_0==From||LA7_0==This_1||(LA7_0>=Type && LA7_0<=Void)||LA7_0==FullStopFullStopFullStop||(LA7_0>=Get && LA7_0<=Let)||(LA7_0>=Out && LA7_0<=Set)||LA7_0==As||LA7_0==Of||LA7_0==LeftParenthesis||LA7_0==LeftSquareBracket||LA7_0==LeftCurlyBracket||LA7_0==Tilde||LA7_0==RULE_IDENTIFIER) ) {
                alt7=1;
            }
            switch (alt7) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    rule__TAnonymousFormalParameterList__Group__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTAnonymousFormalParameterListAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTAnonymousFormalParameter() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTAnonymousFormalParameterRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTAnonymousFormalParameter();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTAnonymousFormalParameterRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTAnonymousFormalParameter() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTAnonymousFormalParameterAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TAnonymousFormalParameter__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTAnonymousFormalParameterAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleDefaultFormalParameter() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getDefaultFormalParameterAccess().getGroup()); 
            }
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0==EqualsSign) ) {
                alt8=1;
            }
            switch (alt8) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    rule__DefaultFormalParameter__Group__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getDefaultFormalParameterAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleUnionTypeExpressionOLD() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getUnionTypeExpressionOLDRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleUnionTypeExpressionOLD();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getUnionTypeExpressionOLDRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleUnionTypeExpressionOLD() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getUnionTypeExpressionOLDAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__UnionTypeExpressionOLD__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getUnionTypeExpressionOLDAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleIntersectionTypeExpressionOLD() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIntersectionTypeExpressionOLDRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleIntersectionTypeExpressionOLD();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getIntersectionTypeExpressionOLDRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleIntersectionTypeExpressionOLD() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIntersectionTypeExpressionOLDAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__IntersectionTypeExpressionOLD__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIntersectionTypeExpressionOLDAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleParameterizedTypeRef() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParameterizedTypeRefRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleParameterizedTypeRef();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getParameterizedTypeRefRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleParameterizedTypeRef() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParameterizedTypeRefAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ParameterizedTypeRef__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getParameterizedTypeRefAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleParameterizedTypeRefNominal() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParameterizedTypeRefNominalRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleParameterizedTypeRefNominal();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getParameterizedTypeRefNominalRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleParameterizedTypeRefNominal() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParameterizedTypeRefNominalAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ParameterizedTypeRefNominal__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getParameterizedTypeRefNominalAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleParameterizedTypeRefStructural() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParameterizedTypeRefStructuralRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleParameterizedTypeRefStructural();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getParameterizedTypeRefStructuralRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleParameterizedTypeRefStructural() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getParameterizedTypeRefStructuralAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ParameterizedTypeRefStructural__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getParameterizedTypeRefStructuralAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleArrayTypeRef() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayTypeRefRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleArrayTypeRef();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayTypeRefRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleArrayTypeRef() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getArrayTypeRefAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ArrayTypeRef__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getArrayTypeRefAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleVersionRequest() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVersionRequestAccess().getRequestedVersionAssignment()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__VersionRequest__RequestedVersionAssignment();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVersionRequestAccess().getRequestedVersionAssignment()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleTypeArguments() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeArgumentsAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeArguments__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeArgumentsAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleTStructMemberList() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTStructMemberListAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TStructMemberList__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTStructMemberListAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTStructMember() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTStructMemberRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTStructMember();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTStructMemberRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTStructMember() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTStructMemberAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TStructMember__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTStructMemberAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTStructMethod() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTStructMethodRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTStructMethod();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTStructMethodRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTStructMethod() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTStructMethodAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TStructMethod__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTStructMethodAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleTypeVariables() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeVariablesAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeVariables__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeVariablesAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleColonSepDeclaredTypeRef() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getColonSepDeclaredTypeRefAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ColonSepDeclaredTypeRef__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getColonSepDeclaredTypeRefAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleColonSepTypeRef() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getColonSepTypeRefAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ColonSepTypeRef__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getColonSepTypeRefAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleColonSepReturnTypeRef() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getColonSepReturnTypeRefAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ColonSepReturnTypeRef__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getColonSepReturnTypeRefAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTStructField() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTStructFieldRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTStructField();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTStructFieldRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTStructField() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTStructFieldAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TStructField__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTStructFieldAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTStructGetter() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTStructGetterRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTStructGetter();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTStructGetterRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTStructGetter() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTStructGetterAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TStructGetter__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTStructGetterAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTStructSetter() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTStructSetterRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTStructSetter();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTStructSetterRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTStructSetter() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTStructSetterAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TStructSetter__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTStructSetterAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypingStrategyUseSiteOperator() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypingStrategyUseSiteOperatorRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypingStrategyUseSiteOperator();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypingStrategyUseSiteOperatorRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypingStrategyUseSiteOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypingStrategyUseSiteOperatorAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypingStrategyUseSiteOperator__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypingStrategyUseSiteOperatorAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypingStrategyDefSiteOperator() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypingStrategyDefSiteOperatorRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypingStrategyDefSiteOperator();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypingStrategyDefSiteOperatorRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypingStrategyDefSiteOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypingStrategyDefSiteOperatorAccess().getTildeKeyword()); 
            }
            match(input,Tilde,FOLLOW_2); if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypingStrategyDefSiteOperatorAccess().getTildeKeyword()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypeTypeRef() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeTypeRefRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypeTypeRef();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeTypeRefRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypeTypeRef() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeTypeRefAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeTypeRef__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeTypeRefAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleTypeArgument() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeArgumentRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleTypeArgument();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeArgumentRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleTypeArgument() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getTypeArgumentAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__TypeArgument__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getTypeArgumentAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleWildcard() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getWildcardRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleWildcard();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getWildcardRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleWildcard() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getWildcardAccess().getGroup()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__Wildcard__Group__0();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getWildcardAccess().getGroup()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleWildcardNewNotation() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getWildcardNewNotationRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleWildcardNewNotation();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getWildcardNewNotationRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleWildcardNewNotation() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getWildcardNewNotationAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__WildcardNewNotation__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getWildcardNewNotationAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleBindingIdentifier() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingIdentifierRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingIdentifierRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleBindingIdentifier() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingIdentifierAccess().getAlternatives(), 0
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__BindingIdentifier__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingIdentifierAccess().getAlternatives(), 0
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BindingIdentifier() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getBindingIdentifierAccess().getAlternatives(), 1
              		); 
            }
            {
            pushFollow(FOLLOW_2);
            norm1_BindingIdentifier__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getBindingIdentifierAccess().getAlternatives(), 1
              		); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleIdentifierName() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIdentifierNameRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleIdentifierName();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getIdentifierNameRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleIdentifierName() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getIdentifierNameAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__IdentifierName__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getIdentifierNameAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleReservedWord() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getReservedWordRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleReservedWord();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getReservedWordRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleReservedWord() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getReservedWordAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__ReservedWord__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getReservedWordAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void entryRuleN4Keyword() throws RecognitionException {
        try {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4KeywordRule()); 
            }
            pushFollow(FOLLOW_1);
            ruleN4Keyword();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4KeywordRule()); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    public final void ruleN4Keyword() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4KeywordAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4Keyword__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4KeywordAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleVariableStatementKeyword() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getVariableStatementKeywordAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__VariableStatementKeyword__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getVariableStatementKeywordAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rulePostfixOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getPostfixOperatorAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__PostfixOperator__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getPostfixOperatorAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleUnaryOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getUnaryOperatorAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__UnaryOperator__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getUnaryOperatorAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleMultiplicativeOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getMultiplicativeOperatorAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__MultiplicativeOperator__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getMultiplicativeOperatorAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleAdditiveOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getAdditiveOperatorAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__AdditiveOperator__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getAdditiveOperatorAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleEqualityOperator() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getEqualityOperatorAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__EqualityOperator__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getEqualityOperatorAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void ruleN4Modifier() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            {
            {
            if ( state.backtracking==0 ) {
               before(grammarAccess.getN4ModifierAccess().getAlternatives()); 
            }
            {
            pushFollow(FOLLOW_2);
            rule__N4Modifier__Alternatives();

            state._fsp--;
            if (state.failed) return ;

            }

            if ( state.backtracking==0 ) {
               after(grammarAccess.getN4ModifierAccess().getAlternatives()); 
            }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__Script__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt9=2;
            int LA9_0 = input.LA(1);

            if ( (LA9_0==CommercialAtCommercialAt) ) {
                alt9=1;
            }
            else if ( ((LA9_0>=Intersection && LA9_0<=With)||(LA9_0>=For && LA9_0<=Var)||(LA9_0>=Try && LA9_0<=Var)||LA9_0==PlusSignPlusSign||LA9_0==HyphenMinusHyphenMinus||LA9_0==SolidusEqualsSign||(LA9_0>=As && LA9_0<=Of)||LA9_0==ExclamationMark||LA9_0==LeftParenthesis||LA9_0==PlusSign||LA9_0==HyphenMinus||LA9_0==Solidus||(LA9_0>=Semicolon && LA9_0<=LessThanSign)||(LA9_0>=CommercialAt && LA9_0<=LeftSquareBracket)||LA9_0==LeftCurlyBracket||LA9_0==Tilde||LA9_0==RULE_DOUBLE||(LA9_0>=RULE_HEX_INT && LA9_0<=RULE_LEGACY_OCTAL_INT)||LA9_0==RULE_SCIENTIFIC_INT||LA9_0==RULE_IDENTIFIER||LA9_0==RULE_STRING||(LA9_0>=RULE_TEMPLATE_HEAD && LA9_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA9_0==RULE_INT) ) {
                alt9=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 9, 0, input);

                throw nvae;
            }
            switch (alt9) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getScriptAccess().getAnnotationsAssignment_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__Script__AnnotationsAssignment_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getScriptAccess().getAnnotationsAssignment_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getScriptAccess().getScriptElementsAssignment_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__Script__ScriptElementsAssignment_1_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getScriptAccess().getScriptElementsAssignment_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ScriptElement__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt10=7;
            alt10 = dfa10.predict(input);
            switch (alt10) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getScriptElementAccess().getAnnotatedScriptElementParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleAnnotatedScriptElement();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getScriptElementAccess().getAnnotatedScriptElementParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getScriptElementAccess().getN4ClassDeclarationParserRuleCall_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleN4ClassDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getScriptElementAccess().getN4ClassDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getScriptElementAccess().getN4InterfaceDeclarationParserRuleCall_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleN4InterfaceDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getScriptElementAccess().getN4InterfaceDeclarationParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getScriptElementAccess().getN4EnumDeclarationParserRuleCall_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleN4EnumDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getScriptElementAccess().getN4EnumDeclarationParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getScriptElementAccess().getImportDeclarationParserRuleCall_4()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleImportDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getScriptElementAccess().getImportDeclarationParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getScriptElementAccess().getExportDeclarationParserRuleCall_5()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleExportDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getScriptElementAccess().getExportDeclarationParserRuleCall_5()); 
                    }

                    }


                    }
                    break;
                case 7 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getScriptElementAccess().getRootStatementParserRuleCall_6()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleRootStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getScriptElementAccess().getRootStatementParserRuleCall_6()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AnnotatedScriptElement__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt11=5;
            alt11 = dfa11.predict(input);
            switch (alt11) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedScriptElement__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedScriptElement__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedScriptElement__Group_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedScriptElement__Group_1_3__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedScriptElement__Group_1_4__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_4()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AnnotatedScriptElement__Alternatives_1_3_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt12=2;
            alt12 = dfa12.predict(input);
            switch (alt12) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3_0_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedScriptElement__Group_1_3_0_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedScriptElement__Group_1_3_0_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3_0_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ExportDeclarationImpl__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt13=4;
            switch ( input.LA(1) ) {
            case Asterisk:
                {
                alt13=1;
                }
                break;
            case LeftCurlyBracket:
                {
                alt13=2;
                }
                break;
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Function:
            case Private:
            case Project:
            case Public:
            case Static:
            case Async:
            case Class:
            case Const:
            case Enum:
            case Let:
            case Var:
            case CommercialAt:
                {
                alt13=3;
                }
                break;
            case Default:
                {
                alt13=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 13, 0, input);

                throw nvae;
            }

            switch (alt13) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportDeclarationImplAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ExportDeclarationImpl__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportDeclarationImplAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportDeclarationImplAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ExportDeclarationImpl__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportDeclarationImplAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportDeclarationImplAccess().getExportedElementAssignment_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ExportDeclarationImpl__ExportedElementAssignment_1_2();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportDeclarationImplAccess().getExportedElementAssignment_1_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportDeclarationImplAccess().getGroup_1_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ExportDeclarationImpl__Group_1_3__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportDeclarationImplAccess().getGroup_1_3()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ExportDeclarationImpl__Alternatives_1_3_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt14=2;
            alt14 = dfa14.predict(input);
            switch (alt14) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportDeclarationImplAccess().getExportedElementAssignment_1_3_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ExportDeclarationImpl__ExportedElementAssignment_1_3_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportDeclarationImplAccess().getExportedElementAssignment_1_3_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportDeclarationImplAccess().getGroup_1_3_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ExportDeclarationImpl__Group_1_3_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportDeclarationImplAccess().getGroup_1_3_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ExportableElement__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt15=6;
            alt15 = dfa15.predict(input);
            switch (alt15) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportableElementAccess().getAnnotatedExportableElementParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleAnnotatedExportableElement();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportableElementAccess().getAnnotatedExportableElementParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportableElementAccess().getN4ClassDeclarationParserRuleCall_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleN4ClassDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportableElementAccess().getN4ClassDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportableElementAccess().getN4InterfaceDeclarationParserRuleCall_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleN4InterfaceDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportableElementAccess().getN4InterfaceDeclarationParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportableElementAccess().getN4EnumDeclarationParserRuleCall_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleN4EnumDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportableElementAccess().getN4EnumDeclarationParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportableElementAccess().getFunctionDeclarationParserRuleCall_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleFunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportableElementAccess().getFunctionDeclarationParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportableElementAccess().getExportedVariableStatementParserRuleCall_5()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleExportedVariableStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportableElementAccess().getExportedVariableStatementParserRuleCall_5()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AnnotatedExportableElement__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt16=4;
            alt16 = dfa16.predict(input);
            switch (alt16) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedExportableElement__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedExportableElement__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedExportableElement__Group_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedExportableElement__Group_1_3__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_3()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AnnotatedExportableElement__Alternatives_1_2_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt17=2;
            alt17 = dfa17.predict(input);
            switch (alt17) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2_0_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedExportableElement__Group_1_2_0_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedExportableElement__Group_1_2_0_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2_0_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ImportClause__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt18=2;
            int LA18_0 = input.LA(1);

            if ( ((LA18_0>=Intersection && LA18_0<=Implements)||(LA18_0>=Promisify && LA18_0<=Abstract)||LA18_0==External||(LA18_0>=Private && LA18_0<=Project)||LA18_0==Public||LA18_0==Static||LA18_0==Target||(LA18_0>=Async && LA18_0<=Await)||LA18_0==Union||(LA18_0>=Yield && LA18_0<=This)||LA18_0==From||LA18_0==Type||(LA18_0>=Get && LA18_0<=Let)||(LA18_0>=Out && LA18_0<=Set)||LA18_0==As||LA18_0==Of||LA18_0==RULE_IDENTIFIER) ) {
                alt18=1;
            }
            else if ( (LA18_0==Asterisk||LA18_0==LeftCurlyBracket) ) {
                alt18=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 18, 0, input);

                throw nvae;
            }
            switch (alt18) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getImportClauseAccess().getGroup_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ImportClause__Group_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getImportClauseAccess().getGroup_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getImportClauseAccess().getImportSpecifiersExceptDefaultParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleImportSpecifiersExceptDefault();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getImportClauseAccess().getImportSpecifiersExceptDefaultParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ImportSpecifiersExceptDefault__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt19=2;
            int LA19_0 = input.LA(1);

            if ( (LA19_0==Asterisk) ) {
                alt19=1;
            }
            else if ( (LA19_0==LeftCurlyBracket) ) {
                alt19=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 19, 0, input);

                throw nvae;
            }
            switch (alt19) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ImportSpecifiersExceptDefault__ImportSpecifiersAssignment_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getImportSpecifiersExceptDefaultAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ImportSpecifiersExceptDefault__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getImportSpecifiersExceptDefaultAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__NamedImportSpecifier__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt20=2;
            alt20 = dfa20.predict(input);
            switch (alt20) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNamedImportSpecifierAccess().getImportedElementAssignment_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__NamedImportSpecifier__ImportedElementAssignment_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNamedImportSpecifierAccess().getImportedElementAssignment_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNamedImportSpecifierAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__NamedImportSpecifier__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNamedImportSpecifierAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__FunctionImpl__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt21=2;
            int LA21_0 = input.LA(1);

            if ( (LA21_0==Asterisk) ) {
                alt21=1;
            }
            else if ( ((LA21_0>=Intersection && LA21_0<=Implements)||(LA21_0>=Promisify && LA21_0<=Abstract)||LA21_0==External||(LA21_0>=Private && LA21_0<=Project)||LA21_0==Public||LA21_0==Static||LA21_0==Target||(LA21_0>=Async && LA21_0<=Await)||LA21_0==Union||(LA21_0>=Yield && LA21_0<=This)||LA21_0==From||LA21_0==Type||(LA21_0>=Get && LA21_0<=Let)||(LA21_0>=Out && LA21_0<=Set)||LA21_0==As||LA21_0==Of||LA21_0==LeftParenthesis||LA21_0==LessThanSign||LA21_0==RULE_IDENTIFIER||LA21_0==RULE_VERSION) ) {
                alt21=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 21, 0, input);

                throw nvae;
            }
            switch (alt21) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getFunctionImplAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__FunctionImpl__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getFunctionImplAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getFunctionImplAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__FunctionImpl__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getFunctionImplAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_FunctionImpl__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt22=2;
            int LA22_0 = input.LA(1);

            if ( (LA22_0==Asterisk) ) {
                alt22=1;
            }
            else if ( ((LA22_0>=Intersection && LA22_0<=Implements)||(LA22_0>=Promisify && LA22_0<=Abstract)||LA22_0==External||(LA22_0>=Private && LA22_0<=Project)||LA22_0==Public||LA22_0==Static||LA22_0==Target||(LA22_0>=Async && LA22_0<=Await)||LA22_0==Union||LA22_0==This||LA22_0==From||LA22_0==Type||(LA22_0>=Get && LA22_0<=Let)||(LA22_0>=Out && LA22_0<=Set)||LA22_0==As||LA22_0==Of||LA22_0==LeftParenthesis||LA22_0==LessThanSign||LA22_0==RULE_IDENTIFIER||LA22_0==RULE_VERSION) ) {
                alt22=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 22, 0, input);

                throw nvae;
            }
            switch (alt22) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getFunctionImplAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_FunctionImpl__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getFunctionImplAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getFunctionImplAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_FunctionImpl__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getFunctionImplAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm6_FunctionImpl__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt23=2;
            int LA23_0 = input.LA(1);

            if ( (LA23_0==Asterisk) ) {
                alt23=1;
            }
            else if ( ((LA23_0>=Intersection && LA23_0<=Implements)||(LA23_0>=Promisify && LA23_0<=Abstract)||LA23_0==External||(LA23_0>=Private && LA23_0<=Project)||LA23_0==Public||LA23_0==Static||LA23_0==Target||(LA23_0>=Async && LA23_0<=Await)||LA23_0==Union||(LA23_0>=Yield && LA23_0<=This)||LA23_0==From||LA23_0==Type||(LA23_0>=Get && LA23_0<=Let)||(LA23_0>=Out && LA23_0<=Set)||LA23_0==As||LA23_0==Of||LA23_0==LeftParenthesis||LA23_0==LessThanSign||LA23_0==RULE_IDENTIFIER||LA23_0==RULE_VERSION) ) {
                alt23=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 23, 0, input);

                throw nvae;
            }
            switch (alt23) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getFunctionImplAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm6_FunctionImpl__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getFunctionImplAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getFunctionImplAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm6_FunctionImpl__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getFunctionImplAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ArrowExpression__Alternatives_0_0_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt24=3;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt24=1;
                }
                break;
            case Async:
                {
                int LA24_2 = input.LA(2);

                if ( (LA24_2==LeftParenthesis||LA24_2==RULE_NO_LINE_TERMINATOR) ) {
                    alt24=2;
                }
                else if ( (LA24_2==EqualsSignGreaterThanSign) ) {
                    alt24=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 24, 2, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Private:
            case Project:
            case Public:
            case Static:
            case Target:
            case Await:
            case Union:
            case Yield:
            case This:
            case From:
            case Type:
            case Get:
            case Let:
            case Out:
            case Set:
            case As:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt24=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 24, 0, input);

                throw nvae;
            }

            switch (alt24) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ArrowExpression__Group_0_0_0_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ArrowExpression__Group_0_0_0_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ArrowExpression__FparsAssignment_0_0_0_2();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ArrowExpression__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt25=2;
            alt25 = dfa25.predict(input);
            switch (alt25) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ArrowExpression__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ArrowExpression__BodyAssignment_1_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ArrowExpression__Alternatives_0_0_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt26=3;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt26=1;
                }
                break;
            case Async:
                {
                int LA26_2 = input.LA(2);

                if ( (LA26_2==LeftParenthesis||LA26_2==RULE_NO_LINE_TERMINATOR) ) {
                    alt26=2;
                }
                else if ( (LA26_2==EqualsSignGreaterThanSign) ) {
                    alt26=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 26, 2, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Private:
            case Project:
            case Public:
            case Static:
            case Target:
            case Await:
            case Union:
            case Yield:
            case This:
            case From:
            case Type:
            case Get:
            case Let:
            case Out:
            case Set:
            case As:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt26=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 26, 0, input);

                throw nvae;
            }

            switch (alt26) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ArrowExpression__Group_0_0_0_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ArrowExpression__Group_0_0_0_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ArrowExpression__FparsAssignment_0_0_0_2();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ArrowExpression__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt27=2;
            alt27 = dfa27.predict(input);
            switch (alt27) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ArrowExpression__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ArrowExpression__BodyAssignment_1_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_ArrowExpression__Alternatives_0_0_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt28=3;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt28=1;
                }
                break;
            case Async:
                {
                int LA28_2 = input.LA(2);

                if ( (LA28_2==EqualsSignGreaterThanSign) ) {
                    alt28=3;
                }
                else if ( (LA28_2==LeftParenthesis||LA28_2==RULE_NO_LINE_TERMINATOR) ) {
                    alt28=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 28, 2, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Private:
            case Project:
            case Public:
            case Static:
            case Target:
            case Await:
            case Union:
            case This:
            case From:
            case Type:
            case Get:
            case Let:
            case Out:
            case Set:
            case As:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt28=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 28, 0, input);

                throw nvae;
            }

            switch (alt28) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm2_ArrowExpression__Group_0_0_0_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm2_ArrowExpression__Group_0_0_0_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm2_ArrowExpression__FparsAssignment_0_0_0_2();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_ArrowExpression__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt29=2;
            alt29 = dfa29.predict(input);
            switch (alt29) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm2_ArrowExpression__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm2_ArrowExpression__BodyAssignment_1_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_ArrowExpression__Alternatives_0_0_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt30=3;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt30=1;
                }
                break;
            case Async:
                {
                int LA30_2 = input.LA(2);

                if ( (LA30_2==EqualsSignGreaterThanSign) ) {
                    alt30=3;
                }
                else if ( (LA30_2==LeftParenthesis||LA30_2==RULE_NO_LINE_TERMINATOR) ) {
                    alt30=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 30, 2, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Private:
            case Project:
            case Public:
            case Static:
            case Target:
            case Await:
            case Union:
            case This:
            case From:
            case Type:
            case Get:
            case Let:
            case Out:
            case Set:
            case As:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt30=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 30, 0, input);

                throw nvae;
            }

            switch (alt30) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_ArrowExpression__Group_0_0_0_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_ArrowExpression__Group_0_0_0_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_ArrowExpression__FparsAssignment_0_0_0_2();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_ArrowExpression__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt31=2;
            alt31 = dfa31.predict(input);
            switch (alt31) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_ArrowExpression__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_ArrowExpression__BodyAssignment_1_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AnnotatedExpression__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt32=2;
            int LA32_0 = input.LA(1);

            if ( (LA32_0==Class) ) {
                alt32=1;
            }
            else if ( (LA32_0==Function||LA32_0==Async) ) {
                alt32=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 32, 0, input);

                throw nvae;
            }
            switch (alt32) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedExpression__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedExpression__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AnnotatedExpression__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt33=2;
            int LA33_0 = input.LA(1);

            if ( (LA33_0==Class) ) {
                alt33=1;
            }
            else if ( (LA33_0==Function||LA33_0==Async) ) {
                alt33=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 33, 0, input);

                throw nvae;
            }
            switch (alt33) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedExpression__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedExpression__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__TypeVariable__Alternatives_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt34=2;
            int LA34_0 = input.LA(1);

            if ( (LA34_0==Out) ) {
                alt34=1;
            }
            else if ( (LA34_0==In) ) {
                alt34=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 34, 0, input);

                throw nvae;
            }
            switch (alt34) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeVariableAccess().getDeclaredCovariantAssignment_0_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__TypeVariable__DeclaredCovariantAssignment_0_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeVariableAccess().getDeclaredCovariantAssignment_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeVariableAccess().getDeclaredContravariantAssignment_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__TypeVariable__DeclaredContravariantAssignment_0_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeVariableAccess().getDeclaredContravariantAssignment_0_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__BindingElementFragment__Alternatives_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt35=2;
            alt35 = dfa35.predict(input);
            switch (alt35) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingElementFragmentAccess().getBindingPatternAssignment_0_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__BindingElementFragment__BindingPatternAssignment_0_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingElementFragmentAccess().getBindingPatternAssignment_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingElementFragmentAccess().getGroup_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__BindingElementFragment__Group_0_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingElementFragmentAccess().getGroup_0_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BindingElementFragment__Alternatives_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt36=2;
            alt36 = dfa36.predict(input);
            switch (alt36) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingElementFragmentAccess().getBindingPatternAssignment_0_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_BindingElementFragment__BindingPatternAssignment_0_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingElementFragmentAccess().getBindingPatternAssignment_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingElementFragmentAccess().getGroup_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_BindingElementFragment__Group_0_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingElementFragmentAccess().getGroup_0_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__RootStatement__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt37=16;
            alt37 = dfa37.predict(input);
            switch (alt37) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getBlockParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleBlock();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getBlockParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getFunctionDeclarationParserRuleCall_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleFunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getFunctionDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getVariableStatementParserRuleCall_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_VariableStatement();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getVariableStatementParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getEmptyStatementParserRuleCall_3()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleEmptyStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getEmptyStatementParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getLabelledStatementParserRuleCall_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleLabelledStatement();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getLabelledStatementParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getExpressionStatementParserRuleCall_5()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleExpressionStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getExpressionStatementParserRuleCall_5()); 
                    }

                    }


                    }
                    break;
                case 7 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getIfStatementParserRuleCall_6()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleIfStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getIfStatementParserRuleCall_6()); 
                    }

                    }


                    }
                    break;
                case 8 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getIterationStatementParserRuleCall_7()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleIterationStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getIterationStatementParserRuleCall_7()); 
                    }

                    }


                    }
                    break;
                case 9 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getContinueStatementParserRuleCall_8()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleContinueStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getContinueStatementParserRuleCall_8()); 
                    }

                    }


                    }
                    break;
                case 10 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getBreakStatementParserRuleCall_9()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleBreakStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getBreakStatementParserRuleCall_9()); 
                    }

                    }


                    }
                    break;
                case 11 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getReturnStatementParserRuleCall_10()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleReturnStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getReturnStatementParserRuleCall_10()); 
                    }

                    }


                    }
                    break;
                case 12 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getWithStatementParserRuleCall_11()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleWithStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getWithStatementParserRuleCall_11()); 
                    }

                    }


                    }
                    break;
                case 13 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getSwitchStatementParserRuleCall_12()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleSwitchStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getSwitchStatementParserRuleCall_12()); 
                    }

                    }


                    }
                    break;
                case 14 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getThrowStatementParserRuleCall_13()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleThrowStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getThrowStatementParserRuleCall_13()); 
                    }

                    }


                    }
                    break;
                case 15 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getTryStatementParserRuleCall_14()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleTryStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getTryStatementParserRuleCall_14()); 
                    }

                    }


                    }
                    break;
                case 16 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getDebuggerStatementParserRuleCall_15()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleDebuggerStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getDebuggerStatementParserRuleCall_15()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_RootStatement__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt38=16;
            alt38 = dfa38.predict(input);
            switch (alt38) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getBlockParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_Block();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getBlockParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getFunctionDeclarationParserRuleCall_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_FunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getFunctionDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getVariableStatementParserRuleCall_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_VariableStatement();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getVariableStatementParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getEmptyStatementParserRuleCall_3()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleEmptyStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getEmptyStatementParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getLabelledStatementParserRuleCall_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_LabelledStatement();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getLabelledStatementParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getExpressionStatementParserRuleCall_5()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_ExpressionStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getExpressionStatementParserRuleCall_5()); 
                    }

                    }


                    }
                    break;
                case 7 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getIfStatementParserRuleCall_6()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_IfStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getIfStatementParserRuleCall_6()); 
                    }

                    }


                    }
                    break;
                case 8 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getIterationStatementParserRuleCall_7()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_IterationStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getIterationStatementParserRuleCall_7()); 
                    }

                    }


                    }
                    break;
                case 9 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getContinueStatementParserRuleCall_8()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_ContinueStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getContinueStatementParserRuleCall_8()); 
                    }

                    }


                    }
                    break;
                case 10 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getBreakStatementParserRuleCall_9()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_BreakStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getBreakStatementParserRuleCall_9()); 
                    }

                    }


                    }
                    break;
                case 11 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getReturnStatementParserRuleCall_10()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_ReturnStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getReturnStatementParserRuleCall_10()); 
                    }

                    }


                    }
                    break;
                case 12 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getWithStatementParserRuleCall_11()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_WithStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getWithStatementParserRuleCall_11()); 
                    }

                    }


                    }
                    break;
                case 13 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getSwitchStatementParserRuleCall_12()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_SwitchStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getSwitchStatementParserRuleCall_12()); 
                    }

                    }


                    }
                    break;
                case 14 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getThrowStatementParserRuleCall_13()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_ThrowStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getThrowStatementParserRuleCall_13()); 
                    }

                    }


                    }
                    break;
                case 15 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getTryStatementParserRuleCall_14()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_TryStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getTryStatementParserRuleCall_14()); 
                    }

                    }


                    }
                    break;
                case 16 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRootStatementAccess().getDebuggerStatementParserRuleCall_15()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleDebuggerStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRootStatementAccess().getDebuggerStatementParserRuleCall_15()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__Statement__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt39=2;
            alt39 = dfa39.predict(input);
            switch (alt39) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getStatementAccess().getAnnotatedFunctionDeclarationParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleAnnotatedFunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getStatementAccess().getAnnotatedFunctionDeclarationParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getStatementAccess().getRootStatementParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleRootStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getStatementAccess().getRootStatementParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_Statement__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt40=2;
            alt40 = dfa40.predict(input);
            switch (alt40) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getStatementAccess().getAnnotatedFunctionDeclarationParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedFunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getStatementAccess().getAnnotatedFunctionDeclarationParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getStatementAccess().getRootStatementParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_RootStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getStatementAccess().getRootStatementParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__VariableDeclarationOrBinding__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt41=2;
            int LA41_0 = input.LA(1);

            if ( (LA41_0==LeftSquareBracket||LA41_0==LeftCurlyBracket) ) {
                alt41=1;
            }
            else if ( ((LA41_0>=Intersection && LA41_0<=Implements)||(LA41_0>=Promisify && LA41_0<=Abstract)||LA41_0==External||(LA41_0>=Private && LA41_0<=Project)||LA41_0==Public||LA41_0==Static||LA41_0==Target||(LA41_0>=Async && LA41_0<=Await)||LA41_0==Union||(LA41_0>=Yield && LA41_0<=This)||LA41_0==From||LA41_0==Type||(LA41_0>=Get && LA41_0<=Let)||(LA41_0>=Out && LA41_0<=Set)||LA41_0==As||LA41_0==Of||LA41_0==CommercialAt||LA41_0==RULE_IDENTIFIER) ) {
                alt41=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 41, 0, input);

                throw nvae;
            }
            switch (alt41) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleVariableBinding();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm4_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_VariableDeclarationOrBinding__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt42=2;
            int LA42_0 = input.LA(1);

            if ( (LA42_0==LeftSquareBracket||LA42_0==LeftCurlyBracket) ) {
                alt42=1;
            }
            else if ( ((LA42_0>=Intersection && LA42_0<=Implements)||(LA42_0>=Promisify && LA42_0<=Abstract)||LA42_0==External||(LA42_0>=Private && LA42_0<=Project)||LA42_0==Public||LA42_0==Static||LA42_0==Target||(LA42_0>=Async && LA42_0<=Await)||LA42_0==Union||(LA42_0>=Yield && LA42_0<=This)||LA42_0==From||LA42_0==Type||(LA42_0>=Get && LA42_0<=Let)||(LA42_0>=Out && LA42_0<=Set)||LA42_0==As||LA42_0==Of||LA42_0==CommercialAt||LA42_0==RULE_IDENTIFIER) ) {
                alt42=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 42, 0, input);

                throw nvae;
            }
            switch (alt42) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_VariableBinding();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm5_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_VariableDeclarationOrBinding__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt43=2;
            int LA43_0 = input.LA(1);

            if ( (LA43_0==LeftSquareBracket||LA43_0==LeftCurlyBracket) ) {
                alt43=1;
            }
            else if ( ((LA43_0>=Intersection && LA43_0<=Implements)||(LA43_0>=Promisify && LA43_0<=Abstract)||LA43_0==External||(LA43_0>=Private && LA43_0<=Project)||LA43_0==Public||LA43_0==Static||LA43_0==Target||(LA43_0>=Async && LA43_0<=Await)||LA43_0==Union||LA43_0==This||LA43_0==From||LA43_0==Type||(LA43_0>=Get && LA43_0<=Let)||(LA43_0>=Out && LA43_0<=Set)||LA43_0==As||LA43_0==Of||LA43_0==CommercialAt||LA43_0==RULE_IDENTIFIER) ) {
                alt43=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 43, 0, input);

                throw nvae;
            }
            switch (alt43) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm2_VariableBinding();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm6_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_VariableDeclarationOrBinding__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt44=2;
            int LA44_0 = input.LA(1);

            if ( (LA44_0==LeftSquareBracket||LA44_0==LeftCurlyBracket) ) {
                alt44=1;
            }
            else if ( ((LA44_0>=Intersection && LA44_0<=Implements)||(LA44_0>=Promisify && LA44_0<=Abstract)||LA44_0==External||(LA44_0>=Private && LA44_0<=Project)||LA44_0==Public||LA44_0==Static||LA44_0==Target||(LA44_0>=Async && LA44_0<=Await)||LA44_0==Union||LA44_0==This||LA44_0==From||LA44_0==Type||(LA44_0>=Get && LA44_0<=Let)||(LA44_0>=Out && LA44_0<=Set)||LA44_0==As||LA44_0==Of||LA44_0==CommercialAt||LA44_0==RULE_IDENTIFIER) ) {
                alt44=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 44, 0, input);

                throw nvae;
            }
            switch (alt44) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_VariableBinding();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm7_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm4_VariableDeclarationOrBinding__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt45=2;
            int LA45_0 = input.LA(1);

            if ( (LA45_0==LeftSquareBracket||LA45_0==LeftCurlyBracket) ) {
                alt45=1;
            }
            else if ( ((LA45_0>=Intersection && LA45_0<=Implements)||(LA45_0>=Promisify && LA45_0<=Abstract)||LA45_0==External||(LA45_0>=Private && LA45_0<=Project)||LA45_0==Public||LA45_0==Static||LA45_0==Target||(LA45_0>=Async && LA45_0<=Await)||LA45_0==Union||(LA45_0>=Yield && LA45_0<=This)||LA45_0==From||LA45_0==Type||(LA45_0>=Get && LA45_0<=Let)||(LA45_0>=Out && LA45_0<=Set)||LA45_0==As||LA45_0==Of||LA45_0==CommercialAt||LA45_0==RULE_IDENTIFIER) ) {
                alt45=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 45, 0, input);

                throw nvae;
            }
            switch (alt45) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm4_VariableBinding();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm4_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm6_VariableDeclarationOrBinding__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt46=2;
            int LA46_0 = input.LA(1);

            if ( (LA46_0==LeftSquareBracket||LA46_0==LeftCurlyBracket) ) {
                alt46=1;
            }
            else if ( ((LA46_0>=Intersection && LA46_0<=Implements)||(LA46_0>=Promisify && LA46_0<=Abstract)||LA46_0==External||(LA46_0>=Private && LA46_0<=Project)||LA46_0==Public||LA46_0==Static||LA46_0==Target||(LA46_0>=Async && LA46_0<=Await)||LA46_0==Union||LA46_0==This||LA46_0==From||LA46_0==Type||(LA46_0>=Get && LA46_0<=Let)||(LA46_0>=Out && LA46_0<=Set)||LA46_0==As||LA46_0==Of||LA46_0==CommercialAt||LA46_0==RULE_IDENTIFIER) ) {
                alt46=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 46, 0, input);

                throw nvae;
            }
            switch (alt46) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm6_VariableBinding();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm6_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ExportedVariableDeclarationOrBinding__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt47=2;
            int LA47_0 = input.LA(1);

            if ( (LA47_0==LeftSquareBracket||LA47_0==LeftCurlyBracket) ) {
                alt47=1;
            }
            else if ( ((LA47_0>=Intersection && LA47_0<=Implements)||(LA47_0>=Promisify && LA47_0<=Abstract)||LA47_0==External||(LA47_0>=Private && LA47_0<=Project)||LA47_0==Public||LA47_0==Static||LA47_0==Target||(LA47_0>=Async && LA47_0<=Await)||LA47_0==Union||(LA47_0>=Yield && LA47_0<=This)||LA47_0==From||LA47_0==Type||(LA47_0>=Get && LA47_0<=Let)||(LA47_0>=Out && LA47_0<=Set)||LA47_0==As||LA47_0==Of||LA47_0==CommercialAt||LA47_0==RULE_IDENTIFIER) ) {
                alt47=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 47, 0, input);

                throw nvae;
            }
            switch (alt47) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableBindingParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleExportedVariableBinding();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableDeclarationParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleExportedVariableDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ExportedVariableDeclarationOrBinding__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt48=2;
            int LA48_0 = input.LA(1);

            if ( (LA48_0==LeftSquareBracket||LA48_0==LeftCurlyBracket) ) {
                alt48=1;
            }
            else if ( ((LA48_0>=Intersection && LA48_0<=Implements)||(LA48_0>=Promisify && LA48_0<=Abstract)||LA48_0==External||(LA48_0>=Private && LA48_0<=Project)||LA48_0==Public||LA48_0==Static||LA48_0==Target||(LA48_0>=Async && LA48_0<=Await)||LA48_0==Union||LA48_0==This||LA48_0==From||LA48_0==Type||(LA48_0>=Get && LA48_0<=Let)||(LA48_0>=Out && LA48_0<=Set)||LA48_0==As||LA48_0==Of||LA48_0==CommercialAt||LA48_0==RULE_IDENTIFIER) ) {
                alt48=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 48, 0, input);

                throw nvae;
            }
            switch (alt48) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableBindingParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ExportedVariableBinding();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableDeclarationParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_ExportedVariableDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__IterationStatement__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt49=3;
            switch ( input.LA(1) ) {
            case Do:
                {
                alt49=1;
                }
                break;
            case While:
                {
                alt49=2;
                }
                break;
            case For:
                {
                alt49=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 49, 0, input);

                throw nvae;
            }

            switch (alt49) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIterationStatementAccess().getDoStatementParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleDoStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIterationStatementAccess().getDoStatementParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIterationStatementAccess().getWhileStatementParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleWhileStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIterationStatementAccess().getWhileStatementParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIterationStatementAccess().getForStatementParserRuleCall_2()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleForStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIterationStatementAccess().getForStatementParserRuleCall_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_IterationStatement__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt50=3;
            switch ( input.LA(1) ) {
            case Do:
                {
                alt50=1;
                }
                break;
            case While:
                {
                alt50=2;
                }
                break;
            case For:
                {
                alt50=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 50, 0, input);

                throw nvae;
            }

            switch (alt50) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIterationStatementAccess().getDoStatementParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_DoStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIterationStatementAccess().getDoStatementParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIterationStatementAccess().getWhileStatementParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_WhileStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIterationStatementAccess().getWhileStatementParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIterationStatementAccess().getForStatementParserRuleCall_2()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIterationStatementAccess().getForStatementParserRuleCall_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ForStatement__Alternatives_3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt51=2;
            alt51 = dfa51.predict(input);
            switch (alt51) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ForStatement__Alternatives_3_1_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt52=3;
            alt52 = dfa52.predict(input);
            switch (alt52) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_1_0_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_1_0_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_1_0_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ForStatement__Alternatives_3_1_0_0_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt53=2;
            alt53 = dfa53.predict(input);
            switch (alt53) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_1_0_0_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_1_0_0_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ForStatement__Alternatives_3_1_0_0_1_0_0_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt54=2;
            int LA54_0 = input.LA(1);

            if ( (LA54_0==In) ) {
                alt54=1;
            }
            else if ( (LA54_0==Of) ) {
                alt54=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 54, 0, input);

                throw nvae;
            }
            switch (alt54) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_0_0_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__ForInAssignment_3_1_0_0_1_0_0_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_0_0_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_0_0_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__ForOfAssignment_3_1_0_0_1_0_0_1_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_0_0_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ForStatement__Alternatives_3_1_0_0_1_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt55=3;
            switch ( input.LA(1) ) {
            case Comma:
            case Semicolon:
                {
                alt55=1;
                }
                break;
            case In:
                {
                alt55=2;
                }
                break;
            case Of:
                {
                alt55=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 55, 0, input);

                throw nvae;
            }

            switch (alt55) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_1_0_0_1_1_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_1_0_0_1_1_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_1_0_0_1_1_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ForStatement__Alternatives_3_1_0_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt56=3;
            switch ( input.LA(1) ) {
            case Semicolon:
                {
                alt56=1;
                }
                break;
            case In:
                {
                alt56=2;
                }
                break;
            case Of:
                {
                alt56=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 56, 0, input);

                throw nvae;
            }

            switch (alt56) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_1_0_1_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_1_0_1_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ForStatement__Group_3_1_0_1_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ForStatement__Alternatives_3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt57=2;
            alt57 = dfa57.predict(input);
            switch (alt57) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ForStatement__Alternatives_3_1_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt58=3;
            alt58 = dfa58.predict(input);
            switch (alt58) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_1_0_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_1_0_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_1_0_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ForStatement__Alternatives_3_1_0_0_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt59=2;
            alt59 = dfa59.predict(input);
            switch (alt59) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_1_0_0_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_1_0_0_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ForStatement__Alternatives_3_1_0_0_1_0_0_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt60=2;
            int LA60_0 = input.LA(1);

            if ( (LA60_0==In) ) {
                alt60=1;
            }
            else if ( (LA60_0==Of) ) {
                alt60=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 60, 0, input);

                throw nvae;
            }
            switch (alt60) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_0_0_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__ForInAssignment_3_1_0_0_1_0_0_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_0_0_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_0_0_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__ForOfAssignment_3_1_0_0_1_0_0_1_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_0_0_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ForStatement__Alternatives_3_1_0_0_1_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt61=3;
            switch ( input.LA(1) ) {
            case Comma:
            case Semicolon:
                {
                alt61=1;
                }
                break;
            case In:
                {
                alt61=2;
                }
                break;
            case Of:
                {
                alt61=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 61, 0, input);

                throw nvae;
            }

            switch (alt61) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_1_0_0_1_1_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_1_0_0_1_1_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_1_0_0_1_1_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ForStatement__Alternatives_3_1_0_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt62=3;
            switch ( input.LA(1) ) {
            case Semicolon:
                {
                alt62=1;
                }
                break;
            case In:
                {
                alt62=2;
                }
                break;
            case Of:
                {
                alt62=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 62, 0, input);

                throw nvae;
            }

            switch (alt62) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_1_0_1_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_1_0_1_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ForStatement__Group_3_1_0_1_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__TryStatement__Alternatives_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt63=2;
            int LA63_0 = input.LA(1);

            if ( (LA63_0==Catch) ) {
                alt63=1;
            }
            else if ( (LA63_0==Finally) ) {
                alt63=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 63, 0, input);

                throw nvae;
            }
            switch (alt63) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTryStatementAccess().getGroup_2_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__TryStatement__Group_2_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTryStatementAccess().getGroup_2_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__TryStatement__FinallyAssignment_2_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_TryStatement__Alternatives_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt64=2;
            int LA64_0 = input.LA(1);

            if ( (LA64_0==Catch) ) {
                alt64=1;
            }
            else if ( (LA64_0==Finally) ) {
                alt64=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 64, 0, input);

                throw nvae;
            }
            switch (alt64) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTryStatementAccess().getGroup_2_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_TryStatement__Group_2_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTryStatementAccess().getGroup_2_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_TryStatement__FinallyAssignment_2_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__CatchVariable__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt65=3;
            alt65 = dfa65.predict(input);
            switch (alt65) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getCatchVariableAccess().getBindingPatternAssignment_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__CatchVariable__BindingPatternAssignment_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getCatchVariableAccess().getBindingPatternAssignment_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getCatchVariableAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__CatchVariable__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getCatchVariableAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getCatchVariableAccess().getGroup_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__CatchVariable__Group_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getCatchVariableAccess().getGroup_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_CatchVariable__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt66=3;
            alt66 = dfa66.predict(input);
            switch (alt66) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getCatchVariableAccess().getBindingPatternAssignment_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_CatchVariable__BindingPatternAssignment_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getCatchVariableAccess().getBindingPatternAssignment_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getCatchVariableAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_CatchVariable__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getCatchVariableAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getCatchVariableAccess().getGroup_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_CatchVariable__Group_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getCatchVariableAccess().getGroup_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__PrimaryExpression__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt67=15;
            alt67 = dfa67.predict(input);
            switch (alt67) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getThisLiteralParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleThisLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getThisLiteralParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getSuperLiteralParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleSuperLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getSuperLiteralParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getIdentifierRefParserRuleCall_2()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleIdentifierRef();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getIdentifierRefParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getJSXFragmentParserRuleCall_3()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleJSXFragment();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getJSXFragmentParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getJSXElementParserRuleCall_4()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleJSXElement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getJSXElementParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getParameterizedCallExpressionParserRuleCall_5()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleParameterizedCallExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getParameterizedCallExpressionParserRuleCall_5()); 
                    }

                    }


                    }
                    break;
                case 7 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getLiteralParserRuleCall_6()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getLiteralParserRuleCall_6()); 
                    }

                    }


                    }
                    break;
                case 8 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getArrayLiteralParserRuleCall_7()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleArrayLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getArrayLiteralParserRuleCall_7()); 
                    }

                    }


                    }
                    break;
                case 9 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getObjectLiteralParserRuleCall_8()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleObjectLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getObjectLiteralParserRuleCall_8()); 
                    }

                    }


                    }
                    break;
                case 10 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getParenExpressionParserRuleCall_9()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleParenExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getParenExpressionParserRuleCall_9()); 
                    }

                    }


                    }
                    break;
                case 11 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getAnnotatedExpressionParserRuleCall_10()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleAnnotatedExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getAnnotatedExpressionParserRuleCall_10()); 
                    }

                    }


                    }
                    break;
                case 12 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getFunctionExpressionParserRuleCall_11()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleFunctionExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getFunctionExpressionParserRuleCall_11()); 
                    }

                    }


                    }
                    break;
                case 13 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getAsyncFunctionExpressionParserRuleCall_12()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleAsyncFunctionExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getAsyncFunctionExpressionParserRuleCall_12()); 
                    }

                    }


                    }
                    break;
                case 14 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getN4ClassExpressionParserRuleCall_13()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleN4ClassExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getN4ClassExpressionParserRuleCall_13()); 
                    }

                    }


                    }
                    break;
                case 15 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getTemplateLiteralParserRuleCall_14()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleTemplateLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getTemplateLiteralParserRuleCall_14()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_PrimaryExpression__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt68=15;
            alt68 = dfa68.predict(input);
            switch (alt68) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getThisLiteralParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleThisLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getThisLiteralParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getSuperLiteralParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleSuperLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getSuperLiteralParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getIdentifierRefParserRuleCall_2()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_IdentifierRef();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getIdentifierRefParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getJSXFragmentParserRuleCall_3()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleJSXFragment();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getJSXFragmentParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getJSXElementParserRuleCall_4()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleJSXElement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getJSXElementParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getParameterizedCallExpressionParserRuleCall_5()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_ParameterizedCallExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getParameterizedCallExpressionParserRuleCall_5()); 
                    }

                    }


                    }
                    break;
                case 7 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getLiteralParserRuleCall_6()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getLiteralParserRuleCall_6()); 
                    }

                    }


                    }
                    break;
                case 8 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getArrayLiteralParserRuleCall_7()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_ArrayLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getArrayLiteralParserRuleCall_7()); 
                    }

                    }


                    }
                    break;
                case 9 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getObjectLiteralParserRuleCall_8()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_ObjectLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getObjectLiteralParserRuleCall_8()); 
                    }

                    }


                    }
                    break;
                case 10 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getParenExpressionParserRuleCall_9()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_ParenExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getParenExpressionParserRuleCall_9()); 
                    }

                    }


                    }
                    break;
                case 11 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getAnnotatedExpressionParserRuleCall_10()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getAnnotatedExpressionParserRuleCall_10()); 
                    }

                    }


                    }
                    break;
                case 12 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getFunctionExpressionParserRuleCall_11()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleFunctionExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getFunctionExpressionParserRuleCall_11()); 
                    }

                    }


                    }
                    break;
                case 13 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getAsyncFunctionExpressionParserRuleCall_12()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleAsyncFunctionExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getAsyncFunctionExpressionParserRuleCall_12()); 
                    }

                    }


                    }
                    break;
                case 14 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getN4ClassExpressionParserRuleCall_13()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_N4ClassExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getN4ClassExpressionParserRuleCall_13()); 
                    }

                    }


                    }
                    break;
                case 15 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryExpressionAccess().getTemplateLiteralParserRuleCall_14()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_TemplateLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryExpressionAccess().getTemplateLiteralParserRuleCall_14()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__IdentifierRef__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt69=2;
            alt69 = dfa69.predict(input);
            switch (alt69) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIdentifierRefAccess().getIdAssignment_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__IdentifierRef__IdAssignment_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIdentifierRefAccess().getIdAssignment_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIdentifierRefAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__IdentifierRef__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIdentifierRefAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_IdentifierRef__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt70=2;
            alt70 = dfa70.predict(input);
            switch (alt70) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIdentifierRefAccess().getIdAssignment_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_IdentifierRef__IdAssignment_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIdentifierRefAccess().getIdAssignment_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIdentifierRefAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_IdentifierRef__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIdentifierRefAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__PropertyAssignment__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt71=6;
            alt71 = dfa71.predict(input);
            switch (alt71) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyAssignmentAccess().getAnnotatedPropertyAssignmentParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleAnnotatedPropertyAssignment();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyAssignmentAccess().getAnnotatedPropertyAssignmentParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairParserRuleCall_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rulePropertyNameValuePair();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyAssignmentAccess().getPropertyGetterDeclarationParserRuleCall_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rulePropertyGetterDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyAssignmentAccess().getPropertyGetterDeclarationParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyAssignmentAccess().getPropertySetterDeclarationParserRuleCall_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rulePropertySetterDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyAssignmentAccess().getPropertySetterDeclarationParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyAssignmentAccess().getPropertyMethodDeclarationParserRuleCall_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rulePropertyMethodDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyAssignmentAccess().getPropertyMethodDeclarationParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairSingleNameParserRuleCall_5()); 
                    }
                    pushFollow(FOLLOW_2);
                    rulePropertyNameValuePairSingleName();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairSingleNameParserRuleCall_5()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_PropertyAssignment__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt72=6;
            alt72 = dfa72.predict(input);
            switch (alt72) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyAssignmentAccess().getAnnotatedPropertyAssignmentParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedPropertyAssignment();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyAssignmentAccess().getAnnotatedPropertyAssignmentParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairParserRuleCall_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_PropertyNameValuePair();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyAssignmentAccess().getPropertyGetterDeclarationParserRuleCall_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_PropertyGetterDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyAssignmentAccess().getPropertyGetterDeclarationParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyAssignmentAccess().getPropertySetterDeclarationParserRuleCall_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_PropertySetterDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyAssignmentAccess().getPropertySetterDeclarationParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyAssignmentAccess().getPropertyMethodDeclarationParserRuleCall_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_PropertyMethodDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyAssignmentAccess().getPropertyMethodDeclarationParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairSingleNameParserRuleCall_5()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_PropertyNameValuePairSingleName();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairSingleNameParserRuleCall_5()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AnnotatedPropertyAssignment__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt73=5;
            alt73 = dfa73.predict(input);
            switch (alt73) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedPropertyAssignment__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedPropertyAssignment__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedPropertyAssignment__Group_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedPropertyAssignment__Group_1_3__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedPropertyAssignment__Group_1_4__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AnnotatedPropertyAssignment__Alternatives_1_3_0_0_3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt74=2;
            int LA74_0 = input.LA(1);

            if ( (LA74_0==Asterisk) ) {
                alt74=1;
            }
            else if ( ((LA74_0>=Intersection && LA74_0<=With)||(LA74_0>=For && LA74_0<=Var)||(LA74_0>=As && LA74_0<=Of)||LA74_0==LeftSquareBracket||LA74_0==RULE_DOUBLE||LA74_0==RULE_HEX_INT||LA74_0==RULE_OCTAL_INT||LA74_0==RULE_SCIENTIFIC_INT||LA74_0==RULE_IDENTIFIER||LA74_0==RULE_STRING||LA74_0==RULE_INT) ) {
                alt74=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 74, 0, input);

                throw nvae;
            }
            switch (alt74) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AnnotatedPropertyAssignment__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt75=5;
            alt75 = dfa75.predict(input);
            switch (alt75) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedPropertyAssignment__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedPropertyAssignment__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedPropertyAssignment__Group_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedPropertyAssignment__Group_1_3__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedPropertyAssignment__Group_1_4__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AnnotatedPropertyAssignment__Alternatives_1_3_0_0_3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt76=2;
            int LA76_0 = input.LA(1);

            if ( (LA76_0==Asterisk) ) {
                alt76=1;
            }
            else if ( ((LA76_0>=Intersection && LA76_0<=With)||(LA76_0>=For && LA76_0<=Var)||(LA76_0>=As && LA76_0<=Of)||LA76_0==LeftSquareBracket||LA76_0==RULE_DOUBLE||LA76_0==RULE_HEX_INT||LA76_0==RULE_OCTAL_INT||LA76_0==RULE_SCIENTIFIC_INT||LA76_0==RULE_IDENTIFIER||LA76_0==RULE_STRING||LA76_0==RULE_INT) ) {
                alt76=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 76, 0, input);

                throw nvae;
            }
            switch (alt76) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__PropertyMethodDeclaration__Alternatives_0_0_3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt77=2;
            int LA77_0 = input.LA(1);

            if ( (LA77_0==Asterisk) ) {
                alt77=1;
            }
            else if ( ((LA77_0>=Intersection && LA77_0<=With)||(LA77_0>=For && LA77_0<=Var)||(LA77_0>=As && LA77_0<=Of)||LA77_0==LeftSquareBracket||LA77_0==RULE_DOUBLE||LA77_0==RULE_HEX_INT||LA77_0==RULE_OCTAL_INT||LA77_0==RULE_SCIENTIFIC_INT||LA77_0==RULE_IDENTIFIER||LA77_0==RULE_STRING||LA77_0==RULE_INT) ) {
                alt77=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 77, 0, input);

                throw nvae;
            }
            switch (alt77) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__PropertyMethodDeclaration__Group_0_0_3_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__PropertyMethodDeclaration__Group_0_0_3_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_PropertyMethodDeclaration__Alternatives_0_0_3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt78=2;
            int LA78_0 = input.LA(1);

            if ( (LA78_0==Asterisk) ) {
                alt78=1;
            }
            else if ( ((LA78_0>=Intersection && LA78_0<=With)||(LA78_0>=For && LA78_0<=Var)||(LA78_0>=As && LA78_0<=Of)||LA78_0==LeftSquareBracket||LA78_0==RULE_DOUBLE||LA78_0==RULE_HEX_INT||LA78_0==RULE_OCTAL_INT||LA78_0==RULE_SCIENTIFIC_INT||LA78_0==RULE_IDENTIFIER||LA78_0==RULE_STRING||LA78_0==RULE_INT) ) {
                alt78=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 78, 0, input);

                throw nvae;
            }
            switch (alt78) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_PropertyMethodDeclaration__Group_0_0_3_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_PropertyMethodDeclaration__Group_0_0_3_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__LeftHandSideExpression__Alternatives_1_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt79=4;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt79=1;
                }
                break;
            case LeftSquareBracket:
                {
                alt79=2;
                }
                break;
            case FullStop:
                {
                alt79=3;
                }
                break;
            case RULE_TEMPLATE_HEAD:
            case RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL:
                {
                alt79=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 79, 0, input);

                throw nvae;
            }

            switch (alt79) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__LeftHandSideExpression__Group_1_2_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__LeftHandSideExpression__Group_1_2_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__LeftHandSideExpression__Group_1_2_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__LeftHandSideExpression__Group_1_2_3__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_LeftHandSideExpression__Alternatives_1_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt80=4;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt80=1;
                }
                break;
            case LeftSquareBracket:
                {
                alt80=2;
                }
                break;
            case FullStop:
                {
                alt80=3;
                }
                break;
            case RULE_TEMPLATE_HEAD:
            case RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL:
                {
                alt80=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 80, 0, input);

                throw nvae;
            }

            switch (alt80) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_LeftHandSideExpression__Group_1_2_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_LeftHandSideExpression__Group_1_2_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_LeftHandSideExpression__Group_1_2_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_LeftHandSideExpression__Group_1_2_3__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__MemberExpression__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt81=3;
            int LA81_0 = input.LA(1);

            if ( (LA81_0==New) ) {
                int LA81_1 = input.LA(2);

                if ( (LA81_1==FullStop) ) {
                    alt81=1;
                }
                else if ( ((LA81_1>=Intersection && LA81_1<=Implements)||(LA81_1>=Promisify && LA81_1<=Abstract)||(LA81_1>=External && LA81_1<=Function)||(LA81_1>=Private && LA81_1<=Project)||LA81_1==Public||LA81_1==Static||LA81_1==Target||(LA81_1>=Async && LA81_1<=Await)||LA81_1==Class||(LA81_1>=False && LA81_1<=Super)||LA81_1==Union||(LA81_1>=Yield && LA81_1<=This)||(LA81_1>=From && LA81_1<=Type)||(LA81_1>=Get && LA81_1<=Set)||LA81_1==SolidusEqualsSign||LA81_1==As||LA81_1==Of||LA81_1==LeftParenthesis||LA81_1==Solidus||LA81_1==LessThanSign||(LA81_1>=CommercialAt && LA81_1<=LeftSquareBracket)||LA81_1==LeftCurlyBracket||LA81_1==RULE_DOUBLE||(LA81_1>=RULE_HEX_INT && LA81_1<=RULE_LEGACY_OCTAL_INT)||LA81_1==RULE_SCIENTIFIC_INT||LA81_1==RULE_IDENTIFIER||LA81_1==RULE_STRING||(LA81_1>=RULE_TEMPLATE_HEAD && LA81_1<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA81_1==RULE_INT) ) {
                    alt81=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 81, 1, input);

                    throw nvae;
                }
            }
            else if ( ((LA81_0>=Intersection && LA81_0<=Implements)||(LA81_0>=Promisify && LA81_0<=Abstract)||(LA81_0>=External && LA81_0<=Function)||(LA81_0>=Private && LA81_0<=Project)||LA81_0==Public||LA81_0==Static||LA81_0==Target||(LA81_0>=Async && LA81_0<=Await)||LA81_0==Class||(LA81_0>=False && LA81_0<=Super)||LA81_0==Union||(LA81_0>=Yield && LA81_0<=This)||(LA81_0>=From && LA81_0<=Type)||(LA81_0>=Get && LA81_0<=Let)||(LA81_0>=Out && LA81_0<=Set)||LA81_0==SolidusEqualsSign||LA81_0==As||LA81_0==Of||LA81_0==LeftParenthesis||LA81_0==Solidus||LA81_0==LessThanSign||(LA81_0>=CommercialAt && LA81_0<=LeftSquareBracket)||LA81_0==LeftCurlyBracket||LA81_0==RULE_DOUBLE||(LA81_0>=RULE_HEX_INT && LA81_0<=RULE_LEGACY_OCTAL_INT)||LA81_0==RULE_SCIENTIFIC_INT||LA81_0==RULE_IDENTIFIER||LA81_0==RULE_STRING||(LA81_0>=RULE_TEMPLATE_HEAD && LA81_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA81_0==RULE_INT) ) {
                alt81=3;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 81, 0, input);

                throw nvae;
            }
            switch (alt81) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__MemberExpression__Group_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__MemberExpression__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__MemberExpression__Group_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__MemberExpression__Alternatives_1_3_3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt82=3;
            switch ( input.LA(1) ) {
            case LeftSquareBracket:
                {
                alt82=1;
                }
                break;
            case FullStop:
                {
                alt82=2;
                }
                break;
            case RULE_TEMPLATE_HEAD:
            case RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL:
                {
                alt82=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 82, 0, input);

                throw nvae;
            }

            switch (alt82) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__MemberExpression__Group_1_3_3_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__MemberExpression__Group_1_3_3_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__MemberExpression__Group_1_3_3_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__MemberExpression__Alternatives_2_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt83=3;
            switch ( input.LA(1) ) {
            case LeftSquareBracket:
                {
                alt83=1;
                }
                break;
            case FullStop:
                {
                alt83=2;
                }
                break;
            case RULE_TEMPLATE_HEAD:
            case RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL:
                {
                alt83=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 83, 0, input);

                throw nvae;
            }

            switch (alt83) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_2_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__MemberExpression__Group_2_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_2_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_2_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__MemberExpression__Group_2_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_2_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_2_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__MemberExpression__Group_2_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_2_1_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_MemberExpression__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt84=3;
            int LA84_0 = input.LA(1);

            if ( (LA84_0==New) ) {
                int LA84_1 = input.LA(2);

                if ( ((LA84_1>=Intersection && LA84_1<=Implements)||(LA84_1>=Promisify && LA84_1<=Abstract)||(LA84_1>=External && LA84_1<=Function)||(LA84_1>=Private && LA84_1<=Project)||LA84_1==Public||LA84_1==Static||LA84_1==Target||(LA84_1>=Async && LA84_1<=Await)||LA84_1==Class||(LA84_1>=False && LA84_1<=Super)||LA84_1==Union||LA84_1==This||(LA84_1>=From && LA84_1<=Type)||(LA84_1>=Get && LA84_1<=Set)||LA84_1==SolidusEqualsSign||LA84_1==As||LA84_1==Of||LA84_1==LeftParenthesis||LA84_1==Solidus||LA84_1==LessThanSign||(LA84_1>=CommercialAt && LA84_1<=LeftSquareBracket)||LA84_1==LeftCurlyBracket||LA84_1==RULE_DOUBLE||(LA84_1>=RULE_HEX_INT && LA84_1<=RULE_LEGACY_OCTAL_INT)||LA84_1==RULE_SCIENTIFIC_INT||LA84_1==RULE_IDENTIFIER||LA84_1==RULE_STRING||(LA84_1>=RULE_TEMPLATE_HEAD && LA84_1<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA84_1==RULE_INT) ) {
                    alt84=2;
                }
                else if ( (LA84_1==FullStop) ) {
                    alt84=1;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 84, 1, input);

                    throw nvae;
                }
            }
            else if ( ((LA84_0>=Intersection && LA84_0<=Implements)||(LA84_0>=Promisify && LA84_0<=Abstract)||(LA84_0>=External && LA84_0<=Function)||(LA84_0>=Private && LA84_0<=Project)||LA84_0==Public||LA84_0==Static||LA84_0==Target||(LA84_0>=Async && LA84_0<=Await)||LA84_0==Class||(LA84_0>=False && LA84_0<=Super)||LA84_0==Union||LA84_0==This||(LA84_0>=From && LA84_0<=Type)||(LA84_0>=Get && LA84_0<=Let)||(LA84_0>=Out && LA84_0<=Set)||LA84_0==SolidusEqualsSign||LA84_0==As||LA84_0==Of||LA84_0==LeftParenthesis||LA84_0==Solidus||LA84_0==LessThanSign||(LA84_0>=CommercialAt && LA84_0<=LeftSquareBracket)||LA84_0==LeftCurlyBracket||LA84_0==RULE_DOUBLE||(LA84_0>=RULE_HEX_INT && LA84_0<=RULE_LEGACY_OCTAL_INT)||LA84_0==RULE_SCIENTIFIC_INT||LA84_0==RULE_IDENTIFIER||LA84_0==RULE_STRING||(LA84_0>=RULE_TEMPLATE_HEAD && LA84_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA84_0==RULE_INT) ) {
                alt84=3;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 84, 0, input);

                throw nvae;
            }
            switch (alt84) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_MemberExpression__Group_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_MemberExpression__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_MemberExpression__Group_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_MemberExpression__Alternatives_1_3_3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt85=3;
            switch ( input.LA(1) ) {
            case LeftSquareBracket:
                {
                alt85=1;
                }
                break;
            case FullStop:
                {
                alt85=2;
                }
                break;
            case RULE_TEMPLATE_HEAD:
            case RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL:
                {
                alt85=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 85, 0, input);

                throw nvae;
            }

            switch (alt85) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_MemberExpression__Group_1_3_3_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_MemberExpression__Group_1_3_3_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_MemberExpression__Group_1_3_3_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_MemberExpression__Alternatives_2_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt86=3;
            switch ( input.LA(1) ) {
            case LeftSquareBracket:
                {
                alt86=1;
                }
                break;
            case FullStop:
                {
                alt86=2;
                }
                break;
            case RULE_TEMPLATE_HEAD:
            case RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL:
                {
                alt86=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 86, 0, input);

                throw nvae;
            }

            switch (alt86) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_2_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_MemberExpression__Group_2_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_2_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_2_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_MemberExpression__Group_2_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_2_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getMemberExpressionAccess().getGroup_2_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_MemberExpression__Group_2_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getMemberExpressionAccess().getGroup_2_1_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__UnaryExpression__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt87=2;
            int LA87_0 = input.LA(1);

            if ( ((LA87_0>=Intersection && LA87_0<=Implements)||(LA87_0>=Promisify && LA87_0<=Abstract)||(LA87_0>=External && LA87_0<=Function)||(LA87_0>=Private && LA87_0<=Project)||LA87_0==Public||LA87_0==Static||LA87_0==Target||(LA87_0>=Async && LA87_0<=Await)||LA87_0==Class||(LA87_0>=False && LA87_0<=Super)||LA87_0==Union||(LA87_0>=Yield && LA87_0<=This)||(LA87_0>=From && LA87_0<=Type)||(LA87_0>=Get && LA87_0<=Set)||LA87_0==SolidusEqualsSign||LA87_0==As||LA87_0==Of||LA87_0==LeftParenthesis||LA87_0==Solidus||LA87_0==LessThanSign||(LA87_0>=CommercialAt && LA87_0<=LeftSquareBracket)||LA87_0==LeftCurlyBracket||LA87_0==RULE_DOUBLE||(LA87_0>=RULE_HEX_INT && LA87_0<=RULE_LEGACY_OCTAL_INT)||LA87_0==RULE_SCIENTIFIC_INT||LA87_0==RULE_IDENTIFIER||LA87_0==RULE_STRING||(LA87_0>=RULE_TEMPLATE_HEAD && LA87_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA87_0==RULE_INT) ) {
                alt87=1;
            }
            else if ( (LA87_0==Delete||LA87_0==Typeof||LA87_0==Void||LA87_0==PlusSignPlusSign||LA87_0==HyphenMinusHyphenMinus||LA87_0==ExclamationMark||LA87_0==PlusSign||LA87_0==HyphenMinus||LA87_0==Tilde) ) {
                alt87=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 87, 0, input);

                throw nvae;
            }
            switch (alt87) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getUnaryExpressionAccess().getCastExpressionParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleCastExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getUnaryExpressionAccess().getCastExpressionParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getUnaryExpressionAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__UnaryExpression__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getUnaryExpressionAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_UnaryExpression__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt88=2;
            int LA88_0 = input.LA(1);

            if ( ((LA88_0>=Intersection && LA88_0<=Implements)||(LA88_0>=Promisify && LA88_0<=Abstract)||(LA88_0>=External && LA88_0<=Function)||(LA88_0>=Private && LA88_0<=Project)||LA88_0==Public||LA88_0==Static||LA88_0==Target||(LA88_0>=Async && LA88_0<=Await)||LA88_0==Class||(LA88_0>=False && LA88_0<=Super)||LA88_0==Union||LA88_0==This||(LA88_0>=From && LA88_0<=Type)||(LA88_0>=Get && LA88_0<=Set)||LA88_0==SolidusEqualsSign||LA88_0==As||LA88_0==Of||LA88_0==LeftParenthesis||LA88_0==Solidus||LA88_0==LessThanSign||(LA88_0>=CommercialAt && LA88_0<=LeftSquareBracket)||LA88_0==LeftCurlyBracket||LA88_0==RULE_DOUBLE||(LA88_0>=RULE_HEX_INT && LA88_0<=RULE_LEGACY_OCTAL_INT)||LA88_0==RULE_SCIENTIFIC_INT||LA88_0==RULE_IDENTIFIER||LA88_0==RULE_STRING||(LA88_0>=RULE_TEMPLATE_HEAD && LA88_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA88_0==RULE_INT) ) {
                alt88=1;
            }
            else if ( (LA88_0==Delete||LA88_0==Typeof||LA88_0==Void||LA88_0==PlusSignPlusSign||LA88_0==HyphenMinusHyphenMinus||LA88_0==ExclamationMark||LA88_0==PlusSign||LA88_0==HyphenMinus||LA88_0==Tilde) ) {
                alt88=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 88, 0, input);

                throw nvae;
            }
            switch (alt88) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getUnaryExpressionAccess().getCastExpressionParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_CastExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getUnaryExpressionAccess().getCastExpressionParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getUnaryExpressionAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_UnaryExpression__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getUnaryExpressionAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ShiftOperator__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt89=2;
            int LA89_0 = input.LA(1);

            if ( (LA89_0==GreaterThanSign) ) {
                alt89=1;
            }
            else if ( (LA89_0==LessThanSignLessThanSign) ) {
                alt89=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 89, 0, input);

                throw nvae;
            }
            switch (alt89) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getShiftOperatorAccess().getGroup_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ShiftOperator__Group_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getShiftOperatorAccess().getGroup_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getShiftOperatorAccess().getLessThanSignLessThanSignKeyword_1()); 
                    }
                    match(input,LessThanSignLessThanSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getShiftOperatorAccess().getLessThanSignLessThanSignKeyword_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__RelationalOperator__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt90=4;
            switch ( input.LA(1) ) {
            case LessThanSign:
                {
                alt90=1;
                }
                break;
            case GreaterThanSign:
                {
                alt90=2;
                }
                break;
            case LessThanSignEqualsSign:
                {
                alt90=3;
                }
                break;
            case Instanceof:
                {
                alt90=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 90, 0, input);

                throw nvae;
            }

            switch (alt90) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRelationalOperatorAccess().getLessThanSignKeyword_0()); 
                    }
                    match(input,LessThanSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRelationalOperatorAccess().getLessThanSignKeyword_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRelationalOperatorAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__RelationalOperator__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRelationalOperatorAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRelationalOperatorAccess().getLessThanSignEqualsSignKeyword_2()); 
                    }
                    match(input,LessThanSignEqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRelationalOperatorAccess().getLessThanSignEqualsSignKeyword_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRelationalOperatorAccess().getInstanceofKeyword_3()); 
                    }
                    match(input,Instanceof,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRelationalOperatorAccess().getInstanceofKeyword_3()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_RelationalOperator__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt91=5;
            switch ( input.LA(1) ) {
            case LessThanSign:
                {
                alt91=1;
                }
                break;
            case GreaterThanSign:
                {
                alt91=2;
                }
                break;
            case LessThanSignEqualsSign:
                {
                alt91=3;
                }
                break;
            case Instanceof:
                {
                alt91=4;
                }
                break;
            case In:
                {
                alt91=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 91, 0, input);

                throw nvae;
            }

            switch (alt91) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRelationalOperatorAccess().getLessThanSignKeyword_0()); 
                    }
                    match(input,LessThanSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRelationalOperatorAccess().getLessThanSignKeyword_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRelationalOperatorAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_RelationalOperator__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRelationalOperatorAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRelationalOperatorAccess().getLessThanSignEqualsSignKeyword_2()); 
                    }
                    match(input,LessThanSignEqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRelationalOperatorAccess().getLessThanSignEqualsSignKeyword_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRelationalOperatorAccess().getInstanceofKeyword_3()); 
                    }
                    match(input,Instanceof,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRelationalOperatorAccess().getInstanceofKeyword_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getRelationalOperatorAccess().getInKeyword_4_0()); 
                    }
                    match(input,In,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getRelationalOperatorAccess().getInKeyword_4_0()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AssignmentExpression__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt92=4;
            alt92 = dfa92.predict(input);
            switch (alt92) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleAwaitExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rulePromisifyExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleArrowExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AssignmentExpression__Group_4__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AssignmentExpression__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt93=4;
            alt93 = dfa93.predict(input);
            switch (alt93) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AwaitExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_PromisifyExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ArrowExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AssignmentExpression__Group_4__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm2_AssignmentExpression__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt94=5;
            alt94 = dfa94.predict(input);
            switch (alt94) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm2_AwaitExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm2_PromisifyExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm2_ArrowExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getYieldExpressionParserRuleCall_3_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleYieldExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getYieldExpressionParserRuleCall_3_0()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm2_AssignmentExpression__Group_4__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm3_AssignmentExpression__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt95=5;
            alt95 = dfa95.predict(input);
            switch (alt95) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_AwaitExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getAwaitExpressionParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_PromisifyExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getPromisifyExpressionParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_ArrowExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getArrowExpressionParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getYieldExpressionParserRuleCall_3_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_YieldExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getYieldExpressionParserRuleCall_3_0()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm3_AssignmentExpression__Group_4__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentExpressionAccess().getGroup_4()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AssignmentOperator__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt96=11;
            switch ( input.LA(1) ) {
            case EqualsSign:
                {
                alt96=1;
                }
                break;
            case AsteriskEqualsSign:
                {
                alt96=2;
                }
                break;
            case SolidusEqualsSign:
                {
                alt96=3;
                }
                break;
            case PercentSignEqualsSign:
                {
                alt96=4;
                }
                break;
            case PlusSignEqualsSign:
                {
                alt96=5;
                }
                break;
            case HyphenMinusEqualsSign:
                {
                alt96=6;
                }
                break;
            case LessThanSignLessThanSignEqualsSign:
                {
                alt96=7;
                }
                break;
            case GreaterThanSign:
                {
                alt96=8;
                }
                break;
            case AmpersandEqualsSign:
                {
                alt96=9;
                }
                break;
            case CircumflexAccentEqualsSign:
                {
                alt96=10;
                }
                break;
            case VerticalLineEqualsSign:
                {
                alt96=11;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 96, 0, input);

                throw nvae;
            }

            switch (alt96) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentOperatorAccess().getEqualsSignKeyword_0()); 
                    }
                    match(input,EqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentOperatorAccess().getEqualsSignKeyword_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentOperatorAccess().getAsteriskEqualsSignKeyword_1()); 
                    }
                    match(input,AsteriskEqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentOperatorAccess().getAsteriskEqualsSignKeyword_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentOperatorAccess().getSolidusEqualsSignKeyword_2()); 
                    }
                    match(input,SolidusEqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentOperatorAccess().getSolidusEqualsSignKeyword_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentOperatorAccess().getPercentSignEqualsSignKeyword_3()); 
                    }
                    match(input,PercentSignEqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentOperatorAccess().getPercentSignEqualsSignKeyword_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentOperatorAccess().getPlusSignEqualsSignKeyword_4()); 
                    }
                    match(input,PlusSignEqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentOperatorAccess().getPlusSignEqualsSignKeyword_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentOperatorAccess().getHyphenMinusEqualsSignKeyword_5()); 
                    }
                    match(input,HyphenMinusEqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentOperatorAccess().getHyphenMinusEqualsSignKeyword_5()); 
                    }

                    }


                    }
                    break;
                case 7 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentOperatorAccess().getLessThanSignLessThanSignEqualsSignKeyword_6()); 
                    }
                    match(input,LessThanSignLessThanSignEqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentOperatorAccess().getLessThanSignLessThanSignEqualsSignKeyword_6()); 
                    }

                    }


                    }
                    break;
                case 8 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentOperatorAccess().getGroup_7()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AssignmentOperator__Group_7__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentOperatorAccess().getGroup_7()); 
                    }

                    }


                    }
                    break;
                case 9 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentOperatorAccess().getAmpersandEqualsSignKeyword_8()); 
                    }
                    match(input,AmpersandEqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentOperatorAccess().getAmpersandEqualsSignKeyword_8()); 
                    }

                    }


                    }
                    break;
                case 10 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentOperatorAccess().getCircumflexAccentEqualsSignKeyword_9()); 
                    }
                    match(input,CircumflexAccentEqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentOperatorAccess().getCircumflexAccentEqualsSignKeyword_9()); 
                    }

                    }


                    }
                    break;
                case 11 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAssignmentOperatorAccess().getVerticalLineEqualsSignKeyword_10()); 
                    }
                    match(input,VerticalLineEqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAssignmentOperatorAccess().getVerticalLineEqualsSignKeyword_10()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__TemplateLiteral__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt97=2;
            int LA97_0 = input.LA(1);

            if ( (LA97_0==RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL) ) {
                alt97=1;
            }
            else if ( (LA97_0==RULE_TEMPLATE_HEAD) ) {
                alt97=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 97, 0, input);

                throw nvae;
            }
            switch (alt97) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__TemplateLiteral__SegmentsAssignment_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTemplateLiteralAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__TemplateLiteral__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTemplateLiteralAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_TemplateLiteral__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt98=2;
            int LA98_0 = input.LA(1);

            if ( (LA98_0==RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL) ) {
                alt98=1;
            }
            else if ( (LA98_0==RULE_TEMPLATE_HEAD) ) {
                alt98=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 98, 0, input);

                throw nvae;
            }
            switch (alt98) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_TemplateLiteral__SegmentsAssignment_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTemplateLiteralAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_TemplateLiteral__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTemplateLiteralAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__Literal__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt99=5;
            switch ( input.LA(1) ) {
            case RULE_DOUBLE:
            case RULE_HEX_INT:
            case RULE_BINARY_INT:
            case RULE_OCTAL_INT:
            case RULE_LEGACY_OCTAL_INT:
            case RULE_SCIENTIFIC_INT:
            case RULE_INT:
                {
                alt99=1;
                }
                break;
            case False:
            case True:
                {
                alt99=2;
                }
                break;
            case RULE_STRING:
                {
                alt99=3;
                }
                break;
            case Null:
                {
                alt99=4;
                }
                break;
            case SolidusEqualsSign:
            case Solidus:
                {
                alt99=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 99, 0, input);

                throw nvae;
            }

            switch (alt99) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralAccess().getNumericLiteralParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleNumericLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralAccess().getNumericLiteralParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralAccess().getBooleanLiteralParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleBooleanLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralAccess().getBooleanLiteralParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralAccess().getStringLiteralParserRuleCall_2()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleStringLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralAccess().getStringLiteralParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralAccess().getNullLiteralParserRuleCall_3()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleNullLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralAccess().getNullLiteralParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralAccess().getRegularExpressionLiteralParserRuleCall_4()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleRegularExpressionLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralAccess().getRegularExpressionLiteralParserRuleCall_4()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__BooleanLiteral__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt100=2;
            int LA100_0 = input.LA(1);

            if ( (LA100_0==True) ) {
                alt100=1;
            }
            else if ( (LA100_0==False) ) {
                alt100=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 100, 0, input);

                throw nvae;
            }
            switch (alt100) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBooleanLiteralAccess().getTrueAssignment_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__BooleanLiteral__TrueAssignment_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBooleanLiteralAccess().getTrueAssignment_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBooleanLiteralAccess().getFalseKeyword_1_1()); 
                    }
                    match(input,False,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBooleanLiteralAccess().getFalseKeyword_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__NumericLiteral__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt101=7;
            switch ( input.LA(1) ) {
            case RULE_DOUBLE:
                {
                alt101=1;
                }
                break;
            case RULE_INT:
                {
                alt101=2;
                }
                break;
            case RULE_BINARY_INT:
                {
                alt101=3;
                }
                break;
            case RULE_OCTAL_INT:
                {
                alt101=4;
                }
                break;
            case RULE_LEGACY_OCTAL_INT:
                {
                alt101=5;
                }
                break;
            case RULE_HEX_INT:
                {
                alt101=6;
                }
                break;
            case RULE_SCIENTIFIC_INT:
                {
                alt101=7;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 101, 0, input);

                throw nvae;
            }

            switch (alt101) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNumericLiteralAccess().getDoubleLiteralParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleDoubleLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNumericLiteralAccess().getDoubleLiteralParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNumericLiteralAccess().getIntLiteralParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleIntLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNumericLiteralAccess().getIntLiteralParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNumericLiteralAccess().getBinaryIntLiteralParserRuleCall_2()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleBinaryIntLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNumericLiteralAccess().getBinaryIntLiteralParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNumericLiteralAccess().getOctalIntLiteralParserRuleCall_3()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleOctalIntLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNumericLiteralAccess().getOctalIntLiteralParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNumericLiteralAccess().getLegacyOctalIntLiteralParserRuleCall_4()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleLegacyOctalIntLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNumericLiteralAccess().getLegacyOctalIntLiteralParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNumericLiteralAccess().getHexIntLiteralParserRuleCall_5()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleHexIntLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNumericLiteralAccess().getHexIntLiteralParserRuleCall_5()); 
                    }

                    }


                    }
                    break;
                case 7 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNumericLiteralAccess().getScientificIntLiteralParserRuleCall_6()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleScientificIntLiteral();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNumericLiteralAccess().getScientificIntLiteralParserRuleCall_6()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__NumericLiteralAsString__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt102=5;
            switch ( input.LA(1) ) {
            case RULE_DOUBLE:
                {
                alt102=1;
                }
                break;
            case RULE_INT:
                {
                alt102=2;
                }
                break;
            case RULE_OCTAL_INT:
                {
                alt102=3;
                }
                break;
            case RULE_HEX_INT:
                {
                alt102=4;
                }
                break;
            case RULE_SCIENTIFIC_INT:
                {
                alt102=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 102, 0, input);

                throw nvae;
            }

            switch (alt102) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNumericLiteralAsStringAccess().getDOUBLETerminalRuleCall_0()); 
                    }
                    match(input,RULE_DOUBLE,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNumericLiteralAsStringAccess().getDOUBLETerminalRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNumericLiteralAsStringAccess().getINTTerminalRuleCall_1()); 
                    }
                    match(input,RULE_INT,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNumericLiteralAsStringAccess().getINTTerminalRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNumericLiteralAsStringAccess().getOCTAL_INTTerminalRuleCall_2()); 
                    }
                    match(input,RULE_OCTAL_INT,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNumericLiteralAsStringAccess().getOCTAL_INTTerminalRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNumericLiteralAsStringAccess().getHEX_INTTerminalRuleCall_3()); 
                    }
                    match(input,RULE_HEX_INT,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNumericLiteralAsStringAccess().getHEX_INTTerminalRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getNumericLiteralAsStringAccess().getSCIENTIFIC_INTTerminalRuleCall_4()); 
                    }
                    match(input,RULE_SCIENTIFIC_INT,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getNumericLiteralAsStringAccess().getSCIENTIFIC_INTTerminalRuleCall_4()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__IdentifierOrThis__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt103=4;
            switch ( input.LA(1) ) {
            case RULE_IDENTIFIER:
                {
                alt103=1;
                }
                break;
            case This:
                {
                alt103=2;
                }
                break;
            case Promisify:
                {
                alt103=3;
                }
                break;
            case Target:
                {
                alt103=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 103, 0, input);

                throw nvae;
            }

            switch (alt103) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIdentifierOrThisAccess().getIDENTIFIERTerminalRuleCall_0()); 
                    }
                    match(input,RULE_IDENTIFIER,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIdentifierOrThisAccess().getIDENTIFIERTerminalRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIdentifierOrThisAccess().getThisKeyword_1()); 
                    }
                    match(input,This,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIdentifierOrThisAccess().getThisKeyword_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIdentifierOrThisAccess().getPromisifyKeyword_2()); 
                    }
                    match(input,Promisify,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIdentifierOrThisAccess().getPromisifyKeyword_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getIdentifierOrThisAccess().getTargetKeyword_3()); 
                    }
                    match(input,Target,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getIdentifierOrThisAccess().getTargetKeyword_3()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AnnotationName__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt104=3;
            switch ( input.LA(1) ) {
            case RULE_IDENTIFIER:
                {
                alt104=1;
                }
                break;
            case This:
                {
                alt104=2;
                }
                break;
            case Target:
                {
                alt104=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 104, 0, input);

                throw nvae;
            }

            switch (alt104) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotationNameAccess().getIDENTIFIERTerminalRuleCall_0()); 
                    }
                    match(input,RULE_IDENTIFIER,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotationNameAccess().getIDENTIFIERTerminalRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotationNameAccess().getThisKeyword_1()); 
                    }
                    match(input,This,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotationNameAccess().getThisKeyword_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotationNameAccess().getTargetKeyword_2()); 
                    }
                    match(input,Target,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotationNameAccess().getTargetKeyword_2()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__REGEX_LITERAL__Alternatives_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt105=2;
            int LA105_0 = input.LA(1);

            if ( (LA105_0==Solidus) ) {
                alt105=1;
            }
            else if ( (LA105_0==SolidusEqualsSign) ) {
                alt105=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 105, 0, input);

                throw nvae;
            }
            switch (alt105) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getREGEX_LITERALAccess().getSolidusKeyword_0_0()); 
                    }
                    match(input,Solidus,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getREGEX_LITERALAccess().getSolidusKeyword_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getREGEX_LITERALAccess().getSolidusEqualsSignKeyword_0_1()); 
                    }
                    match(input,SolidusEqualsSign,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getREGEX_LITERALAccess().getSolidusEqualsSignKeyword_0_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AnnotationArgument__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt106=2;
            int LA106_0 = input.LA(1);

            if ( (LA106_0==False||LA106_0==Null||LA106_0==True||LA106_0==SolidusEqualsSign||LA106_0==Solidus||LA106_0==RULE_DOUBLE||(LA106_0>=RULE_HEX_INT && LA106_0<=RULE_LEGACY_OCTAL_INT)||LA106_0==RULE_SCIENTIFIC_INT||LA106_0==RULE_STRING||LA106_0==RULE_INT) ) {
                alt106=1;
            }
            else if ( ((LA106_0>=Intersection && LA106_0<=Constructor)||LA106_0==Promisify||LA106_0==Default||LA106_0==Target||LA106_0==Await||LA106_0==Union||LA106_0==This||LA106_0==This_1||(LA106_0>=Type && LA106_0<=Void)||LA106_0==LeftParenthesis||LA106_0==LeftSquareBracket||LA106_0==LeftCurlyBracket||LA106_0==Tilde||LA106_0==RULE_IDENTIFIER) ) {
                alt106=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 106, 0, input);

                throw nvae;
            }
            switch (alt106) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotationArgumentAccess().getLiteralAnnotationArgumentParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleLiteralAnnotationArgument();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotationArgumentAccess().getLiteralAnnotationArgumentParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotationArgumentAccess().getTypeRefAnnotationArgumentParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleTypeRefAnnotationArgument();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotationArgumentAccess().getTypeRefAnnotationArgumentParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__TypeRefForCast__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt107=8;
            alt107 = dfa107.predict(input);
            switch (alt107) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeRefForCastAccess().getParameterizedTypeRefParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleParameterizedTypeRef();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeRefForCastAccess().getParameterizedTypeRefParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeRefForCastAccess().getArrayTypeRefParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleArrayTypeRef();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeRefForCastAccess().getArrayTypeRefParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeRefForCastAccess().getThisTypeRefParserRuleCall_2()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleThisTypeRef();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeRefForCastAccess().getThisTypeRefParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeRefForCastAccess().getTypeTypeRefParserRuleCall_3()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleTypeTypeRef();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeRefForCastAccess().getTypeTypeRefParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeRefForCastAccess().getArrowFunctionTypeExpressionParserRuleCall_4()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleArrowFunctionTypeExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeRefForCastAccess().getArrowFunctionTypeExpressionParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeRefForCastAccess().getFunctionTypeExpressionOLDParserRuleCall_5()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleFunctionTypeExpressionOLD();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeRefForCastAccess().getFunctionTypeExpressionOLDParserRuleCall_5()); 
                    }

                    }


                    }
                    break;
                case 7 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeRefForCastAccess().getUnionTypeExpressionOLDParserRuleCall_6()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleUnionTypeExpressionOLD();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeRefForCastAccess().getUnionTypeExpressionOLDParserRuleCall_6()); 
                    }

                    }


                    }
                    break;
                case 8 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeRefForCastAccess().getIntersectionTypeExpressionOLDParserRuleCall_7()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleIntersectionTypeExpressionOLD();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeRefForCastAccess().getIntersectionTypeExpressionOLDParserRuleCall_7()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__TypeReferenceName__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt108=7;
            switch ( input.LA(1) ) {
            case Void:
                {
                alt108=1;
                }
                break;
            case This:
                {
                alt108=2;
                }
                break;
            case Await:
                {
                alt108=3;
                }
                break;
            case Promisify:
                {
                alt108=4;
                }
                break;
            case Target:
                {
                alt108=5;
                }
                break;
            case Default:
                {
                alt108=6;
                }
                break;
            case RULE_IDENTIFIER:
                {
                alt108=7;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 108, 0, input);

                throw nvae;
            }

            switch (alt108) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeReferenceNameAccess().getVoidKeyword_0()); 
                    }
                    match(input,Void,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeReferenceNameAccess().getVoidKeyword_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeReferenceNameAccess().getThisKeyword_1()); 
                    }
                    match(input,This,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeReferenceNameAccess().getThisKeyword_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeReferenceNameAccess().getAwaitKeyword_2()); 
                    }
                    match(input,Await,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeReferenceNameAccess().getAwaitKeyword_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeReferenceNameAccess().getPromisifyKeyword_3()); 
                    }
                    match(input,Promisify,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeReferenceNameAccess().getPromisifyKeyword_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeReferenceNameAccess().getTargetKeyword_4()); 
                    }
                    match(input,Target,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeReferenceNameAccess().getTargetKeyword_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeReferenceNameAccess().getDefaultKeyword_5()); 
                    }
                    match(input,Default,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeReferenceNameAccess().getDefaultKeyword_5()); 
                    }

                    }


                    }
                    break;
                case 7 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeReferenceNameAccess().getIDENTIFIERTerminalRuleCall_6()); 
                    }
                    match(input,RULE_IDENTIFIER,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeReferenceNameAccess().getIDENTIFIERTerminalRuleCall_6()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ClassExtendsImplements__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt109=2;
            int LA109_0 = input.LA(1);

            if ( (LA109_0==Extends) ) {
                alt109=1;
            }
            else if ( (LA109_0==Implements) ) {
                alt109=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 109, 0, input);

                throw nvae;
            }
            switch (alt109) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getClassExtendsImplementsAccess().getGroup_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ClassExtendsImplements__Group_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getClassExtendsImplementsAccess().getGroup_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getClassExtendsImplementsAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ClassExtendsImplements__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getClassExtendsImplementsAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ClassExtendsImplements__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt110=2;
            int LA110_0 = input.LA(1);

            if ( (LA110_0==Extends) ) {
                alt110=1;
            }
            else if ( (LA110_0==Implements) ) {
                alt110=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 110, 0, input);

                throw nvae;
            }
            switch (alt110) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getClassExtendsImplementsAccess().getGroup_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ClassExtendsImplements__Group_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getClassExtendsImplementsAccess().getGroup_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getClassExtendsImplementsAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ClassExtendsImplements__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getClassExtendsImplementsAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__ClassExtendsClause__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt111=2;
            switch ( input.LA(1) ) {
            case Default:
            case Void:
                {
                alt111=1;
                }
                break;
            case This:
                {
                int LA111_2 = input.LA(2);

                if ( (synpred268_InternalN4JSParser()) ) {
                    alt111=1;
                }
                else if ( (true) ) {
                    alt111=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 111, 2, input);

                    throw nvae;
                }
                }
                break;
            case Await:
                {
                int LA111_3 = input.LA(2);

                if ( (synpred268_InternalN4JSParser()) ) {
                    alt111=1;
                }
                else if ( (true) ) {
                    alt111=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 111, 3, input);

                    throw nvae;
                }
                }
                break;
            case Promisify:
                {
                int LA111_4 = input.LA(2);

                if ( (synpred268_InternalN4JSParser()) ) {
                    alt111=1;
                }
                else if ( (true) ) {
                    alt111=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 111, 4, input);

                    throw nvae;
                }
                }
                break;
            case Target:
                {
                int LA111_5 = input.LA(2);

                if ( (synpred268_InternalN4JSParser()) ) {
                    alt111=1;
                }
                else if ( (true) ) {
                    alt111=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 111, 5, input);

                    throw nvae;
                }
                }
                break;
            case RULE_IDENTIFIER:
                {
                int LA111_6 = input.LA(2);

                if ( (synpred268_InternalN4JSParser()) ) {
                    alt111=1;
                }
                else if ( (true) ) {
                    alt111=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 111, 6, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Function:
            case Private:
            case Project:
            case Public:
            case Static:
            case Async:
            case Class:
            case False:
            case Super:
            case Union:
            case Yield:
            case From:
            case Null:
            case This_1:
            case True:
            case Type:
            case Get:
            case Let:
            case New:
            case Out:
            case Set:
            case SolidusEqualsSign:
            case As:
            case Of:
            case LeftParenthesis:
            case Solidus:
            case LessThanSign:
            case CommercialAt:
            case LeftSquareBracket:
            case LeftCurlyBracket:
            case RULE_DOUBLE:
            case RULE_HEX_INT:
            case RULE_BINARY_INT:
            case RULE_OCTAL_INT:
            case RULE_LEGACY_OCTAL_INT:
            case RULE_SCIENTIFIC_INT:
            case RULE_STRING:
            case RULE_TEMPLATE_HEAD:
            case RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL:
            case RULE_INT:
                {
                alt111=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 111, 0, input);

                throw nvae;
            }

            switch (alt111) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getClassExtendsClauseAccess().getSuperClassRefAssignment_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ClassExtendsClause__SuperClassRefAssignment_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getClassExtendsClauseAccess().getSuperClassRefAssignment_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getClassExtendsClauseAccess().getSuperClassExpressionAssignment_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__ClassExtendsClause__SuperClassExpressionAssignment_1_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getClassExtendsClauseAccess().getSuperClassExpressionAssignment_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_ClassExtendsClause__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt112=2;
            switch ( input.LA(1) ) {
            case Default:
            case Void:
                {
                alt112=1;
                }
                break;
            case This:
                {
                int LA112_2 = input.LA(2);

                if ( (synpred269_InternalN4JSParser()) ) {
                    alt112=1;
                }
                else if ( (true) ) {
                    alt112=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 112, 2, input);

                    throw nvae;
                }
                }
                break;
            case Await:
                {
                int LA112_3 = input.LA(2);

                if ( (synpred269_InternalN4JSParser()) ) {
                    alt112=1;
                }
                else if ( (true) ) {
                    alt112=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 112, 3, input);

                    throw nvae;
                }
                }
                break;
            case Promisify:
                {
                int LA112_4 = input.LA(2);

                if ( (synpred269_InternalN4JSParser()) ) {
                    alt112=1;
                }
                else if ( (true) ) {
                    alt112=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 112, 4, input);

                    throw nvae;
                }
                }
                break;
            case Target:
                {
                int LA112_5 = input.LA(2);

                if ( (synpred269_InternalN4JSParser()) ) {
                    alt112=1;
                }
                else if ( (true) ) {
                    alt112=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 112, 5, input);

                    throw nvae;
                }
                }
                break;
            case RULE_IDENTIFIER:
                {
                int LA112_6 = input.LA(2);

                if ( (synpred269_InternalN4JSParser()) ) {
                    alt112=1;
                }
                else if ( (true) ) {
                    alt112=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 112, 6, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Function:
            case Private:
            case Project:
            case Public:
            case Static:
            case Async:
            case Class:
            case False:
            case Super:
            case Union:
            case From:
            case Null:
            case This_1:
            case True:
            case Type:
            case Get:
            case Let:
            case New:
            case Out:
            case Set:
            case SolidusEqualsSign:
            case As:
            case Of:
            case LeftParenthesis:
            case Solidus:
            case LessThanSign:
            case CommercialAt:
            case LeftSquareBracket:
            case LeftCurlyBracket:
            case RULE_DOUBLE:
            case RULE_HEX_INT:
            case RULE_BINARY_INT:
            case RULE_OCTAL_INT:
            case RULE_LEGACY_OCTAL_INT:
            case RULE_SCIENTIFIC_INT:
            case RULE_STRING:
            case RULE_TEMPLATE_HEAD:
            case RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL:
            case RULE_INT:
                {
                alt112=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 112, 0, input);

                throw nvae;
            }

            switch (alt112) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getClassExtendsClauseAccess().getSuperClassRefAssignment_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ClassExtendsClause__SuperClassRefAssignment_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getClassExtendsClauseAccess().getSuperClassRefAssignment_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getClassExtendsClauseAccess().getSuperClassExpressionAssignment_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_ClassExtendsClause__SuperClassExpressionAssignment_1_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getClassExtendsClauseAccess().getSuperClassExpressionAssignment_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__InterfaceExtendsList__Alternatives_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt113=2;
            int LA113_0 = input.LA(1);

            if ( (LA113_0==Extends) ) {
                alt113=1;
            }
            else if ( (LA113_0==Implements) ) {
                alt113=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 113, 0, input);

                throw nvae;
            }
            switch (alt113) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getInterfaceExtendsListAccess().getExtendsKeyword_0_0()); 
                    }
                    match(input,Extends,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getInterfaceExtendsListAccess().getExtendsKeyword_0_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getInterfaceExtendsListAccess().getImplementsKeyword_0_1()); 
                    }
                    match(input,Implements,FOLLOW_2); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getInterfaceExtendsListAccess().getImplementsKeyword_0_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__N4MemberDeclaration__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt114=6;
            alt114 = dfa114.predict(input);
            switch (alt114) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MemberDeclarationAccess().getAnnotatedN4MemberDeclarationParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleAnnotatedN4MemberDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MemberDeclarationAccess().getAnnotatedN4MemberDeclarationParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MemberDeclarationAccess().getN4GetterDeclarationParserRuleCall_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleN4GetterDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MemberDeclarationAccess().getN4GetterDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MemberDeclarationAccess().getN4SetterDeclarationParserRuleCall_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleN4SetterDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MemberDeclarationAccess().getN4SetterDeclarationParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MemberDeclarationAccess().getN4MethodDeclarationParserRuleCall_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleN4MethodDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MemberDeclarationAccess().getN4MethodDeclarationParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MemberDeclarationAccess().getN4FieldDeclarationParserRuleCall_4()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleN4FieldDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MemberDeclarationAccess().getN4FieldDeclarationParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MemberDeclarationAccess().getN4CallableConstructorDeclarationParserRuleCall_5()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleN4CallableConstructorDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MemberDeclarationAccess().getN4CallableConstructorDeclarationParserRuleCall_5()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_N4MemberDeclaration__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt115=6;
            alt115 = dfa115.predict(input);
            switch (alt115) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MemberDeclarationAccess().getAnnotatedN4MemberDeclarationParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedN4MemberDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MemberDeclarationAccess().getAnnotatedN4MemberDeclarationParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MemberDeclarationAccess().getN4GetterDeclarationParserRuleCall_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_N4GetterDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MemberDeclarationAccess().getN4GetterDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MemberDeclarationAccess().getN4SetterDeclarationParserRuleCall_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_N4SetterDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MemberDeclarationAccess().getN4SetterDeclarationParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MemberDeclarationAccess().getN4MethodDeclarationParserRuleCall_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_N4MethodDeclaration();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MemberDeclarationAccess().getN4MethodDeclarationParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MemberDeclarationAccess().getN4FieldDeclarationParserRuleCall_4()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_N4FieldDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MemberDeclarationAccess().getN4FieldDeclarationParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MemberDeclarationAccess().getN4CallableConstructorDeclarationParserRuleCall_5()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_N4CallableConstructorDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MemberDeclarationAccess().getN4CallableConstructorDeclarationParserRuleCall_5()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AnnotatedN4MemberDeclaration__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt116=4;
            alt116 = dfa116.predict(input);
            switch (alt116) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedN4MemberDeclaration__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedN4MemberDeclaration__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedN4MemberDeclaration__Group_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedN4MemberDeclaration__Group_1_3__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_3()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__AnnotatedN4MemberDeclaration__Alternatives_1_2_0_0_4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt117=2;
            int LA117_0 = input.LA(1);

            if ( (LA117_0==Asterisk) ) {
                alt117=1;
            }
            else if ( ((LA117_0>=Intersection && LA117_0<=With)||(LA117_0>=For && LA117_0<=Var)||(LA117_0>=As && LA117_0<=Of)||LA117_0==LeftSquareBracket||LA117_0==RULE_DOUBLE||LA117_0==RULE_HEX_INT||LA117_0==RULE_OCTAL_INT||LA117_0==RULE_SCIENTIFIC_INT||LA117_0==RULE_IDENTIFIER||LA117_0==RULE_STRING||LA117_0==RULE_INT) ) {
                alt117=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 117, 0, input);

                throw nvae;
            }
            switch (alt117) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedN4MemberDeclaration__Group_1_2_0_0_4_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__AnnotatedN4MemberDeclaration__Group_1_2_0_0_4_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AnnotatedN4MemberDeclaration__Alternatives_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt118=4;
            alt118 = dfa118.predict(input);
            switch (alt118) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedN4MemberDeclaration__Group_1_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedN4MemberDeclaration__Group_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedN4MemberDeclaration__Group_1_2__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedN4MemberDeclaration__Group_1_3__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_3()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_AnnotatedN4MemberDeclaration__Alternatives_1_2_0_0_4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt119=2;
            int LA119_0 = input.LA(1);

            if ( (LA119_0==Asterisk) ) {
                alt119=1;
            }
            else if ( ((LA119_0>=Intersection && LA119_0<=With)||(LA119_0>=For && LA119_0<=Var)||(LA119_0>=As && LA119_0<=Of)||LA119_0==LeftSquareBracket||LA119_0==RULE_DOUBLE||LA119_0==RULE_HEX_INT||LA119_0==RULE_OCTAL_INT||LA119_0==RULE_SCIENTIFIC_INT||LA119_0==RULE_IDENTIFIER||LA119_0==RULE_STRING||LA119_0==RULE_INT) ) {
                alt119=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 119, 0, input);

                throw nvae;
            }
            switch (alt119) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedN4MemberDeclaration__Group_1_2_0_0_4_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_AnnotatedN4MemberDeclaration__Group_1_2_0_0_4_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__N4MethodDeclaration__Alternatives_0_0_4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt120=2;
            int LA120_0 = input.LA(1);

            if ( (LA120_0==Asterisk) ) {
                alt120=1;
            }
            else if ( ((LA120_0>=Intersection && LA120_0<=With)||(LA120_0>=For && LA120_0<=Var)||(LA120_0>=As && LA120_0<=Of)||LA120_0==LeftSquareBracket||LA120_0==RULE_DOUBLE||LA120_0==RULE_HEX_INT||LA120_0==RULE_OCTAL_INT||LA120_0==RULE_SCIENTIFIC_INT||LA120_0==RULE_IDENTIFIER||LA120_0==RULE_STRING||LA120_0==RULE_INT) ) {
                alt120=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 120, 0, input);

                throw nvae;
            }
            switch (alt120) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__N4MethodDeclaration__Group_0_0_4_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__N4MethodDeclaration__Group_0_0_4_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_N4MethodDeclaration__Alternatives_0_0_4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt121=2;
            int LA121_0 = input.LA(1);

            if ( (LA121_0==Asterisk) ) {
                alt121=1;
            }
            else if ( ((LA121_0>=Intersection && LA121_0<=With)||(LA121_0>=For && LA121_0<=Var)||(LA121_0>=As && LA121_0<=Of)||LA121_0==LeftSquareBracket||LA121_0==RULE_DOUBLE||LA121_0==RULE_HEX_INT||LA121_0==RULE_OCTAL_INT||LA121_0==RULE_SCIENTIFIC_INT||LA121_0==RULE_IDENTIFIER||LA121_0==RULE_STRING||LA121_0==RULE_INT) ) {
                alt121=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 121, 0, input);

                throw nvae;
            }
            switch (alt121) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_N4MethodDeclaration__Group_0_0_4_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_N4MethodDeclaration__Group_0_0_4_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__BindingPattern__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt122=2;
            int LA122_0 = input.LA(1);

            if ( (LA122_0==LeftCurlyBracket) ) {
                alt122=1;
            }
            else if ( (LA122_0==LeftSquareBracket) ) {
                alt122=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 122, 0, input);

                throw nvae;
            }
            switch (alt122) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingPatternAccess().getObjectBindingPatternParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleObjectBindingPattern();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingPatternAccess().getObjectBindingPatternParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingPatternAccess().getArrayBindingPatternParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleArrayBindingPattern();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingPatternAccess().getArrayBindingPatternParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BindingPattern__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt123=2;
            int LA123_0 = input.LA(1);

            if ( (LA123_0==LeftCurlyBracket) ) {
                alt123=1;
            }
            else if ( (LA123_0==LeftSquareBracket) ) {
                alt123=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 123, 0, input);

                throw nvae;
            }
            switch (alt123) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingPatternAccess().getObjectBindingPatternParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_ObjectBindingPattern();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingPatternAccess().getObjectBindingPatternParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingPatternAccess().getArrayBindingPatternParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    norm1_ArrayBindingPattern();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingPatternAccess().getArrayBindingPatternParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__BindingProperty__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt124=2;
            alt124 = dfa124.predict(input);
            switch (alt124) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingPropertyAccess().getGroup_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__BindingProperty__Group_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingPropertyAccess().getGroup_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingPropertyAccess().getValueAssignment_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__BindingProperty__ValueAssignment_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingPropertyAccess().getValueAssignment_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BindingProperty__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt125=2;
            alt125 = dfa125.predict(input);
            switch (alt125) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingPropertyAccess().getGroup_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_BindingProperty__Group_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingPropertyAccess().getGroup_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingPropertyAccess().getValueAssignment_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_BindingProperty__ValueAssignment_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingPropertyAccess().getValueAssignment_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__BindingElementImpl__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt126=2;
            int LA126_0 = input.LA(1);

            if ( (LA126_0==LeftSquareBracket||LA126_0==LeftCurlyBracket) ) {
                alt126=1;
            }
            else if ( ((LA126_0>=Intersection && LA126_0<=Implements)||(LA126_0>=Promisify && LA126_0<=Abstract)||LA126_0==External||(LA126_0>=Private && LA126_0<=Project)||LA126_0==Public||LA126_0==Static||LA126_0==Target||(LA126_0>=Async && LA126_0<=Await)||LA126_0==Union||(LA126_0>=Yield && LA126_0<=This)||LA126_0==From||LA126_0==Type||(LA126_0>=Get && LA126_0<=Let)||(LA126_0>=Out && LA126_0<=Set)||LA126_0==As||LA126_0==Of||LA126_0==CommercialAt||LA126_0==RULE_IDENTIFIER) ) {
                alt126=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 126, 0, input);

                throw nvae;
            }
            switch (alt126) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingElementImplAccess().getGroup_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__BindingElementImpl__Group_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingElementImplAccess().getGroup_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingElementImplAccess().getVarDeclAssignment_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__BindingElementImpl__VarDeclAssignment_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingElementImplAccess().getVarDeclAssignment_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_BindingElementImpl__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt127=2;
            int LA127_0 = input.LA(1);

            if ( (LA127_0==LeftSquareBracket||LA127_0==LeftCurlyBracket) ) {
                alt127=1;
            }
            else if ( ((LA127_0>=Intersection && LA127_0<=Implements)||(LA127_0>=Promisify && LA127_0<=Abstract)||LA127_0==External||(LA127_0>=Private && LA127_0<=Project)||LA127_0==Public||LA127_0==Static||LA127_0==Target||(LA127_0>=Async && LA127_0<=Await)||LA127_0==Union||LA127_0==This||LA127_0==From||LA127_0==Type||(LA127_0>=Get && LA127_0<=Let)||(LA127_0>=Out && LA127_0<=Set)||LA127_0==As||LA127_0==Of||LA127_0==CommercialAt||LA127_0==RULE_IDENTIFIER) ) {
                alt127=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 127, 0, input);

                throw nvae;
            }
            switch (alt127) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingElementImplAccess().getGroup_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_BindingElementImpl__Group_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingElementImplAccess().getGroup_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getBindingElementImplAccess().getVarDeclAssignment_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_BindingElementImpl__VarDeclAssignment_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getBindingElementImplAccess().getVarDeclAssignment_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__LiteralOrComputedPropertyName__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt128=4;
            switch ( input.LA(1) ) {
            case Intersection:
            case Constructor:
            case Implements:
            case Instanceof:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case Continue:
            case Debugger:
            case External:
            case Function:
            case Default:
            case Extends:
            case Finally:
            case Private:
            case Project:
            case Delete:
            case Export:
            case Import:
            case Public:
            case Return:
            case Static:
            case Switch:
            case Target:
            case Typeof:
            case Async:
            case Await:
            case Break:
            case Catch:
            case Class:
            case Const:
            case False:
            case Super:
            case Throw:
            case Union:
            case While:
            case Yield:
            case This:
            case Case:
            case Else:
            case Enum:
            case From:
            case Null:
            case This_1:
            case True:
            case Type:
            case Void:
            case With:
            case For:
            case Get:
            case Let:
            case New:
            case Out:
            case Set:
            case Try:
            case Var:
            case As:
            case Do:
            case If:
            case In:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt128=1;
                }
                break;
            case RULE_STRING:
                {
                alt128=2;
                }
                break;
            case RULE_DOUBLE:
            case RULE_HEX_INT:
            case RULE_OCTAL_INT:
            case RULE_SCIENTIFIC_INT:
            case RULE_INT:
                {
                alt128=3;
                }
                break;
            case LeftSquareBracket:
                {
                alt128=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 128, 0, input);

                throw nvae;
            }

            switch (alt128) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__LiteralOrComputedPropertyName__LiteralNameAssignment_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__LiteralOrComputedPropertyName__LiteralNameAssignment_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__LiteralOrComputedPropertyName__LiteralNameAssignment_2();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getGroup_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__LiteralOrComputedPropertyName__Group_3__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getGroup_3()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void norm1_LiteralOrComputedPropertyName__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt129=4;
            switch ( input.LA(1) ) {
            case Intersection:
            case Constructor:
            case Implements:
            case Instanceof:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case Continue:
            case Debugger:
            case External:
            case Function:
            case Default:
            case Extends:
            case Finally:
            case Private:
            case Project:
            case Delete:
            case Export:
            case Import:
            case Public:
            case Return:
            case Static:
            case Switch:
            case Target:
            case Typeof:
            case Async:
            case Await:
            case Break:
            case Catch:
            case Class:
            case Const:
            case False:
            case Super:
            case Throw:
            case Union:
            case While:
            case Yield:
            case This:
            case Case:
            case Else:
            case Enum:
            case From:
            case Null:
            case This_1:
            case True:
            case Type:
            case Void:
            case With:
            case For:
            case Get:
            case Let:
            case New:
            case Out:
            case Set:
            case Try:
            case Var:
            case As:
            case Do:
            case If:
            case In:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt129=1;
                }
                break;
            case RULE_STRING:
                {
                alt129=2;
                }
                break;
            case RULE_DOUBLE:
            case RULE_HEX_INT:
            case RULE_OCTAL_INT:
            case RULE_SCIENTIFIC_INT:
            case RULE_INT:
                {
                alt129=3;
                }
                break;
            case LeftSquareBracket:
                {
                alt129=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 129, 0, input);

                throw nvae;
            }

            switch (alt129) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_LiteralOrComputedPropertyName__LiteralNameAssignment_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_LiteralOrComputedPropertyName__LiteralNameAssignment_1();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_2()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_LiteralOrComputedPropertyName__LiteralNameAssignment_2();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getLiteralOrComputedPropertyNameAccess().getGroup_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    norm1_LiteralOrComputedPropertyName__Group_3__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getLiteralOrComputedPropertyNameAccess().getGroup_3()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__JSXElement__Alternatives_3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt130=2;
            int LA130_0 = input.LA(1);

            if ( (LA130_0==GreaterThanSign) ) {
                alt130=1;
            }
            else if ( (LA130_0==Solidus) ) {
                alt130=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 130, 0, input);

                throw nvae;
            }
            switch (alt130) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getJSXElementAccess().getGroup_3_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__JSXElement__Group_3_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getJSXElementAccess().getGroup_3_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getJSXElementAccess().getGroup_3_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__JSXElement__Group_3_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getJSXElementAccess().getGroup_3_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__JSXFragment__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt131=2;
            int LA131_0 = input.LA(1);

            if ( (LA131_0==LessThanSign) ) {
                int LA131_1 = input.LA(2);

                if ( (LA131_1==Solidus) ) {
                    alt131=2;
                }
                else if ( (LA131_1==GreaterThanSign) ) {
                    alt131=1;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 131, 1, input);

                    throw nvae;
                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 131, 0, input);

                throw nvae;
            }
            switch (alt131) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getJSXFragmentAccess().getGroup_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__JSXFragment__Group_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getJSXFragmentAccess().getGroup_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getJSXFragmentAccess().getGroup_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__JSXFragment__Group_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getJSXFragmentAccess().getGroup_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__JSXChild__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt132=2;
            int LA132_0 = input.LA(1);

            if ( (LA132_0==LessThanSign) ) {
                alt132=1;
            }
            else if ( (LA132_0==LeftCurlyBracket) ) {
                alt132=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 132, 0, input);

                throw nvae;
            }
            switch (alt132) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getJSXChildAccess().getJSXElementParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleJSXElement();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getJSXChildAccess().getJSXElementParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getJSXChildAccess().getJSXExpressionParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleJSXExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getJSXChildAccess().getJSXExpressionParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__JSXAttribute__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt133=2;
            int LA133_0 = input.LA(1);

            if ( (LA133_0==LeftCurlyBracket) ) {
                alt133=1;
            }
            else if ( ((LA133_0>=Intersection && LA133_0<=With)||(LA133_0>=For && LA133_0<=Var)||(LA133_0>=As && LA133_0<=Of)||LA133_0==RULE_IDENTIFIER) ) {
                alt133=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 133, 0, input);

                throw nvae;
            }
            switch (alt133) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getJSXAttributeAccess().getJSXSpreadAttributeParserRuleCall_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleJSXSpreadAttribute();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getJSXAttributeAccess().getJSXSpreadAttributeParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getJSXAttributeAccess().getJSXPropertyAttributeParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleJSXPropertyAttribute();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getJSXAttributeAccess().getJSXPropertyAttributeParserRuleCall_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__JSXPropertyAttribute__Alternatives_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt134=2;
            int LA134_0 = input.LA(1);

            if ( (LA134_0==RULE_STRING) ) {
                alt134=1;
            }
            else if ( (LA134_0==LeftCurlyBracket) ) {
                alt134=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 134, 0, input);

                throw nvae;
            }
            switch (alt134) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getJSXPropertyAttributeAccess().getJsxAttributeValueAssignment_1_1_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__JSXPropertyAttribute__JsxAttributeValueAssignment_1_1_0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getJSXPropertyAttributeAccess().getJsxAttributeValueAssignment_1_1_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getJSXPropertyAttributeAccess().getGroup_1_1_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__JSXPropertyAttribute__Group_1_1_1__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getJSXPropertyAttributeAccess().getGroup_1_1_1()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__PrimaryTypeExpression__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt135=4;
            alt135 = dfa135.predict(input);
            switch (alt135) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryTypeExpressionAccess().getArrowFunctionTypeExpressionParserRuleCall_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    ruleArrowFunctionTypeExpression();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryTypeExpressionAccess().getArrowFunctionTypeExpressionParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryTypeExpressionAccess().getArrayTypeRefParserRuleCall_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleArrayTypeRef();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryTypeExpressionAccess().getArrayTypeRefParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryTypeExpressionAccess().getTypeRefWithModifiersParserRuleCall_2()); 
                    }
                    pushFollow(FOLLOW_2);
                    ruleTypeRefWithModifiers();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryTypeExpressionAccess().getTypeRefWithModifiersParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getPrimaryTypeExpressionAccess().getGroup_3()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__PrimaryTypeExpression__Group_3__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getPrimaryTypeExpressionAccess().getGroup_3()); 
                    }

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    public final void rule__TypeRefWithoutModifiers__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            int alt136=5;
            switch ( input.LA(1) ) {
            case Promisify:
            case Default:
            case Target:
            case Await:
            case This:
            case This_1:
            case Void:
            case Tilde:
            case RULE_IDENTIFIER:
                {
                alt136=1;
                }
                break;
            case Constructor:
            case Type:
                {
                alt136=2;
                }
                break;
            case LeftCurlyBracket:
                {
                alt136=3;
                }
                break;
            case Union:
                {
                alt136=4;
                }
                break;
            case Intersection:
                {
                alt136=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 136, 0, input);

                throw nvae;
            }

            switch (alt136) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {
                       before(grammarAccess.getTypeRefWithoutModifiersAccess().getGroup_0()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    rule__TypeRefWithoutModifiers__Group_0__0();

                    state._fsp--;
                    if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       after(grammarAccess.getTypeRefWithoutModifiersAccess().getGroup_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    i