/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.annotation;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import org.eclipse.n4js.annotation.TestWithScript;
import org.eclipse.xtend.lib.macro.AbstractMethodProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Processor for transforming each method annotated with the {@link TestWithScript @TestWithScript} annotation.
 */
@SuppressWarnings("all")
public class TestWithScriptProcessor extends AbstractMethodProcessor {
  @Override
  public void doTransform(final MutableMethodDeclaration m, @Extension final TransformationContext context) {
    final Function1<AnnotationReference, Boolean> _function = (AnnotationReference it) -> {
      String _qualifiedName = it.getAnnotationTypeDeclaration().getQualifiedName();
      String _name = TestWithScript.class.getName();
      return Boolean.valueOf(Objects.equal(_qualifiedName, _name));
    };
    final Iterable<? extends AnnotationReference> annotations = IterableExtensions.filter(m.getAnnotations(), _function);
    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(annotations);
    boolean _not = (!_isNullOrEmpty);
    if (_not) {
      int _size = IterableExtensions.size(annotations);
      boolean _greaterThan = (_size > 1);
      if (_greaterThan) {
        context.addError(m, 
          "Duplicate annotation of non-repeatable type @TestWithScript.\n\t\t\t\t\t\t\tOnly annotation types marked @Repeatable can be used multiple times at one target.");
        return;
      }
      final AnnotationReference annotation = ((AnnotationReference[])Conversions.unwrapArray(annotations, AnnotationReference.class))[0];
      final String script = annotation.getStringValue("script");
      final String selectedText = Strings.nullToEmpty(annotation.getStringValue("selectedText"));
      final int occurrenceIndex = annotation.getIntValue("occurrenceIndex");
      if ((null == script)) {
        context.addError(m, "Script cannot be null.");
        return;
      }
      if ((0 > occurrenceIndex)) {
        context.addError(m, "Occurrence index must be a non-negative integer.");
      }
      int fromIndex = 0;
      int indexOf = 0;
      int numOfSuccess = (-1);
      boolean stop = false;
      while ((!stop)) {
        {
          indexOf = script.indexOf(selectedText, fromIndex);
          if ((indexOf > (-1))) {
            numOfSuccess = (numOfSuccess + 1);
            fromIndex = (indexOf + 1);
            stop = ((fromIndex >= (script.length() - 1)) || (occurrenceIndex == numOfSuccess));
          } else {
            stop = true;
          }
        }
      }
      if ((0 > numOfSuccess)) {
        context.addError(m, "Cannot find selected text in script.");
        return;
      }
      if ((occurrenceIndex != numOfSuccess)) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Selected text exists only ");
        _builder.append((numOfSuccess + 1));
        _builder.append(" time");
        {
          if ((numOfSuccess != 0)) {
            _builder.append("s");
          }
        }
        _builder.append(" in the script instead of ");
        _builder.append((occurrenceIndex + 
          1));
        _builder.append(".");
        context.addError(m, _builder.toString());
        return;
      }
      final int offset = indexOf;
      final int length = selectedText.length();
      final String originalName = m.getSimpleName();
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("__");
      _builder_1.append(originalName);
      final String newName = _builder_1.toString();
      m.setSimpleName(newName);
      m.setVisibility(Visibility.PRIVATE);
      final Procedure1<MutableMethodDeclaration> _function_1 = (MutableMethodDeclaration it) -> {
        it.setReturnType(m.getReturnType());
        it.setExceptions(((TypeReference[])Conversions.unwrapArray(m.getExceptions(), TypeReference.class)));
        it.setDocComment(m.getDocComment());
        Iterable<? extends MutableParameterDeclaration> _parameters = it.getParameters();
        for (final MutableParameterDeclaration p : _parameters) {
          it.addParameter(p.getSimpleName(), p.getType());
        }
        final Function1<AnnotationReference, Boolean> _function_2 = (AnnotationReference it_1) -> {
          String _qualifiedName = it_1.getAnnotationTypeDeclaration().getQualifiedName();
          String _name = TestWithScript.class.getName();
          return Boolean.valueOf((!Objects.equal(_qualifiedName, _name)));
        };
        Iterable<? extends AnnotationReference> _filter = IterableExtensions.filter(m.getAnnotations(), _function_2);
        for (final AnnotationReference a : _filter) {
          it.addAnnotation(a);
        }
        final CompilationStrategy _function_3 = (CompilationStrategy.CompilationContext it_1) -> {
          StringConcatenation _builder_2 = new StringConcatenation();
          String _name = ITextRegion.class.getName();
          _builder_2.append(_name);
          _builder_2.append(" selection = new ");
          String _name_1 = TextRegion.class.getName();
          _builder_2.append(_name_1);
          _builder_2.append("(");
          _builder_2.append(offset);
          _builder_2.append(", ");
          _builder_2.append(length);
          _builder_2.append(");");
          _builder_2.newLineIfNotEmpty();
          String _name_2 = String.class.getName();
          _builder_2.append(_name_2);
          _builder_2.append(" script = \"");
          _builder_2.append(script);
          _builder_2.append("\";");
          _builder_2.newLineIfNotEmpty();
          {
            boolean _isVoid = m.getReturnType().isVoid();
            boolean _not_1 = (!_isVoid);
            if (_not_1) {
              _builder_2.append("return ");
            }
          }
          _builder_2.append(newName);
          _builder_2.append("(");
          {
            Iterable<? extends MutableParameterDeclaration> _parameters_1 = m.getParameters();
            boolean _hasElements = false;
            for(final MutableParameterDeclaration p_1 : _parameters_1) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder_2.appendImmediate(", ", "");
              }
              String _simpleName = p_1.getSimpleName();
              _builder_2.append(_simpleName);
            }
          }
          _builder_2.append(");");
          _builder_2.newLineIfNotEmpty();
          return _builder_2;
        };
        it.setBody(_function_3);
      };
      m.getDeclaringType().addMethod(originalName, _function_1);
      m.addParameter("selection", context.newTypeReference(ITextRegion.class));
      m.addParameter("script", context.newTypeReference(String.class));
      Iterable<? extends AnnotationReference> _annotations = m.getAnnotations();
      for (final AnnotationReference a : _annotations) {
        m.removeAnnotation(a);
      }
    }
  }
}
