/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.ui.building.N4ClusteringBuilderState;
import org.eclipse.n4js.ui.building.N4JSGenerateImmediatelyBuilderState;
import org.eclipse.n4js.utils.N4JSDataCollectors;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.builder.MonitorBasedCancelIndicator;
import org.eclipse.xtext.builder.builderState.BuilderStateUtil;
import org.eclipse.xtext.builder.builderState.impl.ResourceDescriptionImpl;
import org.eclipse.xtext.builder.clustering.CurrentDescriptions;
import org.eclipse.xtext.builder.debug.IBuildLogger;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.resourceloader.IResourceLoader;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;

class DoUpdateImplementation {
    private static final Logger LOGGER = Logger.getLogger(N4JSGenerateImmediatelyBuilderState.class);
    private final IResourceClusteringPolicy clusteringPolicy;
    private final IResourceLoader crossLinkingResourceLoader;
    private final IBuildLogger buildLogger;
    private final BuildData buildData;
    private final ResourceDescriptionsData newData;
    private final SubMonitor progress;
    private final CancelIndicator cancelMonitor;
    private final N4ClusteringBuilderState state;
    private final Set<URI> toBeDeleted;
    private final CurrentDescriptions newState;
    private final ResourceSet resourceSet;
    private final Set<IResourceDescription.Delta> allDeltas = Sets.newHashSet();
    private final IProject currentProject;
    private Queue<URI> queue;
    private final Set<URI> processedURIs = Sets.newHashSet();
    private IResourceLoader.LoadOperation loadOperation = null;
    private Set<URI> allRemainingURIs;

    public DoUpdateImplementation(N4ClusteringBuilderState state, BuildData buildData, ResourceDescriptionsData newData, IProgressMonitor monitor, IBuildLogger buildLogger, IResourceLoader crossLinkingResourceLoader, IResourceClusteringPolicy clusteringPolicy) {
        this.clusteringPolicy = clusteringPolicy;
        this.crossLinkingResourceLoader = crossLinkingResourceLoader;
        this.buildLogger = buildLogger;
        this.state = state;
        this.buildData = buildData;
        this.newData = newData;
        this.progress = SubMonitor.convert((IProgressMonitor)monitor);
        this.cancelMonitor = new MonitorBasedCancelIndicator((IProgressMonitor)this.progress);
        this.toBeDeleted = buildData.getAndRemoveToBeDeleted();
        this.resourceSet = buildData.getResourceSet();
        this.newState = new CurrentDescriptions(this.resourceSet, newData, buildData);
        this.currentProject = state.getBuiltProject(buildData);
        this.queue = buildData.getURIQueue();
    }

    public Collection<IResourceDescription.Delta> doUpdate() {
        this.initSourceLevelURIs();
        this.progress.setWorkRemaining(this.buildData.getToBeUpdated().size() * 8 + 1);
        this.writeNewResourceDescriptions();
        this.checkCancelled();
        this.removeDeleted();
        this.addPendingDeltas();
        this.initRemainingURIs();
        this.queueAffectedResources(this.allDeltas);
        this.queue = this.buildData.getURIQueue();
        this.checkCancelled();
        this.installSourceLevelURIs();
        try {
            this.initLoadOperation();
            while (!this.queue.isEmpty()) {
                this.progress.setWorkRemaining(this.queue.size() * 4 + 1);
                int clusterIndex = this.doUpdateCluster();
                this.installSourceLevelURIs();
                this.initLoadOperation();
                this.clearResourceSetIfNecessary(clusterIndex);
            }
        }
        finally {
            this.done();
        }
        return this.allDeltas;
    }

    private void initSourceLevelURIs() {
        this.buildData.getSourceLevelURICache().cacheAsSourceURIs(this.toBeDeleted);
        this.installSourceLevelURIs();
    }

    private void installSourceLevelURIs() {
        this.state.installSourceLevelURIs(this.buildData);
    }

    private void initRemainingURIs() {
        this.allRemainingURIs = this.getRemainingURIs();
    }

    private int doUpdateCluster() {
        int clusterIndex = 0;
        ArrayList changedDeltas = Lists.newArrayList();
        while (!this.queue.isEmpty()) {
            this.checkCancelled();
            if (!this.continueProcessing(clusterIndex)) break;
            URI changedURI = null;
            Resource resource = null;
            IResourceDescription.Delta newDelta = null;
            try {
                IResourceLoader.LoadResult loadResult = this.loadOperation.next();
                changedURI = loadResult.getUri();
                this.progress.subTask("Linking " + changedURI.lastSegment() + " and dependencies");
                URI actualResourceURI = loadResult.getResource().getURI();
                resource = this.state.addResource(loadResult.getResource(), this.resourceSet);
                this.reportProgress();
                if (!this.removeFromQueue(changedURI)) break;
                this.buildLogger.log((Object)("Linking " + changedURI));
                newDelta = this.resolveLinks(actualResourceURI, resource);
            }
            catch (WrappedException ex) {
                if (ex instanceof IResourceLoader.LoadOperationException) {
                    changedURI = ((IResourceLoader.LoadOperationException)ex).getUri();
                }
                Throwable cause = ex.getCause();
                boolean wasResourceNotFound = false;
                if (cause instanceof CoreException && 368 == ((CoreException)cause).getStatus().getCode()) {
                    wasResourceNotFound = true;
                }
                if (changedURI == null) {
                    LOGGER.error((Object)"Error loading resource", (Throwable)ex);
                }
                if (!this.removeFromQueue(changedURI)) break;
                if (!wasResourceNotFound) {
                    LOGGER.error((Object)("Error loading resource from: " + changedURI.toString()), (Throwable)ex);
                }
                if (resource != null) {
                    this.resourceSet.getResources().remove(resource);
                }
                newDelta = this.createRemoveDelta(changedURI);
            }
            if (newDelta == null) continue;
            ++clusterIndex;
            if (!this.processNewDelta(newDelta)) continue;
            changedDeltas.add(newDelta);
        }
        this.loadOperation.cancel();
        this.queueAffectedResources(changedDeltas);
        return clusterIndex;
    }

    private IResourceDescription.Delta resolveLinks(URI actualResourceURI, Resource resource) {
        IResourceDescription.Manager manager = this.state.getResourceDescriptionManager(resource, actualResourceURI);
        if (manager != null) {
            try {
                this.reportProgress();
                Throwable throwable = null;
                Object var5_9 = null;
                try (Measurement m = N4JSDataCollectors.dcAstPostprocess.getMeasurement("AstPostprocess");){
                    EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)this.cancelMonitor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                IResourceDescription description = manager.getResourceDescription(resource);
                ResourceDescriptionImpl copiedDescription = BuilderStateUtil.create((IResourceDescription)description);
                return manager.createDelta(this.state.getResourceDescription(actualResourceURI), (IResourceDescription)copiedDescription);
            }
            catch (OperationCanceledException e) {
                this.loadOperation.cancel();
                throw e;
            }
            catch (WrappedException e) {
                throw e;
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("Error resolving cross references on resource '" + actualResourceURI + "'"), (Throwable)e);
                throw new IResourceLoader.LoadOperationException(actualResourceURI, (Exception)e);
            }
        }
        return null;
    }

    private void reportProgress() {
        this.progress.split(1);
    }

    private IResourceDescription.Delta createRemoveDelta(URI uri) {
        IResourceDescription oldDescription = this.state.getResourceDescription(uri);
        if (oldDescription != null) {
            return new DefaultResourceDescriptionDelta(oldDescription, null);
        }
        return null;
    }

    private boolean processNewDelta(IResourceDescription.Delta newDelta) {
        this.processedURIs.add(newDelta.getUri());
        this.allDeltas.add(newDelta);
        this.newState.register(newDelta);
        if (!this.buildData.isIndexingOnly()) {
            try {
                this.progress.subTask("Compiling " + newDelta.getUri().lastSegment());
                this.buildLogger.log((Object)("Compiling " + newDelta.getUri()));
                this.state.updateMarkers(newDelta, this.resourceSet, (IProgressMonitor)this.progress.split(2));
            }
            catch (OperationCanceledException e) {
                this.loadOperation.cancel();
                throw e;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error validating " + newDelta.getUri()), (Throwable)e);
            }
        }
        return newDelta.haveEObjectDescriptionsChanged();
    }

    private void clearResourceSetIfNecessary(int processedInThisCluster) {
        if (!this.queue.isEmpty() && !this.continueProcessing(processedInThisCluster)) {
            ArrayList changedDeltas = Lists.newArrayList();
            EList resources = this.resourceSet.getResources();
            this.progress.setWorkRemaining(this.queue.size() * 4 + resources.size());
            int i = 0;
            while (i < resources.size()) {
                URI resourceURI;
                N4JSResource casted;
                Resource res = (Resource)resources.get(i);
                if (res instanceof N4JSResource && !(casted = (N4JSResource)res).isLoadedFromDescription() && casted.isFullyProcessed() && !this.processedURIs.contains(resourceURI = casted.getURI()) && this.queue.remove(resourceURI)) {
                    IResourceDescription.Delta newDelta = null;
                    try {
                        newDelta = this.resolveLinks(resourceURI, (Resource)casted);
                    }
                    catch (WrappedException ex) {
                        newDelta = this.createRemoveDelta(resourceURI);
                    }
                    if (newDelta != null && this.processNewDelta(newDelta)) {
                        changedDeltas.add(newDelta);
                    }
                }
                this.reportProgress();
                ++i;
            }
            this.queueAffectedResources(changedDeltas);
            this.state.clearResourceSet(this.resourceSet);
        }
    }

    private void done() {
        if (this.loadOperation != null) {
            this.loadOperation.cancel();
        }
    }

    private boolean continueProcessing(int clusterIndex) {
        return this.clusteringPolicy.continueProcessing(this.resourceSet, null, clusterIndex);
    }

    private void initLoadOperation() {
        if (!this.queue.isEmpty()) {
            this.loadOperation = this.crossLinkingResourceLoader.create(this.resourceSet, this.currentProject);
            this.loadOperation.load(this.queue);
        }
    }

    private boolean removeFromQueue(URI changedURI) {
        this.queue.remove(changedURI);
        return !this.toBeDeleted.contains(changedURI);
    }

    private void addPendingDeltas() {
        Collection pendingDeltas = this.buildData.getAndRemovePendingDeltas();
        this.allDeltas.addAll(pendingDeltas);
    }

    private void queueAffectedResources(Collection<IResourceDescription.Delta> changedDeltas) {
        this.state.queueAffectedResources(this.allRemainingURIs, (IResourceDescriptions)this.state, this.newState, changedDeltas, this.allDeltas, this.buildData, (IProgressMonitor)this.splitMonitor(changedDeltas.size()));
    }

    private SubMonitor splitMonitor(int consumeWork) {
        return this.progress.split(consumeWork);
    }

    private Set<URI> getRemainingURIs() {
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)this.newData.getAllURIs());
        result.removeAll(this.buildData.getToBeUpdated());
        for (URI remainingURI : this.buildData.getAllRemainingURIs()) {
            result.remove(remainingURI);
        }
        return result;
    }

    private void removeDeleted() {
        if (!this.toBeDeleted.isEmpty()) {
            for (URI uri : this.toBeDeleted) {
                this.newData.removeDescription(uri);
                IResourceDescription oldDescription = this.state.getResourceDescription(uri);
                if (oldDescription == null) continue;
                this.allDeltas.add((IResourceDescription.Delta)new DefaultResourceDescriptionDelta(oldDescription, null));
            }
        }
    }

    private void checkCancelled() {
        if (this.progress.isCanceled()) {
            if (this.loadOperation != null) {
                this.loadOperation.cancel();
            }
            throw new OperationCanceledException();
        }
    }

    private void writeNewResourceDescriptions() {
        SubMonitor splitMonitor = this.splitMonitor(this.buildData.getToBeUpdated().size() * 2);
        this.state.writeNewResourceDescriptions(this.buildData, (IResourceDescriptions)this.state, this.newState, (IProgressMonitor)splitMonitor);
    }
}

