/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.n4js.ui.editor.N4JSDocument;
import org.eclipse.n4js.ui.external.EclipseExternalLibraryWorkspace;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.hyperlinking.DefaultHyperlinkDetector;
import org.eclipse.xtext.ui.editor.hyperlinking.IHyperlinkHelper;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class N4JSHyperlinkDetector
extends DefaultHyperlinkDetector {
    @Inject
    private EclipseExternalLibraryWorkspace extWS;

    public IHyperlink[] detectHyperlinks(final ITextViewer textViewer, final IRegion region, final boolean canShowMultipleHyperlinks) {
        IDocument xtextDocument = textViewer.getDocument();
        if (!(xtextDocument instanceof N4JSDocument)) {
            return super.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
        }
        final IHyperlinkHelper helper = this.getHelper();
        return ((N4JSDocument)xtextDocument).tryReadOnly(new IUnitOfWork<IHyperlink[], XtextResource>(){

            public IHyperlink[] exec(XtextResource resource) throws Exception {
                if ((resource = N4JSHyperlinkDetector.this.tryConvertToFileResource(resource)) == null) {
                    return null;
                }
                if (helper instanceof ISourceViewerAware && textViewer instanceof ISourceViewer) {
                    ((ISourceViewerAware)helper).setSourceViewer((ISourceViewer)textViewer);
                }
                return helper.createHyperlinksByOffset(resource, region.getOffset(), canShowMultipleHyperlinks);
            }
        }, null);
    }

    private XtextResource tryConvertToFileResource(XtextResource resource) {
        Resource extResource;
        URI fileUri = URIUtils.toFileUri((Resource)resource);
        URI extProjectWithResource = this.extWS.findProjectWith(fileUri);
        if (extProjectWithResource != null && (extResource = resource.getResourceSet().getResource(fileUri, true)) instanceof XtextResource) {
            return (XtextResource)extResource;
        }
        return resource;
    }
}

