/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.packagejson;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.packagejson.PackageJsonUtils;
import org.eclipse.n4js.projectDescription.DependencyType;
import org.eclipse.n4js.projectDescription.ProjectDependency;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectDescriptionFactory;
import org.eclipse.n4js.projectDescription.SourceContainerDescription;
import org.eclipse.n4js.projectDescription.SourceContainerType;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;

public class PackageJsonHelper {
    @Inject
    private SemverHelper semverHelper;

    public ProjectDescription convertToProjectDescription(JSONDocument packageJSON, boolean applyDefaultValues, String defaultProjectName) {
        JSONValue rootValue = packageJSON.getContent();
        if (rootValue instanceof JSONObject) {
            ProjectDescription result = ProjectDescriptionFactory.eINSTANCE.createProjectDescription();
            EList rootPairs = ((JSONObject)rootValue).getNameValuePairs();
            this.convertRootPairs(result, (List<NameValuePair>)rootPairs);
            JSONValue property = JSONModelUtils.getProperty((JSONObject)((JSONObject)rootValue), (String)PackageJsonProperties.MAIN.name).orElse(null);
            String propertyAsString = JSONModelUtils.asNonEmptyStringOrNull((JSONValue)property);
            this.adjustProjectDescriptionAfterConversion(result, applyDefaultValues, defaultProjectName, propertyAsString);
            return result;
        }
        return null;
    }

    private void convertRootPairs(ProjectDescription target, List<NameValuePair> rootPairs) {
        for (NameValuePair pair : rootPairs) {
            String name = pair.getName();
            PackageJsonProperties property = PackageJsonProperties.valueOfNameOrNull(name);
            if (property == null) continue;
            JSONValue value = pair.getValue();
            switch (property) {
                case NAME: {
                    target.setProjectName(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case VERSION: {
                    target.setProjectVersion(this.parseVersion(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value)));
                    break;
                }
                case DEPENDENCIES: {
                    this.convertDependencies(target, JSONModelUtils.asNameValuePairsOrEmpty((JSONValue)value), true, DependencyType.RUNTIME);
                    break;
                }
                case DEV_DEPENDENCIES: {
                    this.convertDependencies(target, JSONModelUtils.asNameValuePairsOrEmpty((JSONValue)value), true, DependencyType.DEVELOPMENT);
                    break;
                }
                case MAIN: {
                    break;
                }
                case N4JS: {
                    target.setHasN4JSNature(true);
                    this.convertN4jsPairs(target, JSONModelUtils.asNameValuePairsOrEmpty((JSONValue)value));
                    break;
                }
                case WORKSPACES: {
                    target.setYarnWorkspaceRoot(true);
                    target.getWorkspaces().addAll((Collection)JSONModelUtils.asStringsInArrayOrEmpty((JSONValue)value));
                    break;
                }
            }
        }
    }

    private void convertN4jsPairs(ProjectDescription target, List<NameValuePair> n4jsPairs) {
        for (NameValuePair pair : n4jsPairs) {
            String name = pair.getName();
            PackageJsonProperties property = PackageJsonProperties.valueOfNameOrNull(name);
            if (property == null) continue;
            JSONValue value = pair.getValue();
            switch (property) {
                case PROJECT_TYPE: {
                    target.setProjectType(PackageJsonUtils.parseProjectType(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value)));
                    break;
                }
                case VENDOR_ID: {
                    target.setVendorId(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case VENDOR_NAME: {
                    target.setVendorName(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case OUTPUT: {
                    target.setOutputPath(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case SOURCES: {
                    target.getSourceContainers().addAll(PackageJsonUtils.asSourceContainerDescriptionsOrEmpty(value));
                    break;
                }
                case MODULE_FILTERS: {
                    target.getModuleFilters().addAll(PackageJsonUtils.asModuleFiltersInObjectOrEmpty(value));
                    break;
                }
                case MAIN_MODULE: {
                    target.setMainModule(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case TESTED_PROJECTS: {
                    target.getTestedProjects().addAll(PackageJsonUtils.asProjectReferencesInArrayOrEmpty(value));
                    break;
                }
                case IMPLEMENTATION_ID: {
                    target.setImplementationId(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)value));
                    break;
                }
                case IMPLEMENTED_PROJECTS: {
                    target.getImplementedProjects().addAll(PackageJsonUtils.asProjectReferencesInArrayOrEmpty(value));
                    break;
                }
                case EXTENDED_RUNTIME_ENVIRONMENT: {
                    target.setExtendedRuntimeEnvironment(PackageJsonUtils.asProjectReferenceOrNull(value));
                    break;
                }
                case PROVIDED_RUNTIME_LIBRARIES: {
                    target.getProvidedRuntimeLibraries().addAll(PackageJsonUtils.asProjectReferencesInArrayOrEmpty(value));
                    break;
                }
                case REQUIRED_RUNTIME_LIBRARIES: {
                    target.getRequiredRuntimeLibraries().addAll(PackageJsonUtils.asProjectReferencesInArrayOrEmpty(value));
                    break;
                }
                case DEFINES_PACKAGE: {
                    target.setDefinesPackage(JSONModelUtils.asStringOrNull((JSONValue)value));
                    break;
                }
            }
        }
    }

    private void convertDependencies(ProjectDescription target, List<NameValuePair> depPairs, boolean avoidDuplicates, DependencyType type) {
        HashSet<String> existingProjectNames = new HashSet<String>();
        if (avoidDuplicates) {
            for (ProjectDependency pd : target.getProjectDependencies()) {
                existingProjectNames.add(pd.getProjectName());
            }
        }
        for (NameValuePair pair : depPairs) {
            String projectName = pair.getName();
            boolean addProjectDependency = true;
            addProjectDependency &= projectName != null && !projectName.isEmpty();
            boolean bl = !avoidDuplicates || !existingProjectNames.contains(projectName);
            existingProjectNames.add(projectName);
            if (!(addProjectDependency &= bl)) continue;
            JSONValue value = pair.getValue();
            String valueStr = JSONModelUtils.asStringOrNull((JSONValue)value);
            ProjectDependency dep = ProjectDescriptionFactory.eINSTANCE.createProjectDependency();
            dep.setProjectName(projectName);
            dep.setVersionRequirementString(valueStr);
            dep.setType(type);
            NPMVersionRequirement vreq = this.parseVersionRequirement(valueStr);
            dep.setVersionRequirement(vreq);
            target.getProjectDependencies().add((Object)dep);
        }
    }

    private void adjustProjectDescriptionAfterConversion(ProjectDescription target, boolean applyDefaultValues, String defaultProjectName, String valueOfTopLevelPropertyMain) {
        List<String> sourceContainerPaths;
        String mainModulePath;
        boolean hasN4jsSpecificMainModule;
        boolean bl = hasN4jsSpecificMainModule = target.getMainModule() != null;
        if (applyDefaultValues) {
            this.applyDefaults(target, defaultProjectName);
        }
        if (valueOfTopLevelPropertyMain != null && !hasN4jsSpecificMainModule && (mainModulePath = ProjectDescriptionUtils.convertMainPathToModuleSpecifier(valueOfTopLevelPropertyMain, sourceContainerPaths = target.getSourceContainers().stream().flatMap(scd -> ProjectDescriptionUtils.getPathsNormalized(scd).stream()).collect(Collectors.toList()))) != null) {
            target.setMainModule(mainModulePath);
        }
        Set projectNamesToRemove = target.getProjectDependencies().stream().map(pd -> pd.getProjectName()).filter(id -> id.endsWith(".api")).map(id -> id.substring(0, id.length() - 4)).collect(Collectors.toSet());
        target.getProjectDependencies().removeIf(pd -> projectNamesToRemove.contains(pd.getProjectName()));
    }

    private void applyDefaults(ProjectDescription target, String defaultProjectName) {
        Iterator sourceContainerPaths;
        if (!target.isHasN4JSNature()) {
            target.setProjectType(PackageJsonUtils.parseProjectType(PackageJsonProperties.PROJECT_TYPE.defaultValue));
        }
        if (target.getProjectName() == null) {
            target.setProjectName(defaultProjectName);
        }
        if (target.getProjectVersion() == null) {
            target.setProjectVersion(this.parseVersion(PackageJsonProperties.VERSION.defaultValue));
        }
        if (target.getVendorId() == null) {
            target.setVendorId(PackageJsonProperties.VENDOR_ID.defaultValue);
        }
        if (target.getMainModule() == null) {
            target.setMainModule(PackageJsonProperties.MAIN_MODULE.defaultValue);
        }
        if (target.getOutputPath() == null) {
            target.setOutputPath(PackageJsonProperties.OUTPUT.defaultValue);
        }
        if (!(sourceContainerPaths = target.getSourceContainers().stream().flatMap(sc -> sc.getPaths().stream()).iterator()).hasNext() && !target.isYarnWorkspaceRoot()) {
            SourceContainerDescription scd = target.getSourceContainers().stream().filter(sc -> sc.getSourceContainerType() == SourceContainerType.SOURCE).findFirst().orElse(null);
            if (scd == null) {
                SourceContainerDescription scdNew = ProjectDescriptionFactory.eINSTANCE.createSourceContainerDescription();
                scdNew.setSourceContainerType(SourceContainerType.SOURCE);
                scdNew.getPaths().add((Object)PackageJsonProperties.OUTPUT.defaultValue);
                target.getSourceContainers().add((Object)scdNew);
            } else if (scd.getPaths().isEmpty()) {
                scd.getPaths().add((Object)PackageJsonProperties.OUTPUT.defaultValue);
            }
        }
    }

    private VersionNumber parseVersion(String versionStr) {
        if (versionStr == null) {
            return null;
        }
        VersionNumber result = this.semverHelper.parseVersionNumber(versionStr);
        return result;
    }

    private NPMVersionRequirement parseVersionRequirement(String versionRequirementStr) {
        if (versionRequirementStr == null) {
            return null;
        }
        NPMVersionRequirement result = this.semverHelper.parse(versionRequirementStr);
        return result;
    }
}

