/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.generator;

import org.eclipse.n4js.generator.GeneratorException;
import org.eclipse.xtext.xbase.lib.InputOutput;

/**
 * Code generator exception handler.
 */
@SuppressWarnings("all")
public class GeneratorExceptionHandler {
  /**
   * Prints provided message to the out stream, and the stack trace of the provided cause.
   * Afterwards throws new {@link GeneratorException} wrapping provided cause.
   */
  public void handleError(final String message, final Throwable cause) {
    InputOutput.<String>println(message);
    cause.printStackTrace();
    throw new GeneratorException(message, cause);
  }
}
