/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.scoping.utils;

import com.google.common.base.Predicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.ts.scoping.TypesScopeFilter;
import org.eclipse.xtext.resource.IEObjectDescription;

/**
 * Poor mans filter, for content assist more elaborated solutions are necessary anyway. Reduces the number of elements of
 * a scope returned by getAllElements, although scope might contain more elements. Simplifies tests etc. as less elements
 * are to be checked.
 */
@SuppressWarnings("all")
public class N4JSTypesScopeFilter extends TypesScopeFilter {
  @Override
  protected Predicate<? super IEObjectDescription> getTypeReferenceFilterCriteria(final EObject container, final EReference containmentFeature) {
    Predicate<? super IEObjectDescription> _switchResult = null;
    boolean _matched = false;
    if (container instanceof FunctionDefinition) {
      _matched=true;
      _switchResult = this.getReturnTypeCriteria();
    }
    if (!_matched) {
      if (container instanceof N4FieldDeclaration) {
        _matched=true;
        _switchResult = this.getFieldTypeCriteria();
      }
    }
    if (!_matched) {
      if (container instanceof VariableDeclaration) {
        _matched=true;
        _switchResult = this.getFieldTypeCriteria();
      }
    }
    if (!_matched) {
      if (container instanceof PropertyAssignment) {
        _matched=true;
        _switchResult = this.getFieldTypeCriteria();
      }
    }
    if (!_matched) {
      if (container instanceof FormalParameter) {
        _matched=true;
        _switchResult = this.getParameterTypeCriteria();
      }
    }
    if (!_matched) {
      _switchResult = super.getTypeReferenceFilterCriteria(container, containmentFeature);
    }
    return _switchResult;
  }
}
