/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.typesbuilder;

import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.typesbuilder.N4JSClassifierDeclarationTypesBuilder;
import org.eclipse.n4js.typesbuilder.VersionedTypesBuilderUtil;

@SuppressWarnings("all")
public class N4JSInterfaceDeclarationTypesBuilder extends N4JSClassifierDeclarationTypesBuilder {
  boolean relinkTInterface(final N4InterfaceDeclaration n4Interface, final TModule target, final boolean preLinkingPhase, final int idx) {
    String _name = n4Interface.getName();
    boolean _tripleEquals = (_name == null);
    if (_tripleEquals) {
      return false;
    }
    Type _get = target.getTopLevelTypes().get(idx);
    final TInterface interfaceType = ((TInterface) _get);
    this.relinkClassifierAndMembers(interfaceType, n4Interface, preLinkingPhase);
    return true;
  }
  
  protected TInterface createTInterface(final N4InterfaceDeclaration n4Interface, final TModule target, final boolean preLinkingPhase) {
    String _name = n4Interface.getName();
    boolean _tripleEquals = (_name == null);
    if (_tripleEquals) {
      return null;
    }
    final TInterface interfaceType = this.createTInterface(n4Interface);
    this._n4JSTypesBuilderHelper.<N4InterfaceDeclaration>setTypeAccessModifier(interfaceType, n4Interface);
    TypingStrategy _xifexpression = null;
    TypingStrategy _typingStrategy = n4Interface.getTypingStrategy();
    boolean _tripleEquals_1 = (_typingStrategy == TypingStrategy.DEFAULT);
    if (_tripleEquals_1) {
      _xifexpression = TypingStrategy.DEFAULT;
    } else {
      _xifexpression = TypingStrategy.STRUCTURAL;
    }
    interfaceType.setTypingStrategy(_xifexpression);
    this._n4JSTypesBuilderHelper.setProvidedByRuntime(interfaceType, n4Interface, preLinkingPhase);
    interfaceType.setDeclaredCovariantConstructor(this._n4JSTypesBuilderHelper.isDeclaredCovariantConstructor(n4Interface));
    this.addTypeParameters(interfaceType, n4Interface, preLinkingPhase);
    this.addExtendedInterfaces(interfaceType, n4Interface, preLinkingPhase);
    this.addFields(interfaceType, n4Interface, preLinkingPhase);
    this.addMethods(interfaceType, n4Interface, preLinkingPhase);
    this.addGetters(interfaceType, n4Interface, preLinkingPhase);
    this.addSetters(interfaceType, n4Interface, preLinkingPhase);
    this._n4JSTypesBuilderHelper.copyAnnotations(interfaceType, n4Interface, preLinkingPhase);
    interfaceType.setAstElement(n4Interface);
    n4Interface.setDefinedType(interfaceType);
    EList<Type> _topLevelTypes = target.getTopLevelTypes();
    _topLevelTypes.add(interfaceType);
    return interfaceType;
  }
  
  private TInterface createTInterface(final N4InterfaceDeclaration n4Interface) {
    TInterface _xblockexpression = null;
    {
      final TInterface interfaceType = TypesFactory.eINSTANCE.createTInterface();
      interfaceType.setName(n4Interface.getName());
      interfaceType.setExportedName(n4Interface.getExportedName());
      interfaceType.setExternal(n4Interface.isExternal());
      VersionedTypesBuilderUtil.setTypeVersion(interfaceType, n4Interface);
      _xblockexpression = interfaceType;
    }
    return _xblockexpression;
  }
  
  private void addExtendedInterfaces(final TInterface interfaceType, final N4InterfaceDeclaration c, final boolean preLinkingPhase) {
    if ((!preLinkingPhase)) {
      this._n4JSTypesBuilderHelper.<ParameterizedTypeRef>addCopyOfReferences(interfaceType.getSuperInterfaceRefs(), c.getSuperInterfaceRefs());
    }
  }
}
