/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.codegen;

import com.google.common.base.Objects;
import org.eclipse.n4js.tests.codegen.Fragment;
import org.eclipse.xtend2.lib.StringConcatenation;

public abstract class Member<T extends Member<T>>
extends Fragment<T> {
    protected Visibility visibility = Visibility.PUBLIC;
    protected Static static_ = Static.NO;
    protected String name;
    protected Override override_ = Override.NO;

    protected Member(String name) {
        this.name = name;
    }

    public T makeProjectVisible() {
        return this.setVisibility(Visibility.PROJECT);
    }

    public T makeProtectedInternal() {
        return this.setVisibility(Visibility.PROTECTED_INTERNAL);
    }

    public T makeProtected() {
        return this.setVisibility(Visibility.PROTECTED);
    }

    public T makePublicInternal() {
        return this.setVisibility(Visibility.PUBLIC_INTERNAL);
    }

    public T makePublic() {
        return this.setVisibility(Visibility.PUBLIC);
    }

    public T setVisibility(Visibility visibility) {
        this.visibility = visibility;
        return (T)this;
    }

    public T makeStatic() {
        return this.setStatic(Static.YES);
    }

    public T setStatic(Static static_) {
        this.static_ = static_;
        return (T)this;
    }

    public boolean isStatic() {
        return Objects.equal((Object)((Object)this.static_), (Object)((Object)Static.YES));
    }

    public T makeOverride() {
        return this.setOverride(Override.YES);
    }

    public T setOverride(Override override_) {
        this.override_ = override_;
        return (T)this;
    }

    public boolean isOverride() {
        return Objects.equal((Object)((Object)this.override_), (Object)((Object)Override.YES));
    }

    @java.lang.Override
    public CharSequence generate() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateOverride = this.generateOverride();
        _builder.append((Object)_generateOverride);
        CharSequence _generateVisibility = this.generateVisibility();
        _builder.append((Object)_generateVisibility);
        String _generateStatic = this.generateStatic();
        _builder.append(_generateStatic);
        CharSequence _generateMember = this.generateMember();
        _builder.append((Object)_generateMember);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateOverride() {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isOverride = this.isOverride();
        if (_isOverride) {
            _builder.append("@Override ");
        }
        return _builder;
    }

    private CharSequence generateVisibility() {
        StringConcatenation _builder = new StringConcatenation();
        String _generate = VisibilityExtensions.generate(this.visibility);
        _builder.append(_generate);
        _builder.append(" ");
        return _builder;
    }

    private String generateStatic() {
        return StaticExtensions.generate(this.static_);
    }

    protected abstract CharSequence generateMember();

    public String toString() {
        return this.generate().toString();
    }

    public static enum Override {
        YES,
        NO;

    }

    public static enum Static {
        YES,
        NO;

    }

    public static class StaticExtensions {
        public static String makeName(Static static_, String classifierName) {
            String _nameExtension = StaticExtensions.getNameExtension(static_);
            return String.valueOf(classifierName) + _nameExtension;
        }

        public static String getNameExtension(Static static_) {
            String _switchResult = null;
            if (static_ != null) {
                switch (static_) {
                    case YES: {
                        _switchResult = "_static";
                        break;
                    }
                    case NO: {
                        _switchResult = "";
                        break;
                    }
                }
            }
            return _switchResult;
        }

        public static String generate(Static static_) {
            String _switchResult = null;
            if (static_ != null) {
                switch (static_) {
                    case YES: {
                        _switchResult = "static ";
                        break;
                    }
                    case NO: {
                        _switchResult = "";
                        break;
                    }
                }
            }
            return _switchResult;
        }
    }

    public static enum Visibility {
        PRIVATE,
        PROJECT,
        PROTECTED_INTERNAL,
        PROTECTED,
        PUBLIC_INTERNAL,
        PUBLIC;

    }

    public static class VisibilityExtensions {
        public static String makeName(Visibility visibility, String memberName) {
            String _nameExtension = VisibilityExtensions.getNameExtension(visibility);
            return String.valueOf(memberName) + _nameExtension;
        }

        public static String getNameExtension(Visibility visibility) {
            String _switchResult = null;
            if (visibility != null) {
                switch (visibility) {
                    case PRIVATE: {
                        _switchResult = "_private";
                        break;
                    }
                    case PROJECT: {
                        _switchResult = "_project";
                        break;
                    }
                    case PROTECTED_INTERNAL: {
                        _switchResult = "_protected_internal";
                        break;
                    }
                    case PROTECTED: {
                        _switchResult = "_protected";
                        break;
                    }
                    case PUBLIC_INTERNAL: {
                        _switchResult = "_public_internal";
                        break;
                    }
                    case PUBLIC: {
                        _switchResult = "_public";
                        break;
                    }
                }
            }
            return _switchResult;
        }

        public static String generate(Visibility visibility) {
            String _switchResult = null;
            if (visibility != null) {
                switch (visibility) {
                    case PRIVATE: {
                        _switchResult = "private";
                        break;
                    }
                    case PROJECT: {
                        _switchResult = "project";
                        break;
                    }
                    case PROTECTED_INTERNAL: {
                        _switchResult = "@Internal protected";
                        break;
                    }
                    case PROTECTED: {
                        _switchResult = "protected";
                        break;
                    }
                    case PUBLIC_INTERNAL: {
                        _switchResult = "@Internal public";
                        break;
                    }
                    case PUBLIC: {
                        _switchResult = "public";
                        break;
                    }
                }
            }
            return _switchResult;
        }
    }
}

