/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.projectModel;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.InternalN4JSWorkspace;
import org.eclipse.n4js.projectDescription.ProjectDependency;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.tests.projectModel.AbstractProjectModelTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractInternalWorkspaceTest
extends AbstractProjectModelTest {
    protected abstract InternalN4JSWorkspace getWorkspace();

    @Test
    public void testGetProjectDescription_01() {
        ProjectDescription description = this.getWorkspace().getProjectDescription(this.myProjectURI);
        Assert.assertNotNull((Object)description);
        Assert.assertEquals((Object)"myProject", (Object)description.getProjectName());
    }

    @Test
    public void testGetProjectDescription_02() {
        ProjectDescription description = this.getWorkspace().getProjectDescription(this.libProjectURI);
        Assert.assertNotNull((Object)description);
        Assert.assertEquals((Object)"libProject", (Object)description.getProjectName());
    }

    @Test
    public void testGetProjectDescription_04() {
        URI doesNotExist = URI.createURI((String)"myProjectdoesNotExist");
        ProjectDescription description = this.getWorkspace().getProjectDescription(doesNotExist);
        Assert.assertNull((String)("Expecting null project description for non-existing project. Was: " + description), (Object)description);
    }

    @Test
    public void testDescriptionsAreSame() {
        ProjectDescription first = this.getWorkspace().getProjectDescription(this.myProjectURI);
        ProjectDescription second = this.getWorkspace().getProjectDescription(this.myProjectURI);
        Assert.assertSame((Object)first, (Object)second);
    }

    @Test
    public void testGetLocation_01() {
        ProjectDescription description = this.getWorkspace().getProjectDescription(this.myProjectURI);
        ProjectDependency dependency = (ProjectDependency)description.getProjectDependencies().get(1);
        URI resolvedLocation = this.getWorkspace().getLocation(this.myProjectURI, (ProjectReference)dependency);
        Assert.assertEquals((Object)this.libProjectURI, (Object)resolvedLocation);
    }

    @Test
    public void testGetFolderIterator_01() {
        HashSet containedURIs = Sets.newHashSet((Iterator)this.getWorkspace().getFolderIterator(this.myProjectURI.appendSegment("src")));
        HashSet expectation = Sets.newHashSet((Object[])new URI[]{this.myProjectURI.appendSegments(new String[]{"src", "A.js"}), this.myProjectURI.appendSegments(new String[]{"src", "B.js"}), this.myProjectURI.appendSegments(new String[]{"src", "sub", "B.js"}), this.myProjectURI.appendSegments(new String[]{"src", "sub", "C.js"}), this.myProjectURI.appendSegments(new String[]{"src", "sub", "leaf", "D.js"})});
        Assert.assertEquals((Object)expectation, (Object)containedURIs);
    }

    @Test
    public void testGetFolderIterator_02() {
        HashSet containedURIs = Sets.newHashSet((Iterator)this.getWorkspace().getFolderIterator(this.myProjectURI.appendSegment("doesNotExist")));
        HashSet expectation = Sets.newHashSet();
        Assert.assertEquals((Object)expectation, (Object)containedURIs);
    }

    @Test
    public void testGetFolderIterator_03() {
        HashSet containedURIs = Sets.newHashSet((Iterator)this.getWorkspace().getFolderIterator(this.myProjectURI.appendSegments(new String[]{"src", "sub"})));
        HashSet expectation = Sets.newHashSet((Object[])new URI[]{this.myProjectURI.appendSegments(new String[]{"src", "sub", "B.js"}), this.myProjectURI.appendSegments(new String[]{"src", "sub", "C.js"}), this.myProjectURI.appendSegments(new String[]{"src", "sub", "leaf", "D.js"})});
        Assert.assertEquals((Object)expectation, (Object)containedURIs);
    }
}

